/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;

public class Composition
implements IntegerCODEC {
    IntegerCODEC F1;
    IntegerCODEC F2;

    public Composition(IntegerCODEC f1, IntegerCODEC f2) {
        this.F1 = f1;
        this.F2 = f2;
    }

    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int init = inpos.get();
        this.F1.compress(in, inpos, inlength, out, outpos);
        if (outpos.get() == 0) {
            out[0] = 0;
            outpos.increment();
        }
        this.F2.compress(in, inpos, inlength -= inpos.get() - init, out, outpos);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int init = inpos.get();
        this.F1.uncompress(in, inpos, inlength, out, outpos);
        this.F2.uncompress(in, inpos, inlength -= inpos.get() - init, out, outpos);
    }

    public String toString() {
        return this.F1.toString() + " + " + this.F2.toString();
    }
}

