/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.plots.AesWidget;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.Geom;
import org.rosuda.deducer.plots.Layer;
import org.rosuda.deducer.plots.PlotController;
import org.rosuda.deducer.plots.PositionPanel;
import org.rosuda.deducer.plots.Stat;
import org.rosuda.deducer.toolkit.VariableSelector;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class LayerPanel
extends ElementView
implements ActionListener {
    private VariableSelector variableSelector;
    private JPanel paramPanel;
    private JButton positionButton;
    private JComboBox geomBox;
    private JComboBox statBox;
    private JScrollPane statScroller;
    private JPanel aesPanel;
    private JScrollPane geomScroller;
    private PositionPanel positionPanel;
    private JTabbedPane tabs;
    private Vector widgets = new Vector();
    private Layer model;

    public LayerPanel(Layer layer) {
        this.initGUI();
        this.setModel(layer);
    }

    public LayerPanel() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(437, 535));
            this.positionButton = new JButton();
            this.add((Component)this.positionButton, new AnchorConstraint(32, 294, 73, 74, 1, 1, 1, 1));
            this.positionButton.setText("Position");
            this.positionButton.setPreferredSize(new Dimension(96, 22));
            this.positionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LayerPanel.this.showPosition();
                }
            });
            Object object = new DefaultComboBoxModel<String>(PlotController.getGeomNames());
            this.geomBox = new JComboBox();
            this.add((Component)this.geomBox, new AnchorConstraint(32, 973, 73, 685, 0, 1, 1, 1));
            this.geomBox.setModel(object);
            this.geomBox.setPreferredSize(new Dimension(126, 22));
            object = new DefaultComboBoxModel<String>(PlotController.getStatNames());
            this.statBox = new JComboBox();
            this.add((Component)this.statBox, new AnchorConstraint(34, 671, 73, 376, 0, 1, 1, 1));
            this.statBox.setModel(object);
            this.statBox.setPreferredSize(new Dimension(129, 22));
            this.positionPanel = new PositionPanel();
            this.positionPanel.setPreferredSize(new Dimension(180, 110));
            this.positionPanel.setMaximumSize(new Dimension(190, 110));
            this.positionPanel.setAlignmentX(0.5f);
            this.tabs = new JTabbedPane();
            this.add((Component)this.tabs, new AnchorConstraint(85, 1001, 1000, 376, 1, 1, 1, 1));
            this.tabs.setPreferredSize(new Dimension(273, 490));
            this.geomScroller = new JScrollPane();
            this.geomScroller.setHorizontalScrollBarPolicy(31);
            object = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            this.geomScroller.setBorder((Border)object);
            this.tabs.addTab("Mappings", null, this.geomScroller, null);
            this.aesPanel = new JPanel();
            this.geomScroller.setViewportView(this.aesPanel);
            this.statScroller = new JScrollPane();
            this.statScroller.setHorizontalScrollBarPolicy(31);
            object = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            this.statScroller.setBorder((Border)object);
            this.tabs.addTab("Options", null, this.statScroller, null);
            this.paramPanel = new JPanel();
            this.statScroller.setViewportView(this.paramPanel);
            this.variableSelector = new VariableSelector();
            this.add((Component)this.variableSelector, new AnchorConstraint(96, 362, 991, 12, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(153, 479));
            this.variableSelector.setBorder(BorderFactory.createEtchedBorder(1));
            this.variableSelector.setCopyMode(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(Layer layer) {
        this.statBox.removeActionListener(this);
        this.geomBox.removeActionListener(this);
        this.model = layer;
        this.geomBox.setEnabled(true);
        this.statBox.setEnabled(true);
        this.geomBox.setSelectedItem(this.model.geom.name);
        this.statBox.setSelectedItem(this.model.stat.name);
        if (this.model.isGeom) {
            this.geomBox.setEnabled(false);
        }
        if (this.model.isStat) {
            this.statBox.setEnabled(false);
        }
        if (layer.data != null) {
            this.variableSelector.setSelectedData(layer.data);
        }
        this.updateAesPanel();
        this.updateOptionsPanel();
        this.statBox.addActionListener(this);
        this.geomBox.addActionListener(this);
    }

    public void updateModel() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            Object e = this.widgets.get(i);
            if (e instanceof AesWidget) {
                ((AesWidget)e).updateModel();
                continue;
            }
            if (!(e instanceof ParamWidget)) continue;
            ((ParamWidget)e).updateModel();
        }
        this.model.data = this.variableSelector.getSelectedData();
    }

    public ElementModel getModel() {
        this.updateModel();
        return this.model;
    }

    public void updateAesPanel() {
        this.aesPanel.removeAll();
        BoxLayout boxLayout = new BoxLayout(this.aesPanel, 1);
        this.aesPanel.setLayout(boxLayout);
        for (int i = 0; i < this.model.aess.size(); ++i) {
            AesWidget aesWidget = new AesWidget();
            aesWidget.setAlignmentX(0.5f);
            aesWidget.setVariableSelector(this.variableSelector);
            aesWidget.setModel(this.model.aess.get(i));
            aesWidget.setCalculatedVariables(this.model.stat.generated);
            this.widgets.add(aesWidget);
            this.aesPanel.add(aesWidget);
        }
        this.aesPanel.validate();
        this.aesPanel.repaint();
    }

    public void updateOptionsPanel() {
        ParamWidget paramWidget;
        Param param;
        int n;
        this.paramPanel.removeAll();
        BoxLayout boxLayout = new BoxLayout(this.paramPanel, 1);
        this.paramPanel.setLayout(boxLayout);
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.model.stat.params.size(); ++n) {
            param = (Param)this.model.stat.params.get(n);
            paramWidget = param.getView();
            paramWidget.setAlignmentX(0.5f);
            vector.add(param.getTitle());
            this.widgets.add(paramWidget);
            this.paramPanel.add(paramWidget);
        }
        for (n = 0; n < this.model.geom.params.size(); ++n) {
            param = (Param)this.model.geom.params.get(n);
            paramWidget = param.getView();
            paramWidget.setAlignmentX(0.5f);
            if (vector.contains(paramWidget.getModel().getTitle())) continue;
            this.widgets.add(paramWidget);
            this.paramPanel.add(paramWidget);
        }
        this.paramPanel.validate();
        this.paramPanel.repaint();
    }

    public void showPosition() {
        final JDialog jDialog = new JDialog();
        this.positionPanel.setModel(this.model.pos);
        jDialog.setTitle("Position");
        BoxLayout boxLayout = new BoxLayout(jDialog.getContentPane(), 1);
        jDialog.getContentPane().setLayout(boxLayout);
        jDialog.getContentPane().add(this.positionPanel);
        JButton jButton = new JButton("Okay");
        jButton.setPreferredSize(new Dimension(60, 25));
        jButton.setMaximumSize(new Dimension(60, 25));
        jButton.setMinimumSize(new Dimension(60, 25));
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LayerPanel.this.positionPanel.updateModel();
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add(jButton);
        jDialog.setLocationRelativeTo(this.positionButton);
        jDialog.setModal(true);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string;
        String string2 = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.statBox) {
            this.updateModel();
            string = this.statBox.getSelectedItem().toString();
            object = Stat.makeStat(string);
            this.model.setStat((Stat)object);
            this.setModel(this.model);
        }
        if (actionEvent.getSource() == this.geomBox) {
            this.updateModel();
            string = this.geomBox.getSelectedItem().toString();
            object = Geom.makeGeom(string);
            this.model.setGeom((Geom)object);
            this.setModel(this.model);
        }
    }

    public void setModel(ElementModel elementModel) {
        this.setModel((Layer)elementModel);
    }
}

