/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplaceentitlement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.marketplaceentitlement.model.EntitlementValue;
import com.amazonaws.services.marketplaceentitlement.model.transform.EntitlementMarshaller;
import java.io.Serializable;
import java.util.Date;

public class Entitlement
implements Serializable,
Cloneable,
StructuredPojo {
    private String productCode;
    private String dimension;
    private String customerIdentifier;
    private EntitlementValue value;
    private Date expirationDate;

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public Entitlement withProductCode(String productCode) {
        this.setProductCode(productCode);
        return this;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getDimension() {
        return this.dimension;
    }

    public Entitlement withDimension(String dimension) {
        this.setDimension(dimension);
        return this;
    }

    public void setCustomerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
    }

    public String getCustomerIdentifier() {
        return this.customerIdentifier;
    }

    public Entitlement withCustomerIdentifier(String customerIdentifier) {
        this.setCustomerIdentifier(customerIdentifier);
        return this;
    }

    public void setValue(EntitlementValue value) {
        this.value = value;
    }

    public EntitlementValue getValue() {
        return this.value;
    }

    public Entitlement withValue(EntitlementValue value) {
        this.setValue(value);
        return this;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public Entitlement withExpirationDate(Date expirationDate) {
        this.setExpirationDate(expirationDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProductCode() != null) {
            sb.append("ProductCode: ").append(this.getProductCode()).append(",");
        }
        if (this.getDimension() != null) {
            sb.append("Dimension: ").append(this.getDimension()).append(",");
        }
        if (this.getCustomerIdentifier() != null) {
            sb.append("CustomerIdentifier: ").append(this.getCustomerIdentifier()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getExpirationDate() != null) {
            sb.append("ExpirationDate: ").append(this.getExpirationDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement)obj;
        if (other.getProductCode() == null ^ this.getProductCode() == null) {
            return false;
        }
        if (other.getProductCode() != null && !other.getProductCode().equals(this.getProductCode())) {
            return false;
        }
        if (other.getDimension() == null ^ this.getDimension() == null) {
            return false;
        }
        if (other.getDimension() != null && !other.getDimension().equals(this.getDimension())) {
            return false;
        }
        if (other.getCustomerIdentifier() == null ^ this.getCustomerIdentifier() == null) {
            return false;
        }
        if (other.getCustomerIdentifier() != null && !other.getCustomerIdentifier().equals(this.getCustomerIdentifier())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getExpirationDate() == null ^ this.getExpirationDate() == null) {
            return false;
        }
        return other.getExpirationDate() == null || other.getExpirationDate().equals(this.getExpirationDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProductCode() == null ? 0 : this.getProductCode().hashCode());
        hashCode = 31 * hashCode + (this.getDimension() == null ? 0 : this.getDimension().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerIdentifier() == null ? 0 : this.getCustomerIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getExpirationDate() == null ? 0 : this.getExpirationDate().hashCode());
        return hashCode;
    }

    public Entitlement clone() {
        try {
            return (Entitlement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntitlementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

