/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityAsync;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityAsyncClientBuilder;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityResult;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityResult;
import com.amazonaws.services.cognitoidentity.model.GetIdRequest;
import com.amazonaws.services.cognitoidentity.model.GetIdResult;
import com.amazonaws.services.cognitoidentity.model.GetIdentityPoolRolesRequest;
import com.amazonaws.services.cognitoidentity.model.GetIdentityPoolRolesResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenResult;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.ListIdentityPoolsRequest;
import com.amazonaws.services.cognitoidentity.model.ListIdentityPoolsResult;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityResult;
import com.amazonaws.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.MergeDeveloperIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import com.amazonaws.services.cognitoidentity.model.SetIdentityPoolRolesResult;
import com.amazonaws.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.UnlinkDeveloperIdentityResult;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityResult;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCognitoIdentityAsyncClient
extends AmazonCognitoIdentityClient
implements AmazonCognitoIdentityAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonCognitoIdentityAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonCognitoIdentityAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonCognitoIdentityAsyncClientBuilder asyncBuilder() {
        return AmazonCognitoIdentityAsyncClientBuilder.standard();
    }

    AmazonCognitoIdentityAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateIdentityPoolResult> createIdentityPoolAsync(CreateIdentityPoolRequest request) {
        return this.createIdentityPoolAsync(request, null);
    }

    @Override
    public Future<CreateIdentityPoolResult> createIdentityPoolAsync(CreateIdentityPoolRequest request, final AsyncHandler<CreateIdentityPoolRequest, CreateIdentityPoolResult> asyncHandler) {
        final CreateIdentityPoolRequest finalRequest = (CreateIdentityPoolRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateIdentityPoolResult>(){

            @Override
            public CreateIdentityPoolResult call() throws Exception {
                CreateIdentityPoolResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeCreateIdentityPool(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIdentitiesResult> deleteIdentitiesAsync(DeleteIdentitiesRequest request) {
        return this.deleteIdentitiesAsync(request, null);
    }

    @Override
    public Future<DeleteIdentitiesResult> deleteIdentitiesAsync(DeleteIdentitiesRequest request, final AsyncHandler<DeleteIdentitiesRequest, DeleteIdentitiesResult> asyncHandler) {
        final DeleteIdentitiesRequest finalRequest = (DeleteIdentitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteIdentitiesResult>(){

            @Override
            public DeleteIdentitiesResult call() throws Exception {
                DeleteIdentitiesResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeDeleteIdentities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIdentityPoolResult> deleteIdentityPoolAsync(DeleteIdentityPoolRequest request) {
        return this.deleteIdentityPoolAsync(request, null);
    }

    @Override
    public Future<DeleteIdentityPoolResult> deleteIdentityPoolAsync(DeleteIdentityPoolRequest request, final AsyncHandler<DeleteIdentityPoolRequest, DeleteIdentityPoolResult> asyncHandler) {
        final DeleteIdentityPoolRequest finalRequest = (DeleteIdentityPoolRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteIdentityPoolResult>(){

            @Override
            public DeleteIdentityPoolResult call() throws Exception {
                DeleteIdentityPoolResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeDeleteIdentityPool(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityResult> describeIdentityAsync(DescribeIdentityRequest request) {
        return this.describeIdentityAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityResult> describeIdentityAsync(DescribeIdentityRequest request, final AsyncHandler<DescribeIdentityRequest, DescribeIdentityResult> asyncHandler) {
        final DescribeIdentityRequest finalRequest = (DescribeIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeIdentityResult>(){

            @Override
            public DescribeIdentityResult call() throws Exception {
                DescribeIdentityResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeDescribeIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolResult> describeIdentityPoolAsync(DescribeIdentityPoolRequest request) {
        return this.describeIdentityPoolAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityPoolResult> describeIdentityPoolAsync(DescribeIdentityPoolRequest request, final AsyncHandler<DescribeIdentityPoolRequest, DescribeIdentityPoolResult> asyncHandler) {
        final DescribeIdentityPoolRequest finalRequest = (DescribeIdentityPoolRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeIdentityPoolResult>(){

            @Override
            public DescribeIdentityPoolResult call() throws Exception {
                DescribeIdentityPoolResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeDescribeIdentityPool(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCredentialsForIdentityResult> getCredentialsForIdentityAsync(GetCredentialsForIdentityRequest request) {
        return this.getCredentialsForIdentityAsync(request, null);
    }

    @Override
    public Future<GetCredentialsForIdentityResult> getCredentialsForIdentityAsync(GetCredentialsForIdentityRequest request, final AsyncHandler<GetCredentialsForIdentityRequest, GetCredentialsForIdentityResult> asyncHandler) {
        final GetCredentialsForIdentityRequest finalRequest = (GetCredentialsForIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCredentialsForIdentityResult>(){

            @Override
            public GetCredentialsForIdentityResult call() throws Exception {
                GetCredentialsForIdentityResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeGetCredentialsForIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIdResult> getIdAsync(GetIdRequest request) {
        return this.getIdAsync(request, null);
    }

    @Override
    public Future<GetIdResult> getIdAsync(GetIdRequest request, final AsyncHandler<GetIdRequest, GetIdResult> asyncHandler) {
        final GetIdRequest finalRequest = (GetIdRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetIdResult>(){

            @Override
            public GetIdResult call() throws Exception {
                GetIdResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeGetId(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIdentityPoolRolesResult> getIdentityPoolRolesAsync(GetIdentityPoolRolesRequest request) {
        return this.getIdentityPoolRolesAsync(request, null);
    }

    @Override
    public Future<GetIdentityPoolRolesResult> getIdentityPoolRolesAsync(GetIdentityPoolRolesRequest request, final AsyncHandler<GetIdentityPoolRolesRequest, GetIdentityPoolRolesResult> asyncHandler) {
        final GetIdentityPoolRolesRequest finalRequest = (GetIdentityPoolRolesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetIdentityPoolRolesResult>(){

            @Override
            public GetIdentityPoolRolesResult call() throws Exception {
                GetIdentityPoolRolesResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeGetIdentityPoolRoles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOpenIdTokenResult> getOpenIdTokenAsync(GetOpenIdTokenRequest request) {
        return this.getOpenIdTokenAsync(request, null);
    }

    @Override
    public Future<GetOpenIdTokenResult> getOpenIdTokenAsync(GetOpenIdTokenRequest request, final AsyncHandler<GetOpenIdTokenRequest, GetOpenIdTokenResult> asyncHandler) {
        final GetOpenIdTokenRequest finalRequest = (GetOpenIdTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOpenIdTokenResult>(){

            @Override
            public GetOpenIdTokenResult call() throws Exception {
                GetOpenIdTokenResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeGetOpenIdToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOpenIdTokenForDeveloperIdentityResult> getOpenIdTokenForDeveloperIdentityAsync(GetOpenIdTokenForDeveloperIdentityRequest request) {
        return this.getOpenIdTokenForDeveloperIdentityAsync(request, null);
    }

    @Override
    public Future<GetOpenIdTokenForDeveloperIdentityResult> getOpenIdTokenForDeveloperIdentityAsync(GetOpenIdTokenForDeveloperIdentityRequest request, final AsyncHandler<GetOpenIdTokenForDeveloperIdentityRequest, GetOpenIdTokenForDeveloperIdentityResult> asyncHandler) {
        final GetOpenIdTokenForDeveloperIdentityRequest finalRequest = (GetOpenIdTokenForDeveloperIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOpenIdTokenForDeveloperIdentityResult>(){

            @Override
            public GetOpenIdTokenForDeveloperIdentityResult call() throws Exception {
                GetOpenIdTokenForDeveloperIdentityResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeGetOpenIdTokenForDeveloperIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentitiesResult> listIdentitiesAsync(ListIdentitiesRequest request) {
        return this.listIdentitiesAsync(request, null);
    }

    @Override
    public Future<ListIdentitiesResult> listIdentitiesAsync(ListIdentitiesRequest request, final AsyncHandler<ListIdentitiesRequest, ListIdentitiesResult> asyncHandler) {
        final ListIdentitiesRequest finalRequest = (ListIdentitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIdentitiesResult>(){

            @Override
            public ListIdentitiesResult call() throws Exception {
                ListIdentitiesResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeListIdentities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentityPoolsResult> listIdentityPoolsAsync(ListIdentityPoolsRequest request) {
        return this.listIdentityPoolsAsync(request, null);
    }

    @Override
    public Future<ListIdentityPoolsResult> listIdentityPoolsAsync(ListIdentityPoolsRequest request, final AsyncHandler<ListIdentityPoolsRequest, ListIdentityPoolsResult> asyncHandler) {
        final ListIdentityPoolsRequest finalRequest = (ListIdentityPoolsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIdentityPoolsResult>(){

            @Override
            public ListIdentityPoolsResult call() throws Exception {
                ListIdentityPoolsResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeListIdentityPools(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LookupDeveloperIdentityResult> lookupDeveloperIdentityAsync(LookupDeveloperIdentityRequest request) {
        return this.lookupDeveloperIdentityAsync(request, null);
    }

    @Override
    public Future<LookupDeveloperIdentityResult> lookupDeveloperIdentityAsync(LookupDeveloperIdentityRequest request, final AsyncHandler<LookupDeveloperIdentityRequest, LookupDeveloperIdentityResult> asyncHandler) {
        final LookupDeveloperIdentityRequest finalRequest = (LookupDeveloperIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<LookupDeveloperIdentityResult>(){

            @Override
            public LookupDeveloperIdentityResult call() throws Exception {
                LookupDeveloperIdentityResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeLookupDeveloperIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<MergeDeveloperIdentitiesResult> mergeDeveloperIdentitiesAsync(MergeDeveloperIdentitiesRequest request) {
        return this.mergeDeveloperIdentitiesAsync(request, null);
    }

    @Override
    public Future<MergeDeveloperIdentitiesResult> mergeDeveloperIdentitiesAsync(MergeDeveloperIdentitiesRequest request, final AsyncHandler<MergeDeveloperIdentitiesRequest, MergeDeveloperIdentitiesResult> asyncHandler) {
        final MergeDeveloperIdentitiesRequest finalRequest = (MergeDeveloperIdentitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<MergeDeveloperIdentitiesResult>(){

            @Override
            public MergeDeveloperIdentitiesResult call() throws Exception {
                MergeDeveloperIdentitiesResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeMergeDeveloperIdentities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetIdentityPoolRolesResult> setIdentityPoolRolesAsync(SetIdentityPoolRolesRequest request) {
        return this.setIdentityPoolRolesAsync(request, null);
    }

    @Override
    public Future<SetIdentityPoolRolesResult> setIdentityPoolRolesAsync(SetIdentityPoolRolesRequest request, final AsyncHandler<SetIdentityPoolRolesRequest, SetIdentityPoolRolesResult> asyncHandler) {
        final SetIdentityPoolRolesRequest finalRequest = (SetIdentityPoolRolesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetIdentityPoolRolesResult>(){

            @Override
            public SetIdentityPoolRolesResult call() throws Exception {
                SetIdentityPoolRolesResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeSetIdentityPoolRoles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnlinkDeveloperIdentityResult> unlinkDeveloperIdentityAsync(UnlinkDeveloperIdentityRequest request) {
        return this.unlinkDeveloperIdentityAsync(request, null);
    }

    @Override
    public Future<UnlinkDeveloperIdentityResult> unlinkDeveloperIdentityAsync(UnlinkDeveloperIdentityRequest request, final AsyncHandler<UnlinkDeveloperIdentityRequest, UnlinkDeveloperIdentityResult> asyncHandler) {
        final UnlinkDeveloperIdentityRequest finalRequest = (UnlinkDeveloperIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UnlinkDeveloperIdentityResult>(){

            @Override
            public UnlinkDeveloperIdentityResult call() throws Exception {
                UnlinkDeveloperIdentityResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeUnlinkDeveloperIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnlinkIdentityResult> unlinkIdentityAsync(UnlinkIdentityRequest request) {
        return this.unlinkIdentityAsync(request, null);
    }

    @Override
    public Future<UnlinkIdentityResult> unlinkIdentityAsync(UnlinkIdentityRequest request, final AsyncHandler<UnlinkIdentityRequest, UnlinkIdentityResult> asyncHandler) {
        final UnlinkIdentityRequest finalRequest = (UnlinkIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UnlinkIdentityResult>(){

            @Override
            public UnlinkIdentityResult call() throws Exception {
                UnlinkIdentityResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeUnlinkIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateIdentityPoolResult> updateIdentityPoolAsync(UpdateIdentityPoolRequest request) {
        return this.updateIdentityPoolAsync(request, null);
    }

    @Override
    public Future<UpdateIdentityPoolResult> updateIdentityPoolAsync(UpdateIdentityPoolRequest request, final AsyncHandler<UpdateIdentityPoolRequest, UpdateIdentityPoolResult> asyncHandler) {
        final UpdateIdentityPoolRequest finalRequest = (UpdateIdentityPoolRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateIdentityPoolResult>(){

            @Override
            public UpdateIdentityPoolResult call() throws Exception {
                UpdateIdentityPoolResult result = null;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.executeUpdateIdentityPool(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

