/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTaskPoller;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.BlockCallerPolicy;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorker;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.TypeAlreadyExistsException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericActivityWorker
extends GenericWorker {
    private static final Log log = LogFactory.getLog(GenericActivityWorker.class);
    private static final String POLL_THREAD_NAME_PREFIX = "SWF Activity Poll ";
    private static final String ACTIVITY_THREAD_NAME_PREFIX = "SWF Activity ";
    private ActivityImplementationFactory activityImplementationFactory;
    private int taskExecutorThreadPoolSize = 100;

    public GenericActivityWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        super(service, domain, taskListToPoll);
        if (service == null) {
            throw new IllegalArgumentException("service");
        }
    }

    public GenericActivityWorker() {
    }

    public ActivityImplementationFactory getActivityImplementationFactory() {
        return this.activityImplementationFactory;
    }

    public void setActivityImplementationFactory(ActivityImplementationFactory activityImplementationFactory) {
        this.activityImplementationFactory = activityImplementationFactory;
    }

    public int getTaskExecutorThreadPoolSize() {
        return this.taskExecutorThreadPoolSize;
    }

    public void setTaskExecutorThreadPoolSize(int taskExecutorThreadPoolSize) {
        if (taskExecutorThreadPoolSize < 1) {
            throw new IllegalArgumentException("0 or negative taskExecutorThreadPoolSize");
        }
        this.checkStarted();
        this.taskExecutorThreadPoolSize = taskExecutorThreadPoolSize;
    }

    protected Semaphore createPollSemaphore() {
        return new Semaphore(this.taskExecutorThreadPoolSize);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [super=" + super.toString() + ", taskExecutorThreadPoolSize=" + this.taskExecutorThreadPoolSize + "]";
    }

    @Override
    protected String getPollThreadNamePrefix() {
        return POLL_THREAD_NAME_PREFIX + this.getTaskListToPoll() + " ";
    }

    @Override
    protected TaskPoller createPoller() {
        ThreadPoolExecutor tasksExecutor = new ThreadPoolExecutor(1, this.taskExecutorThreadPoolSize, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
        tasksExecutor.setThreadFactory(new GenericWorker.ExecutorThreadFactory(this, "SWF Activity  " + this.getTaskListToPoll() + " "));
        tasksExecutor.setRejectedExecutionHandler(new BlockCallerPolicy());
        return new ActivityTaskPoller(this.service, this.domain, this.getTaskListToPoll(), this.activityImplementationFactory, tasksExecutor);
    }

    @Override
    public void registerTypesToPoll() {
        GenericActivityWorker.registerActivityTypes(this.service, this.domain, this.getTaskListToPoll(), this.activityImplementationFactory);
    }

    public static void registerActivityTypes(AmazonSimpleWorkflow service, String domain, String defaultTaskList, ActivityImplementationFactory activityImplementationFactory) {
        for (ActivityType activityType : activityImplementationFactory.getActivityTypesToRegister()) {
            try {
                ActivityImplementation implementation = activityImplementationFactory.getActivityImplementation(activityType);
                if (implementation == null) {
                    throw new IllegalStateException("No implementation found for type needed registration: " + activityType);
                }
                ActivityTypeRegistrationOptions registrationOptions = implementation.getRegistrationOptions();
                if (registrationOptions == null) continue;
                GenericActivityWorker.registerActivityType(service, domain, activityType, registrationOptions, defaultTaskList);
            }
            catch (TypeAlreadyExistsException typeAlreadyExistsException) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Activity version already registered: " + activityType.getName() + "_" + activityType.getVersion()));
            }
        }
    }

    public static void registerActivityType(AmazonSimpleWorkflow service, String domain, ActivityType activityType, ActivityTypeRegistrationOptions registrationOptions, String taskListToPoll) throws AmazonServiceException {
        RegisterActivityTypeRequest registerActivity = new RegisterActivityTypeRequest();
        registerActivity.setDomain(domain);
        String taskList = registrationOptions.getDefaultTaskList();
        if (taskList == null) {
            taskList = taskListToPoll;
        } else if (taskList.equals("NO_DEFAULT_TASK_LIST")) {
            taskList = null;
        }
        if (taskList != null && !taskList.isEmpty()) {
            registerActivity.setDefaultTaskList(new TaskList().withName(taskList));
        }
        registerActivity.setName(activityType.getName());
        registerActivity.setVersion(activityType.getVersion());
        registerActivity.setDefaultTaskStartToCloseTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultTaskStartToCloseTimeoutSeconds()));
        registerActivity.setDefaultTaskScheduleToCloseTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultTaskScheduleToCloseTimeoutSeconds()));
        registerActivity.setDefaultTaskHeartbeatTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultTaskHeartbeatTimeoutSeconds()));
        registerActivity.setDefaultTaskScheduleToStartTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultTaskScheduleToStartTimeoutSeconds()));
        registerActivity.setDefaultTaskPriority(FlowHelpers.taskPriorityToString(registrationOptions.getDefaultTaskPriority()));
        if (registrationOptions.getDescription() != null) {
            registerActivity.setDescription(registrationOptions.getDescription());
        }
        service.registerActivityType(registerActivity);
        if (log.isInfoEnabled()) {
            log.info((Object)("regisered activity type: " + activityType));
        }
    }

    @Override
    protected void checkRequredProperties() {
        this.checkRequiredProperty(this.activityImplementationFactory, "activityImplementationFactory");
    }
}

