/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotdata.model.PublishRequest;
import java.nio.ByteBuffer;

@SdkInternalApi
public class PublishRequestMarshaller {
    private static final MarshallingInfo<String> TOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("topic").build();
    private static final MarshallingInfo<Integer> QOS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("qos").build();
    private static final MarshallingInfo<ByteBuffer> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final PublishRequestMarshaller instance = new PublishRequestMarshaller();

    public static PublishRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(PublishRequest publishRequest, ProtocolMarshaller protocolMarshaller) {
        if (publishRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)publishRequest.getTopic(), TOPIC_BINDING);
            protocolMarshaller.marshall((Object)publishRequest.getQos(), QOS_BINDING);
            protocolMarshaller.marshall((Object)publishRequest.getPayload(), PAYLOAD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

