/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.waf.model.SampledHTTPRequest;
import com.amazonaws.services.waf.model.TimeWindow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetSampledRequestsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SampledHTTPRequest> sampledRequests;
    private Long populationSize;
    private TimeWindow timeWindow;

    public List<SampledHTTPRequest> getSampledRequests() {
        return this.sampledRequests;
    }

    public void setSampledRequests(Collection<SampledHTTPRequest> sampledRequests) {
        if (sampledRequests == null) {
            this.sampledRequests = null;
            return;
        }
        this.sampledRequests = new ArrayList<SampledHTTPRequest>(sampledRequests);
    }

    public GetSampledRequestsResult withSampledRequests(SampledHTTPRequest ... sampledRequests) {
        if (this.sampledRequests == null) {
            this.setSampledRequests(new ArrayList<SampledHTTPRequest>(sampledRequests.length));
        }
        for (SampledHTTPRequest ele : sampledRequests) {
            this.sampledRequests.add(ele);
        }
        return this;
    }

    public GetSampledRequestsResult withSampledRequests(Collection<SampledHTTPRequest> sampledRequests) {
        this.setSampledRequests(sampledRequests);
        return this;
    }

    public void setPopulationSize(Long populationSize) {
        this.populationSize = populationSize;
    }

    public Long getPopulationSize() {
        return this.populationSize;
    }

    public GetSampledRequestsResult withPopulationSize(Long populationSize) {
        this.setPopulationSize(populationSize);
        return this;
    }

    public void setTimeWindow(TimeWindow timeWindow) {
        this.timeWindow = timeWindow;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public GetSampledRequestsResult withTimeWindow(TimeWindow timeWindow) {
        this.setTimeWindow(timeWindow);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSampledRequests() != null) {
            sb.append("SampledRequests: ").append(this.getSampledRequests()).append(",");
        }
        if (this.getPopulationSize() != null) {
            sb.append("PopulationSize: ").append(this.getPopulationSize()).append(",");
        }
        if (this.getTimeWindow() != null) {
            sb.append("TimeWindow: ").append(this.getTimeWindow());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsResult)) {
            return false;
        }
        GetSampledRequestsResult other = (GetSampledRequestsResult)obj;
        if (other.getSampledRequests() == null ^ this.getSampledRequests() == null) {
            return false;
        }
        if (other.getSampledRequests() != null && !other.getSampledRequests().equals(this.getSampledRequests())) {
            return false;
        }
        if (other.getPopulationSize() == null ^ this.getPopulationSize() == null) {
            return false;
        }
        if (other.getPopulationSize() != null && !other.getPopulationSize().equals(this.getPopulationSize())) {
            return false;
        }
        if (other.getTimeWindow() == null ^ this.getTimeWindow() == null) {
            return false;
        }
        return other.getTimeWindow() == null || other.getTimeWindow().equals(this.getTimeWindow());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSampledRequests() == null ? 0 : this.getSampledRequests().hashCode());
        hashCode = 31 * hashCode + (this.getPopulationSize() == null ? 0 : this.getPopulationSize().hashCode());
        hashCode = 31 * hashCode + (this.getTimeWindow() == null ? 0 : this.getTimeWindow().hashCode());
        return hashCode;
    }

    public GetSampledRequestsResult clone() {
        try {
            return (GetSampledRequestsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

