/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHsmClientCertificatesRequestMarshaller
implements Marshaller<Request<DescribeHsmClientCertificatesRequest>, DescribeHsmClientCertificatesRequest> {
    public Request<DescribeHsmClientCertificatesRequest> marshall(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeHsmClientCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHsmClientCertificatesRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeHsmClientCertificates");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeHsmClientCertificatesRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)describeHsmClientCertificatesRequest.getHsmClientCertificateIdentifier()));
        }
        if (describeHsmClientCertificatesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeHsmClientCertificatesRequest.getMaxRecords()));
        }
        if (describeHsmClientCertificatesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeHsmClientCertificatesRequest.getMarker()));
        }
        if (!(tagKeysList = (SdkInternalList)describeHsmClientCertificatesRequest.getTagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeHsmClientCertificatesRequest.getTagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

