/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.shaded.apache.http.impl.auth;

import com.simba.athena.shaded.apache.http.annotation.Contract;
import com.simba.athena.shaded.apache.http.annotation.ThreadingBehavior;
import com.simba.athena.shaded.apache.http.auth.AuthScheme;
import com.simba.athena.shaded.apache.http.auth.AuthSchemeFactory;
import com.simba.athena.shaded.apache.http.auth.AuthSchemeProvider;
import com.simba.athena.shaded.apache.http.impl.auth.SPNegoScheme;
import com.simba.athena.shaded.apache.http.params.HttpParams;
import com.simba.athena.shaded.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class SPNegoSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public SPNegoSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public SPNegoSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public SPNegoSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }
}

