/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

public class TextualTwoKnobsSlider
extends JPanel
implements ActionListener,
DocumentListener,
FocusListener,
PropertyChangeListener,
KeyListener {
    public static final int LAYOUT_ALL = 0;
    public static final int LAYOUT_FIELDS = 1;
    public static final int LAYOUT_SLIDER = 2;
    public static final int LAYOUT_SLIDER_AND_LABEL = 3;
    public static final int LAYOUT_SLIDER_FIELDS_X_AXIS = 4;
    public static final int LAYOUT_SLIDER_FIELDS_LABELS_X_AXIS = 5;
    public static final int START = 0;
    public static final int END = 1;
    private static final String NAME_DOC = "name";
    private static final int DECIMAL_PRECISION = 3;
    private static final NumberFormat NUMBER_FORMAT;
    private TwoKnobsSlider slider;
    private NumericalTextField startField;
    private NumericalTextField endField;
    private static final int MAX_TEXTFIELD_LENGTH = 10;
    private JLabel startLabel;
    private JLabel endLabel;
    private JLabel sliderLabel;
    private double start;
    private double end;
    private boolean intMode = false;

    private String formatValue(double value) {
        String s = this.intMode ? "" + (int)value : NUMBER_FORMAT.format(value);
        return s;
    }

    private void attachListeners() {
        this.attachSliderListeners();
        this.installFieldListeners(this.startField, 0);
        this.installFieldListeners(this.endField, 1);
    }

    private void removeListeners() {
        this.removeSliderListeners();
        this.uninstallFieldListeners(this.startField);
        this.uninstallFieldListeners(this.endField);
    }

    private void attachSliderListeners() {
        this.slider.addPropertyChangeListener(this);
    }

    private void removeSliderListeners() {
        this.slider.removePropertyChangeListener(this);
    }

    private void installFieldListeners(JTextField field, int id) {
        field.setActionCommand("" + id);
        field.addActionListener(this);
        field.addFocusListener(this);
        field.addKeyListener(this);
        Document doc = field.getDocument();
        doc.addDocumentListener(this);
        doc.putProperty(NAME_DOC, "" + id);
    }

    private void uninstallFieldListeners(JTextField field) {
        field.removeFocusListener(this);
    }

    private void initComponents(double absMin, double absMax, double min, double max, double start, double end) {
        this.sliderLabel = new JLabel();
        this.startLabel = new JLabel("Start");
        this.endLabel = new JLabel("End");
        this.slider = new TwoKnobsSlider(absMin, absMax, min, max, start, end);
        this.setSliderPaintingDefault(false);
        Class type = this.intMode ? Integer.class : Double.class;
        int textFieldLength = this.calculateRequiredTextfieldLength(absMin, absMax);
        this.startField = new NumericalTextField(absMin, absMax, type, 1);
        this.startField.setColumns(textFieldLength);
        this.startField.setShowWarning(true);
        this.endField = new NumericalTextField(absMin, absMax, type, 1);
        this.endField.setColumns(textFieldLength);
        this.endField.setShowWarning(true);
        this.endField.setText(this.formatValue(end));
        this.startField.setText(this.formatValue(start));
        this.start = start;
        this.end = end;
    }

    private int calculateRequiredTextfieldLength(double min, double max) {
        int result;
        double maxValue = Math.max(Math.abs(min), Math.abs(max));
        if (min < 0.0) {
            maxValue *= -1.0;
        }
        if ((result = this.formatValue(maxValue).length()) > 10) {
            result = 10;
        }
        return result;
    }

    private void setStartValue() {
        boolean valid = false;
        double val = 0.0;
        try {
            val = Double.parseDouble(this.startField.getText());
            if (this.startField.getMinimum() <= val && val <= this.end) {
                valid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!valid) {
            this.startField.selectAll();
            return;
        }
        this.start = val;
        if (this.start < this.slider.getPartialMinimum()) {
            val = this.slider.getPartialMinimum();
        }
        this.removeSliderListeners();
        this.slider.setStartValue(val);
        this.firePropertyChange("knobReleased", null, (Object)val);
        this.attachSliderListeners();
    }

    private void setEndValue() {
        boolean valid = false;
        double val = 0.0;
        try {
            val = Double.parseDouble(this.endField.getText());
            if (this.start <= val && val <= this.endField.getMaximum()) {
                valid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!valid) {
            this.endField.selectAll();
            return;
        }
        this.end = val;
        if (this.end > this.slider.getPartialMaximum()) {
            val = this.slider.getPartialMaximum();
        }
        this.removeSliderListeners();
        this.slider.setEndValue(val);
        this.firePropertyChange("knobReleased", null, (Object)val);
        this.attachSliderListeners();
    }

    private void synchStartValue(double value) {
        this.start = value;
        this.uninstallFieldListeners(this.startField);
        this.startField.setText(this.formatValue(value));
        this.installFieldListeners(this.startField, 0);
    }

    private void synchEndValue(double value) {
        this.end = value;
        this.uninstallFieldListeners(this.endField);
        this.endField.setText(this.formatValue(value));
        this.installFieldListeners(this.endField, 1);
    }

    private void handleFocusLost(Object field) {
        if (field == null) {
            return;
        }
        if (this.startField == field) {
            this.setStartValue();
        } else if (this.endField == field) {
            this.setEndValue();
        }
    }

    private JPanel buildFieldsPane() {
        JPanel p = new JPanel();
        int charWidth = this.getFontMetrics(this.getFont()).charWidth('m');
        Insets insets = this.endField.getInsets();
        int length = this.endField.getColumns();
        int x = insets.left + length * charWidth + insets.left;
        Dimension d = this.startField.getPreferredSize();
        this.startField.setPreferredSize(new Dimension(x, d.height));
        d = this.endField.getPreferredSize();
        this.endField.setPreferredSize(new Dimension(x, d.height));
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.weightx = 0.0;
        c.anchor = 17;
        p.add((Component)this.startLabel, c);
        c.gridx = 1;
        c.ipadx = x;
        c.weightx = 0.5;
        p.add((Component)UIUtilities.buildComponentPanel(this.startField), c);
        c.gridx = 2;
        c.ipadx = 0;
        c.weightx = 0.0;
        p.add((Component)this.endLabel, c);
        c.gridx = 3;
        c.ipadx = x;
        c.weightx = 0.5;
        p.add((Component)UIUtilities.buildComponentPanel(this.endField), c);
        return p;
    }

    public TextualTwoKnobsSlider() {
        this(0, 100);
    }

    public TextualTwoKnobsSlider(int min, int max) {
        this(min, max, min, max);
    }

    public TextualTwoKnobsSlider(double min, double max) {
        this(min, max, min, max);
    }

    public TextualTwoKnobsSlider(int min, int max, int start, int end) {
        this(min, max, min, max, start, end);
    }

    public TextualTwoKnobsSlider(double min, double max, double start, double end) {
        this(min, max, min, max, start, end);
    }

    public TextualTwoKnobsSlider(int absMin, int absMax, int min, int max, int start, int end) {
        this.intMode = true;
        this.initComponents(absMin, absMax, min, max, start, end);
        this.attachListeners();
    }

    public TextualTwoKnobsSlider(double absMin, double absMax, double min, double max, double start, double end) {
        this.intMode = false;
        this.initComponents(absMin, absMax, min, max, start, end);
        this.attachListeners();
    }

    public void setStartLabelText(String text) {
        this.startLabel.setText(text);
    }

    public void setEndLabelText(String text) {
        this.endLabel.setText(text);
    }

    public void setSliderLabelText(String text) {
        this.sliderLabel.setText(text);
    }

    public double getStartValue() {
        return this.start;
    }

    public double getEndValue() {
        return this.end;
    }

    public void layoutComponents() {
        this.layoutComponents(0);
    }

    public void layoutComponents(int index) {
        switch (index) {
            case 1: {
                this.add(this.buildFieldsPane());
                break;
            }
            case 2: {
                this.add(this.slider);
                break;
            }
            case 4: {
                this.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.anchor = 17;
                c.fill = 0;
                this.add((Component)this.startField, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.fill = 2;
                this.add((Component)this.slider, c);
                ++c.gridx;
                c.weightx = 0.0;
                c.fill = 0;
                this.add((Component)this.endField, c);
                break;
            }
            case 5: {
                this.setLayout(new FlowLayout(0, 0, 0));
                this.add(this.sliderLabel);
                this.add(this.startField);
                this.add(this.slider);
                this.add(this.endField);
                this.add(this.endLabel);
                break;
            }
            case 3: {
                JPanel content = new JPanel();
                content.setLayout(new FlowLayout(0, 0, 0));
                content.add(this.sliderLabel);
                content.add(UIUtilities.buildComponentPanel(this.slider));
                this.add(content);
                break;
            }
            default: {
                JPanel content1 = new JPanel();
                content1.setLayout(new BoxLayout(content1, 1));
                JPanel row = new JPanel();
                row.setLayout(new FlowLayout(0, 0, 0));
                row.add(this.sliderLabel);
                row.add(UIUtilities.buildComponentPanel(this.slider));
                content1.add(row);
                content1.add(this.buildFieldsPane());
                this.add(content1);
            }
        }
    }

    public void setSliderPaintingDefault(boolean paint) {
        this.slider.setPaintLabels(paint);
        this.slider.setPaintEndLabels(paint);
        this.slider.setPaintTicks(paint);
    }

    public TwoKnobsSlider getSlider() {
        return this.slider;
    }

    public void setValues(int absoluteMax, int absoluteMin, int max, int min, int start, int end) {
        this.setValues(absoluteMax, absoluteMin, absoluteMax, absoluteMin, max, min, start, end);
    }

    public void setValues(int absoluteMaxSlider, int absoluteMinSlider, int absoluteMaxText, int absoluteMinText, int max, int min, int start, int end) {
        this.slider.setValues(absoluteMaxSlider, absoluteMinSlider, max, min, start, end);
        this.removeListeners();
        this.intMode = true;
        int textFieldLength = this.calculateRequiredTextfieldLength(absoluteMinText, absoluteMaxText);
        this.startField.setNumberType(Integer.class);
        this.endField.setNumberType(Integer.class);
        this.startField.setColumns(textFieldLength);
        this.endField.setColumns(textFieldLength);
        this.endField.setMaximum(absoluteMaxText);
        this.endField.setMinimum(absoluteMinText);
        this.startField.setMaximum(absoluteMaxText);
        this.startField.setMinimum(absoluteMinText);
        this.endField.setText(this.formatValue(end));
        this.startField.setText(this.formatValue(start));
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><body>");
        buffer.append("<b>Min:</b> " + min);
        buffer.append("<br><b>Pixels Type Min: </b>" + absoluteMinText);
        buffer.append("</body></html>");
        this.startField.setToolTipText(buffer.toString());
        buffer = new StringBuffer();
        buffer.append("<html><body>");
        buffer.append("<b>Max:</b> " + max);
        buffer.append("<br><b>Pixels Type Max: </b>" + absoluteMaxText);
        buffer.append("</body></html>");
        this.endField.setToolTipText(buffer.toString());
        this.start = start;
        this.end = end;
        this.attachListeners();
    }

    public void setValues(double absoluteMaxSlider, double absoluteMinSlider, double absoluteMaxText, double absoluteMinText, double max, double min, double start, double end) {
        this.slider.setValues(absoluteMaxSlider, absoluteMinSlider, max, min, start, end);
        this.removeListeners();
        this.intMode = false;
        int textFieldLength = this.calculateRequiredTextfieldLength(absoluteMinText, absoluteMinText);
        this.startField.setNumberType(Double.class);
        this.startField.setNegativeAccepted(true);
        this.endField.setNumberType(Double.class);
        this.endField.setNegativeAccepted(true);
        this.startField.setColumns(textFieldLength);
        this.endField.setColumns(textFieldLength);
        this.endField.setMaximum(absoluteMaxText);
        this.endField.setMinimum(absoluteMinText);
        this.startField.setMaximum(absoluteMaxText);
        this.startField.setMinimum(absoluteMinText);
        this.endField.setText(this.formatValue(end));
        this.startField.setText(this.formatValue(start));
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><body>");
        buffer.append("<b>Min:</b> " + min);
        buffer.append("<br><b>Pixels Type Min: </b>" + absoluteMinText);
        buffer.append("</body></html>");
        this.startField.setToolTipText(buffer.toString());
        buffer = new StringBuffer();
        buffer.append("<html><body>");
        buffer.append("<b>Max:</b> " + max);
        buffer.append("<br><b>Pixels Type Max: </b>" + absoluteMaxText);
        buffer.append("</body></html>");
        this.endField.setToolTipText(buffer.toString());
        this.start = start;
        this.end = end;
        this.attachListeners();
    }

    public int getColumns() {
        return this.startField.getColumns();
    }

    public JComponent getFieldComponent(int index) {
        switch (index) {
            case 0: {
                return this.startField;
            }
            case 1: {
                return this.endField;
            }
        }
        return null;
    }

    public void setInterval(double s, double e) {
        this.removeListeners();
        this.endField.setText(this.formatValue(e));
        this.startField.setText(this.formatValue(s));
        this.slider.setStartValue(s);
        this.slider.setEndValue(e);
        this.start = s;
        this.end = e;
        this.attachListeners();
    }

    public void setColourGradients(Color rgbStart, Color rgbEnd) {
        this.slider.setColourGradients(rgbStart, rgbEnd);
    }

    public void setImage(BufferedImage image) {
        this.slider.setImage(image);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.slider.setEnabled(enabled);
        this.endField.setEnabled(enabled);
        this.startField.setEnabled(enabled);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.slider != null) {
            this.slider.setBackground(c);
        }
        if (this.endField != null) {
            this.endField.setBackground(c);
        }
        if (this.startField != null) {
            this.startField.setBackground(c);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.slider != null) {
            this.slider.setFont(font);
        }
        if (this.endField != null) {
            this.endField.setFont(font);
        }
        if (this.startField != null) {
            this.startField.setFont(font);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("leftMoved".equals(name)) {
            Double value = (Double)evt.getNewValue();
            this.synchStartValue(value);
        } else if ("rightMoved".equals(name)) {
            Double value = (Double)evt.getNewValue();
            this.synchEndValue(value);
        }
        this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.setStartValue();
                break;
            }
            case 1: {
                this.setEndValue();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.handleFocusLost(e.getSource());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (10 == e.getKeyCode()) {
            Object source = e.getSource();
            if (source == this.startField) {
                this.setStartValue();
            } else if (source == this.endField) {
                this.setEndValue();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    static {
        String s = "0.";
        for (int i = 0; i < 3; ++i) {
            s = s + "0";
        }
        NUMBER_FORMAT = new DecimalFormat(s);
    }
}

