/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.FileTable;
import org.openmicroscopy.shoola.util.ui.FileTableNode;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MessengerDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final int ERROR_TYPE = 0;
    public static final int COMMENT_TYPE = 1;
    public static final int SUBMIT_ERROR_TYPE = 2;
    public static final String SEND_PROPERTY = "send";
    public static final String CLOSE_MESSENGER_PROPERTY = "closeMessenger";
    private static final int CANCEL = 0;
    private static final int SEND = 1;
    private static final int COPY = 3;
    private static final int SUBMIT = 4;
    private static final Dimension DEFAULT_SIZE = new Dimension(700, 400);
    private static final String CANCEL_TOOLTIP = "Cancel your message";
    private static final String SEND_TOOLTIP = "Send the information to the development team";
    private static final String COPY_TOOLTIP = "Copy the Exception Message to the clipboard";
    private static final String MESSAGE = "Thank you for taking the time to send us your comments. \n\nYour feedback will be used to further the development of OMERO and improve our software. Any personal details you provide are purely optional, and will only be used for development purposes.\n";
    private static final String DEBUG_MESSAGE = "An error message has been generated by the application.\n\nTo help us improve our software, please fill out the following form. Your personal details are purely optional, and will only be used for development purposes.\n\nPlease note that your application may need to be restarted to work properly.\n";
    private static final String SUBMIT_MESSAGE = "Submit to the development team the files that failed to import.\n\nTo help us improve our software, please fill out the following form. Your personal details are purely optional, and will only be used for development purposes.\n\nPlease note that your application may need to be restarted to work properly.\n";
    private static final String EMAIL_MESSAGE = "The e-mail address entered \n does not seem to be valid. \n Please enter a new e-mail address.";
    private static final String SUBMIT_FILES_MESSAGE = "Choosing not to submit to the files will make it more difficult to fix the problem you are experimenting.\nAre you sure you do not want to submit the files?";
    private static final String COMMENT_FIELD = "Comment: ";
    private static final String DEBUG_COMMENT_FIELD = "What you were doing when you crashed?";
    private static final String EMAIL_FIELD = "Email: ";
    private static final String EMAIL_TOOLTIP = "Enter your email address here.";
    private static final String EMAIL_SUFFIX = " (Optional)";
    private static final String ERROR_BRIEF = "Brief Description:";
    private int dialogType;
    private JButton cancelButton;
    private JButton sendButton;
    private JTextField emailArea;
    private MultilineLabel commentArea;
    private String emailAddress;
    private Exception exception;
    private JTextPane debugArea;
    private JButton copyButton;
    private String serverVersion;
    private String errorDescription;
    private FileTable table;
    private JXBusyLabel submitStatus;
    private JCheckBox submitFile;
    private JXBusyLabel progress;
    private JLabel progressLabel;

    private void submitFilesControl() {
        if (!this.submitFile.isSelected()) {
            MessageBox dialog = new MessageBox(this, "Submit Files", SUBMIT_FILES_MESSAGE);
            dialog.setResizable(false);
            if (dialog.centerMsgBox() == 0) {
                this.submitFile.setSelected(true);
            }
        }
    }

    private void formatButton(JButton b, int mnemonic, String tooltip, int actionID) {
        b.setMnemonic(mnemonic);
        b.setOpaque(false);
        b.setToolTipText(tooltip);
        b.addActionListener(this);
        b.setActionCommand("" + actionID);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.firePropertyChange(CLOSE_MESSENGER_PROPERTY, (Object)false, (Object)true);
    }

    private void copy() {
        if (this.debugArea != null) {
            this.debugArea.selectAll();
            this.debugArea.copy();
        }
    }

    private void sendError(String propertyName) {
        String email = this.emailArea.getText().trim();
        String comment = this.commentArea.getText().trim();
        String error = null;
        if (this.debugArea != null) {
            error = this.debugArea.getText().trim();
        }
        MessengerDetails details = new MessengerDetails(email, comment);
        details.setExtra(this.serverVersion);
        details.setError(error);
        this.firePropertyChange(propertyName, null, details);
        this.close();
    }

    private void send(String propertyName) {
        if (this.dialogType == 2) {
            List<FileTableNode> files = null;
            if (this.table != null) {
                files = this.table.getSelectedFiles();
            }
            if (CollectionUtils.isEmpty(files)) {
                this.sendError(propertyName);
            } else {
                String email = this.emailArea.getText().trim();
                String comment = this.commentArea.getText().trim();
                MessengerDetails details = new MessengerDetails(email, comment);
                details.setExtra(this.serverVersion);
                details.setObjectToSubmit(files);
                this.submitStatus.setVisible(true);
                this.submitStatus.setBusy(true);
                details.setExceptionOnly(!this.submitFile.isSelected());
                this.firePropertyChange(propertyName, null, details);
            }
        } else {
            this.sendError(propertyName);
        }
        this.sendButton.setEnabled(false);
    }

    private void initComponents() {
        this.progress = new JXBusyLabel(new Dimension(16, 16));
        this.progress.setVisible(false);
        this.progressLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MessengerDialog.this.close();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.formatButton(this.cancelButton, 67, CANCEL_TOOLTIP, 0);
        this.sendButton = new JButton("Send");
        this.formatButton(this.sendButton, 83, SEND_TOOLTIP, 1);
        this.emailArea = new JTextField(20);
        this.emailArea.setToolTipText(EMAIL_TOOLTIP);
        this.emailArea.setText(this.emailAddress);
        this.commentArea = new MultilineLabel();
        this.commentArea.setEditable(true);
        this.commentArea.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.commentArea.setOpaque(true);
        if (this.exception != null) {
            this.debugArea = this.buildExceptionArea();
            this.copyButton = new JButton("Copy to Clipboard");
            this.formatButton(this.copyButton, 67, COPY_TOOLTIP, 3);
        }
        this.setAlwaysOnTop(true);
        if (this.dialogType == 1) {
            this.sendButton.setEnabled(false);
            this.commentArea.getDocument().addDocumentListener(this);
        }
        this.submitStatus = new JXBusyLabel(new Dimension(16, 16));
        this.submitStatus.setText("Uploading files");
        this.submitStatus.setVisible(false);
        this.submitFile = new JCheckBox("Files");
        this.submitFile.setSelected(true);
        this.submitFile.addActionListener(this);
        this.submitFile.setActionCommand("4");
    }

    private JTextPane buildExceptionArea() {
        JTextPane pane = UIUtilities.buildExceptionArea();
        StyledDocument document = pane.getStyledDocument();
        Style style = pane.getLogicalStyle();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.exception.printStackTrace(pw);
        try {
            document.insertString(document.getLength(), sw.toString(), style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return pane;
    }

    private JPanel buildCommentAreaPanel(String comment, int mnemonic) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] size = new double[][]{{-1.0}, {20.0, -1.0}};
        TableLayout layout = new TableLayout(size);
        panel.setLayout(layout);
        JScrollPane areaScrollPane = new JScrollPane(this.commentArea);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        this.commentArea.setPreferredSize(new Dimension(300, 100));
        JLabel label = new JLabel(comment);
        label.setOpaque(false);
        label.setDisplayedMnemonic(mnemonic);
        panel.add((Component)label, "0, 0, LEFT, CENTER");
        panel.add((Component)areaScrollPane, "0, 1");
        return panel;
    }

    private JPanel buildEmailAreaPanel(int mnemonic) {
        Object size = null;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        size = EMAIL_SUFFIX.length() == 0 ? (Object)new double[][]{{-2.0, -1.0}, {30.0}} : (Object)new double[][]{{-2.0, -1.0, -2.0}, {30.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout(layout);
        JLabel label = new JLabel(EMAIL_FIELD);
        label.setDisplayedMnemonic(mnemonic);
        label.setLabelFor(this.emailArea);
        label.setOpaque(false);
        panel.add((Component)label, "0, 0, RIGHT, CENTER");
        panel.add((Component)this.emailArea, "1, 0, FULL, CENTER");
        if (EMAIL_SUFFIX.length() != 0) {
            panel.add((Component)new JLabel(EMAIL_SUFFIX), "2, 0, LEFT, CENTER");
        }
        return panel;
    }

    private JPanel buildDebugPane() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] tableSize = new double[][]{{-1.0}, {-1.0, 32.0}};
        TableLayout layout = new TableLayout(tableSize);
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane pane = new JScrollPane(this.debugArea);
        panel.add((Component)pane, "0, 0");
        panel.add((Component)this.copyButton, "0, 1, CENTER, BOTTOM");
        return panel;
    }

    private JPanel buildFilesToSubmitPane(List<ImportErrorObject> toSubmit) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] tableSize = new double[][]{{-1.0}, {-1.0}};
        TableLayout layout = new TableLayout(tableSize);
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.table = new FileTable(toSubmit);
        JScrollPane pane = new JScrollPane(this.table);
        panel.add((Component)pane, "0, 0");
        return panel;
    }

    private JPanel buildCommentPane(String comment) {
        JPanel commentPanel = new JPanel();
        int iconSpace = 0;
        double[][] tableSize = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {0.0, 0.0, 30.0, -1.0}};
        TableLayout layout = new TableLayout(tableSize);
        commentPanel.setLayout(layout);
        commentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        commentPanel.add((Component)this.buildEmailAreaPanel(69), "0, 2, 2, 2");
        commentPanel.add((Component)this.buildCommentAreaPanel(comment, 87), "0, 3, 2, 3");
        if (CommonsLangUtils.isNotBlank(this.errorDescription)) {
            layout.setRow(1, 30.0);
            JPanel p = new JPanel();
            p.add(UIUtilities.setTextFont(ERROR_BRIEF));
            p.add(new JLabel(this.errorDescription));
            commentPanel.add((Component)UIUtilities.buildComponentPanel(p), "0, 1, 2, 1");
        }
        return commentPanel;
    }

    private JTabbedPane buildExceptionPane(List<ImportErrorObject> toSubmit) {
        JTabbedPane tPane = new JTabbedPane();
        tPane.setOpaque(false);
        if (this.dialogType == 2) {
            tPane.addTab("Comments", null, this.buildCommentPane(COMMENT_FIELD), "Your comments go here.");
            tPane.addTab("Files to Send", null, this.buildFilesToSubmitPane(toSubmit), "The files to send to the development team.");
        } else {
            tPane.addTab("Comments", null, this.buildCommentPane(DEBUG_COMMENT_FIELD), "Your comments go here.");
            tPane.addTab("Error Message", null, this.buildDebugPane(), "The Exception Message.");
        }
        return tPane;
    }

    private JPanel buildToolBar(List<ImportErrorObject> toSubmit) {
        JPanel bars = new JPanel();
        bars.setLayout(new BoxLayout(bars, 0));
        if (CollectionUtils.isNotEmpty(toSubmit)) {
            boolean count = false;
            Iterator<ImportErrorObject> j = toSubmit.iterator();
            while (j.hasNext()) {
                if (j.next().getFile() == null) continue;
                count = true;
                break;
            }
            JPanel row = new JPanel();
            row.setLayout(new FlowLayout(0, 0, 0));
            if (count) {
                row.add(new JLabel("Submit Exceptions and: "));
                row.add(UIUtilities.buildComponentPanel(this.submitFile));
            }
            JPanel p = new JPanel();
            p.setBorder(null);
            p.setLayout(new BoxLayout(p, 1));
            p.add(row);
            JPanel progressPane = new JPanel();
            progressPane.setLayout(new BoxLayout(progressPane, 0));
            progressPane.add((Component)this.progress);
            progressPane.add(Box.createHorizontalStrut(5));
            progressPane.add(this.progressLabel);
            p.add(UIUtilities.buildComponentPanel(progressPane));
            bars.add(UIUtilities.buildComponentPanel(p));
        }
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.cancelButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.sendButton);
        bar.add(Box.createHorizontalStrut(10));
        bars.add(UIUtilities.buildComponentPanelRight(bar));
        return bars;
    }

    private void buildGUI(List<ImportErrorObject> toSubmit) {
        Icon icon;
        JComponent component;
        String message;
        IconManager icons = IconManager.getInstance();
        if (this.dialogType == 2) {
            message = SUBMIT_MESSAGE;
            component = this.buildExceptionPane(toSubmit);
            icon = icons.getIcon(132);
            if (icon == null) {
                icon = UIManager.getIcon("OptionPane.errorIcon");
            }
        } else if (this.exception == null) {
            message = MESSAGE;
            icon = icons.getIcon(21);
            if (icon == null) {
                icon = UIManager.getIcon("OptionPane.questionIcon");
            }
            component = this.buildCommentPane(COMMENT_FIELD);
        } else {
            message = DEBUG_MESSAGE;
            component = this.buildExceptionPane(null);
            icon = icons.getIcon(22);
            if (icon == null) {
                icon = UIManager.getIcon("OptionPane.errorIcon");
            }
        }
        Container c = this.getContentPane();
        TitlePanel tp = new TitlePanel(this.getTitle(), message, icon);
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)component, "Center");
        c.add((Component)this.buildToolBar(toSubmit), "South");
    }

    private void initialize(String title, List<ImportErrorObject> toSubmit) {
        this.setTitle(title);
        this.initComponents();
        this.buildGUI(toSubmit);
        this.setSize(DEFAULT_SIZE);
    }

    public MessengerDialog(JFrame parent, String title, String emailAddress) {
        super(parent);
        this.emailAddress = emailAddress;
        this.dialogType = 1;
        this.initialize(title, null);
    }

    public MessengerDialog(JFrame parent, String title, String emailAddress, Exception exception) {
        super(parent);
        this.dialogType = 0;
        this.emailAddress = emailAddress;
        this.exception = exception;
        this.initialize(title, null);
    }

    public MessengerDialog(JFrame parent, String title, String emailAddress, List<ImportErrorObject> toSubmit) {
        super(parent);
        this.dialogType = 2;
        this.emailAddress = emailAddress;
        this.initialize(title, toSubmit);
    }

    public void setErrorDescription(String description) {
        this.errorDescription = description;
    }

    public void setComment(String comment) {
        if (comment != null && comment.trim().length() > 0) {
            this.commentArea.setText(comment);
        }
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setSubmitStatus(String text, boolean hide) {
        this.progressLabel.setText(text);
        this.progress.setVisible(!hide);
        this.progress.setBusy(!hide);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.send(SEND_PROPERTY);
                break;
            }
            case 3: {
                this.copy();
                break;
            }
            case 4: {
                this.submitFilesControl();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.dialogType == 1) {
            String text = this.commentArea.getText();
            this.sendButton.setEnabled(text != null && text.trim().length() > 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.dialogType == 1) {
            String text = this.commentArea.getText();
            this.sendButton.setEnabled(text != null && text.trim().length() > 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.pack();
    }
}

