/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.Collection;
import java.util.List;
import omero.gateway.SecurityContext;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DownloadArchivedActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ArchivedLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class DownloadArchivedActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATED = "Original Image downloaded";
    private static final String DESCRIPTION_CANCEL = "Download Original Image cancelled";
    private static final String DESCRIPTION_NO_ARCHIVED = "No Original Image available";
    private static final String OPTION_NO_ARCHIVED = "You can download the Image as OME-TIFF";
    private DownloadArchivedActivityParam parameters;

    DownloadArchivedActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, DownloadArchivedActivityParam parameters) {
        super(viewer, registry, ctx);
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters");
        }
        this.parameters = parameters;
        this.initialize("Downloading Original Image", parameters.getIcon());
        File f = parameters.getLocation();
        if (f.isFile() || !f.exists()) {
            f = f.getParentFile();
        }
        this.messageLabel.setText("in " + f.getAbsolutePath());
        this.parameters = parameters;
    }

    @Override
    protected UserNotifierLoader createLoader() {
        File f = this.parameters.getLocation();
        this.loader = new ArchivedLoader(this.viewer, this.registry, this.ctx, this.parameters.getImages(), f, this.parameters.isOverride(), this.parameters.isZip(), this.parameters.isKeepOriginalPaths(), this);
        return this.loader;
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityEnd() {
        List files = (List)this.result;
        if (CollectionUtils.isEmpty((Collection)files)) {
            this.type.setText(DESCRIPTION_NO_ARCHIVED);
            this.messageLabel.setText(OPTION_NO_ARCHIVED);
            return;
        }
        this.type.setText(DESCRIPTION_CREATED);
        StringBuffer buffer = new StringBuffer();
        buffer.append("as ");
        buffer.append(((File)files.get(0)).getAbsolutePath());
        this.messageLabel.setText(buffer.toString());
    }

    @Override
    protected void notifyActivityError() {
    }
}

