/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.DataObjectRemover;
import org.openmicroscopy.shoola.env.ui.FileLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.HTMLFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DownloadActivity
extends ActivityComponent {
    private static final String FILE = "file://";
    private static final String DESCRIPTION = "File downloaded";
    private static final String DESCRIPTION_CANCEL = "Download cancelled";
    public static final String LEGEND_TEXT = "_legend.txt";
    public static final String LEGEND_TEXT_CSV = "_legend.csv";
    protected DownloadActivityParam parameters;
    protected String fileName;
    protected File file;
    private String localFileName;
    private boolean overwrite = false;
    private static final List<CustomizedFileFilter> FILTERS = new ArrayList<CustomizedFileFilter>();

    private String getFileName() {
        File folder;
        File directory = folder = this.parameters.getFolder();
        directory = folder.getParentFile();
        File[] files = directory.listFiles();
        String dirPath = directory.getAbsolutePath() + File.separator;
        String value = folder.getName();
        if (this.parameters.getFileName() != null) {
            value = this.parameters.getFileName();
        }
        String extension = null;
        if (value != null && value.trim().length() > 0) {
            int lastDot = value.lastIndexOf(".");
            if (lastDot == -1) {
                String s = this.parameters.getOriginalFileName();
                if (s.endsWith("ome.tif") || s.endsWith("ome.tiff")) {
                    extension = "ome.tiff";
                } else {
                    lastDot = s.lastIndexOf(".");
                    if (lastDot != -1) {
                        extension = s.substring(lastDot, s.length());
                    }
                }
                if (extension != null) {
                    value = value + extension;
                }
            }
            return this.getFileName(files, value, value, dirPath, 1, extension);
        }
        value = this.parameters.getOriginalFileName();
        if (value == null || value.length() == 0) {
            return "";
        }
        return this.getFileName(files, value, value, dirPath, 1, null);
    }

    private boolean canOpenFile(String path) {
        for (CustomizedFileFilter filter : FILTERS) {
            if (!filter.accept(path)) continue;
            return true;
        }
        return false;
    }

    public DownloadActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, DownloadActivityParam parameters) {
        super(viewer, registry, ctx);
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        this.initialize("Download", parameters.getIcon());
        File folder = parameters.getFolder();
        this.fileName = this.getFileName();
        this.localFileName = folder.isDirectory() ? folder + File.separator + this.fileName : folder.toString();
        this.messageLabel.setText(this.localFileName);
        this.overwrite = parameters.isOverwrite();
    }

    @Override
    protected UserNotifierLoader createLoader() {
        OriginalFile f = this.parameters.getFile();
        File folder = this.parameters.getFolder();
        this.file = folder.isDirectory() ? new File(folder, this.fileName) : folder;
        this.registry.getLogger().debug((Object)this, this.file.getAbsolutePath());
        boolean load = true;
        if (this.file.exists() && !this.overwrite) {
            load = false;
        }
        switch (this.parameters.getIndex()) {
            case 0: 
            case 1: 
            case 2: {
                this.loader = new FileLoader(this.viewer, this.registry, this.ctx, this.file, this.parameters.getId(), this.parameters.getIndex(), load, this);
                break;
            }
            default: {
                this.loader = new FileLoader(this.viewer, this.registry, this.ctx, this.file, f.getId().getValue(), load, this);
            }
        }
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION);
        String name = null;
        String legend = this.parameters.getLegend();
        if (legend != null && legend.trim().length() > 0) {
            File folder = this.parameters.getFolder();
            File directory = folder.getParentFile();
            BufferedWriter out = null;
            String n = UIUtilities.removeFileExtension(this.fileName);
            String ext = LEGEND_TEXT;
            String le = this.parameters.getLegendExtension();
            if (le != null && le.length() > 0) {
                ext = le;
            }
            try {
                name = directory + File.separator + n;
                name = name + ext;
                out = new BufferedWriter(new FileWriter(name));
                out.write(legend);
                out.close();
            }
            catch (Exception e) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.localFileName == null) {
            return;
        }
        if (this.canOpenFile(this.localFileName)) {
            String url = UIUtilities.isMacOS() ? FILE + this.localFileName : "file:///" + this.localFileName;
            this.registry.getTaskBar().openURL(url);
        }
        if (this.parameters.getToDelete() != null) {
            ArrayList<DeletableObject> tmp = new ArrayList<DeletableObject>();
            tmp.add(new DeletableObject((DataObject)this.parameters.getToDelete()));
            DataObjectRemover eraser = new DataObjectRemover(this.viewer, this.registry, tmp, null);
            eraser.load();
        }
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
    }

    static {
        FILTERS.add(new JPEGFilter());
        FILTERS.add(new PNGFilter());
        FILTERS.add(new HTMLFilter());
        FILTERS.add(new TIFFFilter());
    }
}

