/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.ImageData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;

public class MIFResultObject {
    private static final int MAX = 4;
    private SecurityContext ctx;
    private Map<Long, Map<Boolean, List<ImageData>>> result;
    private List<ThumbnailData> thumbnails;

    public MIFResultObject(SecurityContext ctx, Map<Long, Map<Boolean, List<ImageData>>> result) {
        this.ctx = ctx;
        this.result = result;
    }

    public List<ImageData> getFailures() {
        ArrayList<ImageData> failures = new ArrayList<ImageData>();
        for (Map<Boolean, List<ImageData>> e : this.result.values()) {
            failures.addAll((Collection<ImageData>)e.get(false));
        }
        return failures;
    }

    public SecurityContext getContext() {
        return this.ctx;
    }

    public Map<Long, Map<Boolean, List<ImageData>>> getResult() {
        return this.result;
    }

    public List<ImageData> getImages() {
        ArrayList<ImageData> ids = new ArrayList<ImageData>();
        for (Map<Boolean, List<ImageData>> e : this.result.values()) {
            for (List<ImageData> l : e.values()) {
                if (l.size() > 4) {
                    ids.addAll(l.subList(0, 3));
                    continue;
                }
                ids.addAll(l);
            }
        }
        return ids;
    }

    public void setThumbnails(List<ThumbnailData> thumbnails) {
        this.thumbnails = thumbnails;
    }

    public List<ThumbnailData> getThumbnailsFromList(List<ImageData> images) {
        ArrayList<ThumbnailData> l = new ArrayList<ThumbnailData>();
        if (CollectionUtils.isEmpty(this.thumbnails)) {
            return l;
        }
        HashMap<Long, ThumbnailData> map = new HashMap<Long, ThumbnailData>();
        for (ThumbnailData data : this.thumbnails) {
            map.put(data.getImageID(), data);
        }
        for (ImageData img : images) {
            if (!map.containsKey(img.getId())) continue;
            l.add((ThumbnailData)map.get(img.getId()));
        }
        return l;
    }
}

