/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import loci.formats.codec.CompressionType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileObject {
    public static final String OMERO_ID = "Omero_iid";
    public static final String OMERO_GROUP = "Omero_group";
    private Object file;
    private boolean generated;
    private List<FileObject> associatedFiles;
    private File trueFile;

    private Node getPixelsNode(Document doc) {
        NodeList l = doc.getElementsByTagName("Image");
        if (l == null || l.getLength() == 0) {
            return null;
        }
        int series = this.getIndex();
        for (int i = 0; i < l.getLength(); ++i) {
            NodeList nodeList;
            NamedNodeMap attributes;
            String value;
            Node node = l.item(i);
            if (!node.hasAttributes() || !(value = (attributes = node.getAttributes()).getNamedItem("ID").getNodeValue()).equals("Image:" + series) || (nodeList = node.getChildNodes()) == null || nodeList.getLength() <= 0) continue;
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Node n = nodeList.item(j);
                if (!"Pixels".equals(n.getNodeName())) continue;
                return n;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document xmlParser(String xmlStr) throws SAXException {
        InputSource stream = new InputSource();
        stream.setCharacterStream(new StringReader(xmlStr));
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Document doc = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(stream);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace(pw);
            IJ.log((String)sw.toString());
        }
        catch (IOException e) {
            e.printStackTrace(pw);
            IJ.log((String)sw.toString());
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e) {
                IJ.log((String)("I/O Exception:" + e.getMessage()));
            }
            pw.close();
        }
        return doc;
    }

    public FileObject(Object file) {
        if (file == null) {
            throw new IllegalArgumentException("No object to import");
        }
        this.file = file;
    }

    public void setImageID(long id) {
        if (!this.isImagePlus()) {
            return;
        }
        ImagePlus image = (ImagePlus)this.file;
        image.setProperty(OMERO_ID, (Object)id);
    }

    public void addAssociatedFile(FileObject file) {
        if (this.associatedFiles == null) {
            this.associatedFiles = new ArrayList<FileObject>();
        }
        if (file != null) {
            this.associatedFiles.add(file);
        }
    }

    public List<FileObject> getAssociatedFiles() {
        return this.associatedFiles;
    }

    public Object getFile() {
        return this.file;
    }

    public String getName() {
        if (this.file instanceof File) {
            return ((File)this.file).getName();
        }
        if (this.file instanceof ImagePlus) {
            ImagePlus img = (ImagePlus)this.file;
            return img.getTitle();
        }
        return null;
    }

    public String getAbsolutePath() {
        if (this.file instanceof File) {
            return ((File)this.file).getAbsolutePath();
        }
        if (this.file instanceof ImagePlus) {
            File f = this.getTrueFile();
            if (f != null) {
                return f.getAbsolutePath();
            }
            return ((ImagePlus)this.file).getTitle();
        }
        return "";
    }

    public File getFileToImport() {
        File f = this.getTrueFile();
        if (f != null) {
            return f;
        }
        if (this.file instanceof ImagePlus) {
            ImagePlus img = (ImagePlus)this.file;
            this.generated = true;
            try {
                String baseName = FilenameUtils.getBaseName((String)FilenameUtils.removeExtension((String)img.getTitle()));
                baseName = CommonsLangUtils.deleteWhitespace(baseName);
                String n = baseName + ".ome.tif";
                f = File.createTempFile(img.getTitle(), ".ome.tif");
                File p = f.getParentFile();
                File[] list = p.listFiles();
                if (list != null) {
                    File toDelete = null;
                    for (int i = 0; i < list.length; ++i) {
                        if (!list[i].getName().equals(n)) continue;
                        toDelete = list[i];
                        break;
                    }
                    if (toDelete != null) {
                        toDelete.delete();
                    }
                }
                f = new File(p, n);
                f.deleteOnExit();
            }
            catch (Exception e) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("outfile=" + f.getAbsolutePath());
            buffer.append(" splitz=false");
            buffer.append(" splitc=false");
            buffer.append(" splitt=false");
            buffer.append(" saveroi=false");
            buffer.append(" compression=" + CompressionType.UNCOMPRESSED.getCompression());
            buffer.append(" imageid=" + img.getID() + " ");
            IJ.runPlugIn((String)"loci.plugins.LociExporter", (String)buffer.toString());
            return f;
        }
        return null;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isNewImage() {
        if (this.file instanceof ImagePlus) {
            String xmlStr;
            ImagePlus img = (ImagePlus)this.file;
            if (img.changes) {
                return true;
            }
            FileInfo info = img.getOriginalFileInfo();
            if (info == null) {
                info = img.getFileInfo();
                String name = info.fileName;
                if (CommonsLangUtils.isBlank(name) || "Untitled".equals(name)) {
                    return true;
                }
            }
            if (CommonsLangUtils.isBlank(xmlStr = info.description)) {
                return false;
            }
            int sizeC_cur = img.getNChannels();
            int sizeT_cur = img.getNFrames();
            int sizeZ_cur = img.getNSlices();
            int sizeC_org = sizeC_cur;
            int sizeT_org = sizeT_cur;
            int sizeZ_org = sizeZ_cur;
            Document doc = null;
            boolean xml = false;
            try {
                if (xmlStr.startsWith("<")) {
                    doc = this.xmlParser(xmlStr);
                }
            }
            catch (SAXException e) {
                xml = false;
            }
            if (!xml) {
                String[] values = xmlStr.split("\n");
                for (int i = 0; i < values.length; ++i) {
                    String[] keys;
                    String v = values[i];
                    if (v.startsWith("slices")) {
                        keys = v.split("=");
                        if (keys.length <= 1) continue;
                        sizeZ_org = Integer.valueOf(keys[1]);
                        continue;
                    }
                    if (v.startsWith("channels")) {
                        keys = v.split("=");
                        if (keys.length <= 1) continue;
                        sizeC_org = Integer.valueOf(keys[1]);
                        continue;
                    }
                    if (!v.startsWith("frames") || (keys = v.split("=")).length <= 1) continue;
                    sizeT_org = Integer.valueOf(keys[1]);
                }
            }
            if (doc != null) {
                Node node = this.getPixelsNode(doc);
                if (node == null) {
                    return false;
                }
                NamedNodeMap nnm = node.getAttributes();
                sizeC_org = Integer.valueOf(nnm.getNamedItem("SizeC").getNodeValue());
                sizeT_org = Integer.valueOf(nnm.getNamedItem("SizeT").getNodeValue());
                sizeZ_org = Integer.valueOf(nnm.getNamedItem("SizeZ").getNodeValue());
            }
            if (sizeC_cur != sizeC_org || sizeT_cur != sizeT_org || sizeZ_cur != sizeZ_org) {
                return true;
            }
        }
        return false;
    }

    public File getTrueFile() {
        if (this.file instanceof File) {
            return (File)this.file;
        }
        if (this.file instanceof ImagePlus) {
            FileInfo info;
            if (this.trueFile != null) {
                return this.trueFile;
            }
            ImagePlus img = (ImagePlus)this.file;
            if (!img.changes && (info = img.getOriginalFileInfo()) != null) {
                if (CommonsLangUtils.isNotEmpty(info.url)) {
                    String fname = img.getTitle();
                    String extension = FilenameUtils.getExtension((String)fname);
                    String baseName = FilenameUtils.getBaseName((String)FilenameUtils.removeExtension((String)fname));
                    try {
                        this.trueFile = File.createTempFile(baseName, "." + extension);
                        this.trueFile.deleteOnExit();
                        FileUtils.copyURLToFile((URL)new URL(info.url), (File)this.trueFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return this.trueFile;
                }
                if (info.directory != null && info.fileName != null) {
                    this.trueFile = new File(info.directory, info.fileName);
                    return this.trueFile;
                }
            }
        }
        return null;
    }

    public String getParentName() {
        File f = this.getTrueFile();
        if (f == null || f.getParentFile() == null) {
            return null;
        }
        return f.getParentFile().getName();
    }

    public long getLength() {
        File f;
        if (this.file instanceof File) {
            File f2 = (File)this.file;
            if (f2.isFile()) {
                return f2.length();
            }
            return FileUtils.sizeOfDirectory((File)f2);
        }
        if (this.file instanceof ImagePlus && (f = this.getTrueFile()) != null) {
            return f.length();
        }
        return 0L;
    }

    public boolean isDirectory() {
        if (this.file instanceof File) {
            File f = (File)this.file;
            return f.isDirectory();
        }
        return false;
    }

    public boolean isFile() {
        if (this.file instanceof File) {
            File f = (File)this.file;
            return f.isFile();
        }
        return true;
    }

    public boolean isImagePlus() {
        return this.file instanceof ImagePlus;
    }

    public int getIndex() {
        if (!this.isImagePlus()) {
            return -1;
        }
        ImagePlus image = (ImagePlus)this.file;
        Object value = image.getProperty("Series");
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }

    public long getOMEROID() {
        if (!this.isImagePlus()) {
            return -1L;
        }
        ImagePlus image = (ImagePlus)this.file;
        Object value = image.getProperty(OMERO_ID);
        if (value != null && value instanceof Long) {
            return (Long)value;
        }
        return -1L;
    }

    public long getGroupID() {
        if (!this.isImagePlus()) {
            return -1L;
        }
        ImagePlus image = (ImagePlus)this.file;
        Object value = image.getProperty(OMERO_GROUP);
        if (value != null && value instanceof Long) {
            return (Long)value;
        }
        return -1L;
    }

    public String getFolderAsContainerName() {
        if (this.file instanceof File) {
            File f = (File)this.file;
            if (f.isFile()) {
                File parentFile = f.getParentFile();
                if (parentFile == null) {
                    return null;
                }
                return parentFile.getName();
            }
            return f.getName();
        }
        File f = this.getTrueFile();
        if (f != null && f.getParentFile() != null) {
            return f.getParentFile().getName();
        }
        return this.getName();
    }
}

