/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.util.SelectionWizardDataSource;
import org.openmicroscopy.shoola.agents.util.SelectionWizardUI;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SelectionWizard
extends JDialog
implements ActionListener,
DocumentListener,
FocusListener,
PropertyChangeListener {
    public static final String SELECTED_ITEMS_PROPERTY = "selectedItems";
    public static final String CANCEL_SELECTION_PROPERTY = "cancelSelection";
    public static final String DATASOURCE_PROPERTY = "datasource";
    private static final String DEFAULT_TAG_TEXT = "Tag";
    private static final String DEFAULT_FOLDER_TEXT = "Folder";
    private static final String DEFAULT_DESCRIPTION = "Description";
    private static final int ACCEPT = 0;
    private static final int CANCEL = 1;
    private static final int RESET = 2;
    private static final int ADD_NEW = 3;
    private static final Dimension DEFAULT_SIZE = new Dimension(700, 700);
    private JButton acceptButton;
    private JButton resetButton;
    private JButton cancelButton;
    private Class<?> type;
    private JButton addNewButton;
    private JTextField addField;
    private JTextField descriptionField;
    private SelectionWizardUI uiDelegate;
    private Color originalColor;
    private JLabel addLabel;
    private SelectionWizardDataSource[] dataSources = new SelectionWizardDataSource[0];
    private JPanel container;
    private boolean allowCreation;

    private void setControls() {
        String text = this.addField.getText();
        this.addNewButton.setEnabled(CommonsLangUtils.isNotBlank(text) && !this.getDefaultText().equals(text));
    }

    private String getDefaultText() {
        if (FolderData.class.equals(this.type)) {
            return DEFAULT_FOLDER_TEXT;
        }
        return DEFAULT_TAG_TEXT;
    }

    private void setTextFieldDefault(JTextField field, String text) {
        field.getDocument().removeDocumentListener(this);
        if (text == null) {
            field.setText("");
            field.setForeground(this.originalColor);
        } else {
            field.setText(text);
            field.setForeground(Color.LIGHT_GRAY);
        }
        field.getDocument().addDocumentListener(this);
        this.setControls();
    }

    private JPanel createFilteringControl() {
        JPanel p;
        JPanel rows = new JPanel();
        rows.setLayout(new BoxLayout(rows, 1));
        if (this.dataSources.length > 1) {
            p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(new JLabel("Source "));
            final JComboBox<SelectionWizardDataSource> box = new JComboBox<SelectionWizardDataSource>(this.dataSources);
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectionWizardDataSource ds = (SelectionWizardDataSource)box.getSelectedItem();
                    SelectionWizard.this.uiDelegate.setAvailableItems(ds.getData());
                    SelectionWizard.this.firePropertyChange(SelectionWizard.DATASOURCE_PROPERTY, null, ds);
                }
            });
            p.add(box);
            rows.add(p);
        }
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Filter by"));
        String txt = null;
        if (TagAnnotationData.class.equals(this.type)) {
            txt = "tag";
        } else if (TagAnnotationData.class.equals(this.type)) {
            txt = "attachment";
        }
        String[] values = new String[2];
        StringBuilder builder = new StringBuilder();
        builder.append("Start of ");
        if (txt != null) {
            builder.append(txt);
            builder.append(" ");
        }
        builder.append("name");
        values[0] = builder.toString();
        builder = new StringBuilder();
        builder.append("Anywhere in ");
        if (txt != null) {
            builder.append(txt);
            builder.append(" ");
        }
        builder.append("name");
        values[1] = builder.toString();
        JComboBox<String> box = new JComboBox<String>(values);
        int selected = 0;
        if (this.uiDelegate.isFilterAnywhere()) {
            selected = 1;
        }
        box.setSelectedIndex(selected);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                SelectionWizard.this.uiDelegate.setFilterAnywhere(src.getSelectedIndex() == 1);
            }
        });
        p.add(box);
        rows.add(p);
        if (!ExperimenterData.class.equals(this.type)) {
            p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(new JLabel("Filter by owner"));
            values = new String[3];
            values[SelectionWizardUI.ALL.intValue()] = "All";
            values[SelectionWizardUI.CURRENT] = "Owned by me";
            values[SelectionWizardUI.OTHERS] = "Owned by others";
            box = new JComboBox<String>(values);
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox src = (JComboBox)e.getSource();
                    SelectionWizard.this.uiDelegate.setOwnerIndex(src.getSelectedIndex());
                }
            });
            p.add(box);
            rows.add(p);
        }
        return UIUtilities.buildComponentPanel(rows);
    }

    private void initComponents() {
        this.addLabel = UIUtilities.setTextFont("");
        this.acceptButton = new JButton("Save");
        this.acceptButton.setToolTipText("Save the selection.");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel the selection.");
        this.resetButton = new JButton("Reset");
        this.resetButton.setToolTipText("Reset the selection.");
        this.addNewButton = new JButton("Add");
        this.addNewButton.setEnabled(false);
        this.addNewButton.setToolTipText("Add to the selection.");
        this.addNewButton.setActionCommand("3");
        this.addNewButton.addActionListener(this);
        this.acceptButton.setActionCommand("0");
        this.acceptButton.addActionListener(this);
        this.acceptButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.cancelButton.setActionCommand("1");
        this.cancelButton.addActionListener(this);
        this.resetButton.setActionCommand("2");
        this.resetButton.addActionListener(this);
        this.addField = new JTextField(10);
        this.addField.setToolTipText("Tag Name");
        this.originalColor = this.addField.getForeground();
        this.setTextFieldDefault(this.addField, this.getDefaultText());
        this.addField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        if (!SelectionWizard.this.addField.isFocusOwner()) break;
                        SelectionWizard.this.addNewObjects();
                    }
                }
            }
        });
        this.descriptionField = new JTextField(15);
        this.descriptionField.setToolTipText("Tag Description");
        this.setTextFieldDefault(this.descriptionField, DEFAULT_DESCRIPTION);
        this.addField.getDocument().addDocumentListener(this);
        this.addField.addFocusListener(this);
        this.descriptionField.addFocusListener(this);
        this.descriptionField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        if (!SelectionWizard.this.descriptionField.isFocusOwner()) break;
                        SelectionWizard.this.addNewObjects();
                    }
                }
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void cancel() {
        this.close();
        this.firePropertyChange(CANCEL_SELECTION_PROPERTY, (Object)false, (Object)true);
    }

    private void accept() {
        HashMap r = new HashMap();
        Collection<Object> l = this.uiDelegate.getSelection();
        l.addAll(this.uiDelegate.getImmutableElements());
        r.put(this.type, l);
        this.firePropertyChange(SELECTED_ITEMS_PROPERTY, null, r);
        this.close();
    }

    private void buildUI() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.container = new JPanel();
        this.container.setLayout(new BoxLayout(this.container, 1));
        this.container.add(this.uiDelegate);
        this.container.add(this.createFilteringControl());
        if (this.allowCreation && (TagAnnotationData.class.equals(this.type) || FolderData.class.equals(this.type))) {
            this.container.add(this.createAdditionPane());
        }
        c.add((Component)this.container, "Center");
        c.add((Component)this.createControlsPane(), "South");
    }

    private JPanel createControlsPane() {
        JPanel controlPanel = new JPanel();
        controlPanel.setOpaque(false);
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.acceptButton);
        controlPanel.add(this.cancelButton);
        controlPanel.add(this.resetButton);
        return UIUtilities.buildComponentPanelRight(controlPanel);
    }

    private void formatAddLabelText() {
        DataObject data;
        String s = "";
        Set<DataObject> list = this.uiDelegate.getAvailableSelectedNodes();
        if (CollectionUtils.isNotEmpty(list) && (data = (DataObject)list.iterator().next()) instanceof TagAnnotationData) {
            s = String.format(" in %s Tag set", ((TagAnnotationData)data).getTagValue());
        }
        String tip = String.format("Add a new tag%s and select it immediately:", s);
        this.addLabel.setText(tip);
    }

    private JPanel createAdditionPane() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.setLayout(new BoxLayout(p, 1));
        if (TagAnnotationData.class.equals(this.type)) {
            this.formatAddLabelText();
            p.add(UIUtilities.buildComponentPanel(this.addLabel));
            JPanel pane = new JPanel();
            pane.setLayout(new BoxLayout(pane, 0));
            pane.add(this.addField);
            pane.add(Box.createHorizontalStrut(5));
            pane.add(this.descriptionField);
            pane.add(this.addNewButton);
            p.add(pane);
        } else if (FolderData.class.equals(this.type)) {
            this.addLabel.setText("Create a new folder and select it immediately:");
            this.addField.setToolTipText("Folder Name");
            this.descriptionField.setToolTipText("Folder Description");
            p.add(UIUtilities.buildComponentPanel(this.addLabel));
            JPanel pane = new JPanel();
            pane.setLayout(new BoxLayout(pane, 0));
            pane.add(this.addField);
            pane.add(Box.createHorizontalStrut(5));
            pane.add(this.descriptionField);
            pane.add(this.addNewButton);
            p.add(pane);
        }
        return UIUtilities.buildComponentPanel(p);
    }

    private void addNewObjects() {
        if (TagAnnotationData.class.equals(this.type)) {
            String text = this.addField.getText();
            if (CommonsLangUtils.isEmpty(text)) {
                return;
            }
            String[] names = text.split(",");
            ArrayList<DataObject> objects = new ArrayList<DataObject>();
            String description = this.descriptionField.getText();
            if (DEFAULT_DESCRIPTION.equals(description)) {
                description = null;
            }
            Set<DataObject> parents = this.uiDelegate.getAvailableSelectedNodes();
            for (int i = 0; i < names.length; ++i) {
                String v = names[i];
                if (!CommonsLangUtils.isNotBlank(v)) continue;
                TagAnnotationData tag = new TagAnnotationData(v.trim());
                if (description != null) {
                    tag.setTagDescription(description);
                }
                if (CollectionUtils.isNotEmpty(parents)) {
                    tag.setDataObjects(parents);
                }
                objects.add((DataObject)tag);
            }
            boolean reset = this.uiDelegate.addObjects(objects);
            if (reset) {
                this.addField.setCaretPosition(0);
                this.setTextFieldDefault(this.addField, this.getDefaultText());
                this.descriptionField.setCaretPosition(0);
                this.setTextFieldDefault(this.descriptionField, DEFAULT_DESCRIPTION);
                this.acceptButton.requestFocus();
            }
        } else if (FolderData.class.equals(this.type)) {
            boolean reset;
            DataObject tmp;
            String name = this.addField.getText();
            if (CommonsLangUtils.isEmpty(name)) {
                return;
            }
            String description = this.descriptionField.getText();
            if (DEFAULT_DESCRIPTION.equals(description)) {
                description = null;
            }
            FolderData folder = new FolderData();
            folder.setName(name);
            folder.setDescription(description);
            Set<DataObject> parents = this.uiDelegate.getAvailableSelectedNodes();
            if (parents != null && parents.size() == 1 && (tmp = parents.iterator().next()) instanceof FolderData) {
                FolderData parentFolder = (FolderData)tmp;
                folder.setParentFolder(parentFolder.asFolder());
            }
            if (reset = this.uiDelegate.addObjects(Arrays.asList(folder))) {
                this.addField.setCaretPosition(0);
                this.setTextFieldDefault(this.addField, this.getDefaultText());
                this.descriptionField.setCaretPosition(0);
                this.setTextFieldDefault(this.descriptionField, DEFAULT_DESCRIPTION);
                this.acceptButton.requestFocus();
            }
        }
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Class<?> type, ExperimenterData user) {
        this(owner, available, null, type, user);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Class<?> type, boolean addCreation, ExperimenterData user) {
        this(owner, available, null, type, addCreation, user);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Collection<Object> selected, Class<?> type, ExperimenterData user) {
        this(owner, available, selected, type, false, user);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Collection<Object> selected, Class<?> type, boolean addCreation, ExperimenterData user) {
        super(owner);
        this.setModal(true);
        this.allowCreation = addCreation;
        this.uiDelegate = new SelectionWizardUI(this, available, selected, type, user);
        this.uiDelegate.addPropertyChangeListener(this);
        this.type = type;
        this.initComponents();
        this.buildUI();
        this.setSize(DEFAULT_SIZE);
    }

    public SelectionWizard(JFrame owner, Collection<Object> selected, Class<?> type, boolean addCreation, ExperimenterData user, SelectionWizardDataSource ... dataSources) {
        super(owner);
        this.setModal(true);
        this.allowCreation = addCreation;
        this.dataSources = dataSources;
        Collection<Object> available = dataSources.length > 0 ? dataSources[0].getData() : null;
        this.uiDelegate = new SelectionWizardUI(this, available, selected, type, user);
        this.uiDelegate.addPropertyChangeListener(this);
        this.type = type;
        this.initComponents();
        this.buildUI();
        this.setSize(DEFAULT_SIZE);
    }

    public void setImmutableElements(Collection immutable) {
        this.uiDelegate.setImmutableElements(immutable);
    }

    public void setTitle(String title, String text) {
        this.setTitle(title, text, null);
    }

    public void setTitle(String title, String text, Icon titleIcon) {
        this.setTitle(title);
        if (titleIcon == null) {
            IconManager icons = IconManager.getInstance();
            titleIcon = icons.getIcon(89);
        }
        TitlePanel titlePanel = new TitlePanel(title, text, titleIcon);
        this.getContentPane().add((Component)((Object)titlePanel), "North");
    }

    public void setGroups(Collection<GroupData> groups) {
        this.uiDelegate.setGroups(groups);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int id = Integer.parseInt(evt.getActionCommand());
        switch (id) {
            case 0: {
                this.accept();
                break;
            }
            case 1: {
                this.cancel();
                break;
            }
            case 2: {
                this.uiDelegate.reset();
                break;
            }
            case 3: {
                this.addNewObjects();
            }
        }
    }

    public void setAcceptButtonText(String text) {
        if (this.acceptButton != null) {
            this.acceptButton.setText(text);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setControls();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selectionChange".equals(name)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.acceptButton.setEnabled(b);
            this.resetButton.setEnabled(b);
            this.acceptButton.requestFocus();
        } else if ("availableSelectionChange".equals(name) && TagAnnotationData.class.equals(this.type)) {
            this.formatAddLabelText();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        String value;
        Object src = evt.getSource();
        if (src == this.addField) {
            String value2 = this.addField.getText();
            if (CommonsLangUtils.isBlank(value2)) {
                this.setTextFieldDefault(this.addField, this.getDefaultText());
            }
        } else if (src == this.descriptionField && CommonsLangUtils.isBlank(value = this.descriptionField.getText())) {
            this.setTextFieldDefault(this.descriptionField, DEFAULT_DESCRIPTION);
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
        String value;
        Object src = evt.getSource();
        if (src == this.addField) {
            String value2 = this.addField.getText();
            if (this.getDefaultText().equals(value2)) {
                this.addField.setCaretPosition(0);
                this.setTextFieldDefault(this.addField, null);
            }
        } else if (src == this.descriptionField && DEFAULT_DESCRIPTION.equals(value = this.descriptionField.getText())) {
            this.descriptionField.setCaretPosition(0);
            this.setTextFieldDefault(this.descriptionField, null);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

