/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.util.ui.FixedSizeSeparator;
import org.openmicroscopy.shoola.env.data.model.ImageCheckerResult;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class LinkNotificationDialog
extends JDialog {
    private static final int MAX_DATASETS_PER_IMAGE = 3;
    public static final String DELETE_PROPERTY = "delete";
    private static final String TITLE = "Delete";
    private static final String MESSAGE = "These images are linked to multiple datasets.\nDeleting them will remove them from all datasets!";
    private JButton closeButton;
    private JButton deleteButton;
    private ImageCheckerResult result;

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void initialize() {
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinkNotificationDialog.this.close();
            }
        });
        this.deleteButton = new JButton(TITLE);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinkNotificationDialog.this.firePropertyChange(LinkNotificationDialog.DELETE_PROPERTY, null, null);
                LinkNotificationDialog.this.close();
            }
        });
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.deleteButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        bar.add(this.closeButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        Icon dsIcon = IconManager.getInstance().getIcon(5);
        String title = TITLE;
        this.setTitle(title);
        TitlePanel tp = new TitlePanel(title, MESSAGE, null);
        Container c = this.getContentPane();
        c.add((Component)((Object)tp), "North");
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentY(0.0f);
        p.setAlignmentX(0.0f);
        List<ImageData> imgs = this.result.getMultiLinkedImages();
        Collections.sort(imgs, new ImageDataComparator());
        for (ImageData img : imgs) {
            List<DatasetData> ds = this.result.getDatasets(img);
            JPanel row = new JPanel();
            row.setLayout(new BoxLayout(row, 1));
            String imgName = img.getName();
            if (imgName.length() > 50) {
                imgName = "..." + imgName.substring(imgName.length() - 50, imgName.length());
            }
            JLabel imgNameLabel = new JLabel(imgName);
            row.add(imgNameLabel);
            row.add(Box.createRigidArea(new Dimension(0, 10)));
            int i = 0;
            for (DatasetData dd : ds) {
                JLabel dsLabel;
                if (i >= 3) {
                    dsLabel = new JLabel("... (" + (ds.size() - i) + " more)");
                    dsLabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
                    row.add(dsLabel);
                    break;
                }
                dsLabel = new JLabel(dsIcon);
                dsLabel.setText(dd.getName());
                dsLabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
                row.add(dsLabel);
                ++i;
            }
            p.add(row);
            p.add(Box.createRigidArea(new Dimension(0, 10)));
            p.add(new FixedSizeSeparator(0));
        }
        p.add(Box.createVerticalGlue());
        JScrollPane sp = new JScrollPane(p);
        c.add((Component)sp, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public LinkNotificationDialog(JFrame owner, ImageCheckerResult result) {
        super(owner);
        this.result = result;
        this.initialize();
        this.buildGUI();
        this.pack();
        this.setSize(new Dimension(400, 400));
    }

    class ImageDataComparator
    implements Comparator<ImageData> {
        ImageDataComparator() {
        }

        @Override
        public int compare(ImageData o1, ImageData o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }
    }
}

