/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import omero.ResourceError;
import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ScriptLoader
extends DataTreeViewerLoader {
    private CallHandle handle;
    private long scriptID;

    public ScriptLoader(TreeViewer viewer, SecurityContext ctx, long scriptID) {
        super(viewer, ctx);
        if (scriptID < 0L) {
            throw new IllegalArgumentException("No script specified.");
        }
        this.scriptID = scriptID;
    }

    @Override
    public void load() {
        this.handle = this.mhView.loadScript(this.ctx, this.scriptID, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        this.viewer.setScript((ScriptObject)result);
    }

    @Override
    public void handleException(Throwable exc) {
        this.viewer.setScript(null);
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        if (exc instanceof ProcessException) {
            ProcessException se = (ProcessException)exc;
            s = se.getMessage();
            Throwable cause = se.getCause();
            if (cause instanceof ResourceError) {
                ResourceError re = (ResourceError)cause;
                s = s + String.format("\nError: \"%s\"", re.message);
            } else if (cause != null && cause.getMessage() != null) {
                s = s + ":" + cause.getMessage();
            }
            this.registry.getUserNotifier().notifyInfo("Running Script", s + "\nPlease contact your administrator.");
        } else {
            super.handleException(exc);
        }
    }
}

