/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.model.ChannelData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.XMLAnnotationData;
import omero.log.LogMessage;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import omero.romio.PlaneDef;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.RenderingControlShutDown;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.rnd.RenderingDefinitionHistory;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.rnd.data.ResolutionLevel;
import org.openmicroscopy.shoola.util.file.modulo.ModuloInfo;
import org.openmicroscopy.shoola.util.file.modulo.ModuloParser;
import org.openmicroscopy.shoola.util.image.geom.Factory;

class RendererModel {
    static final int PREVIEW_WIDTH = 256;
    static final int PREVIEW_HEIGHT = 256;
    static final int CD_START = 0;
    static final int CD_END = 255;
    static final int DEPTH_1BIT = 1;
    static final int DEPTH_2BIT = 3;
    static final int DEPTH_3BIT = 7;
    static final int DEPTH_4BIT = 15;
    static final int DEPTH_5BIT = 31;
    static final int DEPTH_6BIT = 63;
    static final int DEPTH_7BIT = 127;
    static final int DEPTH_8BIT = 255;
    static final String LINEAR = "linear";
    static final String LOGARITHMIC = "logarithmic";
    static final String EXPONENTIAL = "exponential";
    static final String POLYNOMIAL = "polynomial";
    private Renderer component;
    private RenderingControl rndControl;
    private int state;
    private int selectedChannelIndex;
    private boolean visible;
    private int rndIndex;
    private List<ChannelData> sortedChannel;
    private Double globalMinChannels;
    private Double globalMaxChannels;
    private PlaneDef plane;
    private Dimension previewSize;
    private RndProxyDef rndDef;
    private RenderingDefinitionHistory history = new RenderingDefinitionHistory();
    private ImageData image;
    private SecurityContext ctx;
    private Map<Integer, ModuloInfo> modulo;
    private RndProxyDef def;
    private Map<Integer, int[]> histogramData = new HashMap<Integer, int[]>();
    private MetadataViewer viewer;

    RendererModel(SecurityContext ctx, RenderingControl rndControl, int rndIndex, RndProxyDef def, MetadataViewer viewer) {
        if (rndControl == null) {
            throw new NullPointerException("No rendering control.");
        }
        this.setRenderingControl(rndControl);
        this.viewer = viewer;
        this.ctx = ctx;
        this.rndIndex = rndIndex;
        this.visible = false;
        this.globalMaxChannels = null;
        this.globalMinChannels = null;
        this.plane = new PlaneDef();
        this.plane.slice = 0;
        this.def = def;
    }

    SecurityContext getSecurityContext() {
        return this.ctx;
    }

    MetadataViewer getViewer() {
        return this.viewer;
    }

    void setImage(ImageData image) {
        this.image = image;
    }

    void setRenderingControl(RenderingControl rndControl) {
        this.rndControl = rndControl;
        if (rndControl != null) {
            this.rndDef = rndControl.getRndSettingsCopy();
            this.history.reset();
        }
    }

    ImageData getRefImage() {
        return this.image;
    }

    boolean hasSelectedChannel() {
        return this.selectedChannelIndex >= 0;
    }

    int createSelectedChannel() {
        List<Integer> active = this.getActiveChannels();
        List<ChannelData> list = this.getChannelData();
        Iterator<ChannelData> i = list.iterator();
        int setIndex = -1;
        while (i.hasNext()) {
            ChannelData channel = i.next();
            int index = channel.getIndex();
            if (!active.contains(index) || setIndex >= 0) continue;
            setIndex = index;
            break;
        }
        return setIndex;
    }

    Color getChannelColor(int index) {
        if (this.rndControl == null) {
            return Color.white;
        }
        return this.rndControl.getRGBA(index);
    }

    String getLookupTable(int index) {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getLookupTable(index);
    }

    boolean isVisible() {
        return this.visible;
    }

    void initialize(Renderer component) {
        this.component = component;
    }

    void discard() {
        if (this.rndControl == null) {
            return;
        }
        RenderingControlShutDown loader = new RenderingControlShutDown(this.ctx, this.rndControl.getPixelsID());
        loader.load();
        this.rndControl = null;
    }

    int getState() {
        return this.state;
    }

    void setInputInterval(int index, double start, double end) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        if (this.isLifetimeImage() && this.getModuloT() == null) {
            for (int i = 0; i < this.getMaxC(); ++i) {
                this.rndControl.setChannelWindow(i, start, end);
            }
        } else {
            this.rndControl.setChannelWindow(index, start, end);
        }
    }

    int getCodomainEnd() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getCodomainEnd();
    }

    int getCodomainStart() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getCodomainStart();
    }

    void setCodomainInterval(int s, int e) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setCodomainInterval(s, e);
    }

    void setBitResolution(int v) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setQuantumStrategy(v);
    }

    void setSelectedChannel(int index) {
        this.selectedChannelIndex = index;
    }

    void setFamily(int channel, String family) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        if (channel < 0 || channel > this.getMaxC()) {
            channel = this.selectedChannelIndex;
        }
        boolean b = this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
        double k = this.rndControl.getChannelCurveCoefficient(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(channel, family, k, b);
    }

    void setCurveCoefficient(double k) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        boolean b = this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
        String family = this.rndControl.getChannelFamily(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(this.selectedChannelIndex, family, k, b);
    }

    void setNoiseReduction(boolean b) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        String family = this.rndControl.getChannelFamily(this.selectedChannelIndex);
        double k = this.rndControl.getChannelCurveCoefficient(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(this.selectedChannelIndex, family, k, b);
    }

    int getSelectedChannel() {
        return this.selectedChannelIndex;
    }

    List getFamilies() {
        if (this.rndControl == null) {
            return new ArrayList();
        }
        return this.rndControl.getFamilies();
    }

    String getFamily() {
        return this.getFamily(this.selectedChannelIndex);
    }

    String getFamily(int channel) {
        if (this.rndControl == null) {
            return "";
        }
        return this.rndControl.getChannelFamily(channel);
    }

    double getCurveCoefficient() {
        return this.getCurveCoefficient(this.selectedChannelIndex);
    }

    double getCurveCoefficient(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelCurveCoefficient(channel);
    }

    int getBitResolution() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getBitResolution();
    }

    boolean isNoiseReduction() {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
    }

    List<ChannelData> getChannelData() {
        if (this.rndControl == null) {
            return new ArrayList<ChannelData>();
        }
        if (this.sortedChannel == null) {
            Object[] data = this.rndControl.getChannelData();
            ViewerSorter sorter = new ViewerSorter();
            this.sortedChannel = Collections.unmodifiableList(sorter.sort(data));
        }
        return this.sortedChannel;
    }

    double getGlobalMin() {
        if (this.getMaxC() > 100) {
            if (this.globalMinChannels == null) {
                double min = Double.MAX_VALUE;
                for (int i = 0; i < this.getMaxC(); ++i) {
                    double value = this.getGlobalMin(i);
                    if (!(value < min)) continue;
                    min = value;
                }
                this.globalMinChannels = min;
            }
            return this.globalMinChannels;
        }
        return this.getGlobalMin(this.selectedChannelIndex);
    }

    double getGlobalMax() {
        if (this.getMaxC() > 100) {
            if (this.globalMaxChannels == null) {
                double max = Double.MIN_VALUE;
                for (int i = 0; i < this.getMaxC(); ++i) {
                    double value = this.getGlobalMax(i);
                    if (!(value > max)) continue;
                    max = value;
                }
                this.globalMaxChannels = max;
            }
            return this.globalMaxChannels;
        }
        return this.getGlobalMax(this.selectedChannelIndex);
    }

    double getGlobalMax(int index) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelData(index).getGlobalMax();
    }

    double getGlobalMin(int index) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelData(index).getGlobalMin();
    }

    double getLowestValue() {
        return this.getLowestValue(this.selectedChannelIndex);
    }

    double getLowestValue(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getPixelsTypeLowerBound(channel);
    }

    double getHighestValue() {
        return this.getHighestValue(this.selectedChannelIndex);
    }

    double getHighestValue(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getPixelsTypeUpperBound(channel);
    }

    double getWindowStart(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelWindowStart(channel);
    }

    double getWindowEnd(int channel) {
        if (this.rndControl == null) {
            return -1.0;
        }
        return this.rndControl.getChannelWindowEnd(channel);
    }

    double getWindowStart() {
        return this.getWindowStart(this.selectedChannelIndex);
    }

    double getWindowEnd() {
        return this.getWindowEnd(this.selectedChannelIndex);
    }

    boolean isGreyScale() {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.getModel().equals("greyscale");
    }

    void saveRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndDef = this.rndControl.saveCurrentSettings();
    }

    boolean isChannelActive(int w) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isActive(w);
    }

    RenderingDefinitionHistory getRndDefHistory() {
        return this.history;
    }

    List<Integer> getActiveChannels() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        if (this.rndControl == null) {
            return active;
        }
        for (int i = 0; i < this.getMaxC(); ++i) {
            if (!this.rndControl.isActive(i)) continue;
            active.add(i);
        }
        return active;
    }

    int getMaxC() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsC();
    }

    int getRndIndex() {
        return this.rndIndex;
    }

    boolean isGeneralIndex() {
        return this.getRndIndex() == 0;
    }

    void setChannelColor(int index, Color color) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setRGBA(index, color);
    }

    String getColorModel() {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getModel();
    }

    void setColorModel(String colorModel) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.makeHistorySnapshot();
        this.rndControl.setModel(colorModel);
    }

    int getMaxX() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsX();
    }

    int getMaxY() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsY();
    }

    int getMaxZ() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsZ();
    }

    int getMaxT() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getPixelsDimensionsT();
    }

    int getRealT() {
        if (this.hasModuloT()) {
            int sizeBin = this.modulo.get(2).getSize();
            return this.getMaxT() / sizeBin;
        }
        return this.getMaxT();
    }

    int getDefaultZ() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getDefaultZ();
    }

    int getDefaultT() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getDefaultT();
    }

    int getRealSelectedT() {
        if (this.rndControl == null) {
            return -1;
        }
        if (this.hasModuloT()) {
            return this.rndControl.getDefaultT() / this.getMaxLifetimeBin();
        }
        return this.rndControl.getDefaultT();
    }

    void setSelectedXYPlane(int z, int t) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        if (t >= 0 && t != this.getDefaultT()) {
            this.rndControl.setDefaultT(t);
        }
        if (z >= 0 && z != this.getDefaultZ()) {
            this.rndControl.setDefaultZ(z);
        }
    }

    void setSelectedZ(int z) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        if (z >= 0 && z != this.getDefaultZ()) {
            this.rndControl.setDefaultZ(z);
        }
    }

    void setChannelActive(int index, boolean active) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setActive(index, active);
    }

    int getCompressionLevel() {
        if (this.rndControl == null) {
            return -1;
        }
        return this.rndControl.getCompressionLevel();
    }

    Length getPixelsSizeY() {
        if (this.rndControl == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return this.rndControl.getPixelsPhysicalSizeY();
    }

    Length getPixelsSizeX() {
        if (this.rndControl == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return this.rndControl.getPixelsPhysicalSizeX();
    }

    Length getPixelsSizeZ() {
        if (this.rndControl == null) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return this.rndControl.getPixelsPhysicalSizeZ();
    }

    RndProxyDef getRndSettingsCopy() {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getRndSettingsCopy();
    }

    RndProxyDef getAlternativeRndSettings() {
        return this.def;
    }

    RndProxyDef getInitialRndSettings() {
        return this.rndDef;
    }

    boolean hasActiveChannel(int band) {
        if (this.rndControl == null) {
            return false;
        }
        switch (band) {
            case 0: {
                return this.rndControl.hasActiveChannelRed();
            }
            case 1: {
                return this.rndControl.hasActiveChannelGreen();
            }
            case 2: {
                return this.rndControl.hasActiveChannelBlue();
            }
        }
        return false;
    }

    boolean isCompressed() {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isCompressed();
    }

    boolean isColorComponent(int band, int index) {
        if (this.rndControl == null) {
            return false;
        }
        switch (band) {
            case 0: {
                return this.rndControl.isChannelRed(index);
            }
            case 1: {
                return this.rndControl.isChannelGreen(index);
            }
            case 2: {
                return this.rndControl.isChannelBlue(index);
            }
        }
        return false;
    }

    void resetDefaults() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.resetDefaults();
    }

    void resetSettings(RndProxyDef settings) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.resetSettings(settings);
    }

    RndProxyDef saveCurrentSettings() throws RenderingServiceException, DSOutOfServiceException {
        RndProxyDef def;
        if (this.rndControl == null) {
            return null;
        }
        this.rndDef = def = this.rndControl.saveCurrentSettings();
        return def;
    }

    void historyBack() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        boolean canRedo = this.history.canRedo();
        boolean isSame = this.rndControl.isSameSettings(this.history.getCurrent(), true, true);
        RndProxyDef def = !canRedo && !isSame ? this.history.backward(this.rndControl.getRndSettingsCopy()) : this.history.backward();
        this.resetSettings(def);
    }

    void historyForward() throws RenderingServiceException, DSOutOfServiceException {
        RndProxyDef def = this.history.forward();
        this.resetSettings(def);
    }

    void makeHistorySnapshot() {
        if (this.rndControl != null) {
            if (this.history.getCurrent() == null || !this.rndControl.isSameSettings(this.history.getCurrent(), false)) {
                this.history.add(this.rndControl.getRndSettingsCopy());
            } else {
                this.history.resetPrevAction();
            }
        }
    }

    void setActive(int index, boolean active) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setActive(index, active);
    }

    void setCompression(int compression) {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setCompression(compression);
    }

    void setOriginalRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setOriginalRndSettings();
    }

    boolean validatePixels(PixelsData pixels) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.validatePixels(pixels);
    }

    BufferedImage render(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.render(pDef);
    }

    BufferedImage render(PlaneDef pDef, int compression) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.render(pDef, compression);
    }

    boolean isSameSettings(RndProxyDef def, boolean checkPlane) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isSameSettings(def, checkPlane);
    }

    boolean isModified() {
        if (this.rndControl != null) {
            return !this.rndControl.isSameSettings(this.rndDef, true, true);
        }
        return false;
    }

    boolean isMappedImageRGB(List channels) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isMappedImageRGB(channels);
    }

    void setOverlays(long tableID, Map<Long, Integer> overlays) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setOverlays(tableID, overlays);
    }

    BufferedImage renderImage() {
        this.plane.t = this.getDefaultT();
        this.plane.z = this.getDefaultZ();
        try {
            if (this.rndControl == null) {
                return null;
            }
            return this.rndControl.render(this.plane, 2);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.append((CharSequence)"Error while rendering the image.");
            msg.print((Throwable)e);
            MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            return null;
        }
    }

    Dimension getPreviewDimension() {
        if (this.previewSize != null) {
            return this.previewSize;
        }
        this.previewSize = Factory.computeThumbnailSize(256, 256, this.getMaxX(), this.getMaxY());
        return this.previewSize;
    }

    void resetRenderingSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.resetSettings(this.rndDef);
    }

    boolean isBigImage() {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.isBigImage();
    }

    int getMaxLifetimeBin() {
        if (this.hasModuloT()) {
            ModuloInfo info = this.modulo.get(2);
            return info.getSize();
        }
        if (this.isLifetimeImage()) {
            return this.getMaxC() - 1;
        }
        return 0;
    }

    boolean hasModuloT() {
        return this.modulo != null && this.modulo.containsKey(2);
    }

    ModuloInfo getModuloT() {
        if (!this.hasModuloT()) {
            return null;
        }
        return this.modulo.get(2);
    }

    boolean isLifetimeImage() {
        if (this.hasModuloT()) {
            return true;
        }
        return this.getMaxC() >= 100;
    }

    int getSelectedBin() {
        if (!this.isLifetimeImage()) {
            return -1;
        }
        if (this.hasModuloT()) {
            return this.getDefaultT() - this.getRealSelectedT() * this.getMaxLifetimeBin();
        }
        List<Integer> active = this.getActiveChannels();
        if (active == null || active.size() != 1) {
            return 0;
        }
        return active.get(0);
    }

    void setSelectedBin(int bin, int t) throws RenderingServiceException, DSOutOfServiceException {
        if (this.hasModuloT()) {
            int binSize = this.getMaxLifetimeBin();
            int v = bin + t * binSize;
            this.setSelectedXYPlane(this.getDefaultZ(), v);
            return;
        }
        List<ChannelData> channels = this.getChannelData();
        for (ChannelData channel : channels) {
            int index;
            this.setActive(index, (index = channel.getIndex()) == bin);
        }
    }

    Dimension getTileSize() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return new Dimension(0, 0);
        }
        return this.rndControl.getTileSize();
    }

    int getResolutionLevels() {
        if (this.rndControl == null) {
            return 1;
        }
        return this.rndControl.getResolutionLevels();
    }

    int getSelectedResolutionLevel() {
        if (this.rndControl == null) {
            return 0;
        }
        return this.rndControl.getSelectedResolutionLevel();
    }

    void setSelectedResolutionLevel(int level) throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return;
        }
        this.rndControl.setSelectedResolutionLevel(level);
    }

    void setChannels(List<ChannelData> channels) {
        ViewerSorter sorter = new ViewerSorter();
        this.sortedChannel = Collections.unmodifiableList(sorter.sort(channels));
    }

    boolean canAnnotate() {
        ImageData image = this.getRefImage();
        if (image == null) {
            return false;
        }
        return image.canAnnotate();
    }

    List<RenderingControl> getRenderingControls() {
        if (this.rndControl == null) {
            return null;
        }
        ArrayList<RenderingControl> list = new ArrayList<RenderingControl>();
        list.add(this.rndControl);
        List<RenderingControl> slaves = this.rndControl.getSlaves();
        if (slaves != null && slaves.size() > 0) {
            list.addAll(slaves);
        }
        return list;
    }

    List<ResolutionLevel> getResolutionDescriptions() throws RenderingServiceException, DSOutOfServiceException {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getResolutionDescriptions();
    }

    void setXMLAnnotations(Collection<XMLAnnotationData> annotations) {
        this.modulo = new HashMap<Integer, ModuloInfo>();
        if (CollectionUtils.isEmpty(annotations)) {
            return;
        }
        for (XMLAnnotationData data : annotations) {
            ModuloParser parser = new ModuloParser(data.getText());
            try {
                parser.parse();
                List<ModuloInfo> infos = parser.getModulos();
                for (ModuloInfo info : infos) {
                    this.modulo.put(info.getModuloIndex(), info);
                }
            }
            catch (Exception e) {
                LogMessage msg = new LogMessage();
                msg.append((CharSequence)"Error while reading modulo annotation.");
                msg.print((Throwable)e);
                MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            }
        }
    }

    void setGreyscale(boolean b) {
        if (b) {
            this.component.setColorModel("greyscale", true);
        } else {
            this.component.setColorModel("rgb", true);
        }
    }

    boolean isIntegerPixelData() {
        String t = this.image.getDefaultPixels().getPixelType();
        return t.equals("int8") || t.equals("uint8") || t.equals("int16") || t.equals("uint16") || t.equals("int32") || t.equals("uint32");
    }

    public void setHistogramData(int channelIndex, int[] data) {
        this.histogramData.put(channelIndex, data);
    }

    public int[] getHistogramData(int channelIndex) {
        return this.histogramData.get(channelIndex);
    }

    public Collection<String> getAvailableLookupTables() {
        if (this.rndControl == null) {
            return null;
        }
        return this.rndControl.getAvailableLookupTables();
    }

    public void setLookupTable(int index, String lut) {
        try {
            this.rndControl.setLookupTable(index, lut);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.append((CharSequence)"Error while setting lookup table.");
            msg.print((Throwable)e);
            MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
        }
    }

    public void setReverseIntensity(int index, boolean revInt) {
        try {
            this.rndControl.setReverseIntensity(index, revInt);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.append((CharSequence)"Error while setting reverse intensity.");
            msg.print((Throwable)e);
            MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
        }
    }

    public boolean getReverseIntensity(int index) {
        if (this.rndControl == null) {
            return false;
        }
        return this.rndControl.getReverseIntensity(index);
    }
}

