/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class DetectorComponent
extends JPanel
implements PropertyChangeListener {
    private OMEComboBox binningBox;
    private OMEComboBox detectorBox;
    private Map<String, DataComponent> fieldsDetector;
    private JLabelButton unsetDetector;
    private boolean unsetDetectorShown;
    private AcquisitionDataUI parent;
    private EditorModel model;

    private void resetBoxes() {
        List<EnumerationObject> l = this.model.getChannelEnumerations(Editor.BINNING);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        int i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.binningBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.DETECTOR_TYPE);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.detectorBox = EditorUtil.createComboBox(array);
    }

    private void initComponents() {
        this.resetBoxes();
        this.fieldsDetector = new LinkedHashMap<String, DataComponent>();
        this.unsetDetector = null;
        this.unsetDetectorShown = false;
    }

    private void displayUnsetDetectorFields() {
        this.unsetDetectorShown = !this.unsetDetectorShown;
        String s = "Show unset fields";
        if (this.unsetDetectorShown) {
            s = "Hide unset fields";
        }
        this.unsetDetector.setText(s);
        this.parent.layoutFields(this, this.unsetDetector, this.fieldsDetector, this.unsetDetectorShown);
    }

    private void transformDetectorSource(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetDetector == null) {
            this.unsetDetector = this.parent.formatUnsetFieldsControl();
            this.unsetDetector.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        Iterator<Map.Entry<String, Object>> i = entrySet.iterator();
        String v = "";
        while (i.hasNext()) {
            JComponent area;
            Object selected;
            Map.Entry<String, Object> entry = i.next();
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if ("Binning".equals(key)) {
                selected = this.model.getChannelEnumerationSelected(Editor.BINNING, (String)value);
                if (selected != null) {
                    this.binningBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.binningBox.setSelectedIndex(this.binningBox.getItemCount() - 1);
                    notSet.add(key);
                }
                this.binningBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.binningBox;
            } else if ("Type".equals(key)) {
                selected = this.model.getChannelEnumerationSelected(Editor.DETECTOR_TYPE, (String)value);
                if (selected != null) {
                    this.detectorBox.setSelectedItem(selected);
                } else {
                    set = false;
                    notSet.add(key);
                    this.detectorBox.setSelectedIndex(this.detectorBox.getItemCount() - 1);
                }
                this.detectorBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.detectorBox;
            } else if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if (value instanceof Double) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Float.class);
                } else {
                    v = "" + value;
                }
                ((NumericalTextField)area).setText(v);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                }
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsDetector.put(key, comp);
        }
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createTitledBorder("Detector"));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
    }

    DetectorComponent(AcquisitionDataUI parent, EditorModel model) {
        this.parent = parent;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void displayDetector(Map<String, Object> details) {
        this.resetBoxes();
        this.fieldsDetector.clear();
        this.transformDetectorSource(details);
        this.parent.layoutFields(this, this.unsetDetector, this.fieldsDetector, this.unsetDetectorShown);
        this.parent.attachListener(this.fieldsDetector);
    }

    boolean hasDataToSave() {
        return this.parent.hasDataToSave(this.fieldsDetector);
    }

    void prepareDataToSave() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            this.displayUnsetDetectorFields();
        }
    }
}

