/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DatasetData;
import omero.gateway.model.PlateData;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ChannelEditUI
extends JPanel
implements ActionListener,
DocumentListener {
    static final String APPLY_TO_ALL_PROPERTY = "ApplyToAll";
    static final String CANCEL_PROPERTY = "Cancel";
    static final String SAVE_PROPERTY = "Save";
    private static final String WARNING_DATASET = "Update channel names for all images in the dataset? This cannot be undone.";
    private static final String WARNING_PLATE = "Update channel names for all images in the plate? This cannot be undone.";
    private static final int SAVE = 0;
    private static final int CANCEL = 1;
    private static final int APPLY_TO_ALL = 2;
    private static final String APPLY_TO_ALL_TEXT = "Apply to All";
    private static final String SAVE_TEXT = "Save";
    private static final String CONTINUE_TEXT = "Continue";
    private static final String CANCEL_TEXT = "Cancel";
    private static final String APPLY_TO_ALL_TIP = "Save and apply to all images.";
    private static final String SAVE_TIP = "Save Channel Names.";
    private static final String CANCEL_TIP = "Cancel.";
    private Map<JTextField, ChannelData> fields;
    private JButton saveButton;
    private JButton cancelButton;
    private JButton applyToAll;
    private Object parent;
    private JTextArea messageLabel;
    private Map channels;

    private void initComponents() {
        this.fields = new LinkedHashMap<JTextField, ChannelData>(this.channels.size());
        for (ChannelData channel : this.channels.keySet()) {
            JTextField field = new JTextField();
            field.setBackground(UIUtilities.BACKGROUND_COLOR);
            field.setText(channel.getChannelLabeling());
            field.getDocument().addDocumentListener(this);
            this.fields.put(field, channel);
        }
        this.saveButton = new JButton("Save");
        this.saveButton.setToolTipText(SAVE_TIP);
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("0");
        this.saveButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText(CANCEL_TIP);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("1");
        this.applyToAll = new JButton(APPLY_TO_ALL_TEXT);
        this.applyToAll.setToolTipText(APPLY_TO_ALL_TIP);
        this.applyToAll.addActionListener(this);
        this.applyToAll.setActionCommand("2");
        CompoundBorder border = new CompoundBorder(BorderFactory.createLineBorder(Color.gray), new EmptyBorder(2, 2, 2, 2));
        this.saveButton.setOpaque(true);
        this.saveButton.setBackground(UIUtilities.LIGHT_GREY);
        this.saveButton.setBorder(border);
        this.cancelButton.setOpaque(true);
        this.cancelButton.setBackground(UIUtilities.LIGHT_GREY);
        this.cancelButton.setBorder(border);
        this.applyToAll.setOpaque(true);
        this.applyToAll.setBackground(UIUtilities.LIGHT_GREY);
        this.applyToAll.setBorder(border);
        this.messageLabel = new MultilineLabel();
        this.messageLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.saveButton.setVisible(!(this.parent instanceof PlateData));
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        Iterator<Map.Entry<JTextField, ChannelData>> i = this.fields.entrySet().iterator();
        while (i.hasNext()) {
            this.add(i.next().getKey());
        }
        this.add(this.messageLabel);
        this.add(this.buildControls());
    }

    private JPanel buildControls() {
        JPanel bar = new JPanel();
        bar.setLayout(new FlowLayout(0));
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.add(this.saveButton);
        if (this.parent instanceof DatasetData || this.parent instanceof PlateData) {
            bar.add(this.applyToAll);
        }
        bar.add(this.cancelButton);
        return bar;
    }

    private void save() {
        Iterator<Map.Entry<JTextField, ChannelData>> i = this.fields.entrySet().iterator();
        ArrayList<ChannelData> channels = new ArrayList<ChannelData>(this.fields.size());
        while (i.hasNext()) {
            Map.Entry<JTextField, ChannelData> e = i.next();
            ChannelData channel = e.getValue();
            channel.setName(e.getKey().getText());
            channels.add(channel);
        }
        if (!this.applyToAll.isVisible()) {
            this.firePropertyChange(APPLY_TO_ALL_PROPERTY, null, channels);
        } else {
            this.firePropertyChange("Save", null, channels);
        }
        this.resetControls();
    }

    private void resetControls() {
        this.saveButton.setEnabled(false);
        this.saveButton.setVisible(!(this.parent instanceof PlateData));
        this.saveButton.setText("Save");
        this.messageLabel.setText("");
        this.applyToAll.setVisible(true);
    }

    private void applyToAll() {
        if (this.parent instanceof DatasetData) {
            this.messageLabel.setText(WARNING_DATASET);
        } else if (this.parent instanceof PlateData) {
            this.messageLabel.setText(WARNING_PLATE);
        }
        this.applyToAll.setVisible(false);
        this.saveButton.setEnabled(true);
        this.saveButton.setVisible(true);
        this.saveButton.setText(CONTINUE_TEXT);
        this.repaint();
    }

    private void cancel() {
        this.resetControls();
        for (Map.Entry<JTextField, ChannelData> e : this.fields.entrySet()) {
            e.getKey().setText(e.getValue().getChannelLabeling());
        }
        this.firePropertyChange("Cancel", (Object)false, (Object)true);
    }

    private void handleNameChange() {
        Iterator<Map.Entry<JTextField, ChannelData>> i = this.fields.entrySet().iterator();
        boolean enabled = false;
        while (i.hasNext()) {
            Map.Entry<JTextField, ChannelData> e = i.next();
            if (e.getKey().getText().equals(e.getValue().getChannelLabeling())) continue;
            enabled = true;
            break;
        }
        this.saveButton.setEnabled(enabled);
    }

    ChannelEditUI(Map channels, Object parent) {
        if (channels == null || channels.size() == 0) {
            throw new IllegalArgumentException("No Channels specified.");
        }
        this.parent = parent;
        this.channels = channels;
        this.initComponents();
        this.buildGUI();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int index = Integer.parseInt(evt.getActionCommand());
        switch (index) {
            case 0: {
                this.save();
                break;
            }
            case 1: {
                this.cancel();
                break;
            }
            case 2: {
                this.applyToAll();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.handleNameChange();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.handleNameChange();
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }
}

