/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import omero.gateway.model.TagAnnotationData;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.openmicroscopy.shoola.agents.events.measurement.SelectChannel;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.actions.CreateFigureAction;
import org.openmicroscopy.shoola.agents.measurement.actions.DeleteROIAction;
import org.openmicroscopy.shoola.agents.measurement.actions.ExportGraphAction;
import org.openmicroscopy.shoola.agents.measurement.actions.LoadROIAction;
import org.openmicroscopy.shoola.agents.measurement.actions.MeasurementViewerAction;
import org.openmicroscopy.shoola.agents.measurement.actions.SaveROIAction;
import org.openmicroscopy.shoola.agents.measurement.actions.ShowROIAssistant;
import org.openmicroscopy.shoola.agents.measurement.actions.UnitsAction;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerFactory;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.util.ui.PermissionMenu;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;

class MeasurementViewerControl
implements ChangeListener,
DrawingListener,
FigureListener,
FigureSelectionListener,
PropertyChangeListener,
WindowFocusListener,
KeyListener {
    static final Integer SAVE = 0;
    static final Integer LOAD = 1;
    static final Integer ROI_ASSISTANT = 5;
    static final Integer IN_MICRONS = 6;
    static final Integer IN_PIXELS = 7;
    static final Integer CREATE_SINGLE_FIGURE = 8;
    static final Integer CREATE_MULTIPLE_FIGURES = 9;
    static final Integer DELETE = 13;
    static final Integer EXPORT_GRAPH = 14;
    private MeasurementViewer model;
    private MeasurementViewerUI view;
    private Map<Integer, MeasurementViewerAction> actionsMap;
    private boolean keyRemove;

    private void createActions() {
        this.actionsMap.put(SAVE, new SaveROIAction(this.model));
        this.actionsMap.put(LOAD, new LoadROIAction(this.model));
        this.actionsMap.put(ROI_ASSISTANT, new ShowROIAssistant(this.model));
        this.actionsMap.put(IN_MICRONS, new UnitsAction(this.model, true));
        this.actionsMap.put(IN_PIXELS, new UnitsAction(this.model, false));
        this.actionsMap.put(CREATE_SINGLE_FIGURE, new CreateFigureAction(this.model, true));
        this.actionsMap.put(CREATE_MULTIPLE_FIGURES, new CreateFigureAction(this.model, false));
        this.actionsMap.put(DELETE, new DeleteROIAction(this.model));
        this.actionsMap.put(EXPORT_GRAPH, new ExportGraphAction(this.model));
    }

    public static boolean isRightClick(MouseEvent e) {
        return e.getButton() == 3 || e.getButton() == 1 && e.isControlDown();
    }

    private void setROIFigureStatus(int status) {
        Set<Figure> selectedFigures = this.view.getDrawingView().getSelectedFigures();
        if (selectedFigures.size() != 1) {
            return;
        }
        for (Figure fig : selectedFigures) {
            if (!(fig instanceof ROIFigure)) continue;
            ROIFigure roiFigure = (ROIFigure)fig;
            roiFigure.setStatus(status);
            this.handleFigureChange(roiFigure);
        }
    }

    private void handleFigureChange(ROIFigure figure) {
        this.view.onSelectedFigures();
        ROI roi = figure.getROI();
        if (figure instanceof MeasureLineFigure || figure instanceof MeasurePointFigure) {
            figure.calculateMeasurements();
            this.view.refreshResultsTable();
            if (!this.view.inDataView()) {
                return;
            }
            ROIShape shape = figure.getROIShape();
            ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
            roi = shape.getROI();
            TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
            Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
            while (shapeIterator.hasNext()) {
                shapeList.add(shapeMap.get(shapeIterator.next()));
            }
            if (shapeList.size() != 0) {
                this.model.analyseShapeList(shapeList);
            }
            return;
        }
        if (figure.getStatus() != 0) {
            return;
        }
        figure.calculateMeasurements();
        this.view.refreshResultsTable();
        if (!this.view.inDataView()) {
            return;
        }
        ROIShape shape = figure.getROIShape();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        roi = shape.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            ROIShape thisShape = shapeMap.get(shapeIterator.next());
            shapeList.add(thisShape);
        }
        if (shapeList.size() != 0) {
            this.model.analyseShapeList(shapeList);
        }
    }

    MeasurementViewerControl() {
    }

    void initialize(MeasurementViewer model, MeasurementViewerUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        model.addChangeListener(this);
        model.addPropertyChangeListener(this);
        this.actionsMap = new HashMap<Integer, MeasurementViewerAction>();
        this.createActions();
    }

    void attachListeners() {
        this.view.getLoadingWindow().addPropertyChangeListener("closed", this);
        this.view.getDrawing().addDrawingListener(this);
        this.view.getDrawingView().addFigureSelectionListener(this);
        this.view.getDrawingView().addKeyListener(this);
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MeasurementViewerControl.this.model.close();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                MeasurementViewerControl.this.view.addWindowFocusListener(this);
            }
        });
        this.view.getDrawingView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                MeasurementViewerControl.this.setROIFigureStatus(0);
                if (!UIUtilities.isWindowsOS() && MeasurementViewerControl.isRightClick(e)) {
                    MeasurementViewerControl.this.view.showROIManagementMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MeasurementViewerControl.this.setROIFigureStatus(0);
                if (UIUtilities.isWindowsOS() && MeasurementViewerControl.isRightClick(e)) {
                    MeasurementViewerControl.this.view.showROIManagementMenu(e.getX(), e.getY());
                }
            }
        });
        this.view.getDrawingView().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (MeasurementViewerControl.isRightClick(e)) {
                    return;
                }
                MeasurementViewerControl.this.setROIFigureStatus(1);
            }
        });
        JMenu menu = MeasurementViewerFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    MeasurementViewerFactory.register((JMenu)source);
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    MeasurementViewerFactory.register((JMenu)source);
                }
            }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
        MeasurementViewerFactory.attachWindowMenuToTaskBar();
    }

    void toFront() {
        if (this.view.getExtendedState() != 0) {
            return;
        }
        if (!this.view.isFocused()) {
            this.view.removeWindowFocusListener(this);
            if (this.view.isVisible()) {
                this.view.setVisible(true);
            }
        }
    }

    MeasurementViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void showColorPicker(Color color) {
        if (color == null) {
            return;
        }
        ColourPicker picker = new ColourPicker((JFrame)this.view, color);
        picker.addPropertyChangeListener("colour", this);
        UIUtilities.setLocationRelativeTo(this.view, (Component)picker);
    }

    void analyseSelectedFigures() {
        this.analyseFigures(this.model.getSelectedFigures());
    }

    void analyseFigures(Collection<Figure> figures) {
        if (figures.size() != 1 && !this.view.inDataView()) {
            return;
        }
        Iterator<Figure> j = figures.iterator();
        ROIFigure figure = null;
        if (j.hasNext()) {
            figure = (ROIFigure)j.next();
        }
        if (figure == null) {
            return;
        }
        ROIShape shape = figure.getROIShape();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = shape.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        for (Map.Entry<Coord3D, ROIShape> entry : shapeMap.entrySet()) {
            Coord3D c = entry.getKey();
            ROIShape currentShape = entry.getValue();
            if (currentShape.getFigure() instanceof MeasureTextFigure) continue;
            shapeList.add(currentShape);
        }
        if (shapeList.size() != 0) {
            this.model.analyseShapeList(shapeList);
        }
    }

    void loadTags() {
        this.model.loadTags();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("colour".equals(name)) {
            ColourObject co = (ColourObject)evt.getNewValue();
            this.view.setCellColor(co.color);
        } else if ("closed".equals(name)) {
            this.model.discard();
        } else if (PermissionMenu.SELECTED_LEVEL_PROPERTY.equals(name)) {
            this.model.deleteAllROIs((Integer)evt.getNewValue());
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                if (!TagAnnotationData.class.getName().equals(type.getName())) continue;
                List tags = (List)entry.getValue();
                this.model.tagSelectedFigures(tags);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int state = this.model.getState();
        switch (state) {
            case 4: {
                this.view.setStatus("Analysing Shape.");
                this.view.onAnalysed(true);
                break;
            }
            case 2: {
                LoadingWindow w = this.view.getLoadingWindow();
                if (!w.isVisible()) {
                    UIUtilities.centerAndShow(w);
                }
                this.view.setStatus("Loading.");
                break;
            }
            case 5: {
                this.view.getLoadingWindow().setVisible(false);
                this.view.setStatus("Ready.");
                this.view.onAnalysed(false);
                if (this.view.isVisible()) break;
                this.view.setOnScreen();
                break;
            }
            case 6: {
                LoadingWindow window = this.view.getLoadingWindow();
                window.setVisible(false);
                window.dispose();
                this.view.setVisible(false);
                this.view.dispose();
            }
        }
    }

    @Override
    public void figureAdded(DrawingEvent e) {
        Figure f = e.getFigure();
        if (!(f instanceof ROIFigure)) {
            return;
        }
        ROIFigure roiFigure = (ROIFigure)f;
        roiFigure.setStatus(1);
        this.view.addROI(roiFigure);
        if (roiFigure.canEdit()) {
            roiFigure.addFigureListener(this);
        }
        this.model.setDataChanged();
        if (!this.view.inDataView()) {
            return;
        }
        ROIShape shape = roiFigure.getROIShape();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = shape.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            shapeList.add(shapeMap.get(shapeIterator.next()));
        }
        if (shapeList.size() == 0) {
            return;
        }
        if (f instanceof MeasureLineFigure || f instanceof MeasurePointFigure) {
            roiFigure.setStatus(0);
            this.model.analyseShapeList(shapeList);
        }
    }

    @Override
    public void figureRemoved(DrawingEvent e) {
        if (this.model.getState() != 5) {
            return;
        }
        Figure f = e.getFigure();
        if (f instanceof ROIFigure) {
            ROIFigure roi = (ROIFigure)f;
            if (this.keyRemove) {
                if (roi.isReadOnly() || !roi.canDelete()) {
                    this.view.getDrawing().removeDrawingListener(this);
                    this.view.getDrawing().add(roi);
                    this.view.getDrawing().addDrawingListener(this);
                    return;
                }
                this.view.markROIForDelete(roi);
                this.keyRemove = false;
            }
            this.view.removeROI(roi);
            this.model.setDataChanged();
        }
    }

    @Override
    public void selectionChanged(FigureSelectionEvent evt) {
        if (!this.view.isVisible()) {
            return;
        }
        Set<Figure> figures = evt.getView().getSelectedFigures();
        if (figures == null) {
            return;
        }
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        if (this.view.inDataView() && figures.size() == 1) {
            ROIFigure figure = (ROIFigure)figures.iterator().next();
            if (figure == null) {
                return;
            }
            ROIShape shape = figure.getROIShape();
            if (shape == null) {
                return;
            }
            ROI roi = shape.getROI();
            if (roi == null) {
                return;
            }
            TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
            Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
            while (shapeIterator.hasNext()) {
                shapeList.add(shapeMap.get(shapeIterator.next()));
            }
        }
        this.view.setSelectedFigures(figures);
        if (!shapeList.isEmpty()) {
            this.model.analyseShapeList(shapeList);
        }
    }

    @Override
    public void figureAttributeChanged(FigureEvent e) {
        Figure f = e.getFigure();
        if (f instanceof ROIFigure) {
            AttributeKey key;
            ROIFigure fig = (ROIFigure)f;
            this.view.onAttributeChanged(fig);
            this.view.refreshInspectorTable();
            this.model.figureAttributeChanged(e.getAttribute(), fig);
            if (!fig.isReadOnly() && fig.canEdit() && (key = e.getAttribute()) != MeasurementAttributes.SHOWTEXT && key != MeasurementAttributes.SHOWMEASUREMENT && key != AnnotationKeys.TAG && key != AnnotationKeys.FOLDERS) {
                this.model.setDataChanged();
            }
        }
    }

    @Override
    public void figureChanged(FigureEvent e) {
        Figure f = e.getFigure();
        if (f instanceof ROIFigure) {
            ROIFigure fig = (ROIFigure)f;
            Coord3D coord = fig.getROIShape().getCoord3D();
            int c = coord.getChannel();
            if (c >= 0 && !this.view.isChannelActive(c)) {
                EventBus bus = MeasurementAgent.getRegistry().getEventBus();
                bus.post(new SelectChannel(this.view.getPixelsID(), c));
            }
            this.handleFigureChange(fig);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyRemove = false;
        if (e.getKeyCode() == 127) {
            this.keyRemove = true;
        }
        char ANALYSECHAR = 'a';
        if (e.getKeyChar() == ANALYSECHAR) {
            Set<Figure> selectedFigures = this.view.getDrawingView().getSelectedFigures();
            if (selectedFigures.size() != 1) {
                return;
            }
            Iterator iterator = selectedFigures.iterator();
            ROIFigure fig = (ROIFigure)iterator.next();
            if (fig instanceof MeasureTextFigure) {
                return;
            }
            ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
            shapeList.add(fig.getROIShape());
            this.view.calculateStats(shapeList);
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void areaInvalidated(DrawingEvent e) {
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureAreaInvalidated(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
    }

    @Override
    public void figureHandlesChanged(FigureEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

