/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import omero.model.Length;
import omero.model.enums.UnitsLength;
import org.openmicroscopy.shoola.agents.measurement.util.model.MeasurementObject;
import org.openmicroscopy.shoola.agents.measurement.util.ui.KeyDescription;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MeasurementTableModel
extends AbstractTableModel {
    private MeasurementUnits unitsType;
    private List<KeyDescription> columnNames;
    private List<MeasurementObject> values;
    private boolean showUnits;
    private List<Boolean> unitsDisplay;

    MeasurementTableModel(List<KeyDescription> colNames, MeasurementUnits units) {
        if (colNames == null) {
            throw new IllegalArgumentException("No column's names specified.");
        }
        this.columnNames = colNames;
        this.values = new ArrayList<MeasurementObject>();
        this.unitsType = units;
        this.unitsDisplay = new ArrayList<Boolean>();
    }

    void setShowUnits(boolean showUnits) {
        this.showUnits = showUnits;
    }

    public List<KeyDescription> getColumnNames() {
        return this.columnNames;
    }

    public MeasurementUnits getUnitsType() {
        return this.unitsType;
    }

    void addRow(MeasurementObject row) {
        this.values.add(row);
        this.fireTableStructureChanged();
    }

    MeasurementObject getRow(int index) {
        if (index < this.values.size()) {
            return this.values.get(index);
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || row > this.values.size()) {
            return null;
        }
        MeasurementObject rowData = this.values.get(row);
        Object value = rowData.getElement(col);
        if (this.showUnits) {
            if (value instanceof List) {
                List l = (List)value;
                Iterator i = l.iterator();
                StringBuilder buffer = new StringBuilder();
                int size = l.size();
                while (i.hasNext()) {
                    Object s;
                    Object v = i.next();
                    if (v instanceof Length) {
                        Length n = (Length)v;
                        s = this.convertLength(n, col);
                        if (size == 1) {
                            return s;
                        }
                        if (s == null) continue;
                        buffer.append(s);
                        buffer.append(" ");
                        continue;
                    }
                    if (!(v instanceof Number)) continue;
                    double d = ((Number)v).doubleValue();
                    if (size == 1) {
                        return UIUtilities.twoDecimalPlaces(d);
                    }
                    s = UIUtilities.twoDecimalPlaces(d);
                    if (s == null) continue;
                    buffer.append(s);
                    buffer.append(" ");
                }
                return buffer.toString();
            }
            if (value instanceof Number) {
                double d = ((Number)value).doubleValue();
                return UIUtilities.twoDecimalPlaces(d);
            }
            if (value instanceof Length) {
                return UIUtilities.twoDecimalPlaces(((Length)value).getValue());
            }
            return value;
        }
        if (value instanceof List) {
            List l = (List)value;
            StringBuilder buffer = new StringBuilder();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Object v = i.next();
                if (v instanceof Number) {
                    double d = ((Number)v).doubleValue();
                    if (l.size() == 1) {
                        return UIUtilities.twoDecimalPlacesAsNumber(d);
                    }
                    buffer.append(UIUtilities.twoDecimalPlacesAsNumber(d));
                }
                if (v instanceof Length) {
                    Length n = (Length)v;
                    if (l.size() == 1) {
                        return UIUtilities.twoDecimalPlacesAsNumber(n.getValue());
                    }
                    buffer.append(UIUtilities.twoDecimalPlacesAsNumber(n.getValue()));
                }
                if (!i.hasNext()) continue;
                buffer.append(" ");
            }
            return buffer.toString();
        }
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            return UIUtilities.twoDecimalPlacesAsNumber(d);
        }
        if (value instanceof Length) {
            return UIUtilities.twoDecimalPlacesAsNumber(((Length)value).getValue());
        }
        return value;
    }

    private Object convertLength(Length n, int col) {
        KeyDescription key = this.getColumnNames().get(col);
        MeasurementUnits units = this.getUnitsType();
        String k = key.getKey();
        String s = null;
        if (!units.getUnit().equals((Object)UnitsLength.PIXEL) && CommonsLangUtils.isNotBlank(s = UIUtilities.formatValue(n, AnnotationKeys.AREA.getKey().equals(k)))) {
            return s;
        }
        Number value = UIUtilities.twoDecimalPlacesAsNumber(n.getValue());
        if (value.doubleValue() == 0.0) {
            return null;
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public String getColumnName(int col) {
        KeyDescription k = this.columnNames.get(col);
        String symbol = this.unitsType.getPixelSizeX().getSymbol();
        if (k.getKey().equals(AnnotationKeys.ANGLE.getKey())) {
            return k.getDescription() + "(" + "\u00b0" + ")";
        }
        UnitsLength unit = this.unitsType.getPixelSizeX().getUnit();
        if (!unit.equals((Object)UnitsLength.PIXEL)) {
            if (k.getKey().equals(AnnotationKeys.LENGTH.getKey()) || k.getKey().equals(AnnotationKeys.CENTREX.getKey()) || k.getKey().equals(AnnotationKeys.CENTREY.getKey()) || k.getKey().equals(AnnotationKeys.WIDTH.getKey()) || k.getKey().equals(AnnotationKeys.HEIGHT.getKey()) || k.getKey().equals(AnnotationKeys.ENDPOINTX.getKey()) || k.getKey().equals(AnnotationKeys.ENDPOINTY.getKey()) || k.getKey().equals(AnnotationKeys.PERIMETER.getKey()) || k.getKey().equals(AnnotationKeys.POINTARRAYX.getKey()) || k.getKey().equals(AnnotationKeys.POINTARRAYY.getKey()) || k.getKey().equals(AnnotationKeys.STARTPOINTX.getKey()) || k.getKey().equals(AnnotationKeys.STARTPOINTY.getKey())) {
                return k.getDescription() + "(" + symbol + ")";
            }
            if (k.getKey().equals(AnnotationKeys.AREA.getKey())) {
                return k.getDescription() + "(" + symbol + "\u00b2" + ")";
            }
        }
        return k.getDescription();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    MeasurementTableModel copy() {
        ArrayList<KeyDescription> list = new ArrayList<KeyDescription>(this.columnNames.size());
        for (KeyDescription key : this.columnNames) {
            list.add(new KeyDescription(key.getKey(), key.getDescription()));
        }
        MeasurementTableModel model = new MeasurementTableModel(list, this.unitsType);
        model.values.addAll(this.values);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            KeyDescription key;
            ArrayList<String> symbols = new ArrayList<String>();
            key = model.getColumnNames().get(i);
            String k = key.getKey();
            for (int j = 0; j < this.getRowCount(); ++j) {
                Object v = this.getValueAt(j, i);
                if (!(v instanceof Length)) continue;
                Length l = (Length)v;
                l = AnnotationKeys.AREA.getKey().equals(k) ? UIUtilities.transformSquareSize(l) : UIUtilities.transformSize(l);
                String s = l.getSymbol();
                if (symbols.contains(s) || l.getUnit().equals((Object)UnitsLength.PIXEL)) continue;
                symbols.add(s);
            }
            if (symbols.size() == 1) {
                String value = key.getDescription() + " (" + (String)symbols.get(0);
                if (AnnotationKeys.AREA.getKey().equals(k)) {
                    value = value + "\u00b2";
                }
                value = value + ")";
                key.setDescription(value);
                model.unitsDisplay.add(false);
                continue;
            }
            model.unitsDisplay.add(true);
        }
        return model;
    }
}

