/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.PixelsData;
import omero.log.LogMessage;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.measurement.MeasurementViewerLoader;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

public class Analyser
extends MeasurementViewerLoader {
    private PixelsData pixels;
    private Collection channels;
    private List shapes;
    private CallHandle handle;
    private Coord3D plane;

    public Analyser(MeasurementViewer viewer, SecurityContext ctx, PixelsData pixels, Collection channels, List shapes, Coord3D plane) {
        super(viewer, ctx);
        if (CollectionUtils.isEmpty((Collection)channels)) {
            throw new IllegalArgumentException("No channels specified.");
        }
        if (CollectionUtils.isEmpty((Collection)shapes)) {
            throw new IllegalArgumentException("No shapes specified.");
        }
        this.pixels = pixels;
        this.channels = channels;
        this.shapes = shapes;
        this.plane = plane;
    }

    @Override
    public void load() {
        this.handle = this.idView.analyseShapes(this.ctx, this.pixels, this.channels, this.shapes, this.plane, this);
    }

    @Override
    public void handleNullResult() {
        this.handleException(null);
    }

    @Override
    public void handleException(Throwable exc) {
        if (exc != null) {
            int state = this.viewer.getState();
            String s = "Data Retrieval Failure: ";
            LogMessage msg = new LogMessage();
            msg.print("State: " + state);
            msg.print(s);
            msg.print(exc);
            this.registry.getLogger().error((Object)this, msg);
        }
        UserNotifier un = this.registry.getUserNotifier();
        un.notifyInfo("Analyzing data", "An error occurred while analyzing the data.");
        this.viewer.setStatsShapes(null);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 6) {
            return;
        }
        this.viewer.setStatsShapes((Map)result);
    }
}

