/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import ome.model.units.BigResult;
import omero.gateway.model.ChannelData;
import omero.log.LogMessage;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarSizeAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomCmd;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.GridImage;
import org.openmicroscopy.shoola.agents.imviewer.browser.SplitImage;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.env.rnd.data.Region;
import org.openmicroscopy.shoola.env.rnd.data.Tile;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class BrowserModel {
    private static final String COMBINED = "Merged";
    private static final String PREFIX = "";
    static final int GAP = 0;
    private Browser component;
    private BufferedImage renderedImage;
    private BufferedImage displayedImage;
    private BufferedImage projectedImage;
    private BufferedImage displayedProjectedImage;
    private BufferedImage combinedImage;
    private double zoomFactor;
    private ImViewer parent;
    private boolean unitBar;
    private Length unitBarLength;
    private Color unitBarColor;
    private Color backgroundColor;
    private List<BufferedImage> originalGridImages;
    private List<BufferedImage> gridImages;
    private List<SplitImage> splitImages;
    private double ratio;
    private double gridRatio;
    private boolean init;
    private boolean interpolationServerProperty = false;

    private boolean isImageMappedRGB(List channels) {
        return this.parent.isMappedImageRGB(channels);
    }

    private void handleGridImageCreationException(Exception e) {
        UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
        un.notifyInfo("Split View", "Unable to create the images for the view");
        LogMessage msg = new LogMessage();
        msg.print("Grid Images creation");
        msg.print((Throwable)e);
        ImViewerAgent.getRegistry().getLogger().error((Object)this, msg);
        this.gridImages.clear();
    }

    private void createGridImagesForGreyScale() {
        int maxC = this.parent.getMaxC();
        List l = this.parent.getActiveChannelsInGrid();
        int n = l.size();
        this.clearList(this.gridImages);
        if (this.combinedImage != null) {
            this.combinedImage.flush();
        }
        switch (n) {
            case 0: {
                for (int i = 0; i < maxC; ++i) {
                    this.gridImages.add(null);
                }
                this.combinedImage = null;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.isImageMappedRGB(l)) {
                    BufferedImage image = this.parent.getCombinedGridImage();
                    if (image == null) {
                        for (int i = 0; i < maxC; ++i) {
                            this.gridImages.add(null);
                        }
                    } else {
                        this.combinedImage = Factory.magnifyImage(this.gridRatio, image);
                        int w = this.combinedImage.getWidth();
                        int h = this.combinedImage.getHeight();
                        DataBuffer buf = this.combinedImage.getRaster().getDataBuffer();
                        List<ChannelData> list = this.parent.getSortedChannelData();
                        Iterator<ChannelData> i = list.iterator();
                        while (i.hasNext()) {
                            int index = i.next().getIndex();
                            if (l.contains(index)) {
                                if (this.parent.isChannelRed(index)) {
                                    this.gridImages.add(Factory.createBandImage(buf, w, h, 0xFF0000, 0xFF0000, 0xFF0000));
                                    continue;
                                }
                                if (this.parent.isChannelGreen(index)) {
                                    this.gridImages.add(Factory.createBandImage(buf, w, h, 65280, 65280, 65280));
                                    continue;
                                }
                                if (!this.parent.isChannelBlue(index)) continue;
                                this.gridImages.add(Factory.createBandImage(buf, w, h, 255, 255, 255));
                                continue;
                            }
                            this.gridImages.add(null);
                        }
                    }
                    break;
                }
                this.retrieveGridImagesForGreyScale(l);
                break;
            }
            default: {
                this.retrieveGridImagesForGreyScale(l);
            }
        }
    }

    private void retrieveGridImagesForGreyScale(List channels) {
        List images = this.parent.getGridImages();
        if (images != null) {
            boolean b;
            int last = images.size() - 1;
            this.combinedImage = Factory.magnifyImage(this.gridRatio, (BufferedImage)images.get(last));
            images.remove(last);
            Iterator i = images.iterator();
            boolean bl = b = this.originalGridImages.size() == 0 && !this.isImageMappedRGB(channels);
            while (i.hasNext()) {
                BufferedImage img = (BufferedImage)i.next();
                this.gridImages.add(Factory.magnifyImage(this.gridRatio, img));
                if (!b) continue;
                this.originalGridImages.add(img);
            }
        }
    }

    private void retrieveGridImages() {
        List images = this.parent.getGridImages();
        if (images != null) {
            boolean b;
            Iterator i = images.iterator();
            boolean bl = b = this.originalGridImages.size() == 0;
            while (i.hasNext()) {
                BufferedImage img = (BufferedImage)i.next();
                this.gridImages.add(Factory.magnifyImage(img, this.gridRatio, 0, this.isInterpolation()));
                if (!b) continue;
                this.originalGridImages.add(img);
            }
            this.combinedImage = Factory.magnifyImage(this.renderedImage, this.gridRatio, 0, this.isInterpolation());
        }
    }

    private void clearList(List<BufferedImage> l) {
        if (l == null) {
            return;
        }
        for (BufferedImage img : l) {
            img = null;
        }
        l.clear();
    }

    private void createGridImages() {
        if (this.originalGridImages == null) {
            this.originalGridImages = new ArrayList<BufferedImage>();
        }
        this.clearList(this.gridImages);
        if ("greyscale".equals(this.parent.getColorModel())) {
            this.createGridImagesForGreyScale();
            return;
        }
        List l = this.parent.getActiveChannels();
        int maxC = this.parent.getMaxC();
        switch (l.size()) {
            case 0: {
                for (int i = 0; i < maxC; ++i) {
                    this.gridImages.add(null);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.isImageMappedRGB(l) && !this.parent.isCompressed()) {
                    this.combinedImage = null;
                    this.combinedImage = Factory.magnifyImage(this.gridRatio, this.renderedImage);
                    int w = this.combinedImage.getWidth();
                    int h = this.combinedImage.getHeight();
                    DataBuffer buf = this.combinedImage.getRaster().getDataBuffer();
                    List<ChannelData> list = this.parent.getSortedChannelData();
                    Iterator<ChannelData> i = list.iterator();
                    while (i.hasNext()) {
                        int index = i.next().getIndex();
                        if (this.parent.isChannelActive(index)) {
                            if (this.parent.isChannelRed(index)) {
                                this.gridImages.add(Factory.createBandImage(buf, w, h, 0xFF0000, 0, 0));
                                continue;
                            }
                            if (this.parent.isChannelGreen(index)) {
                                this.gridImages.add(Factory.createBandImage(buf, w, h, 0, 65280, 0));
                                continue;
                            }
                            if (!this.parent.isChannelBlue(index)) continue;
                            this.gridImages.add(Factory.createBandImage(buf, w, h, 0, 0, 255));
                            continue;
                        }
                        this.gridImages.add(null);
                    }
                    break;
                }
                this.retrieveGridImages();
                break;
            }
            default: {
                this.retrieveGridImages();
            }
        }
    }

    private double getBarSizeInPx(double ratio) {
        if (this.unitBarLength == null || Double.isInfinite(this.getPixelsSizeX().getValue()) || Double.isNaN(this.getPixelsSizeX().getValue())) {
            return 1.0;
        }
        try {
            double v = this.unitBarLength.getValue() / new LengthI(this.getPixelsSizeX(), this.unitBarLength.getUnit()).getValue();
            return v *= ratio;
        }
        catch (BigResult bigResult) {
            return 1.0;
        }
    }

    BrowserModel(ImViewer parent, ViewerPreferences pref) {
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.parent = parent;
        this.unitBar = false;
        this.ratio = 0.5;
        this.gridRatio = 0.5;
        this.init = true;
        this.unitBarColor = ImagePaintingFactory.UNIT_BAR_COLOR;
        this.backgroundColor = ImagePaintingFactory.DEFAULT_BACKGROUND;
        this.gridImages = new ArrayList<BufferedImage>();
        this.zoomFactor = 1.0;
        if (pref != null) {
            if (pref.getBackgroundColor() != null) {
                this.backgroundColor = pref.getBackgroundColor();
            }
            if (pref.getScaleBarColor() != null) {
                this.unitBarColor = pref.getScaleBarColor();
            }
            if (pref.isFieldSelected("Zoom factor")) {
                this.zoomFactor = ZoomAction.getZoomFactor(pref.getZoomIndex());
            }
        }
        this.interpolationServerProperty = Boolean.parseBoolean((String)ImViewerAgent.getRegistry().lookup("omero.client.viewer.interpolate_pixels"));
    }

    void initialize(Browser component) {
        this.component = component;
    }

    boolean hasImage() {
        return this.renderedImage != null;
    }

    void setRenderedImage(BufferedImage image) {
        this.renderedImage = null;
        this.displayedImage = null;
        this.combinedImage = null;
        this.clearList(this.gridImages);
        this.renderedImage = image;
        if (this.renderedImage != null && this.init) {
            int imageWidth = image.getWidth();
            if (imageWidth < 96) {
                this.ratio = 1.0;
                this.gridRatio = 1.0;
                this.setUnitBar(false);
            }
            if ((double)imageWidth * this.ratio > 256.0) {
                this.ratio = 256.0 / (double)imageWidth;
            }
            this.init = false;
        }
    }

    void setGridImages() {
        if (this.gridImages.size() != 0) {
            return;
        }
        this.clearList(this.originalGridImages);
        try {
            this.createGridImages();
        }
        catch (Exception e) {
            this.handleGridImageCreationException(e);
        }
    }

    BufferedImage getDisplayedImage() {
        if (this.displayedImage == null && this.isBigImage()) {
            BufferedImage bi = new BufferedImage(this.getTiledImageSizeX(), this.getTiledImageSizeY(), 1);
            Graphics2D g2D = bi.createGraphics();
            ImagePaintingFactory.setGraphicRenderingSettings(g2D, this.isInterpolation());
            Map<Integer, Tile> tiles = this.getTiles();
            int rows = this.getRows();
            int columns = this.getColumns();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    int index = i * columns + j;
                    Tile tile = tiles.get(index);
                    Region region = tile.getRegion();
                    Object img = tile.getImage();
                    if (img == null) continue;
                    g2D.drawImage((Image)((BufferedImage)img), region.getX(), region.getY(), null);
                }
            }
            g2D.dispose();
            return bi;
        }
        return this.displayedImage;
    }

    BufferedImage getDisplayedProjectedImage() {
        return this.displayedProjectedImage;
    }

    BufferedImage getRenderedImage() {
        return this.renderedImage;
    }

    void setZoomFactor(double factor) {
        this.zoomFactor = factor;
    }

    double getZoomFactor() {
        return this.zoomFactor;
    }

    String getTitle() {
        return "Image";
    }

    Icon getIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(22);
    }

    void createDisplayedImage() {
        if (this.renderedImage == null) {
            return;
        }
        this.displayedImage = null;
        if (this.zoomFactor != 1.0) {
            BufferedImage img = null;
            try {
                img = Factory.magnifyImage(this.renderedImage, this.zoomFactor, 0, this.isInterpolation());
                this.renderedImage.flush();
            }
            catch (Throwable e) {
                UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Magnification", "An error occurred while magnifying the image.");
            }
            if (img != null) {
                this.displayedImage = img;
            }
        } else {
            this.displayedImage = this.renderedImage;
        }
    }

    void createDisplayedProjectedImage() {
        if (this.projectedImage == null) {
            return;
        }
        if (this.displayedProjectedImage != null) {
            this.displayedProjectedImage.flush();
        }
        if (this.zoomFactor != 1.0) {
            BufferedImage img = null;
            try {
                img = Factory.magnifyImage(this.projectedImage, this.zoomFactor, 0, this.isInterpolation());
            }
            catch (Throwable e) {
                UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Magnification", "An error occurred while magnifying the image.");
            }
            if (img != null) {
                this.displayedProjectedImage = img;
            }
        } else {
            this.displayedProjectedImage = this.projectedImage;
        }
    }

    int getMaxZ() {
        return this.parent.getMaxZ();
    }

    int getMaxT() {
        return this.parent.getRealT();
    }

    Length getPixelsSizeX() {
        return this.parent.getPixelsSizeX();
    }

    boolean isUnitBar() {
        return this.unitBar;
    }

    void setUnitBar(boolean unitBar) {
        if (unitBar) {
            if (Double.isInfinite(this.getPixelsSizeX().getValue()) || Double.isNaN(this.getPixelsSizeX().getValue())) {
                return;
            }
            LengthI tmp = new LengthI(this.getPixelsSizeX().getValue() / this.zoomFactor, this.getPixelsSizeX().getUnit());
            tmp = UIUtilities.transformSize((Length)tmp);
            UnitsLength unit = tmp.getUnit();
            Rectangle visSize = ((BrowserUI)this.component.getUI()).getVisibleRect();
            int barLengthInPx = (int)(visSize.getWidth() / 5.0);
            tmp = new LengthI(this.getPixelsSizeX().getValue() * (double)barLengthInPx / this.zoomFactor, this.getPixelsSizeX().getUnit());
            try {
                tmp = new LengthI((Length)tmp, unit);
            }
            catch (BigResult bigResult) {
                // empty catch block
            }
            if (tmp.getValue() > 999.0) {
                int dec = (int)Math.log10(tmp.getValue());
                this.unitBarLength = new LengthI(Math.pow(10.0, dec), tmp.getUnit());
            } else {
                int index = UnitBarSizeAction.getIndex(tmp.getValue());
                this.unitBarLength = new LengthI((double)UnitBarSizeAction.getValue(index), tmp.getUnit());
            }
            this.parent.updateUnitBarMenu(this.unitBarLength);
        }
        this.unitBar = unitBar;
    }

    void setUnitBarSize(double size, UnitsLength unit) {
        this.unitBarLength = new LengthI(size, unit);
    }

    double getUnitInRefUnits() {
        return this.unitBarLength != null ? this.unitBarLength.getValue() : 1.0;
    }

    double getOriginalUnitBarSize() {
        return this.getBarSizeInPx(1.0);
    }

    double getUnitBarSize() {
        return this.getBarSizeInPx(this.zoomFactor);
    }

    double getGridBarSize() {
        return this.getBarSizeInPx(this.gridRatio);
    }

    String getUnitBarValue() {
        if (this.unitBarLength == null || Double.isInfinite(this.getPixelsSizeX().getValue()) || Double.isNaN(this.getPixelsSizeX().getValue())) {
            return "1";
        }
        return UIUtilities.twoDecimalPlaces(this.unitBarLength.getValue());
    }

    String getUnitBarUnit() {
        if (this.unitBarLength == null || Double.isInfinite(this.getPixelsSizeX().getValue()) || Double.isNaN(this.getPixelsSizeX().getValue())) {
            return LengthI.lookupSymbol((UnitsLength)UnitsLength.PIXEL);
        }
        return LengthI.lookupSymbol((UnitsLength)this.unitBarLength.getUnit());
    }

    Color getUnitBarColor() {
        return this.unitBarColor;
    }

    void setUnitBarColor(Color c) {
        this.unitBarColor = c;
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    String getGridViewTitle() {
        return "Split";
    }

    Icon getGridViewIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(34);
    }

    String getProjectionViewTitle() {
        return "Projection";
    }

    Icon getProjectionViewIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(58);
    }

    Icon getAnnotatorIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(33);
    }

    void setSelectedXYPlane(int z, int t) {
        this.parent.setSelectedXYPlane(z, t);
    }

    int getRealSelectedT() {
        return this.parent.getRealSelectedT();
    }

    int getDefaultT() {
        return this.parent.getDefaultT();
    }

    int getDefaultZ() {
        return this.parent.getDefaultZ();
    }

    int getMaxX() {
        return this.parent.getMaxX();
    }

    int getMaxY() {
        return this.parent.getMaxY();
    }

    Length getPixelsSizeY() {
        return this.parent.getPixelsSizeY();
    }

    Length getPixelsSizeZ() {
        return this.parent.getPixelsSizeZ();
    }

    public Length getUnitBarLength() {
        return this.unitBarLength;
    }

    int getGridColumn() {
        return 2;
    }

    int getGridRow() {
        int n = this.parent.getMaxC();
        if (n == 1) {
            return 1;
        }
        if (n == 2 || n == 3) {
            return 2;
        }
        int row = n / 2;
        if (n % 2 != 0) {
            ++row;
        }
        return row;
    }

    Dimension getGridSize() {
        int w = (int)((double)this.getMaxX() * this.gridRatio);
        int h = (int)((double)this.getMaxY() * this.gridRatio);
        int n = this.parent.getMaxC();
        int row = 0;
        int col = 0;
        if (n == 1) {
            row = 1;
            col = 2;
        } else if (n == 2 || n == 3) {
            row = 2;
            col = 2;
        } else {
            col = 3;
            row = n / 2;
            if (n % 2 != 0) {
                ++row;
            }
        }
        return new Dimension(col * w + (col - 1) * 0, row * h + (row - 1) * 0);
    }

    boolean hasNoGridImages() {
        return this.gridImages.size() == 0;
    }

    List<SplitImage> getSplitImages() {
        if (this.splitImages == null) {
            this.splitImages = new ArrayList<SplitImage>();
        } else {
            this.splitImages.clear();
        }
        this.splitImages = new ArrayList<SplitImage>();
        List<ChannelData> list = this.parent.getSortedChannelData();
        Iterator<ChannelData> i = list.iterator();
        int j = 0;
        int size = this.gridImages.size();
        while (i.hasNext()) {
            ChannelData channel = i.next();
            String n = PREFIX + channel.getChannelLabeling();
            if (j >= size) {
                this.splitImages.add(new SplitImage(null, n));
            } else {
                this.splitImages.add(new SplitImage(this.gridImages.get(j), n));
            }
            ++j;
        }
        this.splitImages.add(new SplitImage(this.combinedImage, COMBINED));
        return this.splitImages;
    }

    int getSelectedIndex() {
        return this.parent.getSelectedIndex();
    }

    boolean isTextVisible() {
        return this.parent.isTextVisible();
    }

    double getRatio() {
        return this.ratio;
    }

    double getGridRatio() {
        return this.gridRatio;
    }

    void setGridRatio(double gridRatio) {
        double max = 1.0;
        if (gridRatio > max) {
            return;
        }
        this.gridRatio = gridRatio;
        if (CollectionUtils.isEmpty(this.originalGridImages)) {
            try {
                this.createGridImages();
            }
            catch (Exception e) {
                this.handleGridImageCreationException(e);
            }
            return;
        }
        int n = this.originalGridImages.size();
        this.clearList(this.gridImages);
        int maxC = this.parent.getMaxC();
        switch (n) {
            case 0: {
                for (int i = 0; i < maxC; ++i) {
                    this.gridImages.add(null);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.isImageMappedRGB(this.parent.getActiveChannels())) {
                    try {
                        this.createGridImages();
                    }
                    catch (Exception e) {
                        this.handleGridImageCreationException(e);
                    }
                    break;
                }
                this.combinedImage = null;
                this.combinedImage = Factory.magnifyImage(gridRatio, this.renderedImage);
                Iterator<BufferedImage> i = this.originalGridImages.iterator();
                while (i.hasNext()) {
                    this.gridImages.add(Factory.magnifyImage(gridRatio, i.next()));
                }
                break;
            }
            default: {
                this.combinedImage = null;
                this.combinedImage = Factory.magnifyImage(gridRatio, this.renderedImage);
                Iterator<BufferedImage> i = this.originalGridImages.iterator();
                while (i.hasNext()) {
                    this.gridImages.add(Factory.magnifyImage(gridRatio, i.next()));
                }
                break block2;
            }
        }
    }

    BufferedImage getCombinedImage() {
        return this.combinedImage;
    }

    int getMaxC() {
        return this.parent.getMaxC();
    }

    void zoom(boolean increase) {
        int index = 0;
        if (!increase) {
            index = 1;
        }
        ZoomCmd cmd = new ZoomCmd(this.parent, index);
        cmd.execute();
    }

    BufferedImage getProjectedImage() {
        return this.projectedImage;
    }

    void setProjectedImage(BufferedImage projectedImage) {
        if (this.projectedImage != null) {
            this.projectedImage.flush();
        }
        this.projectedImage = projectedImage;
    }

    void projectionPreview() {
        this.parent.renderXYPlane();
    }

    ImViewer getParentModel() {
        return this.parent;
    }

    void clearGridImages() {
        this.clearList(this.gridImages);
    }

    boolean isRenderedImageRGB() {
        return this.isImageMappedRGB(this.parent.getActiveChannels());
    }

    boolean isModelRGB() {
        return !"greyscale".equals(this.parent.getColorModel());
    }

    List<GridImage> getGridImages() {
        ArrayList<GridImage> list = new ArrayList<GridImage>();
        List<ChannelData> l = this.parent.getSortedChannelData();
        for (ChannelData data : l) {
            int index = data.getIndex();
            String label = data.getChannelLabeling();
            GridImage image = this.parent.isChannelActive(index) ? new GridImage(index, true, label) : new GridImage(index, false, label);
            list.add(image);
        }
        return list;
    }

    int getRows() {
        return this.parent.getRows();
    }

    int getColumns() {
        return this.parent.getColumns();
    }

    Map<Integer, Tile> getTiles() {
        return this.parent.getTiles();
    }

    boolean isBigImage() {
        return this.parent.isBigImage();
    }

    void loadTiles(Rectangle r) {
        this.parent.loadTiles(r);
    }

    int getTiledImageSizeX() {
        return this.parent.getTiledImageSizeX();
    }

    int getTiledImageSizeY() {
        return this.parent.getTiledImageSizeY();
    }

    void discard() {
        this.combinedImage = null;
        this.displayedImage = null;
        this.displayedProjectedImage = null;
        this.projectedImage = null;
        this.renderedImage = null;
        this.clearList(this.gridImages);
        this.clearList(this.originalGridImages);
        System.gc();
    }

    boolean isInterpolation() {
        if (ImViewerFactory.isInterpolation() != null) {
            return ImViewerFactory.isInterpolation();
        }
        return this.interpolationServerProperty;
    }

    void setInterpolation(boolean interpolation) {
        ImViewerFactory.setInterpolation(interpolation);
    }
}

