/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;

public class TagsModel
extends DataBrowserModel {
    private Collection<DataObject> dataObjects;

    TagsModel(SecurityContext ctx, Object parent, Collection<DataObject> dataObjects, boolean withImages) {
        super(ctx);
        if (dataObjects == null) {
            throw new IllegalArgumentException("No dataObjects.");
        }
        this.dataObjects = dataObjects;
        this.parent = parent;
        Set visTrees = withImages ? DataBrowserTranslator.transformHierarchy(dataObjects) : DataBrowserTranslator.transformImages(dataObjects);
        this.browser = BrowserFactory.createBrowser(visTrees);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ImageDisplay node : visTrees) {
            Set datasets;
            Set images;
            Object object = node.getHierarchyObject();
            if (object instanceof ImageData) {
                ids.add(((ImageData)object).getId());
                continue;
            }
            if (object instanceof DatasetData) {
                images = ((DatasetData)object).getImages();
                if (images == null) continue;
                for (ImageData img : images) {
                    if (ids.contains(img.getId())) continue;
                    ids.add(img.getId());
                }
                continue;
            }
            if (!(object instanceof ProjectData) || (datasets = ((ProjectData)object).getDatasets()) == null) continue;
            Iterator j = datasets.iterator();
            while (j.hasNext()) {
                images = ((DatasetData)j.next()).getImages();
                if (images == null) continue;
                for (ImageData img : images) {
                    if (ids.contains(img.getId())) continue;
                    ids.add(img.getId());
                }
            }
        }
        this.numberOfImages = ids.size();
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<ImageData> imgs = new ArrayList<ImageData>();
        ArrayList<Long> loaded = new ArrayList<Long>();
        if (ids != null) {
            while (i.hasNext()) {
                ImageData img;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || !ids.contains((img = (ImageData)node.getHierarchyObject()).getId()) || loaded.contains(img.getId())) continue;
                imgs.add(img);
                loaded.add(img.getId());
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                ImageData img;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || loaded.contains((img = (ImageData)node.getHierarchyObject()).getId())) continue;
                imgs.add(img);
                loaded.add(img.getId());
                ++this.imagesLoaded;
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        return this.createThumbnailsLoader(this.sorter.sort(imgs));
    }

    @Override
    protected int getType() {
        return 6;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

