/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Color;
import javax.swing.Icon;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;

public class ImageTableNode
extends OMETreeNode {
    static final int MIN_HEIGHT = 50;
    static final int MEDIUM_HEIGHT = 98;
    static final int MAX_HEIGHT = 242;
    static final double MIN_FACTOR = 0.5;
    static final double MEDIUM_FACTOR = 1.0;
    private Icon icon;
    private String toolTip;
    private Color siblingColor;

    ImageTableNode(ImageDisplay refNode) {
        super(refNode);
        if (refNode == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        this.setAllowsChildren(!(refNode instanceof ImageNode));
        Object o = this.getHierarchyObject();
        if (o instanceof ImageData) {
            this.toolTip = UIUtilities.formatToolTipText(EditorUtil.formatObjectTooltip((DataObject)((ImageData)o)));
        }
    }

    void setSibingColor(Color siblingColor) {
        this.siblingColor = siblingColor;
    }

    public Color getSibingColor() {
        return this.siblingColor;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public Object getHierarchyObject() {
        return ((ImageDisplay)this.getUserObject()).getHierarchyObject();
    }

    public Color getHighLight() {
        return ((ImageDisplay)this.getUserObject()).getHighlight();
    }

    public Icon getThumbnailIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Object o = this.getUserObject();
        if (o instanceof ImageNode) {
            ImageNode n = (ImageNode)o;
            Thumbnail thumb = n.getThumbnail();
            if (thumb != null) {
                this.icon = thumb.getIcon(thumb.getScalingFactor());
                return this.icon;
            }
            return null;
        }
        return null;
    }

    public Object getValueAt(int column) {
        ImageDisplay node = (ImageDisplay)this.getUserObject();
        Object ho = node.getHierarchyObject();
        switch (column) {
            case 0: {
                if (ho instanceof ExperimenterData) {
                    ExperimenterData exp = (ExperimenterData)ho;
                    return exp.getUserName();
                }
                return node.toString();
            }
            case 1: {
                return this;
            }
        }
        return null;
    }
}

