/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;

public abstract class ImageDisplay
extends TinyPane {
    public static final String ANNOTATE_NODE_PROPERTY = "annotateNode";
    private static final Icon NOT_OWNED_ICON;
    private static final Icon ANNOTATION_ICON;
    protected ImageDisplay parentDisplay;
    private List<ImageDisplay> childrenDisplay;
    protected Object hierarchyObject;
    private int count;

    protected ExperimenterData getNodeOwner() {
        if (this.hierarchyObject instanceof ExperimenterData || this.hierarchyObject instanceof GroupData) {
            return null;
        }
        if (this.hierarchyObject instanceof DataObject) {
            return ((DataObject)this.hierarchyObject).getOwner();
        }
        return null;
    }

    private boolean checkAlgoType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected String getPartialName(String originalName) {
        return EditorUtil.getPartialName(originalName);
    }

    protected ImageDisplay(String title, String note, Object hierarchyObject) {
        super(title, note);
        if (hierarchyObject == null) {
            throw new NullPointerException("No hierarchy object.");
        }
        this.count = 0;
        this.hierarchyObject = hierarchyObject;
        this.childrenDisplay = new ArrayList<ImageDisplay>();
        this.setToolTipText(this.getNodeName());
    }

    public ImageDisplay getParentDisplay() {
        return this.parentDisplay;
    }

    public Collection<ImageDisplay> getChildrenDisplay() {
        return Collections.unmodifiableList(this.childrenDisplay);
    }

    public void addChildDisplay(ImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            return;
        }
        if (child.parentDisplay != null) {
            child.parentDisplay.removeChildDisplay(child);
        }
        child.parentDisplay = this;
        this.childrenDisplay.add(child);
        ((JLayeredPane)this.getInternalDesktop()).add((Component)child, (Object)0);
    }

    public void removeChildDisplay(ImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            child.parentDisplay.childrenDisplay.remove(child);
            child.parentDisplay.getInternalDesktop().remove(child);
            child.parentDisplay = null;
        }
    }

    public void removeAllChildrenDisplay() {
        Iterator<ImageDisplay> i = this.childrenDisplay.iterator();
        HashSet<ImageDisplay> toRemove = new HashSet<ImageDisplay>(this.childrenDisplay.size());
        while (i.hasNext()) {
            toRemove.add(i.next());
        }
        i = toRemove.iterator();
        while (i.hasNext()) {
            this.removeChildDisplay(i.next());
        }
    }

    public void setHierarchyObject(Object ho) {
        if (ho == null) {
            throw new NullPointerException("No hierarchy object.");
        }
        this.hierarchyObject = ho;
        this.setToolTipText(this.toString());
    }

    public Object getHierarchyObject() {
        return this.hierarchyObject;
    }

    public void setNodeDecoration(long userID) {
        ArrayList<JLabel> nodes = new ArrayList<JLabel>();
        if (EditorUtil.isAnnotated(this.hierarchyObject, this.count)) {
            nodes.add(new JLabel(ANNOTATION_ICON));
        }
        if (nodes.size() > 0) {
            this.setDecoration(nodes);
        }
        this.validate();
        this.repaint();
    }

    public void setNodeDecoration() {
        this.setNodeDecoration(-1L);
    }

    public void setAnnotationCount(int count) {
        this.count = count;
        this.noDecoration();
        this.setNodeDecoration();
        this.validate();
        this.repaint();
    }

    public void accept(ImageDisplayVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("No visitor.");
        }
        this.accept(visitor, 2);
    }

    public void accept(ImageDisplayVisitor visitor, int algoType) {
        if (visitor == null) {
            throw new NullPointerException("No visitor.");
        }
        if (!this.checkAlgoType(algoType)) {
            throw new IllegalArgumentException("Algorithm not supported.");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Iterator<ImageDisplay> i = this.childrenDisplay.iterator();
        switch (algoType) {
            case 0: {
                while (i.hasNext()) {
                    i.next().accept(visitor, algoType);
                }
                if (!(this instanceof ImageNode)) break;
                this.doAccept(visitor);
                break;
            }
            case 1: {
                while (i.hasNext()) {
                    ImageDisplay child = i.next();
                    if (!(child instanceof ImageSet)) continue;
                    child.accept(visitor, algoType);
                }
                if (!(this instanceof ImageSet)) break;
                this.doAccept(visitor);
                break;
            }
            case 2: {
                while (i.hasNext()) {
                    i.next().accept(visitor, algoType);
                }
                this.doAccept(visitor);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public String getNodeName() {
        if (this.hierarchyObject instanceof ProjectData) {
            return ((ProjectData)this.hierarchyObject).getName();
        }
        if (this.hierarchyObject instanceof DatasetData) {
            return ((DatasetData)this.hierarchyObject).getName();
        }
        if (this.hierarchyObject instanceof ImageData) {
            return ((ImageData)this.hierarchyObject).getName();
        }
        if (this.hierarchyObject instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)this.hierarchyObject;
            return exp.getFirstName() + " " + exp.getLastName();
        }
        if (this.hierarchyObject instanceof String) {
            return (String)this.hierarchyObject;
        }
        return "";
    }

    @Override
    public String toString() {
        String s = "";
        if (this.hierarchyObject instanceof ProjectData) {
            s = ((ProjectData)this.hierarchyObject).getName();
        } else if (this.hierarchyObject instanceof DatasetData) {
            s = ((DatasetData)this.hierarchyObject).getName();
        } else if (this.hierarchyObject instanceof ImageData) {
            s = this.getPartialName(((ImageData)this.hierarchyObject).getName());
        } else if (this.hierarchyObject instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)this.hierarchyObject;
            s = exp.getFirstName() + " " + exp.getLastName();
        }
        return s;
    }

    public final boolean equals(Object x) {
        return this == x;
    }

    protected abstract void doAccept(ImageDisplayVisitor var1);

    public abstract boolean containsImages();

    public abstract void addListenerToComponents(Object var1);

    static {
        IconManager icons = IconManager.getInstance();
        NOT_OWNED_ICON = icons.getIcon(50);
        ANNOTATION_ICON = icons.getIcon(19);
    }
}

