/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageFinder;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RollOverNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RootDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.FilesetVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.NodesFinder;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.ResetNodesVisitor;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class BrowserModel
extends AbstractComponent
implements Browser {
    private boolean mouseOver;
    private boolean rollOver;
    private boolean thumbSelected;
    private Point popupPoint;
    private RootDisplay rootDisplay;
    private Layout selectedLayout;
    private boolean multiSelection;
    private List<ImageDisplay> selectedDisplays;
    private boolean titleBarVisible;
    private RollOverNode rollOverNode;
    private Set<ImageDisplay> originalNodes;

    private void addToDesktop(ImageDisplay node) {
        if (node instanceof ImageNode) {
            return;
        }
        JComponent desktop = node.getInternalDesktop();
        Collection<ImageDisplay> children = node.getChildrenDisplay();
        if (children == null) {
            return;
        }
        for (ImageDisplay child : children) {
            if (!node.containsImages()) {
                this.addToDesktop(child);
                continue;
            }
            desktop.add(child);
        }
    }

    private void setNodesColor(Collection<ImageDisplay> toSelect, Collection<ImageDisplay> toDeselect) {
        Object ho;
        Colors colors = Colors.getInstance();
        ImageDisplay primary = null;
        if (this.selectedDisplays.size() > 0) {
            primary = this.selectedDisplays.get(0);
        }
        ArrayList<ImageData> selectedImages = new ArrayList<ImageData>();
        ArrayList<ImageData> deselectedImages = new ArrayList<ImageData>();
        if (toDeselect != null && toDeselect.size() > 0) {
            for (ImageDisplay node : toDeselect) {
                if (node == null) continue;
                ho = node.getHierarchyObject();
                if (ho instanceof ImageData) {
                    deselectedImages.add((ImageData)ho);
                }
                if (toSelect != null) {
                    if (toSelect.contains(node)) continue;
                    node.setHighlight(colors.getDeselectedHighLight(node));
                    continue;
                }
                node.setHighlight(colors.getDeselectedHighLight(node));
            }
        }
        if (toSelect != null && toSelect.size() > 0) {
            for (ImageDisplay node : toSelect) {
                ho = node.getHierarchyObject();
                if (ho instanceof ImageData) {
                    selectedImages.add((ImageData)ho);
                }
                node.setHighlight(colors.getSelectedHighLight(node, this.isSameNode(node, primary)));
            }
        }
        FilesetVisitor visitor = new FilesetVisitor(selectedImages, deselectedImages);
        this.accept(visitor);
    }

    private boolean isSameNode(ImageDisplay n1, ImageDisplay n2) {
        if (n1 != null && n2 != null) {
            Object o1 = n1.getHierarchyObject();
            Object o2 = n2.getHierarchyObject();
            if (o1 == null || o2 == null) {
                return false;
            }
            if (!o1.getClass().equals(o2.getClass())) {
                return false;
            }
            if (o1 instanceof DataObject && o2 instanceof DataObject) {
                long id2;
                long id1 = ((DataObject)o1).getId();
                return id1 == (id2 = ((DataObject)o2).getId());
            }
            if (o1 instanceof File && o2 instanceof File) {
                String s1 = ((File)o1).getAbsolutePath();
                String s2 = ((File)o2).getAbsolutePath();
                return s1.equals(s2);
            }
        }
        return false;
    }

    BrowserModel(RootDisplay view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.rootDisplay = view;
        this.selectedDisplays = new ArrayList<ImageDisplay>();
        this.originalNodes = new HashSet<ImageDisplay>(this.rootDisplay.getChildrenDisplay());
        this.titleBarVisible = true;
    }

    void onNodeSelected(ImageDisplay newNode, Set<ImageDisplay> nodes) {
        if (newNode == null) {
            return;
        }
        this.rootDisplay.setTitle(this.currentPathString(newNode));
        ArrayList<ImageDisplay> selected = new ArrayList<ImageDisplay>();
        selected.add(newNode);
        if (this.isMultiSelection() || nodes == null) {
            this.setNodesColor(selected, null);
        } else {
            this.setNodesColor(selected, nodes);
        }
    }

    void setSelectedCell(CellDisplay cell) {
        this.firePropertyChange("cellSelection", null, cell);
    }

    String currentPathString(ImageDisplay parent) {
        StringBuffer buf = new StringBuffer();
        ArrayList<String> titleBuf = new ArrayList<String>();
        while (parent != null && !(parent instanceof RootDisplay)) {
            if (parent instanceof CellDisplay) {
                int type = ((CellDisplay)parent).getType();
                if (type == 1) {
                    titleBuf.add("column: " + parent.getTitle());
                } else {
                    titleBuf.add("row: " + parent.getTitle());
                }
            } else if (parent instanceof WellImageSet) {
                WellImageSet wiNode = (WellImageSet)parent;
                titleBuf.add(wiNode.getTitle());
            } else if (parent instanceof WellSampleNode) {
                Object o = ((WellSampleNode)parent).getParentObject();
                if (o instanceof WellData) {
                    titleBuf.add(((WellData)o).getPlate().getName());
                    titleBuf.add(parent.getTitle());
                    if (titleBuf.size() == 0) {
                        titleBuf.add("[..]");
                    }
                }
            } else {
                titleBuf.add(parent.getTitle());
            }
            parent = parent.getParentDisplay();
        }
        int n = titleBuf.size();
        for (int i = 0; i < n; ++i) {
            buf.append((String)titleBuf.get(n - 1 - i));
            if (i == n - 1) continue;
            buf.append(">");
        }
        return buf.toString();
    }

    void setNodeForProperty(String propName, Object node) {
        this.firePropertyChange(propName, null, node);
    }

    @Override
    public void setRollOverNode(RollOverNode node) {
        RollOverNode previousNode = this.rollOverNode;
        this.rollOverNode = node;
        this.firePropertyChange("rollOver", previousNode, node);
    }

    @Override
    public Collection<ImageDisplay> getRootNodes() {
        NodesFinder finder = new NodesFinder();
        this.accept(finder);
        return finder.getFoundNodes();
    }

    @Override
    public Collection<ImageDisplay> getSelectedDisplays() {
        return this.selectedDisplays;
    }

    @Override
    public Collection<DataObject> getSelectedDataObjects() {
        if (this.selectedDisplays == null) {
            return null;
        }
        Iterator<ImageDisplay> i = this.selectedDisplays.iterator();
        ArrayList<DataObject> nodes = new ArrayList<DataObject>();
        while (i.hasNext()) {
            ImageDisplay o = i.next();
            Object ho = o.getHierarchyObject();
            if (!(ho instanceof DataObject)) continue;
            nodes.add((DataObject)ho);
        }
        return nodes;
    }

    @Override
    public ImageDisplay getLastSelectedDisplay() {
        int size = this.selectedDisplays.size();
        return size < 1 ? null : this.selectedDisplays.get(size - 1);
    }

    @Override
    public void setThumbSelected(boolean selected, ImageNode node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        if (!selected) {
            return;
        }
        this.popupPoint = null;
        this.thumbSelected = selected;
        this.firePropertyChange("thumbSelected", null, node);
    }

    @Override
    public boolean isThumbSelected() {
        return this.thumbSelected;
    }

    @Override
    public void setPopupPoint(Point p, boolean fireProperty) {
        this.thumbSelected = false;
        Object oldValue = null;
        this.popupPoint = p;
        if (fireProperty) {
            this.firePropertyChange("popupPoint", oldValue, p);
        }
    }

    @Override
    public Point getPopupPoint() {
        return this.popupPoint;
    }

    @Override
    public Set<DataObject> getImages() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 0);
        return finder.getImages();
    }

    @Override
    public Set<ImageDisplay> getImageNodes() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 0);
        return finder.getImageNodes();
    }

    @Override
    public void accept(ImageDisplayVisitor visitor) {
        this.rootDisplay.accept(visitor, 2);
    }

    @Override
    public void accept(ImageDisplayVisitor visitor, int algoType) {
        this.rootDisplay.accept(visitor, algoType);
    }

    @Override
    public JComponent getUI() {
        return this.rootDisplay;
    }

    @Override
    public void setSelectedLayout(Layout layout) {
        if (layout == null) {
            return;
        }
        Layout oldLayout = this.selectedLayout;
        switch (layout.getIndex()) {
            case 1: 
            case 2: 
            case 3: {
                this.selectedLayout = layout;
            }
        }
        this.firePropertyChange("layout", oldLayout, this.selectedLayout);
    }

    @Override
    public Layout getSelectedLayout() {
        return this.selectedLayout;
    }

    @Override
    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    @Override
    public boolean isTitleBarVisible() {
        return this.titleBarVisible;
    }

    @Override
    public void setTitleBarVisible(boolean b) {
        this.titleBarVisible = b;
    }

    @Override
    public void setRollOver(boolean rollOver) {
        this.setRollOverNode(null);
        this.rollOver = rollOver;
    }

    @Override
    public boolean isRollOver() {
        return this.rollOver;
    }

    @Override
    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public void setMouseOver(boolean b) {
        this.mouseOver = b;
    }

    @Override
    public void resetChildDisplay() {
        this.rootDisplay.setCursor(Cursor.getPredefinedCursor(3));
        Collection<ImageDisplay> rootChildren = this.rootDisplay.getChildrenDisplay();
        JComponent desktop = this.rootDisplay.getInternalDesktop();
        desktop.removeAll();
        switch (this.selectedLayout.getIndex()) {
            case 1: {
                for (ImageDisplay child : rootChildren) {
                    desktop.add(child);
                    this.addToDesktop(child);
                }
                break;
            }
            case 2: {
                Iterator<ImageDisplay> i = this.getImageNodes().iterator();
                while (i.hasNext()) {
                    desktop.add(i.next());
                }
                break;
            }
        }
        this.rootDisplay.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void setSelectedNodes(List<DataObject> nodes) {
        HashSet<ImageDisplay> oldValue = null;
        if (this.selectedDisplays != null) {
            oldValue = new HashSet<ImageDisplay>(this.selectedDisplays);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            if (this.selectedDisplays != null) {
                this.selectedDisplays.clear();
            }
            this.setNodesColor(null, oldValue);
            return;
        }
        NodesFinder finder = new NodesFinder(nodes);
        this.accept(finder);
        List<ImageDisplay> found = finder.getFoundNodes();
        if (CollectionUtils.isEmpty(found)) {
            this.setSelectedDisplay(null, false, false);
            Collection<ImageDisplay> selected = this.getSelectedDisplays();
            if (CollectionUtils.isEmpty(selected)) {
                this.setNodesColor(null, this.getRootNodes());
            }
            return;
        }
        this.thumbSelected = false;
        this.multiSelection = found.size() > 1;
        this.setSelectedDisplays(found);
        this.setNodesColor(found, oldValue);
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        for (ImageDisplay d : found) {
            if (!(d.getHierarchyObject() instanceof ImageData)) continue;
            images.add((ImageData)d.getHierarchyObject());
        }
        FilesetVisitor visitor = new FilesetVisitor(images, null);
        this.accept(visitor);
    }

    @Override
    public void setFilterNodes(Collection<ImageDisplay> nodes) {
        ResetNodesVisitor visitor = new ResetNodesVisitor(nodes, true);
        this.rootDisplay.accept(visitor, 1);
        Set<DataObject> visibleDataObjects = this.getVisibleImages();
        Collection<DataObject> selectedDataObjects = this.getSelectedDataObjects();
        HashSet<ImageDisplay> nodesWithVisibleSelectedDataObjects = new HashSet<ImageDisplay>();
        for (ImageDisplay filterNode : nodes) {
            Object hierarchyObject = filterNode.getHierarchyObject();
            if (!visibleDataObjects.contains(hierarchyObject) || !selectedDataObjects.contains(hierarchyObject)) continue;
            nodesWithVisibleSelectedDataObjects.add(filterNode);
        }
        this.setNodesSelection(nodesWithVisibleSelectedDataObjects);
    }

    @Override
    public void showAll() {
        this.setFilterNodes(this.getImageNodes());
    }

    @Override
    public Set<DataObject> getOriginal() {
        HashSet<DataObject> nodes = new HashSet<DataObject>();
        Iterator<ImageDisplay> i = this.originalNodes.iterator();
        while (i.hasNext()) {
            Object ho = i.next().getHierarchyObject();
            if (!(ho instanceof DataObject)) continue;
            nodes.add((DataObject)ho);
        }
        return nodes;
    }

    @Override
    public Set<DataObject> getVisibleImages() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 1);
        return finder.getVisibleImages();
    }

    @Override
    public List<ImageNode> getVisibleImageNodes() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 1);
        return new ArrayList<ImageNode>(finder.getVisibleImageNodes());
    }

    @Override
    public List<ImageNode> getVisibleNodes() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 2);
        return new ArrayList<ImageNode>(finder.getVisibleImageNodes());
    }

    @Override
    public void setNodesSelection(Collection<ImageDisplay> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        this.setNodesColor(nodes, this.getSelectedDisplays());
        HashSet<ImageDisplay> previouslySelectedDisplays = new HashSet<ImageDisplay>(this.selectedDisplays);
        previouslySelectedDisplays.removeAll(nodes);
        Colors colors = Colors.getInstance();
        for (ImageDisplay node : previouslySelectedDisplays) {
            node.setHighlight(colors.getDeselectedHighLight(node));
            this.selectedDisplays.remove(node);
        }
        boolean multiSelection = false;
        HashSet<ImageDisplay> oldValue = new HashSet<ImageDisplay>(this.selectedDisplays);
        for (ImageDisplay node : nodes) {
            this.setSelectedDisplay(node, multiSelection, false);
            multiSelection = true;
        }
        this.firePropertyChange("selectedDataBrowserNodesDisplay", oldValue, this.selectedDisplays);
    }

    @Override
    public void removeSelectedDisplay(ImageDisplay node) {
        if (node == null) {
            return;
        }
        Colors colors = Colors.getInstance();
        node.setHighlight(colors.getDeselectedHighLight(node));
        this.selectedDisplays.remove(node);
        this.firePropertyChange("unselectedDataBrowserNodeDisplay", null, node);
    }

    @Override
    public void viewDisplay(ImageDisplay node, boolean internal) {
        if (node == null) {
            return;
        }
        if (internal) {
            this.firePropertyChange("mainViewDisplay", null, node);
        } else {
            this.firePropertyChange("viewDisplay", null, node);
        }
    }

    @Override
    public void setComponentTitle(String title) {
        this.rootDisplay.setTitle(title);
    }

    @Override
    public void refresh(Collection<ImageDisplay> nodes, List<ImageDisplay> selected) {
        this.rootDisplay.removeAllChildrenDisplay();
        if (nodes == null) {
            return;
        }
        Iterator<ImageDisplay> i = nodes.iterator();
        while (i.hasNext()) {
            this.rootDisplay.addChildDisplay(i.next());
        }
        if (selected == null) {
            return;
        }
        boolean b = selected.size() > 1;
        i = selected.iterator();
        while (i.hasNext()) {
            this.setSelectedDisplay(i.next(), b, true);
        }
    }

    @Override
    public void markUnmodifiedNodes(Class type, Collection<Long> ids) {
        Iterator<ImageDisplay> i = this.selectedDisplays.iterator();
        Colors colors = Colors.getInstance();
        while (i.hasNext()) {
            long id;
            ImageDisplay node = i.next();
            Object ho = node.getHierarchyObject();
            if (!ho.getClass().equals(type) || !(ho instanceof DataObject) || !ids.contains(id = ((DataObject)ho).getId())) continue;
            node.setHighlight(colors.getUnmodifiedHighLight(node));
        }
    }

    @Override
    public void setSelectedDisplay(Point coords, boolean multiSel) {
        Component c = this.rootDisplay.getInternalDesktop().getComponentAt(coords);
        if (c != null && c instanceof ImageDisplay) {
            this.setSelectedDisplay((ImageDisplay)c, multiSel, true);
        }
    }

    @Override
    public void setSelectedDisplay(ImageDisplay node, boolean multiSelection, boolean fireProperty) {
        if (node instanceof CellDisplay) {
            return;
        }
        this.thumbSelected = false;
        this.multiSelection = multiSelection;
        HashSet<ImageDisplay> oldValue = new HashSet<ImageDisplay>(this.selectedDisplays);
        if (!multiSelection) {
            this.selectedDisplays.clear();
        }
        int n = this.selectedDisplays.size();
        boolean removed = false;
        if (node != null) {
            if (this.selectedDisplays.contains(node)) {
                this.selectedDisplays.remove(node);
                n = this.selectedDisplays.size();
                removed = true;
            } else {
                this.selectedDisplays.add(node);
            }
        }
        if (fireProperty) {
            this.onNodeSelected(node, oldValue);
            this.firePropertyChange("selectedDataBrowserNodeDisplay", oldValue, node);
        } else if (multiSelection) {
            Colors colors = Colors.getInstance();
            if (removed) {
                node.setHighlight(colors.getDeselectedHighLight(node));
            } else {
                node.setHighlight(colors.getSelectedHighLight(node, n == 0));
            }
        } else {
            this.onNodeSelected(node, oldValue);
        }
    }

    @Override
    public void setSelectedDisplays(List<ImageDisplay> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        if (nodes.size() == 1) {
            this.setSelectedDisplay(nodes.get(0), false, true);
        } else {
            ArrayList<ImageData> selected = new ArrayList<ImageData>(nodes.size());
            for (ImageDisplay img : nodes) {
                if (!(img.getHierarchyObject() instanceof ImageData)) continue;
                selected.add((ImageData)img.getHierarchyObject());
            }
            FilesetVisitor visitor = new FilesetVisitor(selected, null);
            this.accept(visitor);
            this.thumbSelected = false;
            this.multiSelection = true;
            HashSet<ImageDisplay> oldValue = new HashSet<ImageDisplay>(this.selectedDisplays);
            this.selectedDisplays = nodes;
            this.firePropertyChange("selectedDataBrowserNodesDisplay", oldValue, nodes);
        }
    }

    @Override
    public void scrollToNode(ImageDisplay node) {
        JScrollBar vBar;
        if (node == null) {
            return;
        }
        JScrollPane pane = this.rootDisplay.getDeskDecorator();
        Rectangle bounds = node.getBounds();
        Rectangle viewRect = pane.getViewport().getViewRect();
        if (viewRect.contains(bounds)) {
            return;
        }
        JScrollBar hBar = pane.getHorizontalScrollBar();
        if (hBar.isVisible()) {
            int x = bounds.x;
            int max = hBar.getMaximum();
            if (x > max) {
                x = max;
            }
            hBar.setValue(x);
        }
        if ((vBar = pane.getVerticalScrollBar()).isVisible()) {
            int y = bounds.y;
            int max = vBar.getMaximum();
            if (y > max) {
                y = max;
            }
            vBar.setValue(y);
        }
    }
}

