/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class DataFilter
extends DataBrowserLoader {
    private Class nodeType;
    private List<Long> nodeIds;
    private Map<Long, DataObject> nodes;
    private FilterContext context;
    private CallHandle handle;

    private boolean filterByDate(ImageData image) {
        Timestamp start = this.context.getFromDate();
        Timestamp end = this.context.getToDate();
        if (start == null && end == null) {
            return true;
        }
        Timestamp date = this.context.getTimeType() == 1 ? image.getAcquisitionDate() : image.getCreated();
        if (date == null) {
            return false;
        }
        if (start != null && end != null) {
            return date.after(start) && date.before(end);
        }
        if (start == null) {
            return date.before(end);
        }
        return date.after(start);
    }

    public DataFilter(DataBrowser viewer, SecurityContext ctx, FilterContext context, Collection<DataObject> nodes) {
        super(viewer, ctx);
        if (CollectionUtils.isEmpty(nodes)) {
            throw new IllegalArgumentException("No nodes to filter.");
        }
        if (context == null) {
            throw new IllegalArgumentException("No filtering context.");
        }
        this.context = context;
        this.nodes = new HashMap<Long, DataObject>();
        this.nodeIds = new ArrayList<Long>();
        for (DataObject data : nodes) {
            this.nodeIds.add(data.getId());
            this.nodeType = data.getClass();
            this.nodes.put(data.getId(), data);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        this.handle = this.mhView.filterData(this.ctx, this.nodeType, this.nodeIds, this.context, -1L, this);
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 5) {
            return;
        }
        Collection r = (Collection)result;
        ArrayList<DataObject> filteredNodes = new ArrayList<DataObject>();
        List<String> names = this.context.getNames();
        if (CollectionUtils.isEmpty((Collection)r)) {
            this.viewer.setFilteredNodes(filteredNodes, names);
        } else {
            Iterator i = r.iterator();
            while (i.hasNext()) {
                DataObject object = this.nodes.get(i.next());
                if (object instanceof ImageData) {
                    if (!this.filterByDate((ImageData)object)) continue;
                    filteredNodes.add(object);
                    continue;
                }
                filteredNodes.add(object);
            }
            this.viewer.setFilteredNodes(filteredNodes, names);
        }
    }
}

