/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.File;
import java.io.FileWriter;
import java.util.prefs.BackingStoreException;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;

public class IniFile
extends IniPreferences {
    private final Mode _mode;
    private final File _file;

    public IniFile(File file, Mode mode) throws BackingStoreException {
        super(new Ini());
        this._file = file;
        this._mode = mode;
        if (this._mode == Mode.RO || this._mode != Mode.WO && this._file.exists()) {
            this.sync();
        }
    }

    public IniFile(File file) throws BackingStoreException {
        this(file, Mode.RO);
    }

    public Mode getMode() {
        return this._mode;
    }

    public File getFile() {
        return this._file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws BackingStoreException {
        if (this._mode == Mode.WO) {
            throw new BackingStoreException("write only instance");
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.getIni().load(this._file.toURL());
            }
        }
        catch (Exception x) {
            throw new BackingStoreException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws BackingStoreException {
        if (this._mode == Mode.RO) {
            throw new BackingStoreException("read only instance");
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                FileWriter writer = new FileWriter(this._file);
                try {
                    this.getIni().store(writer);
                }
                finally {
                    writer.close();
                }
            }
        }
        catch (Exception x) {
            throw new BackingStoreException(x);
        }
    }

    public static enum Mode {
        RO,
        WO,
        RW;

    }
}

