/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import Ice.DNSException;
import Ice.SocketException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ome.formats.OMEROMetadataStoreClient;
import omero.RType;
import omero.ServerError;
import omero.api.ExporterPrx;
import omero.api.IAdminPrx;
import omero.api.IConfigPrx;
import omero.api.IContainerPrx;
import omero.api.IMetadataPrx;
import omero.api.IPixelsPrx;
import omero.api.IProjectionPrx;
import omero.api.IQueryPrx;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRepositoryInfoPrx;
import omero.api.IRoiPrx;
import omero.api.IScriptPrx;
import omero.api.ITypesPrx;
import omero.api.IUpdatePrx;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.SearchPrx;
import omero.api.ServiceFactoryPrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.ThumbnailStorePrx;
import omero.client;
import omero.cmd.CmdCallbackI;
import omero.cmd.HandlePrx;
import omero.cmd.Request;
import omero.gateway.Connector;
import omero.gateway.LoginCredentials;
import omero.gateway.SecurityContext;
import omero.gateway.cache.CacheService;
import omero.gateway.exception.ConnectionStatus;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.Facility;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.util.NetworkChecker;
import omero.gateway.util.PojoMapper;
import omero.grid.ProcessCallbackI;
import omero.grid.ScriptProcessPrx;
import omero.grid.SharedResourcesPrx;
import omero.log.LogMessage;
import omero.log.Logger;
import omero.model.ExperimenterGroupI;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class Gateway
implements AutoCloseable {
    public static final String PROP_CONNECTOR_CREATED = "PROP_CONNECTOR_CREATED";
    public static final String PROP_CONNECTOR_CLOSED = "PROP_CONNECTOR_CLOSED";
    public static final String PROP_SESSION_CREATED = "PROP_SESSION_CREATED";
    public static final String PROP_SESSION_CLOSED = "PROP_SESSION_CLOSED";
    public static final String PROP_FACILITY_CREATED = "PROP_FACILITY_CREATED";
    public static final String PROP_FACILITY_CLOSED = "PROP_FACILITY_CLOSED";
    public static final String PROP_IMPORTSTORE_CREATED = "PROP_IMPORTSTORE_CREATED";
    public static final String PROP_IMPORTSTORE_CLOSED = "PROP_IMPORTSTORE_CLOSED";
    public static final String PROP_RENDERINGENGINE_CREATED = "PROP_RENDERINGENGINE_CREATED";
    public static final String PROP_RENDERINGENGINE_CLOSED = "PROP_RENDERINGENGINE_CLOSED";
    public static final String PROP_STATEFUL_SERVICE_CREATED = "PROP_SERVICE_CREATED";
    public static final String PROP_STATEFUL_SERVICE_CLOSED = "PROP_SERVICE_CLOSED";
    public static final String PROP_STATELESS_SERVICE_CREATED = "PROP_STATELESS_SERVICE_CREATED";
    private Logger log;
    private String serverVersion;
    private NetworkChecker networkChecker;
    private boolean connected = false;
    private ScheduledThreadPoolExecutor keepAliveExecutor;
    private LoginCredentials login;
    private ExperimenterData loggedInUser;
    private ListMultimap<Long, Connector> groupConnectorMap = Multimaps.synchronizedListMultimap((ListMultimap)LinkedListMultimap.create());
    private CacheService cacheService;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ExecutorService executorService;
    private boolean executorShutdownOnDisconnect = false;

    public Gateway(Logger log) {
        this(log, null, null, false);
    }

    public Gateway(Logger log, CacheService cacheService) {
        this(log, cacheService, null, true);
    }

    public Gateway(Logger log, CacheService cacheService, ExecutorService executorService, boolean executorShutdownOnDisconnect) {
        this.log = log;
        this.cacheService = cacheService;
        this.executorService = executorService == null ? Executors.newCachedThreadPool() : executorService;
        this.executorShutdownOnDisconnect = executorService == null ? true : executorShutdownOnDisconnect;
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    public ExperimenterData connect(LoginCredentials c) throws DSOutOfServiceException {
        client client2 = null;
        try {
            client2 = this.createSession(c);
            this.loggedInUser = this.login(client2, c);
            this.connected = true;
            return this.loggedInUser;
        }
        catch (CannotCreateSessionException e) {
            throw new DSOutOfServiceException("Could not initialize session", e);
        }
        catch (PermissionDeniedException e) {
            throw new DSOutOfServiceException("Login credentials not valid", e);
        }
        catch (ServerError e) {
            throw new DSOutOfServiceException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SocketException e) {
            throw new DSOutOfServiceException(e.getMessage(), e);
        }
        catch (DNSException e) {
            throw new DSOutOfServiceException("Can't resolve hostname " + c.getServer().getHostname(), e);
        }
    }

    public ExperimenterData getLoggedInUser() {
        return this.loggedInUser;
    }

    public void disconnect() {
        if (this.executorShutdownOnDisconnect) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                        this.getLogger().warn((Object)this, "Could not terminate all asynchronous tasks");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        boolean online = this.isNetworkUp(false);
        List<Connector> connectors = this.getAllConnectors();
        Iterator<Connector> i = connectors.iterator();
        while (i.hasNext()) {
            i.next().shutDownServices(true);
        }
        i = connectors.iterator();
        while (i.hasNext()) {
            try {
                i.next().close(online);
            }
            catch (Throwable e) {
                if (this.log == null) continue;
                this.log.warn((Object)this, new LogMessage("Cannot close connector", e));
            }
        }
        Facility.clear();
        this.groupConnectorMap.clear();
        if (this.keepAliveExecutor != null) {
            this.keepAliveExecutor.shutdown();
        }
        this.connected = false;
        if (this.cacheService != null) {
            this.cacheService.shutDown();
        }
    }

    public boolean joinSession() {
        try {
            this.isNetworkUp(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean networkup = this.isNetworkUp(false);
        this.connected = false;
        if (!networkup) {
            if (this.log != null) {
                this.log.warn((Object)this, "Network is down");
            }
            return false;
        }
        List<Connector> connectors = this.removeAllConnectors();
        Iterator<Connector> i = connectors.iterator();
        int index = 0;
        while (i.hasNext()) {
            Connector c = i.next();
            try {
                if (this.log != null) {
                    this.log.debug((Object)this, "joining the session ");
                }
                c.joinSession();
                this.groupConnectorMap.put((Object)c.getGroupID(), (Object)c);
            }
            catch (Throwable t) {
                block14: {
                    if (this.log != null) {
                        this.log.error((Object)this, new LogMessage("Failed to join the session ", t));
                    }
                    try {
                        c.shutDownServices(true);
                        c.close(networkup);
                    }
                    catch (Throwable e) {
                        if (this.log == null) break block14;
                        this.log.error((Object)this, new LogMessage("Failed to close the session ", t));
                    }
                }
                if (this.groupConnectorMap.containsKey((Object)c.getGroupID())) continue;
                try {
                    this.createConnector(new SecurityContext(c.getGroupID()), false);
                }
                catch (Exception e) {
                    if (this.log != null) {
                        this.log.error((Object)this, new LogMessage("Failed to create connector ", e));
                    }
                    ++index;
                }
            }
        }
        this.connected = index == 0;
        return this.connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getSessionId(ExperimenterData user) throws DSOutOfServiceException {
        Connector c = this.getConnector(new SecurityContext(user.getGroupId()), false, false);
        if (c != null) {
            return c.getClient().getSessionId();
        }
        return null;
    }

    public String getServerVersion() throws DSOutOfServiceException {
        if (this.serverVersion == null) {
            throw new DSOutOfServiceException("Not logged in.");
        }
        return this.serverVersion;
    }

    public <T extends Facility> T getFacility(Class<T> type) throws ExecutionException {
        return Facility.getFacility(type, this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public CmdCallbackI submit(SecurityContext ctx, List<Request> commands, SecurityContext target) throws Throwable {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.submit(commands, target);
        }
        return null;
    }

    public CmdCallbackI submit(SecurityContext ctx, Request cmd) throws Throwable {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            client client2 = this.getConnector(ctx, true, false).getClient();
            HandlePrx handle = client2.getSession().submit(cmd);
            return new CmdCallbackI(client2, handle);
        }
        return null;
    }

    public void closeImport(SecurityContext ctx, String userName) {
        block4: {
            try {
                Connector c = this.getConnector(ctx, false, true);
                if (c != null) {
                    if (StringUtils.isNotEmpty((String)userName)) {
                        c = c.getConnector(userName);
                    }
                    c.closeImport();
                }
            }
            catch (Throwable e) {
                if (this.log == null) break block4;
                this.log.warn((Object)this, "Failed to close import: " + e);
            }
        }
    }

    public ProcessCallbackI runScript(SecurityContext ctx, long scriptID, Map<String, RType> parameters) throws DSOutOfServiceException, ServerError {
        Connector c = this.getConnector(ctx);
        if (c == null) {
            return null;
        }
        IScriptPrx svc = c.getScriptService();
        ScriptProcessPrx prx = svc.runScript(scriptID, parameters, null);
        return new ProcessCallbackI(c.getClient(), prx);
    }

    public Logger getLogger() {
        return this.log;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public SharedResourcesPrx getSharedResources(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getSharedResources();
        }
        return null;
    }

    public IRenderingSettingsPrx getRenderingSettingsService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getRenderingSettingsService();
        }
        return null;
    }

    public IRepositoryInfoPrx getRepositoryService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getRepositoryService();
        }
        return null;
    }

    public IScriptPrx getScriptService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getScriptService();
        }
        return null;
    }

    public IContainerPrx getPojosService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getPojosService();
        }
        return null;
    }

    public IQueryPrx getQueryService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getQueryService();
        }
        return null;
    }

    public IUpdatePrx getUpdateService(SecurityContext ctx) throws DSOutOfServiceException {
        return this.getUpdateService(ctx, null);
    }

    public IUpdatePrx getUpdateService(SecurityContext ctx, String userName) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (StringUtils.isNotEmpty((String)userName)) {
            try {
                c = c.getConnector(userName);
            }
            catch (Throwable e) {
                throw new DSOutOfServiceException("Can't get derived connector.", e);
            }
        }
        if (c != null) {
            return c.getUpdateService();
        }
        return null;
    }

    public IMetadataPrx getMetadataService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getMetadataService();
        }
        return null;
    }

    public IRoiPrx getROIService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getROIService();
        }
        return null;
    }

    public IConfigPrx getConfigService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getConfigService();
        }
        return null;
    }

    public ThumbnailStorePrx getThumbnailService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getThumbnailService();
        }
        return null;
    }

    public ExporterPrx getExporterService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getExporterService();
        }
        return null;
    }

    public RawFileStorePrx getRawFileService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getRawFileService();
        }
        return null;
    }

    public RawPixelsStorePrx getPixelsStore(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getPixelsStore();
        }
        return null;
    }

    public IPixelsPrx getPixelsService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getPixelsService();
        }
        return null;
    }

    public SearchPrx getSearchService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getSearchService();
        }
        return null;
    }

    public IProjectionPrx getProjectionService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getProjectionService();
        }
        return null;
    }

    public IAdminPrx getAdminService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getAdminService();
        }
        return null;
    }

    public IAdminPrx getAdminService(SecurityContext ctx, boolean secure) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getAdminService();
        }
        return null;
    }

    public OMEROMetadataStoreClient getImportStore(SecurityContext ctx) throws DSOutOfServiceException {
        return this.getImportStore(ctx, null);
    }

    public OMEROMetadataStoreClient getImportStore(SecurityContext ctx, String userName) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (StringUtils.isNotEmpty((String)userName)) {
            try {
                c = c.getConnector(userName);
            }
            catch (Throwable e) {
                throw new DSOutOfServiceException("Can't get derived connector.", e);
            }
        }
        if (c != null) {
            return c.getImportStore();
        }
        return null;
    }

    public RenderingEnginePrx getRenderingService(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, ServerError {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getRenderingService(pixelsID, ctx.getCompression());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connector> removeAllConnectors() {
        ListMultimap<Long, Connector> listMultimap = this.groupConnectorMap;
        synchronized (listMultimap) {
            ArrayList<Connector> rv = new ArrayList<Connector>(this.groupConnectorMap.values());
            this.groupConnectorMap.clear();
            return rv;
        }
    }

    private client createSession(LoginCredentials c) throws DSOutOfServiceException, CannotCreateSessionException, PermissionDeniedException, ServerError {
        client secureClient;
        block11: {
            String username;
            secureClient = null;
            List<String> args = c.getArguments();
            if (args != null) {
                secureClient = new client(args.toArray(new String[args.size()]));
                username = secureClient.getProperty("omero.user");
            } else {
                username = c.getUser().getUsername();
                secureClient = c.getServer().getPort() > 0 ? new client(c.getServer().getHostname(), c.getServer().getPort()) : new client(c.getServer().getHostname());
            }
            secureClient.setAgent(c.getApplicationName());
            ServiceFactoryPrx entryEncrypted = null;
            boolean connected = false;
            if (this.isSessionID(username)) {
                try {
                    entryEncrypted = secureClient.joinSession(username);
                    connected = true;
                }
                catch (Exception e) {
                    this.log.warn((Object)this, new LogMessage("Could not join session " + username + " , trying username/password login next.", e));
                }
            }
            if (!connected) {
                try {
                    entryEncrypted = args != null ? secureClient.createSession() : secureClient.createSession(c.getUser().getUsername(), c.getUser().getPassword());
                }
                catch (Exception e1) {
                    secureClient.closeSession();
                    throw e1;
                }
            }
            this.pcs.firePropertyChange(PROP_SESSION_CREATED, null, secureClient.getSessionId());
            this.serverVersion = entryEncrypted.getConfigService().getVersion();
            if (c.isCheckNetwork()) {
                try {
                    String ip = InetAddress.getByName(c.getServer().getHostname()).getHostAddress();
                    this.networkChecker = new NetworkChecker(ip, this.log);
                }
                catch (Exception e) {
                    if (this.log == null) break block11;
                    this.log.warn((Object)this, new LogMessage("Failed to get inet address: " + c.getServer().getHostname(), e));
                }
            }
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        Gateway.this.keepSessionAlive();
                    }
                    catch (Throwable t) {
                        if (Gateway.this.log == null) break block2;
                        Gateway.this.log.warn((Object)this, new LogMessage("Exception while keeping the services alive", t));
                    }
                }
            }
        };
        this.keepAliveExecutor = new ScheduledThreadPoolExecutor(1);
        this.keepAliveExecutor.scheduleWithFixedDelay(r, 60L, 60L, TimeUnit.SECONDS);
        return secureClient;
    }

    private boolean isSessionID(String s) {
        try {
            UUID.fromString(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private ExperimenterData login(client client2, LoginCredentials cred) throws DSOutOfServiceException {
        this.login = cred;
        Connector connector = null;
        SecurityContext ctx = null;
        try {
            ExperimenterData exp;
            ServiceFactoryPrx entryEncrypted;
            block13: {
                String[] vs;
                String[] vc;
                entryEncrypted = client2.getSession();
                ResourceBundle bundle = ResourceBundle.getBundle("omero");
                String clientVersion = bundle.getString("omero.version");
                IConfigPrx conf = entryEncrypted.getConfigService();
                String serverVersion = conf.getVersion();
                if (StringUtils.isNotEmpty((String)clientVersion) && StringUtils.isNotEmpty((String)serverVersion) && (!(vc = clientVersion.split("\\."))[0].equals((vs = serverVersion.split("\\."))[0]) || !vc[1].equals(vs[1]))) {
                    throw new DSOutOfServiceException("Client version " + clientVersion + " is not compatible with server version " + serverVersion);
                }
                IAdminPrx prx = entryEncrypted.getAdminService();
                String userName = prx.getEventContext().userName;
                exp = (ExperimenterData)PojoMapper.asDataObject(prx.lookupExperimenter(userName));
                if (cred.getGroupID() >= 0L) {
                    long defaultID = -1L;
                    try {
                        defaultID = exp.getDefaultGroup().getId();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ctx = new SecurityContext(defaultID);
                    ctx.setServerInformation(cred.getServer());
                    connector = new Connector(ctx, client2, entryEncrypted, cred.isEncryption(), this.log);
                    for (PropertyChangeListener l : this.pcs.getPropertyChangeListeners()) {
                        connector.addPropertyChangeListener(l);
                    }
                    this.pcs.firePropertyChange(PROP_CONNECTOR_CREATED, null, client2.getSessionId());
                    this.groupConnectorMap.put((Object)ctx.getGroupID(), (Object)connector);
                    if (defaultID == cred.getGroupID()) {
                        return exp;
                    }
                    try {
                        this.changeCurrentGroup(ctx, exp, cred.getGroupID());
                        ctx = new SecurityContext(cred.getGroupID());
                        ctx.setServerInformation(cred.getServer());
                        ctx.setCompression(cred.getCompression());
                        connector = new Connector(ctx, client2, entryEncrypted, cred.isEncryption(), this.log);
                        for (PropertyChangeListener l : this.pcs.getPropertyChangeListeners()) {
                            connector.addPropertyChangeListener(l);
                        }
                        exp = this.getUserDetails(ctx, userName);
                        this.groupConnectorMap.put((Object)ctx.getGroupID(), (Object)connector);
                    }
                    catch (Exception e) {
                        LogMessage msg = new LogMessage();
                        msg.print("Error while changing group.");
                        msg.print(e);
                        if (this.log == null) break block13;
                        this.log.debug((Object)this, msg);
                    }
                }
            }
            String host = client2.getProperty("omero.host");
            cred.getServer().setHostname(host);
            String port = client2.getProperty("omero.port");
            cred.getServer().setPort(Integer.parseInt(port));
            ctx = new SecurityContext(exp.getDefaultGroup().getId());
            ctx.setServerInformation(cred.getServer());
            ctx.setCompression(cred.getCompression());
            connector = new Connector(ctx, client2, entryEncrypted, cred.isEncryption(), this.log);
            for (PropertyChangeListener l : this.pcs.getPropertyChangeListeners()) {
                connector.addPropertyChangeListener(l);
            }
            this.pcs.firePropertyChange(PROP_CONNECTOR_CREATED, null, client2.getSessionId());
            this.groupConnectorMap.put((Object)ctx.getGroupID(), (Object)connector);
            return exp;
        }
        catch (DSOutOfServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DSOutOfServiceException("Cannot log in. Login credentials not valid", e);
        }
    }

    private void keepSessionAlive() throws DSOutOfServiceException {
        try {
            this.isNetworkUp(false);
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Network not available");
        }
        for (Connector c : this.getAllConnectors()) {
            if (!c.needsKeepAlive() || c.keepSessionAlive()) continue;
            this.groupConnectorMap.removeAll((Object)c.getGroupID());
        }
    }

    private void changeCurrentGroup(SecurityContext ctx, ExperimenterData exp, long groupID) throws DSOutOfServiceException {
        List<GroupData> groups = exp.getGroups();
        Iterator<GroupData> i = groups.iterator();
        GroupData group = null;
        boolean in = false;
        while (i.hasNext()) {
            group = i.next();
            if (group.getId() != groupID) continue;
            in = true;
            break;
        }
        if (in) {
            Connector c = this.getConnector(ctx, true, false);
            try {
                IAdminPrx svc = c.getAdminService();
                svc.setDefaultGroup(exp.asExperimenter(), new ExperimenterGroupI(groupID, false));
            }
            catch (Exception e) {
                throw new DSOutOfServiceException("Can't modify the current group for user:" + exp.getId(), e);
            }
        }
        String s = "Can't modify the current group.\n\n";
        if (!in) {
            throw new DSOutOfServiceException(s);
        }
    }

    public ExperimenterData getUserDetails(SecurityContext ctx, String name) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        try {
            IAdminPrx service = c.getAdminService();
            return (ExperimenterData)PojoMapper.asDataObject(service.lookupExperimenter(name));
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Cannot retrieve user's data ", e);
        }
    }

    public boolean isNetworkUp(boolean useCachedValue) {
        try {
            if (this.networkChecker != null) {
                return this.networkChecker.isNetworkup(useCachedValue);
            }
            return true;
        }
        catch (Throwable t) {
            if (this.log != null) {
                this.log.warn((Object)this, new LogMessage("Error on isNetworkUp check", t));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connector> getAllConnectors() {
        ListMultimap<Long, Connector> listMultimap = this.groupConnectorMap;
        synchronized (listMultimap) {
            return new ArrayList<Connector>(this.groupConnectorMap.values());
        }
    }

    public Connector getConnector(SecurityContext ctx) throws DSOutOfServiceException {
        return this.getConnector(ctx, false, false);
    }

    public void closeConnector(SecurityContext ctx) {
        List clist = this.groupConnectorMap.removeAll((Object)ctx.getGroupID());
        if (CollectionUtils.isEmpty((Collection)clist)) {
            return;
        }
        for (Connector c : clist) {
            c.close(this.isNetworkUp(true));
        }
    }

    public void closeService(SecurityContext ctx, StatefulServiceInterfacePrx svc) {
        block4: {
            try {
                Connector c = this.getConnector(ctx, false, true);
                if (c != null) {
                    c.close(svc);
                } else {
                    svc.close();
                }
            }
            catch (Exception e) {
                if (this.log == null) break block4;
                this.log.warn((Object)this, String.format("Failed to close %s: %s", svc, e));
            }
        }
    }

    public RawPixelsStorePrx createPixelsStore(SecurityContext ctx) throws DSOutOfServiceException {
        if (ctx == null) {
            return null;
        }
        Connector c = this.getConnector(ctx, true, false);
        return c.getPixelsStore();
    }

    public ThumbnailStorePrx createThumbnailStore(SecurityContext ctx) throws DSOutOfServiceException {
        if (ctx == null) {
            return null;
        }
        Connector c = this.getConnector(ctx, true, false);
        ExperimenterData exp = ctx.getExperimenterData();
        if (exp != null && ctx.isSudo()) {
            try {
                c = c.getConnector(exp.getUserName());
            }
            catch (Throwable e) {
                throw new DSOutOfServiceException("Cannot create ThumbnailStore", e);
            }
        }
        return c.getThumbnailService();
    }

    public boolean isAlive(SecurityContext ctx) throws DSOutOfServiceException {
        return null != this.getConnector(ctx, true, true);
    }

    public Connector getConnector(SecurityContext ctx, boolean recreate, boolean permitNull) throws DSOutOfServiceException {
        ExperimenterData exp;
        try {
            this.isNetworkUp(true);
        }
        catch (Exception e1) {
            if (permitNull) {
                if (this.log != null) {
                    this.log.warn((Object)this, new LogMessage("Failed to check network. Returning null connector", e1));
                }
                return null;
            }
            throw new DSOutOfServiceException("Network not available", e1, ConnectionStatus.NETWORK);
        }
        if (!this.isNetworkUp(true)) {
            if (permitNull) {
                if (this.log != null) {
                    this.log.warn((Object)this, "Network down. Returning null connector");
                }
                return null;
            }
            throw new DSOutOfServiceException("Network down. Returning null connector", ConnectionStatus.NETWORK);
        }
        if (ctx == null) {
            if (permitNull) {
                if (this.log != null) {
                    this.log.warn((Object)this, "Null SecurityContext");
                }
                return null;
            }
            throw new DSOutOfServiceException("Null SecurityContext");
        }
        Connector c = null;
        List clist = this.groupConnectorMap.get((Object)ctx.getGroupID());
        if (clist.size() > 0 && (c = (Connector)clist.get(0)).needsKeepAlive()) {
            try {
                this.isNetworkUp(true);
            }
            catch (Exception e) {
                throw new DSOutOfServiceException("Network down.", e, ConnectionStatus.NETWORK);
            }
            if (!c.keepSessionAlive()) {
                this.groupConnectorMap.removeAll((Object)c.getGroupID());
                c = null;
            }
        }
        if (c == null) {
            if (recreate) {
                c = this.createConnector(ctx, permitNull);
            } else {
                if (permitNull) {
                    if (this.log != null) {
                        this.log.warn((Object)this, "Cannot re-create. Returning null connector");
                    }
                    return null;
                }
                throw new DSOutOfServiceException("Not allowed to recreate");
            }
        }
        if ((exp = ctx.getExperimenterData()) != null && ctx.isSudo()) {
            try {
                c = c.getConnector(exp.getUserName());
            }
            catch (Throwable e) {
                throw new DSOutOfServiceException("Could not derive connector", e);
            }
        }
        return c;
    }

    public void shutDownDerivedConnector(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, true);
        if (c == null) {
            return;
        }
        c.closeDerived(this.isNetworkUp(true));
    }

    public Map<SecurityContext, Set<Long>> getRenderingEngines() {
        HashMap<SecurityContext, Set<Long>> l = new HashMap<SecurityContext, Set<Long>>();
        Iterator<Connector> i = this.getAllConnectors().iterator();
        while (i.hasNext()) {
            l.putAll(i.next().getRenderingEngines());
        }
        return l;
    }

    public void shutdownRenderingEngine(SecurityContext ctx, long pixelsID) {
        List clist = this.groupConnectorMap.get((Object)ctx.getGroupID());
        for (Connector c : clist) {
            c.shutDownRenderingEngine(pixelsID);
        }
    }

    public ITypesPrx getTypesService(SecurityContext ctx) throws DSOutOfServiceException {
        Connector c = this.getConnector(ctx, true, false);
        if (c != null) {
            return c.getTypesService();
        }
        return null;
    }

    private Connector createConnector(SecurityContext ctx, boolean permitNull) throws DSOutOfServiceException {
        Connector c;
        block6: {
            c = null;
            try {
                ServiceFactoryPrx prx;
                client client2;
                ctx.setServerInformation(this.login.getServer());
                if (this.login.getArguments() != null) {
                    List<String> args = this.login.getArguments();
                    client2 = new client(args.toArray(new String[args.size()]));
                    prx = client2.createSession();
                } else {
                    client2 = new client(this.login.getServer().getHostname(), this.login.getServer().getPort());
                    prx = client2.createSession(this.login.getUser().getUsername(), this.login.getUser().getPassword());
                }
                if (ctx.getGroupID() < 0L) {
                    throw new IllegalArgumentException("must set security context with a valid group ID");
                }
                prx.setSecurityContext(new ExperimenterGroupI(ctx.getGroupID(), false));
                c = new Connector(ctx, client2, prx, this.login.isEncryption(), this.log);
                for (PropertyChangeListener l : this.pcs.getPropertyChangeListeners()) {
                    c.addPropertyChangeListener(l);
                }
                this.pcs.firePropertyChange(PROP_CONNECTOR_CREATED, null, client2.getSessionId());
                this.groupConnectorMap.put((Object)ctx.getGroupID(), (Object)c);
            }
            catch (Throwable e) {
                if (permitNull) break block6;
                throw new DSOutOfServiceException("Failed to create connector", e);
            }
        }
        return c;
    }

    public Boolean canCreate(SecurityContext ctx) throws DSOutOfServiceException {
        Map<String, String> properties;
        try {
            String keyRegex = "^omero\\.cluster\\.read_only\\.runtime\\.";
            properties = this.getConfigService(ctx).getConfigValues("^omero\\.cluster\\.read_only\\.runtime\\.");
        }
        catch (ServerError se) {
            throw new DSOutOfServiceException("failed to query read-only configuration values", (Throwable)((Object)se));
        }
        ImmutableSet values = ImmutableSet.copyOf(properties.values());
        if (values.isEmpty()) {
            return true;
        }
        if (values.size() == 1) {
            return values.contains("false");
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        if (this.connected) {
            this.disconnect();
        }
    }
}

