/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import com.google.common.base.Function;
import ome.services.blitz.repo.path.FilePathRestrictions;

public class MakePathComponentSafe
implements Function<String, String> {
    protected final FilePathRestrictions rules;

    public MakePathComponentSafe(FilePathRestrictions ... rules) {
        this.rules = FilePathRestrictions.combineFilePathRestrictions(rules);
    }

    public String apply(String string) {
        String ucString = string.toUpperCase();
        for (String unsafeName : this.rules.unsafeNames) {
            if (!ucString.equals(unsafeName)) continue;
            string = string + this.rules.safeCharacter;
        }
        for (String unsafePrefix : this.rules.unsafePrefixes) {
            if (!ucString.startsWith(unsafePrefix)) continue;
            string = this.rules.safeCharacter + string;
        }
        for (String unsafeSuffix : this.rules.unsafeSuffixes) {
            if (!ucString.endsWith(unsafeSuffix)) continue;
            string = string + this.rules.safeCharacter;
        }
        int codePointCount = string.codePointCount(0, string.length());
        int[] codePointArray = new int[codePointCount];
        for (int codePointIndex = 0; codePointIndex < codePointCount; ++codePointIndex) {
            int originalCodePoint = string.codePointAt(string.offsetByCodePoints(0, codePointIndex));
            Integer substituteCodePoint = (Integer)this.rules.transformationMap.get((Object)originalCodePoint);
            codePointArray[codePointIndex] = substituteCodePoint == null ? originalCodePoint : substituteCodePoint;
        }
        return new String(codePointArray, 0, codePointCount);
    }
}

