/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.meta.MetadataStore;

public class LegacyND2Reader
extends FormatReader {
    private static final int WIDE_FIELD = 0;
    private static final int BRIGHT_FIELD = 1;
    private static final int LASER_SCAN_CONFOCAL = 2;
    private static final int SPIN_DISK_CONFOCAL = 3;
    private static final int SWEPT_FIELD_CONFOCAL = 4;
    private static final int MULTI_PHOTON = 5;
    private static final String URL_NIKON_ND2 = "https://docs.openmicroscopy.org/bio-formats/" + FormatTools.VERSION + "/formats/nikon-nis-elements-nd2.html";
    private static final String NO_NIKON_MSG = "Nikon ND2 library not found. Please see " + URL_NIKON_ND2 + " for details.";
    private static boolean libraryFound = true;

    public LegacyND2Reader() {
        super("Nikon ND2 (Legacy)", new String[]{"jp2", "nd2"});
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(String file2, boolean open) {
        return libraryFound && super.isThisType(file2, open);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int[] zct = FormatTools.getZCTCoords((IFormatReader)this, (int)no);
        int bpc = FormatTools.getBytesPerPixel((int)this.getPixelType());
        byte[] b = new byte[FormatTools.getPlaneSize((IFormatReader)this)];
        this.getImage(b, this.getSeries(), zct[0], zct[1], zct[2]);
        int pixel = bpc * this.getRGBChannelCount();
        int rowLen = w * pixel;
        for (int row = 0; row < h; ++row) {
            System.arraycopy(b, pixel * ((row + y) * this.getSizeX() + x), buf, row * rowLen, rowLen);
        }
        if (this.isRGB()) {
            int bpp = this.getSizeC() * bpc;
            int line = w * bpp;
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    int base = row * line + col * bpp;
                    for (int bb = 0; bb < bpc; ++bb) {
                        byte blue = buf[base + bpc * (this.getSizeC() - 1) + bb];
                        buf[base + bpc * (this.getSizeC() - 1) + bb] = buf[base + bb];
                        buf[base + bb] = blue;
                    }
                }
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        try {
            this.openFile(id);
            int numSeries = this.getNumSeries();
            this.core.clear();
            for (i = 0; i < numSeries; ++i) {
                CoreMetadata ms = new CoreMetadata();
                this.core.add(ms);
                ms.sizeX = this.getWidth(i);
                if (ms.sizeX % 2 != 0) {
                    ++ms.sizeX;
                }
                ms.sizeY = this.getHeight(i);
                ms.sizeZ = this.getZSlices(i);
                ms.sizeT = this.getTFrames(i);
                ms.sizeC = this.getChannels(i);
                int bytes = this.getBytesPerPixel(i);
                if (bytes % 3 == 0) {
                    ms.sizeC *= 3;
                    bytes /= 3;
                    ms.rgb = true;
                } else {
                    ms.rgb = false;
                }
                ms.pixelType = FormatTools.pixelTypeFromBytes((int)bytes, (boolean)false, (boolean)true);
                ms.imageCount = ms.sizeZ * ms.sizeT;
                if (!ms.rgb) {
                    ms.imageCount *= ms.sizeC;
                }
                ms.interleaved = true;
                ms.littleEndian = true;
                ms.dimensionOrder = "XYCZT";
                ms.indexed = false;
                ms.falseColor = false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new MissingLibraryException(NO_NIKON_MSG, (Throwable)e);
        }
        catch (Exception e) {
            throw new MissingLibraryException(NO_NIKON_MSG, (Throwable)e);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
    }

    public native void openFile(String var1);

    public native int getNumSeries();

    public native int getWidth(int var1);

    public native int getHeight(int var1);

    public native int getZSlices(int var1);

    public native int getTFrames(int var1);

    public native int getChannels(int var1);

    public native int getBytesPerPixel(int var1);

    public native byte[] getImage(byte[] var1, int var2, int var3, int var4, int var5);

    public native double getDX(int var1, int var2, int var3, int var4);

    public native double getDY(int var1, int var2, int var3, int var4);

    public native double getDZ(int var1, int var2, int var3, int var4);

    public native double getDT(int var1, int var2, int var3, int var4);

    public native double getWavelength(int var1, int var2, int var3, int var4);

    public native String getChannelName(int var1, int var2, int var3, int var4);

    public native double getMagnification(int var1, int var2, int var3, int var4);

    public native double getNA(int var1, int var2, int var3, int var4);

    public native String getObjectiveName(int var1, int var2, int var3, int var4);

    public native int getModality(int var1, int var2, int var3, int var4);

    static {
        try {
            System.loadLibrary("LegacyND2Reader");
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.trace(NO_NIKON_MSG, (Throwable)e);
            libraryFound = false;
        }
        catch (SecurityException e) {
            LOGGER.warn("Insufficient permission to load native library", (Throwable)e);
        }
    }
}

