/*
 * Decompiled with CFR 0.152.
 */
package ome.model.experiment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.enums.ExperimentType;
import ome.model.experiment.MicrobeamManipulation;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="experiment_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="experiment_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="experiment_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="experiment_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="experiment_owner_filter_MICROBEAMMANIPULATION", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="experiment_group_filter_MICROBEAMMANIPULATION", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="experiment_event_filter_MICROBEAMMANIPULATION", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="experiment_perms_filter_MICROBEAMMANIPULATION", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="experiment_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="experiment_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="experiment_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="experiment_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)")})
@Entity
@Table(name="experiment", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_experiment", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_experiment"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Experiment
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "experiment_owner_filter";
    public static final String GROUP_FILTER = "experiment_group_filter";
    public static final String EVENT_FILTER = "experiment_event_filter";
    public static final String PERMS_FILTER = "experiment_perms_filter";
    public static final String ID = "ome.model.experiment.Experiment_id";
    protected Long id;
    public static final String VERSION = "ome.model.experiment.Experiment_version";
    protected Integer version = 0;
    protected ExperimentType type = null;
    protected Set<MicrobeamManipulation> microbeamManipulation = new HashSet<MicrobeamManipulation>();
    public static final String OWNER_FILTER_MICROBEAMMANIPULATION = "experiment_owner_filter_MICROBEAMMANIPULATION";
    public static final String GROUP_FILTER_MICROBEAMMANIPULATION = "experiment_group_filter_MICROBEAMMANIPULATION";
    public static final String EVENT_FILTER_MICROBEAMMANIPULATION = "experiment_event_filter_MICROBEAMMANIPULATION";
    public static final String PERMS_FILTER_MICROBEAMMANIPULATION = "experiment_perms_filter_MICROBEAMMANIPULATION";
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String TYPE = "ome.model.experiment.Experiment_type";
    public static final String MICROBEAMMANIPULATION = "ome.model.experiment.Experiment_microbeamManipulation";
    public static final String DESCRIPTION = "ome.model.experiment.Experiment_description";
    public static final String DETAILS = "ome.model.experiment.Experiment_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Experiment() {
        this(null, true);
    }

    protected Experiment(Long id) {
        this(id, true);
    }

    public Experiment(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Experiment(ExperimentType _type) {
        this(null, true);
        this.setType(_type);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_experiment")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ExperimentType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="type", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKexperiment_type_experimenttype")
    public ExperimentType getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(ExperimentType type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @OneToMany(mappedBy="experiment", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="experiment_owner_filter_MICROBEAMMANIPULATION", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="experiment_group_filter_MICROBEAMMANIPULATION", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="experiment_event_filter_MICROBEAMMANIPULATION", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="experiment_perms_filter_MICROBEAMMANIPULATION", condition=":permsStr = permissions")})
    protected Set<MicrobeamManipulation> getMicrobeamManipulation() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.microbeamManipulation;
    }

    protected void setMicrobeamManipulation(Set<MicrobeamManipulation> microbeamManipulation) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.microbeamManipulation = microbeamManipulation;
    }

    public int sizeOfMicrobeamManipulation() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.microbeamManipulation == null ? -1 : this.microbeamManipulation.size();
    }

    public Iterator<MicrobeamManipulation> iterateMicrobeamManipulation() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getMicrobeamManipulation() == null) {
            return new EmptyIterator<MicrobeamManipulation>();
        }
        return this.getMicrobeamManipulation().iterator();
    }

    public Collection<MicrobeamManipulation> unmodifiableMicrobeamManipulation() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getMicrobeamManipulation() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getMicrobeamManipulation());
    }

    public <E> List<E> collectMicrobeamManipulation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<MicrobeamManipulation> it = this.iterateMicrobeamManipulation();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addMicrobeamManipulation(MicrobeamManipulation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getMicrobeamManipulation() == null) {
            this.throwNullCollectionException("MicrobeamManipulation");
        }
        this.getMicrobeamManipulation().add(target);
        if (target != null) {
            target.setExperiment(this);
        }
    }

    public void addMicrobeamManipulationSet(Collection<MicrobeamManipulation> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getMicrobeamManipulation() == null) {
            this.throwNullCollectionException("MicrobeamManipulation");
        }
        this.getMicrobeamManipulation().addAll(targets);
        for (MicrobeamManipulation target : targets) {
            if (target == null) continue;
            target.setExperiment(this);
        }
    }

    public void removeMicrobeamManipulation(MicrobeamManipulation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getMicrobeamManipulation() == null) {
            this.throwNullCollectionException("MicrobeamManipulation");
        }
        this.getMicrobeamManipulation().remove(target);
        target.setExperiment(null);
    }

    public void removeMicrobeamManipulationSet(Collection<MicrobeamManipulation> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getMicrobeamManipulation() == null) {
            this.throwNullCollectionException("MicrobeamManipulation");
        }
        this.getMicrobeamManipulation().removeAll(targets);
        for (MicrobeamManipulation target : targets) {
            target.setExperiment(null);
        }
    }

    public void clearMicrobeamManipulation() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getMicrobeamManipulation() == null) {
            this.throwNullCollectionException("MicrobeamManipulation");
        }
        this.getMicrobeamManipulation().clear();
        Iterator<MicrobeamManipulation> it = this.iterateMicrobeamManipulation();
        while (it.hasNext()) {
            MicrobeamManipulation target = it.next();
            target.setExperiment(null);
        }
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Experiment newInstance() {
        return new Experiment();
    }

    public Experiment proxy() {
        return new Experiment(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.type = (ExperimentType)__filter.filter(TYPE, this.type);
            this.microbeamManipulation = (Set)__filter.filter(MICROBEAMMANIPULATION, this.microbeamManipulation);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(MICROBEAMMANIPULATION)) {
            return this.getMicrobeamManipulation();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(TYPE)) {
            this.setType((ExperimentType)value);
        } else if (field.equals(MICROBEAMMANIPULATION)) {
            this.setMicrobeamManipulation((Set)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.type = null;
        this.microbeamManipulation = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(TYPE);
        raw.add(MICROBEAMMANIPULATION);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKexperiment_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKexperiment_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKexperiment_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKexperiment_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKexperiment_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

