/*
 * Decompiled with CFR 0.152.
 */
package ome.model.display;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.display.RenderingDef;
import ome.model.enums.ProjectionAxis;
import ome.model.enums.ProjectionType;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="projectiondef_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="projectiondef_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="projectiondef_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="projectiondef_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="projectiondef_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="projectiondef_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="projectiondef_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="projectiondef_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT projectiondef.id FROM projectiondef*, renderingdef*, pixels* WHERE projectiondef.renderingdef = renderingdef.id AND renderingdef.pixels = pixels.id AND pixels.image IN (:images)))")})
@Entity
@Table(name="projectiondef", uniqueConstraints={@UniqueConstraint(columnNames={"renderingDef", "renderingDef_index"})})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_projectiondef", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_projectiondef"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class ProjectionDef
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "projectiondef_owner_filter";
    public static final String GROUP_FILTER = "projectiondef_group_filter";
    public static final String EVENT_FILTER = "projectiondef_event_filter";
    public static final String PERMS_FILTER = "projectiondef_perms_filter";
    public static final String ID = "ome.model.display.ProjectionDef_id";
    protected Long id;
    public static final String VERSION = "ome.model.display.ProjectionDef_version";
    protected Integer version = 0;
    protected RenderingDef renderingDef = null;
    protected ProjectionAxis axis = null;
    protected ProjectionType type = null;
    protected Boolean active = null;
    protected Integer startPlane = null;
    protected Integer endPlane = null;
    protected Integer stepping = null;
    protected ome.model.internal.Details details = new Details();
    public static final String RENDERINGDEF = "ome.model.display.ProjectionDef_renderingDef";
    public static final String AXIS = "ome.model.display.ProjectionDef_axis";
    public static final String TYPE = "ome.model.display.ProjectionDef_type";
    public static final String ACTIVE = "ome.model.display.ProjectionDef_active";
    public static final String STARTPLANE = "ome.model.display.ProjectionDef_startPlane";
    public static final String ENDPLANE = "ome.model.display.ProjectionDef_endPlane";
    public static final String STEPPING = "ome.model.display.ProjectionDef_stepping";
    public static final String DETAILS = "ome.model.display.ProjectionDef_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public ProjectionDef() {
        this(null, true);
    }

    protected ProjectionDef(Long id) {
        this(id, true);
    }

    public ProjectionDef(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public ProjectionDef(RenderingDef _renderingDef, ProjectionAxis _axis, ProjectionType _type, Boolean _active) {
        this(null, true);
        this.setRenderingDef(_renderingDef);
        this.setAxis(_axis);
        this.setType(_type);
        this.setActive(_active);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_projectiondef")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=RenderingDef.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="renderingDef", nullable=false, unique=false, insertable=false, updatable=false)
    @ForeignKey(name="FKprojectiondef_renderingDef_renderingdef")
    public RenderingDef getRenderingDef() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.renderingDef;
    }

    public void setRenderingDef(RenderingDef renderingDef) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.renderingDef = renderingDef;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ProjectionAxis.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="axis", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKprojectiondef_axis_projectionaxis")
    public ProjectionAxis getAxis() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.axis;
    }

    public void setAxis(ProjectionAxis axis) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.axis = axis;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ProjectionType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="type", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKprojectiondef_type_projectiontype")
    public ProjectionType getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(ProjectionType type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="active", updatable=true)
    public Boolean getActive() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.active = active;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="nonnegative_int", nullable=true, unique=false, name="startPlane", updatable=true)
    public Integer getStartPlane() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.startPlane;
    }

    public void setStartPlane(Integer startPlane) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (startPlane != null && startPlane < 0) {
            throw new IllegalArgumentException("values of ProjectionDef.startPlane must not be negative");
        }
        this.startPlane = startPlane;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="nonnegative_int", nullable=true, unique=false, name="endPlane", updatable=true)
    public Integer getEndPlane() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.endPlane;
    }

    public void setEndPlane(Integer endPlane) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (endPlane != null && endPlane < 0) {
            throw new IllegalArgumentException("values of ProjectionDef.endPlane must not be negative");
        }
        this.endPlane = endPlane;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="positive_int", nullable=true, unique=false, name="stepping", updatable=true)
    public Integer getStepping() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.stepping;
    }

    public void setStepping(Integer stepping) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (stepping != null && stepping <= 0) {
            throw new IllegalArgumentException("values of ProjectionDef.stepping must be strictly positive");
        }
        this.stepping = stepping;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public ProjectionDef newInstance() {
        return new ProjectionDef();
    }

    public ProjectionDef proxy() {
        return new ProjectionDef(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.renderingDef = (RenderingDef)__filter.filter(RENDERINGDEF, this.renderingDef);
            this.axis = (ProjectionAxis)__filter.filter(AXIS, this.axis);
            this.type = (ProjectionType)__filter.filter(TYPE, this.type);
            this.active = (Boolean)__filter.filter(ACTIVE, this.active);
            this.startPlane = (Integer)__filter.filter(STARTPLANE, this.startPlane);
            this.endPlane = (Integer)__filter.filter(ENDPLANE, this.endPlane);
            this.stepping = (Integer)__filter.filter(STEPPING, this.stepping);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(RENDERINGDEF)) {
            return this.getRenderingDef();
        }
        if (field.equals(AXIS)) {
            return this.getAxis();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(ACTIVE)) {
            return this.getActive();
        }
        if (field.equals(STARTPLANE)) {
            return this.getStartPlane();
        }
        if (field.equals(ENDPLANE)) {
            return this.getEndPlane();
        }
        if (field.equals(STEPPING)) {
            return this.getStepping();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(RENDERINGDEF)) {
            this.setRenderingDef((RenderingDef)value);
        } else if (field.equals(AXIS)) {
            this.setAxis((ProjectionAxis)value);
        } else if (field.equals(TYPE)) {
            this.setType((ProjectionType)value);
        } else if (field.equals(ACTIVE)) {
            this.setActive((Boolean)value);
        } else if (field.equals(STARTPLANE)) {
            this.setStartPlane((Integer)value);
        } else if (field.equals(ENDPLANE)) {
            this.setEndPlane((Integer)value);
        } else if (field.equals(STEPPING)) {
            this.setStepping((Integer)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.renderingDef = null;
        this.axis = null;
        this.type = null;
        this.active = null;
        this.startPlane = null;
        this.endPlane = null;
        this.stepping = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(RENDERINGDEF);
        raw.add(AXIS);
        raw.add(TYPE);
        raw.add(ACTIVE);
        raw.add(STARTPLANE);
        raw.add(ENDPLANE);
        raw.add(STEPPING);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKprojectiondef_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKprojectiondef_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKprojectiondef_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKprojectiondef_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKprojectiondef_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

