/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import loci.common.DataTools;
import loci.common.Location;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Modulo;
import loci.formats.meta.MetadataStore;

public class FilePatternReader
extends FormatReader {
    private FileStitcher helper;

    public FilePatternReader() {
        super("File pattern", new String[]{"pattern"});
        ClassList classes = ImageReader.getDefaultReaderClasses();
        Class[] classArray = classes.getClasses();
        ClassList newClasses = new ClassList(IFormatReader.class);
        for (Class c : classArray) {
            if (c.equals(FilePatternReader.class)) continue;
            newClasses.addClass(c);
        }
        this.helper = new FileStitcher((IFormatReader)new ImageReader(newClasses));
        this.suffixSufficient = true;
    }

    public void reopenFile() throws IOException {
        this.helper.reopenFile();
    }

    public int getImageCount() {
        return this.helper.getImageCount();
    }

    public boolean isRGB() {
        return this.helper.isRGB();
    }

    public int getSizeX() {
        return this.helper.getSizeX();
    }

    public int getSizeY() {
        return this.helper.getSizeY();
    }

    public int getSizeZ() {
        return this.helper.getSizeZ();
    }

    public int getSizeC() {
        return this.helper.getSizeC();
    }

    public int getSizeT() {
        return this.helper.getSizeT();
    }

    public int getPixelType() {
        return this.helper.getPixelType();
    }

    public int getBitsPerPixel() {
        return this.helper.getBitsPerPixel();
    }

    public int getEffectiveSizeC() {
        return this.helper.getEffectiveSizeC();
    }

    public int getRGBChannelCount() {
        return this.helper.getRGBChannelCount();
    }

    public boolean isIndexed() {
        return this.helper.isIndexed();
    }

    public boolean isFalseColor() {
        return this.helper.isFalseColor();
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.getCurrentFile() == null) {
            return null;
        }
        return this.helper.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.getCurrentFile() == null) {
            return null;
        }
        return this.helper.get16BitLookupTable();
    }

    public Modulo getModuloZ() {
        return this.helper.getModuloZ();
    }

    public Modulo getModuloC() {
        return this.helper.getModuloC();
    }

    public Modulo getModuloT() {
        return this.helper.getModuloT();
    }

    public int getThumbSizeX() {
        return this.helper.getThumbSizeX();
    }

    public int getThumbSizeY() {
        return this.helper.getThumbSizeY();
    }

    public boolean isLittleEndian() {
        return this.helper.isLittleEndian();
    }

    public String getDimensionOrder() {
        return this.helper.getDimensionOrder();
    }

    public boolean isOrderCertain() {
        return this.helper.isOrderCertain();
    }

    public boolean isThumbnailSeries() {
        return this.helper.isThumbnailSeries();
    }

    public boolean isInterleaved() {
        return this.helper.isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        return this.helper.isInterleaved(subC);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.helper.openBytes(no);
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.helper.openBytes(no, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.helper.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.helper.openBytes(no, buf, x, y, w, h);
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.helper.openPlane(no, x, y, w, h);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return this.helper.openThumbBytes(no);
    }

    public void close(boolean fileOnly) throws IOException {
        this.helper.close(fileOnly);
    }

    public int getSeriesCount() {
        return this.helper.getSeriesCount();
    }

    public void setSeries(int no) {
        this.helper.setSeries(no);
    }

    public int getSeries() {
        return this.helper.getSeries();
    }

    public void setGroupFiles(boolean group) {
        this.helper.setGroupFiles(group);
    }

    public boolean isGroupFiles() {
        return this.helper.isGroupFiles();
    }

    public boolean isMetadataComplete() {
        return this.helper.isMetadataComplete();
    }

    public void setNormalized(boolean normalize) {
        this.helper.setNormalized(normalize);
    }

    public boolean isNormalized() {
        return this.helper.isNormalized();
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        this.helper.setOriginalMetadataPopulated(populate);
    }

    public boolean isOriginalMetadataPopulated() {
        return this.helper.isOriginalMetadataPopulated();
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] helperFiles = this.helper.getSeriesUsedFiles(noPixels);
        String[] allFiles = new String[helperFiles.length + 1];
        allFiles[0] = this.currentId;
        System.arraycopy(helperFiles, 0, allFiles, 1, helperFiles.length);
        return allFiles;
    }

    public String[] getUsedFiles(boolean noPixels) {
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] helperFiles = this.helper.getUsedFiles(noPixels);
        String[] allFiles = new String[helperFiles.length + 1];
        allFiles[0] = this.currentId;
        System.arraycopy(helperFiles, 0, allFiles, 1, helperFiles.length);
        return allFiles;
    }

    public int getIndex(int z, int c, int t) {
        return this.helper.getIndex(z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return this.helper.getZCTCoords(index);
    }

    public Object getMetadataValue(String field) {
        return this.helper.getMetadataValue(field);
    }

    public Object getSeriesMetadataValue(String field) {
        return this.helper.getSeriesMetadataValue(field);
    }

    public Hashtable<String, Object> getGlobalMetadata() {
        return this.helper.getGlobalMetadata();
    }

    public Hashtable<String, Object> getSeriesMetadata() {
        return this.helper.getSeriesMetadata();
    }

    public List<CoreMetadata> getCoreMetadataList() {
        List<CoreMetadata> oldcore = this.helper.getCoreMetadataList();
        ArrayList<CoreMetadata> newcore = new ArrayList<CoreMetadata>();
        for (int s = 0; s < oldcore.size(); ++s) {
            CoreMetadata newMeta = oldcore.get(s).clone((IFormatReader)this, s);
            newMeta.resolutionCount = oldcore.get((int)s).resolutionCount;
            newcore.add(newMeta);
        }
        return newcore;
    }

    public void setMetadataFiltered(boolean filter) {
        this.helper.setMetadataFiltered(filter);
    }

    public boolean isMetadataFiltered() {
        return this.helper.isMetadataFiltered();
    }

    public void setMetadataStore(MetadataStore store) {
        this.helper.setMetadataStore(store);
    }

    public MetadataStore getMetadataStore() {
        return this.helper.getMetadataStore();
    }

    public Object getMetadataStoreRoot() {
        return this.helper.getMetadataStoreRoot();
    }

    public IFormatReader[] getUnderlyingReaders() {
        return new IFormatReader[]{this.helper};
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public String getDatasetStructureDescription() {
        return this.helper.getDatasetStructureDescription();
    }

    public boolean hasCompanionFiles() {
        return true;
    }

    public String[] getPossibleDomains(String id) throws FormatException, IOException {
        return this.helper.getPossibleDomains(id);
    }

    public String[] getDomains() {
        return this.helper.getDomains();
    }

    public int getOptimalTileWidth() {
        return this.helper.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        return this.helper.getOptimalTileHeight();
    }

    public int getCoreIndex() {
        return this.helper.getCoreIndex();
    }

    public void setCoreIndex(int no) {
        this.helper.setCoreIndex(no);
    }

    public int seriesToCoreIndex(int series) {
        return this.helper.seriesToCoreIndex(series);
    }

    public int coreIndexToSeries(int index) {
        return this.helper.coreIndexToSeries(index);
    }

    public int getResolutionCount() {
        return this.helper.getResolutionCount();
    }

    public void setResolution(int no) {
        this.helper.setResolution(no);
    }

    public int getResolution() {
        return this.helper.getResolution();
    }

    public boolean hasFlattenedResolutions() {
        return this.helper.hasFlattenedResolutions();
    }

    public void setFlattenedResolutions(boolean flattened) {
        this.helper.setFlattenedResolutions(flattened);
    }

    public Class<?> getNativeDataType() {
        return this.helper.getNativeDataType();
    }

    public void close() throws IOException {
        if (this.helper != null) {
            this.helper.close();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.currentId = new Location(id).getAbsolutePath();
        String pattern = DataTools.readFile((String)id).trim();
        String dir = new Location(id).getAbsoluteFile().getParent();
        if (new Location(pattern).getParent() == null) {
            pattern = dir + File.separator + pattern;
        }
        this.helper.setUsingPatternIds(true);
        this.helper.setCanChangePattern(false);
        this.helper.setId(pattern);
        this.core = this.helper.getCoreMetadataList();
    }
}

