/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.PackbitsCodec;
import loci.formats.codec.WrappedCodec;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Timestamp;

public class DicomReader
extends FormatReader {
    public static final String DICOM_MAGIC_STRING = "DICM";
    private static final String[] DICOM_SUFFIXES = new String[]{"dic", "dcm", "dicom", "j2ki", "j2kr"};
    private static final ImmutableMap<Integer, String> TYPES = DicomReader.buildTypes();
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int PIXEL_SIGN = 2625601;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int SLICE_SPACING = 0x180088;
    private static final int SAMPLES_PER_PIXEL = 0x280002;
    private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
    private static final int PLANAR_CONFIGURATION = 2621446;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int WINDOW_CENTER = 2625616;
    private static final int WINDOW_WIDTH = 2625617;
    private static final int RESCALE_INTERCEPT = 2625618;
    private static final int RESCALE_SLOPE = 2625619;
    private static final int ICON_IMAGE_SEQUENCE = 0x880200;
    private static final int ITEM = -73728;
    private static final int ITEM_DELIMINATION = -73715;
    private static final int SEQUENCE_DELIMINATION = -73507;
    private static final int PIXEL_DATA = 2145386512;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static final int IMPLICIT_VR = 11565;
    private int bitsPerPixel;
    private int location;
    private int elementLength;
    private int vr;
    private boolean oddLocations;
    private boolean inSequence;
    private boolean bigEndianTransferSyntax;
    private byte[][] lut;
    private short[][] shortLut;
    private long[] offsets;
    private int maxPixelRange;
    private int centerPixelValue;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private boolean isJP2K = false;
    private boolean isJPEG = false;
    private boolean isRLE = false;
    private boolean isDeflate = false;
    private boolean inverted;
    private String date;
    private String time;
    private String imageType;
    private String pixelSizeX;
    private String pixelSizeY;
    private Double pixelSizeZ;
    private List<Double> positionX = new ArrayList<Double>();
    private List<Double> positionY = new ArrayList<Double>();
    private List<Double> positionZ = new ArrayList<Double>();
    private Map<Integer, List<String>> fileList;
    private int imagesPerFile;
    private String originalDate;
    private String originalTime;
    private String originalInstance;
    private int originalSeries;
    private DicomReader helper;
    private List<String> companionFiles = new ArrayList<String>();

    public DicomReader() {
        super("DICOM", new String[]{"dic", "dcm", "dicom", "jp2", "j2ki", "j2kr", "raw", "ima"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = new String[]{"Medical Imaging"};
        this.datasetDescription = "One or more .dcm or .dicom files";
        this.hasCompanionFiles = true;
    }

    public boolean isThisType(String name, boolean open) {
        if (DicomReader.checkSuffix((String)name, (String[])DICOM_SUFFIXES)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 1024;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)1024, (boolean)true)) {
            return false;
        }
        stream.seek(128L);
        if (stream.readString(4).equals(DICOM_MAGIC_STRING)) {
            return true;
        }
        stream.seek(0L);
        try {
            int tag = this.getNextTag(stream, false);
            return TYPES.containsKey((Object)tag);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return false;
    }

    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        for (String file : files) {
            if (!file.endsWith("DICOMDIR")) continue;
            return 1;
        }
        return super.getRequiredDirectories(files);
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.getPixelType() != 0 && this.getPixelType() != 1) {
            return null;
        }
        return this.lut;
    }

    public short[][] get16BitLookupTable() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.getPixelType() != 2 && this.getPixelType() != 3) {
            return null;
        }
        return this.shortLut;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (noPixels || this.fileList == null) {
            return null;
        }
        Object[] keys = this.fileList.keySet().toArray(new Integer[0]);
        Arrays.sort(keys);
        List<String> files = this.fileList.get(keys[this.getSeries()]);
        if (files == null) {
            return null;
        }
        ArrayList<String> uniqueFiles = new ArrayList<String>();
        for (String f : files) {
            if (uniqueFiles.contains(f)) continue;
            uniqueFiles.add(f);
        }
        for (String f : this.companionFiles) {
            if (uniqueFiles.contains(f)) continue;
            uniqueFiles.add(f);
        }
        return uniqueFiles.toArray(new String[uniqueFiles.size()]);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 1;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        block28: {
            int bpp;
            block29: {
                FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
                Object[] keys = this.fileList.keySet().toArray(new Integer[0]);
                Arrays.sort(keys);
                if (this.fileList.size() > 1) {
                    int fileNumber = 0;
                    if (this.fileList.get(keys[this.getSeries()]).size() > 1) {
                        fileNumber = no / this.imagesPerFile;
                        no %= this.imagesPerFile;
                    }
                    String file = this.fileList.get(keys[this.getSeries()]).get(fileNumber);
                    this.helper.setId(file);
                    return this.helper.openBytes(no, buf, x, y, w, h);
                }
                int ec = this.isIndexed() ? 1 : this.getSizeC();
                bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
                int bytes = this.getSizeX() * this.getSizeY() * bpp * ec;
                this.in.seek(this.offsets[no]);
                if (this.isRLE) {
                    CodecOptions options = new CodecOptions();
                    options.maxBytes = this.getSizeX() * this.getSizeY();
                    block0: for (int c = 0; c < ec; ++c) {
                        PackbitsCodec codec = new PackbitsCodec();
                        byte[] t = null;
                        if (bpp > 1) {
                            int i;
                            int plane = bytes / (bpp * ec);
                            byte[][] tmp = new byte[bpp][];
                            long start = this.in.getFilePointer();
                            for (i = 0; i < bpp; ++i) {
                                tmp[i] = codec.decompress(this.in, options);
                                if (i > 0 && tmp[i].length > options.maxBytes) {
                                    this.in.seek(start);
                                    tmp[i] = codec.decompress(this.in, options);
                                }
                                if (no >= this.imagesPerFile - 1 && i >= bpp - 1) continue;
                                start = this.in.getFilePointer();
                                while (this.in.read() == 0) {
                                }
                                long end = this.in.getFilePointer();
                                this.in.seek(end - 1L);
                            }
                            t = new byte[bytes / ec];
                            for (i = 0; i < plane; ++i) {
                                for (int j = 0; j < bpp; ++j) {
                                    int byteIndex;
                                    int n = byteIndex = this.isLittleEndian() ? bpp - j - 1 : j;
                                    if (i >= tmp[byteIndex].length) continue;
                                    t[i * bpp + j] = tmp[byteIndex][i];
                                }
                            }
                        } else {
                            t = codec.decompress(this.in, options);
                            if (t.length < bytes / ec) {
                                byte[] tmp = t;
                                t = new byte[bytes / ec];
                                System.arraycopy(tmp, 0, t, 0, tmp.length);
                            }
                            if (no < this.imagesPerFile - 1 || c < ec - 1) {
                                while (this.in.read() == 0) {
                                }
                                this.in.seek(this.in.getFilePointer() - 1L);
                            }
                        }
                        int rowLen = w * bpp;
                        int srcRowLen = this.getSizeX() * bpp;
                        for (int row = 0; row < h; ++row) {
                            int src = (row + y) * srcRowLen + x * bpp;
                            int dest = (h * c + row) * rowLen;
                            int len = Math.min(rowLen, t.length - src - 1);
                            if (len < 0) continue block0;
                            System.arraycopy(t, src, buf, dest, len);
                        }
                    }
                } else if (this.isJPEG || this.isJP2K) {
                    int pt;
                    long end = no < this.offsets.length - 1 ? this.offsets[no + 1] : this.in.length();
                    byte[] b = new byte[(int)(end - this.in.getFilePointer())];
                    this.in.read(b);
                    if (b[2] != -1) {
                        byte[] tmp = new byte[b.length + 1];
                        tmp[0] = b[0];
                        tmp[1] = b[1];
                        tmp[2] = -1;
                        System.arraycopy(b, 2, tmp, 3, b.length - 2);
                        b = tmp;
                    }
                    if ((b[3] & 0xFF) >= 240) {
                        b[3] = (byte)(b[3] - 48);
                    }
                    for (pt = b.length - 2; pt >= 0 && b[pt] != -1 || b[pt + 1] != -39; --pt) {
                    }
                    if (pt < b.length - 2) {
                        byte[] tmp = b;
                        b = new byte[pt + 2];
                        System.arraycopy(tmp, 0, b, 0, b.length);
                    }
                    WrappedCodec codec = null;
                    CodecOptions options = new CodecOptions();
                    options.littleEndian = this.isLittleEndian();
                    options.interleaved = this.isInterleaved();
                    codec = this.isJPEG ? new JPEGCodec() : new JPEG2000Codec();
                    b = codec.decompress(b, options);
                    int rowLen = w * bpp;
                    int srcRowLen = this.getSizeX() * bpp;
                    int srcPlane = this.getSizeY() * srcRowLen;
                    for (int c = 0; c < ec; ++c) {
                        for (int row = 0; row < h; ++row) {
                            System.arraycopy(b, c * srcPlane + (row + y) * srcRowLen + x * bpp, buf, h * rowLen * c + row * rowLen, rowLen);
                        }
                    }
                } else {
                    if (this.isDeflate) {
                        throw new UnsupportedCompressionException("Deflate data is not supported.");
                    }
                    this.readPlane(this.in, x, y, w, h, buf);
                }
                if (!this.inverted) break block28;
                if (bpp != 1) break block29;
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)(255 - buf[i]);
                }
                break block28;
            }
            if (bpp != 2) break block28;
            long maxPixelValue = this.maxPixelRange + this.centerPixelValue / 2;
            if (this.maxPixelRange == -1 || this.centerPixelValue < this.maxPixelRange / 2) {
                maxPixelValue = FormatTools.defaultMinMax((int)this.getPixelType())[1];
            }
            boolean little = this.isLittleEndian();
            for (int i = 0; i < buf.length; i += 2) {
                short s = DataTools.bytesToShort((byte[])buf, (int)i, (int)2, (boolean)little);
                DataTools.unpackBytes((long)(maxPixelValue - (long)s), (byte[])buf, (int)i, (int)2, (boolean)little);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.helper != null) {
            this.helper.close(fileOnly);
        }
        if (!fileOnly) {
            this.vr = 0;
            this.elementLength = 0;
            this.location = 0;
            this.bitsPerPixel = 0;
            this.bigEndianTransferSyntax = false;
            this.inSequence = false;
            this.oddLocations = false;
            this.isDeflate = false;
            this.isRLE = false;
            this.isJP2K = false;
            this.isJPEG = false;
            this.lut = null;
            this.offsets = null;
            this.shortLut = null;
            this.maxPixelRange = 0;
            this.centerPixelValue = 0;
            this.rescaleSlope = 1.0;
            this.rescaleIntercept = 0.0;
            this.pixelSizeY = null;
            this.pixelSizeX = null;
            this.pixelSizeZ = null;
            this.imagesPerFile = 0;
            this.fileList = null;
            this.inverted = false;
            this.imageType = null;
            this.time = null;
            this.date = null;
            this.originalInstance = null;
            this.originalTime = null;
            this.originalDate = null;
            this.originalSeries = 0;
            this.helper = null;
            this.companionFiles.clear();
            this.positionX.clear();
            this.positionY.clear();
            this.positionZ.clear();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        this.attachCompanionFiles();
        this.helper = new DicomReader();
        this.helper.setGroupFiles(false);
        m.littleEndian = true;
        this.location = 0;
        this.isJPEG = false;
        this.isRLE = false;
        this.bigEndianTransferSyntax = false;
        this.oddLocations = false;
        this.inSequence = false;
        this.bitsPerPixel = 0;
        this.elementLength = 0;
        this.vr = 0;
        this.lut = null;
        this.offsets = null;
        this.inverted = false;
        LOGGER.info("Verifying DICOM format");
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        this.in.seek(128L);
        if (this.in.readString(4).equals(DICOM_MAGIC_STRING)) {
            if (level != MetadataLevel.MINIMUM) {
                this.in.seek(0L);
                this.addSeriesMeta("Header information", this.in.readString(128));
                this.in.skipBytes(4);
            }
            this.location = 128;
        } else {
            this.in.seek(0L);
        }
        LOGGER.info("Reading tags");
        long baseOffset = 0L;
        boolean decodingTags = true;
        boolean signed = false;
        String currentType = "";
        while (decodingTags && this.in.getFilePointer() + 4L < this.in.length()) {
            LOGGER.debug("Reading tag from {}", (Object)this.in.getFilePointer());
            int tag = this.getNextTag(this.in);
            if (this.elementLength <= 0) continue;
            this.oddLocations = (this.location & 1) != 0;
            LOGGER.debug("  tag={} len={} fp=", new Object[]{tag, this.elementLength, this.in.getFilePointer()});
            String s = null;
            switch (tag) {
                case 131088: {
                    s = this.in.readString(this.elementLength);
                    this.addInfo(tag, s);
                    if (s.startsWith("1.2.840.10008.1.2.4.9")) {
                        this.isJP2K = true;
                    } else if (s.startsWith("1.2.840.10008.1.2.4")) {
                        this.isJPEG = true;
                    } else if (s.startsWith("1.2.840.10008.1.2.5")) {
                        this.isRLE = true;
                    } else if (s.equals("1.2.8.10008.1.2.1.99")) {
                        this.isDeflate = true;
                    } else if (s.indexOf("1.2.4") > -1 || s.indexOf("1.2.5") > -1) {
                        throw new UnsupportedCompressionException("Sorry, compression type " + s + " not supported");
                    }
                    if (s.indexOf("1.2.840.10008.1.2.2") < 0) break;
                    this.bigEndianTransferSyntax = true;
                    break;
                }
                case 0x280008: {
                    s = this.in.readString(this.elementLength);
                    this.addInfo(tag, s);
                    double frames = Double.parseDouble(s);
                    if (!(frames > 1.0)) break;
                    this.imagesPerFile = (int)frames;
                    break;
                }
                case 0x280002: {
                    this.addInfo(tag, this.in.readShort());
                    break;
                }
                case 2621446: {
                    short config = this.in.readShort();
                    m.interleaved = config == 0;
                    this.addInfo(tag, config);
                    break;
                }
                case 2621456: {
                    short y = this.in.readShort();
                    if (y > this.getSizeY()) {
                        m.sizeY = y;
                    }
                    this.addInfo(tag, this.getSizeY());
                    break;
                }
                case 2621457: {
                    short x = this.in.readShort();
                    if (x > this.getSizeX()) {
                        m.sizeX = x;
                    }
                    this.addInfo(tag, this.getSizeX());
                    break;
                }
                case 0x180088: 
                case 2621444: 
                case 2621488: 
                case 2625616: 
                case 2625618: {
                    String winCenter = this.in.readString(this.elementLength);
                    if (winCenter.trim().length() == 0) {
                        this.centerPixelValue = -1;
                    } else {
                        try {
                            this.centerPixelValue = new Double(winCenter).intValue();
                        }
                        catch (NumberFormatException e) {
                            this.centerPixelValue = -1;
                        }
                    }
                    this.addInfo(tag, winCenter);
                    break;
                }
                case 2625619: {
                    this.addInfo(tag, this.in.readString(this.elementLength));
                    break;
                }
                case 2621696: {
                    if (this.bitsPerPixel == 0) {
                        this.bitsPerPixel = this.in.readShort();
                    } else {
                        this.in.skipBytes(2);
                    }
                    this.addInfo(tag, this.bitsPerPixel);
                    break;
                }
                case 2621699: 
                case 2625601: {
                    short ss = this.in.readShort();
                    signed = ss == 1;
                    this.addInfo(tag, ss);
                    break;
                }
                case 2625617: 
                case 537262910: {
                    String t = this.in.readString(this.elementLength);
                    if (t.trim().length() == 0) {
                        this.maxPixelRange = -1;
                    } else {
                        try {
                            this.maxPixelRange = new Double(t.trim()).intValue();
                        }
                        catch (NumberFormatException e) {
                            this.maxPixelRange = -1;
                        }
                    }
                    this.addInfo(tag, t);
                    break;
                }
                case -73728: 
                case 0xFFEE000: 
                case 2145386512: {
                    if (this.elementLength != 0) {
                        baseOffset = this.in.getFilePointer();
                        this.addInfo(tag, this.location);
                        decodingTags = false;
                        break;
                    }
                    this.addInfo(tag, null);
                    break;
                }
                case 2139619344: {
                    if (this.elementLength == 0) break;
                    baseOffset = this.location + 4;
                    decodingTags = false;
                    break;
                }
                case 2145386496: {
                    this.in.skipBytes(this.elementLength);
                    break;
                }
                case 0: {
                    this.in.seek(this.in.getFilePointer() - 4L);
                    break;
                }
                case 267312: {
                    currentType = this.getHeaderInfo(tag, s).trim();
                    break;
                }
                case 267520: {
                    if (currentType.equals("IMAGE")) {
                        if (this.fileList == null) {
                            this.fileList = new HashMap<Integer, List<String>>();
                        }
                        int seriesIndex = 0;
                        if (this.originalInstance != null) {
                            try {
                                seriesIndex = Integer.parseInt(this.originalInstance);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.debug("Could not parse instance number: {}", (Object)this.originalInstance);
                            }
                        }
                        if (this.fileList.get(seriesIndex) == null) {
                            this.fileList.put(seriesIndex, new ArrayList());
                        }
                        this.fileList.get(seriesIndex).add(this.getHeaderInfo(tag, s).trim());
                    } else {
                        this.companionFiles.add(this.getHeaderInfo(tag, s).trim());
                    }
                    currentType = "";
                    break;
                }
                default: {
                    long oldfp = this.in.getFilePointer();
                    this.addInfo(tag, s);
                    this.in.seek(oldfp + (long)this.elementLength);
                }
            }
            if (this.in.getFilePointer() < this.in.length() - 4L) continue;
            decodingTags = false;
        }
        if (this.imagesPerFile == 0) {
            this.imagesPerFile = 1;
        }
        if (id.endsWith("DICOMDIR")) {
            String parent = new Location(this.currentId).getAbsoluteFile().getParent();
            for (int q = 0; q < this.fileList.size(); ++q) {
                Integer[] fileKeys = this.fileList.keySet().toArray(new Integer[0]);
                for (int i2 = 0; i2 < this.fileList.get(fileKeys[q]).size(); ++i2) {
                    String file = this.fileList.get(fileKeys[q]).get(i2);
                    file = file.replace('\\', File.separatorChar);
                    file = file.replaceAll("/", File.separator);
                    this.fileList.get(fileKeys[q]).set(i2, parent + File.separator + file);
                }
            }
            for (int i3 = 0; i3 < this.companionFiles.size(); ++i3) {
                String file = this.companionFiles.get(i3);
                file = file.replace('\\', File.separatorChar);
                file = file.replaceAll("/", File.separator);
                this.companionFiles.set(i3, parent + File.separator + file);
            }
            this.companionFiles.add(new Location(this.currentId).getAbsolutePath());
            this.initFile(this.fileList.get(0).get(0));
            return;
        }
        m.bitsPerPixel = this.bitsPerPixel;
        while (this.bitsPerPixel % 8 != 0) {
            ++this.bitsPerPixel;
        }
        if (this.bitsPerPixel == 24 || this.bitsPerPixel == 48) {
            this.bitsPerPixel /= 3;
            m.bitsPerPixel /= 3;
        }
        m.pixelType = FormatTools.pixelTypeFromBytes((int)(this.bitsPerPixel / 8), (boolean)signed, (boolean)false);
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int plane = this.getSizeX() * this.getSizeY() * (this.lut == null ? this.getSizeC() : 1) * bpp;
        LOGGER.info("Calculating image offsets");
        this.in.seek(baseOffset - 12L);
        int len = this.in.readInt();
        if (len >= 0 && (long)len + this.in.getFilePointer() < this.in.length()) {
            this.in.skipBytes(len);
            int check = this.in.readShort() & 0xFFFF;
            if (check == 65534) {
                baseOffset = this.in.getFilePointer() + 2L;
            }
        }
        this.offsets = new long[this.imagesPerFile];
        for (int i4 = 0; i4 < this.imagesPerFile; ++i4) {
            if (this.isRLE) {
                if (i4 == 0) {
                    this.in.seek(baseOffset);
                } else {
                    this.in.seek(this.offsets[i4 - 1]);
                    CodecOptions options = new CodecOptions();
                    options.maxBytes = plane / bpp;
                    for (int q = 0; q < bpp; ++q) {
                        new PackbitsCodec().decompress(this.in, options);
                        while (this.in.read() == 0) {
                        }
                        this.in.seek(this.in.getFilePointer() - 1L);
                    }
                }
                this.in.skipBytes(i4 == 0 ? 64 : 53);
                while (this.in.read() == 0) {
                }
                this.offsets[i4] = this.in.getFilePointer() - 1L;
                continue;
            }
            if (this.isJPEG || this.isJP2K) {
                this.offsets[i4] = i4 == 0 ? baseOffset : this.offsets[i4 - 1] + 3L;
                byte secondCheck = this.isJPEG ? (byte)-40 : 79;
                this.in.seek(this.offsets[i4]);
                byte[] buf = new byte[8192];
                int n = this.in.read(buf);
                boolean found = false;
                while (!found) {
                    int q;
                    for (q = 0; q < n - 2; ++q) {
                        if (buf[q] != -1 || buf[q + 1] != secondCheck || buf[q + 2] != -1 || !this.isJPEG && (!this.isJP2K || buf[q + 3] != 81)) continue;
                        found = true;
                        this.offsets[i4] = this.in.getFilePointer() + (long)q - (long)n;
                        break;
                    }
                    if (found) continue;
                    for (q = 0; q < 4; ++q) {
                        buf[q] = buf[buf.length + q - 4];
                    }
                    n = this.in.read(buf, 4, buf.length - 4) + 4;
                }
                continue;
            }
            this.offsets[i4] = baseOffset + (long)(plane * i4);
        }
        this.makeFileList();
        LOGGER.info("Populating metadata");
        int seriesCount = this.fileList.size();
        Object[] keys = this.fileList.keySet().toArray(new Integer[0]);
        Arrays.sort(keys);
        if (seriesCount > 1) {
            this.core.clear();
        }
        for (int i5 = 0; i5 < seriesCount; ++i5) {
            CoreMetadata ms;
            if (seriesCount == 1) {
                ms = (CoreMetadata)this.core.get(i5);
                ms.sizeZ = this.imagesPerFile * this.fileList.get(keys[i5]).size();
                if (ms.sizeC == 0) {
                    ms.sizeC = 1;
                }
                ms.rgb = ms.sizeC > 1;
                ms.sizeT = 1;
                ms.dimensionOrder = "XYCZT";
                ms.metadataComplete = true;
                ms.falseColor = false;
                if (this.isRLE) {
                    ((CoreMetadata)this.core.get((int)i5)).interleaved = false;
                }
                ms.imageCount = ms.sizeZ;
                continue;
            }
            this.helper.close();
            this.helper.setId(this.fileList.get(keys[i5]).get(0));
            ms = (CoreMetadata)this.helper.getCoreMetadataList().get(0);
            ms.sizeZ *= this.fileList.get(keys[i5]).size();
            ms.imageCount = ms.sizeZ;
            this.core.add(ms);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        String stamp = null;
        if (this.date != null && this.time != null) {
            stamp = this.date + " " + this.time;
            stamp = DateTools.formatDate((String)stamp, (String)"yyyy.MM.dd HH:mm:ss", (String)".");
        }
        if (stamp == null || stamp.trim().equals("")) {
            stamp = null;
        }
        for (i = 0; i < this.core.size(); ++i) {
            if (stamp != null) {
                store.setImageAcquisitionDate(new Timestamp(stamp), i);
            }
            store.setImageName("Series " + i, i);
        }
        if (level != MetadataLevel.MINIMUM) {
            for (i = 0; i < this.core.size(); ++i) {
                Length z;
                Length y;
                Length x;
                store.setImageDescription(this.imageType, i);
                if (this.pixelSizeX != null && (x = FormatTools.getPhysicalSizeX((Double)new Double(this.pixelSizeX), (Unit)UNITS.MILLIMETER)) != null) {
                    store.setPixelsPhysicalSizeX(x, i);
                }
                if (this.pixelSizeY != null && (y = FormatTools.getPhysicalSizeY((Double)new Double(this.pixelSizeY), (Unit)UNITS.MILLIMETER)) != null) {
                    store.setPixelsPhysicalSizeY(y, i);
                }
                if (this.pixelSizeZ != null && (z = FormatTools.getPhysicalSizeZ((Double)new Double(this.pixelSizeZ), (Unit)UNITS.MILLIMETER)) != null) {
                    store.setPixelsPhysicalSizeZ(z, i);
                }
                for (int p = 0; p < this.getImageCount(); ++p) {
                    Length z2;
                    Length y2;
                    Length x2;
                    if (p < this.positionX.size() && this.positionX.get(p) != null && (x2 = new Length((Number)this.positionX.get(p), UNITS.MM)) != null) {
                        store.setPlanePositionX(x2, 0, p);
                    }
                    if (p < this.positionY.size() && this.positionY.get(p) != null && (y2 = new Length((Number)this.positionY.get(p), UNITS.MM)) != null) {
                        store.setPlanePositionY(y2, 0, p);
                    }
                    if (p >= this.positionZ.size() || this.positionZ.get(p) == null || (z2 = new Length((Number)this.positionZ.get(p), UNITS.MM)) == null) continue;
                    store.setPlanePositionZ(z2, 0, p);
                }
            }
        }
    }

    private void addInfo(int tag, String value) throws IOException {
        String oldValue = value;
        String info = this.getHeaderInfo(tag, value);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        if (info != null && tag != -73728) {
            String key;
            if ((info = info.trim()).equals("")) {
                String string = info = oldValue == null ? "" : oldValue.trim();
            }
            if ((key = (String)TYPES.get((Object)tag)) == null) {
                key = this.formatTag(tag);
            }
            if (key.equals("Samples per pixel")) {
                m.sizeC = Integer.parseInt(info);
                if (this.getSizeC() > 1) {
                    m.rgb = true;
                }
            } else if (key.equals("Photometric Interpretation")) {
                if (info.equals("PALETTE COLOR")) {
                    m.indexed = true;
                    m.sizeC = 1;
                    m.rgb = false;
                    this.lut = new byte[3][];
                    this.shortLut = new short[3][];
                } else if (info.startsWith("MONOCHROME")) {
                    this.inverted = info.endsWith("1");
                }
            } else if (key.equals("Acquisition Date")) {
                this.originalDate = info;
            } else if (key.equals("Acquisition Time")) {
                this.originalTime = info;
            } else if (key.equals("Instance Number")) {
                if (info.trim().length() > 0) {
                    this.originalInstance = info;
                }
            } else if (key.equals("Series Number")) {
                try {
                    this.originalSeries = Integer.parseInt(info);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (key.indexOf("Palette Color LUT Data") != -1) {
                String color = key.substring(0, key.indexOf(32)).trim();
                int ndx = color.equals("Red") ? 0 : (color.equals("Green") ? 1 : 2);
                long fp = this.in.getFilePointer();
                this.in.seek(this.in.getFilePointer() - (long)this.elementLength + 1L);
                this.shortLut[ndx] = new short[this.elementLength / 2];
                this.lut[ndx] = new byte[this.elementLength / 2];
                for (int i = 0; i < this.lut[ndx].length; ++i) {
                    this.shortLut[ndx][i] = this.in.readShort();
                    this.lut[ndx][i] = (byte)(this.shortLut[ndx][i] & 0xFF);
                }
                this.in.seek(fp);
            } else if (key.equals("Content Time")) {
                this.time = info;
            } else if (key.equals("Content Date")) {
                this.date = info;
            } else if (key.equals("Image Type")) {
                this.imageType = info;
            } else if (key.equals("Rescale Intercept")) {
                this.rescaleIntercept = Double.parseDouble(info);
            } else if (key.equals("Rescale Slope")) {
                this.rescaleSlope = Double.parseDouble(info);
            } else if (key.equals("Pixel Spacing")) {
                this.pixelSizeY = info.substring(0, info.indexOf("\\"));
                this.pixelSizeX = info.substring(info.lastIndexOf("\\") + 1);
            } else if (key.equals("Spacing Between Slices")) {
                this.pixelSizeZ = new Double(info);
            } else if (tag == 0x200032) {
                String[] positions = info.replace('\\', '_').split("_");
                if (positions.length > 0) {
                    try {
                        this.positionX.add(Double.valueOf(positions[0]));
                    }
                    catch (NumberFormatException e) {
                        this.positionX.add(null);
                    }
                } else {
                    this.positionX.add(null);
                    this.positionY.add(null);
                    this.positionZ.add(null);
                }
                if (positions.length > 1) {
                    try {
                        this.positionY.add(Double.valueOf(positions[1]));
                    }
                    catch (NumberFormatException e) {
                        this.positionY.add(null);
                    }
                } else {
                    this.positionY.add(null);
                    this.positionZ.add(null);
                }
                if (positions.length > 2) {
                    try {
                        this.positionZ.add(Double.valueOf(positions[2]));
                    }
                    catch (NumberFormatException e) {
                        this.positionZ.add(null);
                    }
                } else {
                    this.positionZ.add(null);
                }
            }
            if ((tag & 0xFFFF0000) >> 16 != 32736) {
                key = this.formatTag(tag) + " " + key;
                if (this.metadata.containsKey(key)) {
                    Object v = this.getMetadataValue(key);
                    this.metadata.remove(key);
                    this.addSeriesMetaList(key, v);
                    this.addSeriesMetaList(key, info);
                } else {
                    this.addSeriesMetaList(key, info);
                }
            }
        }
    }

    private void addInfo(int tag, int value) throws IOException {
        this.addInfo(tag, Integer.toString(value));
    }

    private String getHeaderInfo(int tag, String value) throws IOException {
        String id;
        if (tag == -73715 || tag == -73507) {
            this.inSequence = false;
        }
        if ((id = (String)TYPES.get((Object)tag)) != null) {
            if (this.vr == 11565 && id != null) {
                this.vr = (id.charAt(0) << 8) + id.charAt(1);
            }
            if (id.length() > 2) {
                id = id.substring(2);
            }
        }
        if (tag == -73728) {
            return id != null ? id : null;
        }
        if (value != null) {
            return value;
        }
        boolean skip = false;
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                value = this.in.readString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    value = Integer.toString(this.in.readShort());
                    break;
                }
                StringBuilder sb = new StringBuilder();
                int n = this.elementLength / 2;
                for (int i = 0; i < n; ++i) {
                    sb.append(this.in.readShort());
                    sb.append(" ");
                }
                value = sb.toString();
                break;
            }
            case 11565: {
                value = this.in.readString(this.elementLength);
                if (this.elementLength > 4 && this.elementLength <= 44) break;
                value = null;
                break;
            }
            case 21329: {
                boolean privateTag;
                value = "";
                boolean bl = privateTag = (tag >> 16 & 1) != 0;
                if (tag != 0x880200 && !privateTag) break;
                skip = true;
                break;
            }
            default: {
                skip = true;
            }
        }
        if (skip) {
            long skipCount = this.elementLength;
            if (this.in.getFilePointer() + skipCount <= this.in.length()) {
                this.in.skipBytes((int)skipCount);
            }
            this.location += this.elementLength;
            value = "";
        }
        if (value != null && id == null && !value.equals("")) {
            return value;
        }
        if (id == null) {
            return null;
        }
        return value;
    }

    private int getLength(RandomAccessInputStream stream, int tag) throws IOException {
        byte[] b = new byte[4];
        stream.read(b);
        this.vr = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (b[2] == 0 || b[3] == 0) {
                    return stream.readInt();
                }
                this.vr = 11565;
                return DataTools.bytesToInt((byte[])b, (boolean)stream.isLittleEndian());
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                if (tag == 2633734) {
                    return DataTools.bytesToInt((byte[])b, (int)2, (int)2, (boolean)stream.isLittleEndian());
                }
                int n1 = DataTools.bytesToShort((byte[])b, (int)2, (int)2, (boolean)stream.isLittleEndian());
                int n2 = DataTools.bytesToShort((byte[])b, (int)2, (int)2, (!stream.isLittleEndian() ? 1 : 0) != 0);
                n2 &= 0xFFFF;
                if ((n1 &= 0xFFFF) < 0 || (long)n1 + stream.getFilePointer() > stream.length()) {
                    return n2;
                }
                if (n2 < 0 || (long)n2 + stream.getFilePointer() > stream.length()) {
                    return n1;
                }
                return n1;
            }
            case 65535: {
                this.vr = 11565;
                return 8;
            }
        }
        this.vr = 11565;
        int len = DataTools.bytesToInt((byte[])b, (boolean)stream.isLittleEndian());
        if ((long)len + stream.getFilePointer() > stream.length() || len < 0) {
            len = DataTools.bytesToInt((byte[])b, (int)2, (int)2, (boolean)stream.isLittleEndian());
            len &= 0xFFFF;
        }
        return len;
    }

    private int getNextTag(RandomAccessInputStream stream) throws FormatException, IOException {
        return this.getNextTag(stream, true);
    }

    private int getNextTag(RandomAccessInputStream stream, boolean setMetadata) throws FormatException, IOException {
        long fp = stream.getFilePointer();
        if (fp >= stream.length() - 2L) {
            return 0;
        }
        int groupWord = stream.readShort() & 0xFFFF;
        if (groupWord == 2048 && this.bigEndianTransferSyntax) {
            if (setMetadata) {
                ((CoreMetadata)this.core.get((int)0)).littleEndian = false;
            }
            groupWord = 8;
            stream.order(false);
        } else if (groupWord == 65279 || groupWord == 65534) {
            stream.skipBytes(6);
            return this.getNextTag(stream, setMetadata);
        }
        short elementWord = stream.readShort();
        int tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
        this.elementLength = this.getLength(stream, tag);
        if ((long)this.elementLength > stream.length()) {
            stream.seek(fp);
            stream.order(!((CoreMetadata)this.core.get((int)0)).littleEndian);
            if (setMetadata) {
                ((CoreMetadata)this.core.get((int)0)).littleEndian = !((CoreMetadata)this.core.get((int)0)).littleEndian;
            }
            groupWord = stream.readShort() & 0xFFFF;
            elementWord = stream.readShort();
            tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
            this.elementLength = this.getLength(stream, tag);
            if ((long)this.elementLength > stream.length()) {
                throw new FormatException("Invalid tag length " + this.elementLength);
            }
            return tag;
        }
        if (this.elementLength < 0 && groupWord == 32736) {
            stream.skipBytes(12);
            this.elementLength = stream.readInt();
            if (this.elementLength < 0) {
                this.elementLength = stream.readInt();
            }
        }
        if (this.elementLength == 0 && (groupWord == 32736 || tag == 2691092)) {
            this.elementLength = this.getLength(stream, tag);
        } else if (this.elementLength == 0) {
            stream.seek(stream.getFilePointer() - 4L);
            String v = stream.readString(2);
            if (v.equals("UT")) {
                stream.skipBytes(2);
                this.elementLength = stream.readInt();
            } else {
                stream.skipBytes(2);
            }
        }
        if (!this.oddLocations && this.elementLength % 2 == 1) {
            ++this.elementLength;
        }
        if (this.elementLength == -1 || tag != 1572896 && TYPES.containsKey((Object)tag) && ((String)TYPES.get((Object)tag)).endsWith("Sequence")) {
            this.elementLength = 0;
            this.inSequence = true;
        }
        return tag;
    }

    private void makeFileList() throws FormatException, IOException {
        LOGGER.info("Building file list");
        if (this.fileList == null && this.originalInstance != null && this.originalDate != null && this.originalTime != null && this.isGroupFiles()) {
            this.currentId = new Location(this.currentId).getAbsolutePath();
            this.fileList = new HashMap<Integer, List<String>>();
            Integer s = this.originalSeries;
            this.fileList.put(s, new ArrayList());
            int instanceNumber = Integer.parseInt(this.originalInstance) - 1;
            if (instanceNumber == 0) {
                this.fileList.get(s).add(this.currentId);
            } else {
                while (instanceNumber > this.fileList.get(s).size()) {
                    this.fileList.get(s).add(null);
                }
                this.fileList.get(s).add(this.currentId);
            }
            Location currentFile = new Location(this.currentId).getAbsoluteFile();
            Location directory = currentFile.getParentFile();
            directory = directory.getParentFile();
            String[] subdirs = directory.list(true);
            if (subdirs != null) {
                for (String subdir : subdirs) {
                    Location f = new Location(directory, subdir).getAbsoluteFile();
                    if (!f.isDirectory()) continue;
                    this.scanDirectory(f, true);
                }
            }
            for (List list : this.fileList.values()) {
                Iterator fileIterator = list.iterator();
                while (fileIterator.hasNext()) {
                    if (fileIterator.next() != null) continue;
                    fileIterator.remove();
                }
            }
        } else if (this.fileList == null || !this.isGroupFiles()) {
            this.fileList = new HashMap<Integer, List<String>>();
            this.fileList.put(0, new ArrayList());
            this.fileList.get(0).add(this.currentId);
        }
    }

    private void scanDirectory(Location dir, boolean checkSeries) throws FormatException, IOException {
        Location currentFile = new Location(this.currentId).getAbsoluteFile();
        FilePattern pattern = new FilePattern(currentFile.getName(), dir.getAbsolutePath());
        Object[] patternFiles = pattern.getFiles();
        if (patternFiles == null) {
            patternFiles = new String[]{};
        }
        Arrays.sort(patternFiles);
        for (int i = 0; i < patternFiles.length; ++i) {
            patternFiles[i] = new Location((String)patternFiles[i]).getAbsolutePath();
        }
        Object[] files = dir.list(true);
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (Object f : files) {
            String file = new Location(dir, (String)f).getAbsolutePath();
            LOGGER.debug("Checking file {}", (Object)file);
            if (((String)f).equals(this.currentId) || file.equals(this.currentId) || !this.isThisType(file) || Arrays.binarySearch(patternFiles, file) < 0) continue;
            this.addFileToList(file, checkSeries);
        }
    }

    private void addFileToList(String file, boolean checkSeries) throws FormatException, IOException {
        long fp;
        RandomAccessInputStream stream = new RandomAccessInputStream(file);
        if (!this.isThisType(stream)) {
            stream.close();
            return;
        }
        stream.order(true);
        stream.seek(128L);
        if (!stream.readString(4).equals(DICOM_MAGIC_STRING)) {
            stream.seek(0L);
        }
        int fileSeries = -1;
        String date = null;
        String time = null;
        String instance = null;
        while ((date == null || time == null || instance == null || checkSeries && fileSeries < 0) && (fp = stream.getFilePointer()) + 4L < stream.length() && fp >= 0L) {
            int tag = this.getNextTag(stream);
            String key = (String)TYPES.get((Object)tag);
            if ("Instance Number".equals(key)) {
                instance = stream.readString(this.elementLength).trim();
                if (instance.length() != 0) continue;
                instance = null;
                continue;
            }
            if ("Acquisition Time".equals(key)) {
                time = stream.readString(this.elementLength);
                continue;
            }
            if ("Acquisition Date".equals(key)) {
                date = stream.readString(this.elementLength);
                continue;
            }
            if ("Series Number".equals(key)) {
                fileSeries = Integer.parseInt(stream.readString(this.elementLength).trim());
                continue;
            }
            stream.skipBytes(this.elementLength);
        }
        stream.close();
        if (date == null || time == null || instance == null || checkSeries && fileSeries == this.originalSeries) {
            return;
        }
        int stamp = 0;
        try {
            stamp = Integer.parseInt(time);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int timestamp = 0;
        try {
            timestamp = Integer.parseInt(this.originalTime);
        }
        catch (NumberFormatException tag) {
            // empty catch block
        }
        if (date.equals(this.originalDate) && Math.abs(stamp - timestamp) < 150) {
            int position = Integer.parseInt(instance) - 1;
            if (position < 0) {
                position = 0;
            }
            if (this.fileList.get(fileSeries) == null) {
                this.fileList.put(fileSeries, new ArrayList());
            }
            if (position < this.fileList.get(fileSeries).size()) {
                while (position < this.fileList.get(fileSeries).size() && this.fileList.get(fileSeries).get(position) != null) {
                    ++position;
                }
                if (position < this.fileList.get(fileSeries).size()) {
                    this.fileList.get(fileSeries).set(position, file);
                } else if (!this.fileList.get(fileSeries).contains(file)) {
                    this.fileList.get(fileSeries).add(file);
                }
            } else if (!this.fileList.get(fileSeries).contains(file)) {
                while (position > this.fileList.get(fileSeries).size()) {
                    this.fileList.get(fileSeries).add(null);
                }
                this.fileList.get(fileSeries).add(file);
            }
        }
    }

    private String formatTag(int tag) {
        String s = Integer.toHexString(tag);
        while (s.length() < 8) {
            s = "0" + s;
        }
        return s.substring(0, 4) + "," + s.substring(4);
    }

    private void attachCompanionFiles() throws IOException {
        Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
        Location grandparent = parent.getParentFile();
        if (new Location(grandparent, parent.getName() + ".mif").exists()) {
            String[] list;
            for (String f : list = grandparent.list(true)) {
                Location file = new Location(grandparent, f);
                if (file.isDirectory()) continue;
                this.companionFiles.add(file.getAbsolutePath());
            }
        }
    }

    private static ImmutableMap<Integer, String> buildTypes() {
        ImmutableMap.Builder dict = ImmutableMap.builder();
        dict.put((Object)new Integer(131074), (Object)"Media Storage SOP Class UID");
        dict.put((Object)new Integer(131075), (Object)"Media Storage SOP Instance UID");
        dict.put((Object)new Integer(131088), (Object)"Transfer Syntax UID");
        dict.put((Object)new Integer(131090), (Object)"Implementation Class UID");
        dict.put((Object)new Integer(131091), (Object)"Implementation Version Name");
        dict.put((Object)new Integer(131094), (Object)"Source Application Entity Title");
        dict.put((Object)new Integer(524293), (Object)"Specific Character Set");
        dict.put((Object)new Integer(524296), (Object)"Image Type");
        dict.put((Object)new Integer(524304), (Object)"Recognition Code");
        dict.put((Object)new Integer(524306), (Object)"Instance Creation Date");
        dict.put((Object)new Integer(524307), (Object)"Instance Creation Time");
        dict.put((Object)new Integer(524308), (Object)"Instance Creator UID");
        dict.put((Object)new Integer(524310), (Object)"SOP Class UID");
        dict.put((Object)new Integer(524312), (Object)"SOP Instance UID");
        dict.put((Object)new Integer(524314), (Object)"Related General SOP Class UID");
        dict.put((Object)new Integer(524315), (Object)"Original Specialized SOP Class UID");
        dict.put((Object)new Integer(524320), (Object)"Study Date");
        dict.put((Object)new Integer(524321), (Object)"Series Date");
        dict.put((Object)new Integer(524322), (Object)"Acquisition Date");
        dict.put((Object)new Integer(524323), (Object)"Content Date");
        dict.put((Object)new Integer(524324), (Object)"Overlay Date");
        dict.put((Object)new Integer(524325), (Object)"Curve Date");
        dict.put((Object)new Integer(524330), (Object)"Acquisition Date/Time");
        dict.put((Object)new Integer(524336), (Object)"Study Time");
        dict.put((Object)new Integer(524337), (Object)"Series Time");
        dict.put((Object)new Integer(524338), (Object)"Acquisition Time");
        dict.put((Object)new Integer(524339), (Object)"Content Time");
        dict.put((Object)new Integer(524340), (Object)"Overlay Time");
        dict.put((Object)new Integer(524341), (Object)"Curve Time");
        dict.put((Object)new Integer(524353), (Object)"Data Set Subtype");
        dict.put((Object)new Integer(524368), (Object)"Accession Number");
        dict.put((Object)new Integer(524370), (Object)"Query/Retrieve Level");
        dict.put((Object)new Integer(524372), (Object)"Retrieve AE Title");
        dict.put((Object)new Integer(524374), (Object)"Instance Availability");
        dict.put((Object)new Integer(524376), (Object)"Failed SOP Instance UID List");
        dict.put((Object)new Integer(524384), (Object)"Modality");
        dict.put((Object)new Integer(524385), (Object)"Modalities in Study");
        dict.put((Object)new Integer(524386), (Object)"SOP Classes in Study");
        dict.put((Object)new Integer(524388), (Object)"Conversion Type");
        dict.put((Object)new Integer(524392), (Object)"Presentation Intent Type");
        dict.put((Object)new Integer(524400), (Object)"Manufacturer");
        dict.put((Object)new Integer(524416), (Object)"Institution Name");
        dict.put((Object)new Integer(524417), (Object)"Institution Address");
        dict.put((Object)new Integer(524418), (Object)"Institution Code Sequence");
        dict.put((Object)new Integer(524432), (Object)"Referring Physician's Name");
        dict.put((Object)new Integer(524434), (Object)"Referring Physician's Address");
        dict.put((Object)new Integer(524436), (Object)"Referring Physician's Telephone");
        dict.put((Object)new Integer(524438), (Object)"Referring Physician ID");
        dict.put((Object)new Integer(524544), (Object)"Code Value");
        dict.put((Object)new Integer(524546), (Object)"Coding Scheme Designator");
        dict.put((Object)new Integer(524547), (Object)"Coding Scheme Version");
        dict.put((Object)new Integer(524548), (Object)"Code Meaning");
        dict.put((Object)new Integer(524549), (Object)"Mapping Resource");
        dict.put((Object)new Integer(524550), (Object)"Context Group Version");
        dict.put((Object)new Integer(524551), (Object)"Context Group Local Version");
        dict.put((Object)new Integer(524555), (Object)"Context Group Extension Flag");
        dict.put((Object)new Integer(524556), (Object)"Coding Scheme UID");
        dict.put((Object)new Integer(524557), (Object)"Context Group Extension Creator UID");
        dict.put((Object)new Integer(524559), (Object)"Context ID");
        dict.put((Object)new Integer(524560), (Object)"Coding Scheme ID");
        dict.put((Object)new Integer(524562), (Object)"Coding Scheme Registry");
        dict.put((Object)new Integer(524564), (Object)"Coding Scheme External ID");
        dict.put((Object)new Integer(524565), (Object)"Coding Scheme Name");
        dict.put((Object)new Integer(524566), (Object)"Responsible Organization");
        dict.put((Object)new Integer(524801), (Object)"Timezone Offset from UTC");
        dict.put((Object)new Integer(528400), (Object)"Station Name");
        dict.put((Object)new Integer(528432), (Object)"Study Description");
        dict.put((Object)new Integer(528434), (Object)"Procedure Code Sequence");
        dict.put((Object)new Integer(528446), (Object)"Series Description");
        dict.put((Object)new Integer(528448), (Object)"Institutional Department Name");
        dict.put((Object)new Integer(528456), (Object)"Physician(s) of Record");
        dict.put((Object)new Integer(528457), (Object)"Physician(s) of Record ID");
        dict.put((Object)new Integer(528464), (Object)"Performing Physician's Name");
        dict.put((Object)new Integer(528466), (Object)"Performing Physican ID");
        dict.put((Object)new Integer(528480), (Object)"Name of Physician(s) Reading Study");
        dict.put((Object)new Integer(528482), (Object)"Physician(s) Reading Study ID");
        dict.put((Object)new Integer(528496), (Object)"Operator's Name");
        dict.put((Object)new Integer(528498), (Object)"Operator ID");
        dict.put((Object)new Integer(528512), (Object)"Admitting Diagnoses Description");
        dict.put((Object)new Integer(528516), (Object)"Admitting Diagnoses Code Sequence");
        dict.put((Object)new Integer(528528), (Object)"Manufacturer's Model Name");
        dict.put((Object)new Integer(528640), (Object)"Referenced Results Sequence");
        dict.put((Object)new Integer(528656), (Object)"Referenced Study Sequence");
        dict.put((Object)new Integer(528657), (Object)"Referenced Performed Procedure Step");
        dict.put((Object)new Integer(528661), (Object)"Referenced Series Sequence");
        dict.put((Object)new Integer(528672), (Object)"Referenced Patient Sequence");
        dict.put((Object)new Integer(528677), (Object)"Referenced Visit Sequence");
        dict.put((Object)new Integer(528688), (Object)"Referenced Overlay Sequence");
        dict.put((Object)new Integer(528698), (Object)"Referenced Waveform Sequence");
        dict.put((Object)new Integer(528704), (Object)"Referenced Image Sequence");
        dict.put((Object)new Integer(528709), (Object)"Referenced Curve Sequence");
        dict.put((Object)new Integer(528714), (Object)"Referenced Instance Sequence");
        dict.put((Object)new Integer(528720), (Object)"Referenced SOP Class UID");
        dict.put((Object)new Integer(528725), (Object)"Referenced SOP Instance UID");
        dict.put((Object)new Integer(528730), (Object)"SOP Classes Supported");
        dict.put((Object)new Integer(528736), (Object)"Referenced Frame Number");
        dict.put((Object)new Integer(528789), (Object)"Transaction UID");
        dict.put((Object)new Integer(528791), (Object)"Failure Reason");
        dict.put((Object)new Integer(528792), (Object)"Failed SOP Sequence");
        dict.put((Object)new Integer(528793), (Object)"Referenced SOP Sequence");
        dict.put((Object)new Integer(528896), (Object)"Studies Containing Other Referenced Instances Sequence");
        dict.put((Object)new Integer(528976), (Object)"Related Series Sequence");
        dict.put((Object)new Integer(532753), (Object)"Derivation Description");
        dict.put((Object)new Integer(532754), (Object)"Source Image Sequence");
        dict.put((Object)new Integer(532768), (Object)"Stage Name");
        dict.put((Object)new Integer(532770), (Object)"Stage Number");
        dict.put((Object)new Integer(532772), (Object)"Number of Stages");
        dict.put((Object)new Integer(532775), (Object)"View Name");
        dict.put((Object)new Integer(532776), (Object)"View Number");
        dict.put((Object)new Integer(532777), (Object)"Number of Event Timers");
        dict.put((Object)new Integer(532778), (Object)"Number of Views in Stage");
        dict.put((Object)new Integer(532784), (Object)"Event Elapsed Time(s)");
        dict.put((Object)new Integer(532786), (Object)"Event Timer Name(s)");
        dict.put((Object)new Integer(532802), (Object)"Start Trim");
        dict.put((Object)new Integer(532803), (Object)"Stop Trim");
        dict.put((Object)new Integer(532804), (Object)"Recommended Display Frame Rate");
        dict.put((Object)new Integer(533016), (Object)"Anatomic Region Sequence");
        dict.put((Object)new Integer(533024), (Object)"Anatomic Region Modifier Sequence");
        dict.put((Object)new Integer(533032), (Object)"Primary Anatomic Structure Sequence");
        dict.put((Object)new Integer(533033), (Object)"Anatomic Structure Sequence");
        dict.put((Object)new Integer(533040), (Object)"Primary Anatomic Structure Modifier");
        dict.put((Object)new Integer(533056), (Object)"Transducer Position Sequence");
        dict.put((Object)new Integer(533058), (Object)"Transducer Position Modifier Sequence");
        dict.put((Object)new Integer(533060), (Object)"Transducer Orientation Sequence");
        dict.put((Object)new Integer(533062), (Object)"Transducer Orientation Modifier");
        dict.put((Object)new Integer(536577), (Object)"Alternate Representation Sequence");
        dict.put((Object)new Integer(561159), (Object)"Frame Type");
        dict.put((Object)new Integer(561298), (Object)"Referenced Image Evidence Sequence");
        dict.put((Object)new Integer(561441), (Object)"Referenced Raw Data Sequence");
        dict.put((Object)new Integer(561443), (Object)"Creator-Version UID");
        dict.put((Object)new Integer(561444), (Object)"Derivation Image Sequence");
        dict.put((Object)new Integer(561492), (Object)"Source Image Evidence Sequence");
        dict.put((Object)new Integer(561669), (Object)"Pixel Representation");
        dict.put((Object)new Integer(561670), (Object)"Volumetric Properties");
        dict.put((Object)new Integer(561671), (Object)"Volume Based Calculation Technique");
        dict.put((Object)new Integer(561672), (Object)"Complex Image Component");
        dict.put((Object)new Integer(561673), (Object)"Acquisition Contrast");
        dict.put((Object)new Integer(561685), (Object)"Derivation Code Sequence");
        dict.put((Object)new Integer(561719), (Object)"Reference Grayscale Presentation State");
        dict.put((Object)new Integer(0x100010), (Object)"Patient's Name");
        dict.put((Object)new Integer(0x100020), (Object)"Patient ID");
        dict.put((Object)new Integer(0x100021), (Object)"Issuer of Patient ID");
        dict.put((Object)new Integer(0x100030), (Object)"Patient's Birth Date");
        dict.put((Object)new Integer(1048626), (Object)"Patient's Birth Time");
        dict.put((Object)new Integer(0x100040), (Object)"Patient's Sex");
        dict.put((Object)new Integer(0x100050), (Object)"Patient's Insurance Plane Code");
        dict.put((Object)new Integer(0x100101), (Object)"Patient's Primary Language Code");
        dict.put((Object)new Integer(0x100102), (Object)"Patient's Primary Language Modifier");
        dict.put((Object)new Integer(0x101000), (Object)"Other Patient IDs");
        dict.put((Object)new Integer(0x101001), (Object)"Other Patient Names");
        dict.put((Object)new Integer(0x101005), (Object)"Patient's Birth Name");
        dict.put((Object)new Integer(0x101010), (Object)"Patient's Age");
        dict.put((Object)new Integer(0x101020), (Object)"Patient's Size");
        dict.put((Object)new Integer(0x101030), (Object)"Patient's Weight");
        dict.put((Object)new Integer(0x101040), (Object)"Patient's Address");
        dict.put((Object)new Integer(0x101060), (Object)"Patient's Mother's Birth Name");
        dict.put((Object)new Integer(0x101080), (Object)"Military Rank");
        dict.put((Object)new Integer(0x101081), (Object)"Branch of Service");
        dict.put((Object)new Integer(0x101090), (Object)"Medical Record Locator");
        dict.put((Object)new Integer(0x102000), (Object)"Medical Alerts");
        dict.put((Object)new Integer(0x102110), (Object)"Contrast Allergies");
        dict.put((Object)new Integer(1057104), (Object)"Country of Residence");
        dict.put((Object)new Integer(1057106), (Object)"Region of Residence");
        dict.put((Object)new Integer(1057108), (Object)"Patient's Telephone Numbers");
        dict.put((Object)new Integer(1057120), (Object)"Ethnic Group");
        dict.put((Object)new Integer(1057152), (Object)"Occupation");
        dict.put((Object)new Integer(1057184), (Object)"Smoking Status");
        dict.put((Object)new Integer(1057200), (Object)"Additional Patient History");
        dict.put((Object)new Integer(1057216), (Object)"Pregnancy Status");
        dict.put((Object)new Integer(1057232), (Object)"Last Menstrual Date");
        dict.put((Object)new Integer(1057264), (Object)"Patient's Religious Preference");
        dict.put((Object)new Integer(0x104000), (Object)"Patient Comments");
        dict.put((Object)new Integer(0x120010), (Object)"Clinical Trial Sponsor Name");
        dict.put((Object)new Integer(0x120020), (Object)"Clinical Trial Protocol ID");
        dict.put((Object)new Integer(0x120021), (Object)"Clinical Trial Protocol Name");
        dict.put((Object)new Integer(1179696), (Object)"Clinical Trial Site ID");
        dict.put((Object)new Integer(1179697), (Object)"Clinical Trial Site Name");
        dict.put((Object)new Integer(1179712), (Object)"Clinical Trial Subject ID");
        dict.put((Object)new Integer(1179714), (Object)"Clinical Trial Subject Reading ID");
        dict.put((Object)new Integer(1179728), (Object)"Clinical Trial Time Point ID");
        dict.put((Object)new Integer(1179729), (Object)"Clinical Trial Time Point Description");
        dict.put((Object)new Integer(1179744), (Object)"Clinical Trial Coordinating Center");
        dict.put((Object)new Integer(0x180010), (Object)"Contrast/Bolus Agent");
        dict.put((Object)new Integer(1572882), (Object)"Contrast/Bolus Agent Sequence");
        dict.put((Object)new Integer(1572884), (Object)"Contrast/Bolus Admin. Route Sequence");
        dict.put((Object)new Integer(1572885), (Object)"Body Part Examined");
        dict.put((Object)new Integer(1572896), (Object)"Scanning Sequence");
        dict.put((Object)new Integer(1572897), (Object)"Sequence Variant");
        dict.put((Object)new Integer(1572898), (Object)"Scan Options");
        dict.put((Object)new Integer(1572899), (Object)"MR Acquisition Type");
        dict.put((Object)new Integer(1572900), (Object)"Sequence Name");
        dict.put((Object)new Integer(1572901), (Object)"Angio Flag");
        dict.put((Object)new Integer(1572902), (Object)"Intervention Drug Information Sequence");
        dict.put((Object)new Integer(1572903), (Object)"Intervention Drug Stop Time");
        dict.put((Object)new Integer(1572904), (Object)"Intervention Drug Dose");
        dict.put((Object)new Integer(1572905), (Object)"Intervention Drug Sequence");
        dict.put((Object)new Integer(1572906), (Object)"Additional Drug Sequence");
        dict.put((Object)new Integer(1572913), (Object)"Radiopharmaceutical");
        dict.put((Object)new Integer(1572916), (Object)"Intervention Drug Name");
        dict.put((Object)new Integer(1572917), (Object)"Intervention Drug Start Time");
        dict.put((Object)new Integer(1572918), (Object)"Intervention Sequence");
        dict.put((Object)new Integer(1572920), (Object)"Intervention Status");
        dict.put((Object)new Integer(1572922), (Object)"Intervention Description");
        dict.put((Object)new Integer(1572928), (Object)"Cine Rate");
        dict.put((Object)new Integer(1572944), (Object)"Slice Thickness");
        dict.put((Object)new Integer(1572960), (Object)"KVP");
        dict.put((Object)new Integer(1572976), (Object)"Counts Accumulated");
        dict.put((Object)new Integer(1572977), (Object)"Acquisition Termination Condition");
        dict.put((Object)new Integer(1572978), (Object)"Effective Duration");
        dict.put((Object)new Integer(1572979), (Object)"Acquisition Start Condition");
        dict.put((Object)new Integer(1572980), (Object)"Acquisition Start Condition Data");
        dict.put((Object)new Integer(1572981), (Object)"Acquisition Termination Condition Data");
        dict.put((Object)new Integer(0x180080), (Object)"Repetition Time");
        dict.put((Object)new Integer(0x180081), (Object)"Echo Time");
        dict.put((Object)new Integer(1572994), (Object)"Inversion Time");
        dict.put((Object)new Integer(1572995), (Object)"Number of Averages");
        dict.put((Object)new Integer(1572996), (Object)"Imaging Frequency");
        dict.put((Object)new Integer(1572997), (Object)"Imaged Nucleus");
        dict.put((Object)new Integer(1572998), (Object)"Echo Number(s)");
        dict.put((Object)new Integer(1572999), (Object)"Magnetic Field Strength");
        dict.put((Object)new Integer(0x180088), (Object)"Spacing Between Slices");
        dict.put((Object)new Integer(1573001), (Object)"Number of Phase Encoding Steps");
        dict.put((Object)new Integer(1573008), (Object)"Data Collection Diameter");
        dict.put((Object)new Integer(1573009), (Object)"Echo Train Length");
        dict.put((Object)new Integer(1573011), (Object)"Percent Sampling");
        dict.put((Object)new Integer(1573012), (Object)"Percent Phase Field of View");
        dict.put((Object)new Integer(1573013), (Object)"Pixel Bandwidth");
        dict.put((Object)new Integer(0x181000), (Object)"Device Serial Number");
        dict.put((Object)new Integer(1576964), (Object)"Plate ID");
        dict.put((Object)new Integer(0x181010), (Object)"Secondary Capture Device ID");
        dict.put((Object)new Integer(0x181011), (Object)"Hardcopy Creation Device ID");
        dict.put((Object)new Integer(1576978), (Object)"Date of Secondary Capture");
        dict.put((Object)new Integer(1576980), (Object)"Time of Secondary Capture");
        dict.put((Object)new Integer(1576982), (Object)"Secondary Capture Device Manufacturer");
        dict.put((Object)new Integer(1576983), (Object)"Hardcopy Device Manufacturer");
        dict.put((Object)new Integer(0x181018), (Object)"Secondary Capture Device Model Name");
        dict.put((Object)new Integer(1576985), (Object)"Secondary Capture Device Software Version");
        dict.put((Object)new Integer(1576986), (Object)"Hardcopy Device Software Version");
        dict.put((Object)new Integer(1576987), (Object)"Hardcopy Device Model Name");
        dict.put((Object)new Integer(1576992), (Object)"Software Version(s)");
        dict.put((Object)new Integer(1576994), (Object)"Video Image Format Acquired");
        dict.put((Object)new Integer(1576995), (Object)"Digital Image Format Acquired");
        dict.put((Object)new Integer(1577008), (Object)"Protocol Name");
        dict.put((Object)new Integer(1577024), (Object)"Contrast/Bolus Route");
        dict.put((Object)new Integer(1577025), (Object)"Contrast/Bolus Volume");
        dict.put((Object)new Integer(1577026), (Object)"Contrast/Bolus Start Time");
        dict.put((Object)new Integer(1577027), (Object)"Contrast/Bolus Stop Time");
        dict.put((Object)new Integer(1577028), (Object)"Contrast/Bolus Total Dose");
        dict.put((Object)new Integer(1577029), (Object)"Syringe Counts");
        dict.put((Object)new Integer(1577030), (Object)"Contrast Flow Rate");
        dict.put((Object)new Integer(1577031), (Object)"Contrast Flow Duration");
        dict.put((Object)new Integer(1577032), (Object)"Contrast/Bolus Ingredient");
        dict.put((Object)new Integer(1577033), (Object)"Contrast Ingredient Concentration");
        dict.put((Object)new Integer(1577040), (Object)"Spatial Resolution");
        dict.put((Object)new Integer(1577056), (Object)"Trigger Time");
        dict.put((Object)new Integer(1577057), (Object)"Trigger Source or Type");
        dict.put((Object)new Integer(1577058), (Object)"Nominal Interval");
        dict.put((Object)new Integer(1577059), (Object)"Frame Time");
        dict.put((Object)new Integer(1577060), (Object)"Framing Type");
        dict.put((Object)new Integer(1577061), (Object)"Frame Time Vector");
        dict.put((Object)new Integer(1577062), (Object)"Frame Delay");
        dict.put((Object)new Integer(1577063), (Object)"Image Trigger Delay");
        dict.put((Object)new Integer(1577064), (Object)"Multiplex Group Time Offset");
        dict.put((Object)new Integer(1577065), (Object)"Trigger Time Offset");
        dict.put((Object)new Integer(1577066), (Object)"Synchronization Trigger");
        dict.put((Object)new Integer(1577068), (Object)"Synchronization Channel");
        dict.put((Object)new Integer(1577070), (Object)"Trigger Sample Position");
        dict.put((Object)new Integer(1577072), (Object)"Radiopharmaceutical Route");
        dict.put((Object)new Integer(1577073), (Object)"Radiopharmaceutical Volume");
        dict.put((Object)new Integer(1577074), (Object)"Radiopharmaceutical Start Time");
        dict.put((Object)new Integer(1577075), (Object)"Radiopharmaceutical Stop Time");
        dict.put((Object)new Integer(1577076), (Object)"Radionuclide Total Dose");
        dict.put((Object)new Integer(1577077), (Object)"Radionuclide Half Life");
        dict.put((Object)new Integer(1577078), (Object)"Radionuclide Positron Fraction");
        dict.put((Object)new Integer(1577079), (Object)"Radiopharmaceutical Specific Activity");
        dict.put((Object)new Integer(0x181080), (Object)"Beat Rejection Flag");
        dict.put((Object)new Integer(0x181081), (Object)"Low R-R Value");
        dict.put((Object)new Integer(1577090), (Object)"High R-R Value");
        dict.put((Object)new Integer(1577091), (Object)"Intervals Acquired");
        dict.put((Object)new Integer(1577092), (Object)"Intervals Rejected");
        dict.put((Object)new Integer(1577093), (Object)"PVC Rejection");
        dict.put((Object)new Integer(1577094), (Object)"Skip Beats");
        dict.put((Object)new Integer(0x181088), (Object)"Heart Rate");
        dict.put((Object)new Integer(1577104), (Object)"Cardiac Number of Images");
        dict.put((Object)new Integer(1577108), (Object)"Trigger Window");
        dict.put((Object)new Integer(0x181100), (Object)"Reconstruction Diameter");
        dict.put((Object)new Integer(0x181110), (Object)"Distance Source to Detector");
        dict.put((Object)new Integer(0x181111), (Object)"Distance Source to Patient");
        dict.put((Object)new Integer(0x181114), (Object)"Estimated Radiographic Mag. Factor");
        dict.put((Object)new Integer(1577248), (Object)"Gantry/Detector Tilt");
        dict.put((Object)new Integer(0x181121), (Object)"Gantry/Detector Skew");
        dict.put((Object)new Integer(1577264), (Object)"Table Height");
        dict.put((Object)new Integer(0x181131), (Object)"Table Traverse");
        dict.put((Object)new Integer(1577268), (Object)"Table Motion");
        dict.put((Object)new Integer(1577269), (Object)"Table Vertical Increment");
        dict.put((Object)new Integer(1577270), (Object)"Table Lateral Increment");
        dict.put((Object)new Integer(1577271), (Object)"Table Longitudinal Increment");
        dict.put((Object)new Integer(0x181138), (Object)"Table Angle");
        dict.put((Object)new Integer(1577274), (Object)"Table Type");
        dict.put((Object)new Integer(1577280), (Object)"Rotation Direction");
        dict.put((Object)new Integer(0x181141), (Object)"Angular Position");
        dict.put((Object)new Integer(1577282), (Object)"Radial Position");
        dict.put((Object)new Integer(1577283), (Object)"Scan Arc");
        dict.put((Object)new Integer(0x181144), (Object)"Angular Step");
        dict.put((Object)new Integer(1577285), (Object)"Center of Rotation Offset");
        dict.put((Object)new Integer(1577287), (Object)"Field of View Shape");
        dict.put((Object)new Integer(1577289), (Object)"Field of View Dimension(s)");
        dict.put((Object)new Integer(1577296), (Object)"Exposure Time");
        dict.put((Object)new Integer(0x181151), (Object)"X-ray Tube Current");
        dict.put((Object)new Integer(1577298), (Object)"Exposure");
        dict.put((Object)new Integer(1577299), (Object)"Exposure in uAs");
        dict.put((Object)new Integer(1577300), (Object)"Average Pulse Width");
        dict.put((Object)new Integer(0x181155), (Object)"Radiation Setting");
        dict.put((Object)new Integer(1577302), (Object)"Rectification Type");
        dict.put((Object)new Integer(1577306), (Object)"Radiation Mode");
        dict.put((Object)new Integer(1577310), (Object)"Image Area Dose Product");
        dict.put((Object)new Integer(1577312), (Object)"Filter Type");
        dict.put((Object)new Integer(0x181161), (Object)"Type of Filters");
        dict.put((Object)new Integer(1577314), (Object)"Intensifier Size");
        dict.put((Object)new Integer(1577316), (Object)"Imager Pixel Spacing");
        dict.put((Object)new Integer(0x181166), (Object)"Grid");
        dict.put((Object)new Integer(1577328), (Object)"Generator Power");
        dict.put((Object)new Integer(0x181180), (Object)"Collimator/Grid Name");
        dict.put((Object)new Integer(0x181181), (Object)"Collimator Type");
        dict.put((Object)new Integer(0x181182), (Object)"Focal Distance");
        dict.put((Object)new Integer(0x181183), (Object)"X Focus Center");
        dict.put((Object)new Integer(0x181184), (Object)"Y Focus Center");
        dict.put((Object)new Integer(1577360), (Object)"Focal Spot(s)");
        dict.put((Object)new Integer(0x181191), (Object)"Anode Target Material");
        dict.put((Object)new Integer(1577376), (Object)"Body Part Thickness");
        dict.put((Object)new Integer(1577378), (Object)"Compression Force");
        dict.put((Object)new Integer(1577472), (Object)"Date of Last Calibration");
        dict.put((Object)new Integer(1577473), (Object)"Time of Last Calibration");
        dict.put((Object)new Integer(1577488), (Object)"Convolution Kernel");
        dict.put((Object)new Integer(1577538), (Object)"Actual Frame Duration");
        dict.put((Object)new Integer(1577539), (Object)"Count Rate");
        dict.put((Object)new Integer(1577540), (Object)"Preferred Playback Sequencing");
        dict.put((Object)new Integer(1577552), (Object)"Receive Coil Name");
        dict.put((Object)new Integer(1577553), (Object)"Transmit Coil Name");
        dict.put((Object)new Integer(1577568), (Object)"Plate Type");
        dict.put((Object)new Integer(1577569), (Object)"Phosphor Type");
        dict.put((Object)new Integer(1577728), (Object)"Scan Velocity");
        dict.put((Object)new Integer(1577729), (Object)"Whole Body Technique");
        dict.put((Object)new Integer(1577730), (Object)"Scan Length");
        dict.put((Object)new Integer(1577744), (Object)"Acquisition Matrix");
        dict.put((Object)new Integer(1577746), (Object)"In-plane Phase Encoding Direction");
        dict.put((Object)new Integer(1577748), (Object)"Flip Angle");
        dict.put((Object)new Integer(1577749), (Object)"Variable Flip Angle Flag");
        dict.put((Object)new Integer(1577750), (Object)"SAR");
        dict.put((Object)new Integer(0x181318), (Object)"dB/dt");
        dict.put((Object)new Integer(1577984), (Object)"Acquisition Device Processing Descr.");
        dict.put((Object)new Integer(1577985), (Object)"Acquisition Device Processing Code");
        dict.put((Object)new Integer(1577986), (Object)"Cassette Orientation");
        dict.put((Object)new Integer(1577987), (Object)"Cassette Size");
        dict.put((Object)new Integer(1577988), (Object)"Exposures on Plate");
        dict.put((Object)new Integer(1577989), (Object)"Relative X-ray Exposure");
        dict.put((Object)new Integer(1578064), (Object)"Column Angulation");
        dict.put((Object)new Integer(1578080), (Object)"Tomo Layer Height");
        dict.put((Object)new Integer(1578096), (Object)"Tomo Angle");
        dict.put((Object)new Integer(1578112), (Object)"Tomo Time");
        dict.put((Object)new Integer(1578128), (Object)"Tomo Type");
        dict.put((Object)new Integer(1578129), (Object)"Tomo Class");
        dict.put((Object)new Integer(1578133), (Object)"Number of Tomosynthesis Source Images");
        dict.put((Object)new Integer(1578240), (Object)"Positioner Motion");
        dict.put((Object)new Integer(1578248), (Object)"Positioner Type");
        dict.put((Object)new Integer(1578256), (Object)"Positioner Primary Angle");
        dict.put((Object)new Integer(0x181511), (Object)"Positioner Secondary Angle");
        dict.put((Object)new Integer(1578272), (Object)"Positioner Primary Angle Increment");
        dict.put((Object)new Integer(1578273), (Object)"Positioner Secondary Angle Increment");
        dict.put((Object)new Integer(1578288), (Object)"Detector Primary Angle");
        dict.put((Object)new Integer(1578289), (Object)"Detector Secondary Angle");
        dict.put((Object)new Integer(1578496), (Object)"Shutter Shape");
        dict.put((Object)new Integer(1578498), (Object)"Shutter Left Vertical Edge");
        dict.put((Object)new Integer(1578500), (Object)"Shutter Right Vertical Edge");
        dict.put((Object)new Integer(1578502), (Object)"Shutter Upper Horizontal Edge");
        dict.put((Object)new Integer(1578504), (Object)"Shutter Lower Horizontal Edge");
        dict.put((Object)new Integer(1578512), (Object)"Center of Circular Shutter");
        dict.put((Object)new Integer(1578514), (Object)"Radius of Circular Shutter");
        dict.put((Object)new Integer(1578528), (Object)"Vertices of the Polygonal Shutter");
        dict.put((Object)new Integer(1578530), (Object)"Shutter Presentation Value");
        dict.put((Object)new Integer(1578531), (Object)"Shutter Overlay Group");
        dict.put((Object)new Integer(1578752), (Object)"Collimator Shape");
        dict.put((Object)new Integer(1578754), (Object)"Collimator Left Vertical Edge");
        dict.put((Object)new Integer(1578756), (Object)"Collimator Right Vertical Edge");
        dict.put((Object)new Integer(1578758), (Object)"Collimator Upper Horizontal Edge");
        dict.put((Object)new Integer(1578760), (Object)"Collimator Lower Horizontal Edge");
        dict.put((Object)new Integer(1578768), (Object)"Center of Circular Collimator");
        dict.put((Object)new Integer(1578770), (Object)"Radius of Circular Collimator");
        dict.put((Object)new Integer(1578784), (Object)"Vertices of the polygonal Collimator");
        dict.put((Object)new Integer(0x181800), (Object)"Acquisition Time Synchronized");
        dict.put((Object)new Integer(0x181801), (Object)"Time Source");
        dict.put((Object)new Integer(1579010), (Object)"Time Distribution Protocol");
        dict.put((Object)new Integer(1579011), (Object)"NTP Source Address");
        dict.put((Object)new Integer(1581057), (Object)"Page Number Vector");
        dict.put((Object)new Integer(1581058), (Object)"Frame Label Vector");
        dict.put((Object)new Integer(1581059), (Object)"Frame Primary Angle Vector");
        dict.put((Object)new Integer(1581060), (Object)"Frame Secondary Angle Vector");
        dict.put((Object)new Integer(1581061), (Object)"Slice Location Vector");
        dict.put((Object)new Integer(1581062), (Object)"Display Window Label Vector");
        dict.put((Object)new Integer(1581072), (Object)"Nominal Scanned Pixel Spacing");
        dict.put((Object)new Integer(1581088), (Object)"Digitizing Device Transport Direction");
        dict.put((Object)new Integer(1581104), (Object)"Rotation of Scanned Film");
        dict.put((Object)new Integer(1585408), (Object)"IVUS Acquisition");
        dict.put((Object)new Integer(1585409), (Object)"IVUS Pullback Rate");
        dict.put((Object)new Integer(1585410), (Object)"IVUS Gated Rate");
        dict.put((Object)new Integer(1585411), (Object)"IVUS Pullback Start Frame Number");
        dict.put((Object)new Integer(1585412), (Object)"IVUS Pullback Stop Frame Number");
        dict.put((Object)new Integer(1585413), (Object)"Lesion Number");
        dict.put((Object)new Integer(1593344), (Object)"Output Power");
        dict.put((Object)new Integer(1593360), (Object)"Transducer Data");
        dict.put((Object)new Integer(1593362), (Object)"Focus Depth");
        dict.put((Object)new Integer(1593376), (Object)"Processing Function");
        dict.put((Object)new Integer(1593377), (Object)"Postprocessing Fuction");
        dict.put((Object)new Integer(1593378), (Object)"Mechanical Index");
        dict.put((Object)new Integer(1593380), (Object)"Bone Thermal Index");
        dict.put((Object)new Integer(1593382), (Object)"Cranial Thermal Index");
        dict.put((Object)new Integer(1593383), (Object)"Soft Tissue Thermal Index");
        dict.put((Object)new Integer(1593384), (Object)"Soft Tissue-focus Thermal Index");
        dict.put((Object)new Integer(1593385), (Object)"Soft Tissue-surface Thermal Index");
        dict.put((Object)new Integer(1593424), (Object)"Depth of scan field");
        dict.put((Object)new Integer(1593600), (Object)"Patient Position");
        dict.put((Object)new Integer(1593601), (Object)"View Position");
        dict.put((Object)new Integer(1593604), (Object)"Projection Eponymous Name Code");
        dict.put((Object)new Integer(1597440), (Object)"Sensitivity");
        dict.put((Object)new Integer(1597457), (Object)"Sequence of Ultrasound Regions");
        dict.put((Object)new Integer(1597458), (Object)"Region Spatial Format");
        dict.put((Object)new Integer(1597460), (Object)"Region Data Type");
        dict.put((Object)new Integer(1597462), (Object)"Region Flags");
        dict.put((Object)new Integer(1597464), (Object)"Region Location Min X0");
        dict.put((Object)new Integer(1597466), (Object)"Region Location Min Y0");
        dict.put((Object)new Integer(1597468), (Object)"Region Location Max X1");
        dict.put((Object)new Integer(1597470), (Object)"Region Location Max Y1");
        dict.put((Object)new Integer(1597472), (Object)"Reference Pixel X0");
        dict.put((Object)new Integer(1597474), (Object)"Reference Pixel Y0");
        dict.put((Object)new Integer(1597476), (Object)"Physical Units X Direction");
        dict.put((Object)new Integer(1597478), (Object)"Physical Units Y Direction");
        dict.put((Object)new Integer(1597480), (Object)"Reference Pixel Physical Value X");
        dict.put((Object)new Integer(1597482), (Object)"Reference Pixel Physical Value Y");
        dict.put((Object)new Integer(1597484), (Object)"Physical Delta X");
        dict.put((Object)new Integer(1597486), (Object)"Physical Delta Y");
        dict.put((Object)new Integer(1597488), (Object)"Transducer Frequency");
        dict.put((Object)new Integer(1597489), (Object)"Transducer Type");
        dict.put((Object)new Integer(1597490), (Object)"Pulse Repetition Frequency");
        dict.put((Object)new Integer(1597492), (Object)"Doppler Correction Angle");
        dict.put((Object)new Integer(1597494), (Object)"Steering Angle");
        dict.put((Object)new Integer(1597497), (Object)"Doppler Sample Volume X Position");
        dict.put((Object)new Integer(1597499), (Object)"Doppler Sample Volume Y Position");
        dict.put((Object)new Integer(1597501), (Object)"TM-Line Position X0");
        dict.put((Object)new Integer(1597503), (Object)"TM-Line Position Y0");
        dict.put((Object)new Integer(1597505), (Object)"TM-Line Position X1");
        dict.put((Object)new Integer(1597507), (Object)"TM-Line Position Y1");
        dict.put((Object)new Integer(1597508), (Object)"Pixel Component Organization");
        dict.put((Object)new Integer(1597510), (Object)"Pixel Component Mask");
        dict.put((Object)new Integer(1597512), (Object)"Pixel Component Range Start");
        dict.put((Object)new Integer(1597514), (Object)"Pixel Component Range Stop");
        dict.put((Object)new Integer(1597516), (Object)"Pixel Component Physical Units");
        dict.put((Object)new Integer(1597518), (Object)"Pixel Component Data Type");
        dict.put((Object)new Integer(1597520), (Object)"Number of Table Break Points");
        dict.put((Object)new Integer(1597522), (Object)"Table of X Break Points");
        dict.put((Object)new Integer(1597524), (Object)"Table of Y Break Points");
        dict.put((Object)new Integer(1597526), (Object)"Number of Table Entries");
        dict.put((Object)new Integer(1597528), (Object)"Table of Pixel Values");
        dict.put((Object)new Integer(1597530), (Object)"Table of Parameter Values");
        dict.put((Object)new Integer(1597536), (Object)"R Wave Time Vector");
        dict.put((Object)new Integer(1601536), (Object)"Detector Conditions Nominal Flag");
        dict.put((Object)new Integer(1601537), (Object)"Detector Temperature");
        dict.put((Object)new Integer(1601540), (Object)"Detector Type");
        dict.put((Object)new Integer(1601541), (Object)"Detector Configuration");
        dict.put((Object)new Integer(1601542), (Object)"Detector Description");
        dict.put((Object)new Integer(1601544), (Object)"Detector Mode");
        dict.put((Object)new Integer(1601546), (Object)"Detector ID");
        dict.put((Object)new Integer(1601548), (Object)"Date of Last Detector Calibration");
        dict.put((Object)new Integer(1601550), (Object)"Time of Last Detector Calibration");
        dict.put((Object)new Integer(1601554), (Object)"Detector Time Since Last Exposure");
        dict.put((Object)new Integer(1601556), (Object)"Detector Active Time");
        dict.put((Object)new Integer(1601558), (Object)"Detector Activation Offset");
        dict.put((Object)new Integer(1601562), (Object)"Detector Binning");
        dict.put((Object)new Integer(1601568), (Object)"Detector Element Physical Size");
        dict.put((Object)new Integer(1601570), (Object)"Detector Element Spacing");
        dict.put((Object)new Integer(1601572), (Object)"Detector Active Shape");
        dict.put((Object)new Integer(1601574), (Object)"Detector Active Dimension(s)");
        dict.put((Object)new Integer(1601576), (Object)"Detector Active Origin");
        dict.put((Object)new Integer(1601578), (Object)"Detector Manufacturer Name");
        dict.put((Object)new Integer(1601579), (Object)"Detector Model Name");
        dict.put((Object)new Integer(1601584), (Object)"Field of View Origin");
        dict.put((Object)new Integer(1601586), (Object)"Field of View Rotation");
        dict.put((Object)new Integer(1601588), (Object)"Field of View Horizontal Flip");
        dict.put((Object)new Integer(1601600), (Object)"Grid Absorbing Material");
        dict.put((Object)new Integer(1601601), (Object)"Grid Spacing Material");
        dict.put((Object)new Integer(1601602), (Object)"Grid Thickness");
        dict.put((Object)new Integer(1601604), (Object)"Grid Pitch");
        dict.put((Object)new Integer(1601606), (Object)"Grid Aspect Ratio");
        dict.put((Object)new Integer(1601608), (Object)"Grid Period");
        dict.put((Object)new Integer(1601612), (Object)"Grid Focal Distance");
        dict.put((Object)new Integer(1601616), (Object)"Filter Material");
        dict.put((Object)new Integer(1601618), (Object)"Filter Thickness Min");
        dict.put((Object)new Integer(1601620), (Object)"Filter Thickness Max");
        dict.put((Object)new Integer(1601632), (Object)"Exposure Control Mode");
        dict.put((Object)new Integer(0x20000D), (Object)"Study Instance UID");
        dict.put((Object)new Integer(0x20000E), (Object)"Series Instance UID");
        dict.put((Object)new Integer(0x200011), (Object)"Series Number");
        dict.put((Object)new Integer(0x200012), (Object)"Acquisition Number");
        dict.put((Object)new Integer(2097171), (Object)"Instance Number");
        dict.put((Object)new Integer(0x200020), (Object)"Patient Orientation");
        dict.put((Object)new Integer(0x200030), (Object)"Image Position");
        dict.put((Object)new Integer(0x200032), (Object)"Image Position (Patient)");
        dict.put((Object)new Integer(2097207), (Object)"Image Orientation (Patient)");
        dict.put((Object)new Integer(0x200050), (Object)"Location");
        dict.put((Object)new Integer(0x200052), (Object)"Frame of Reference UID");
        dict.put((Object)new Integer(0x200070), (Object)"Image Geometry Type");
        dict.put((Object)new Integer(0x201001), (Object)"Acquisitions in Series");
        dict.put((Object)new Integer(0x201020), (Object)"Reference");
        dict.put((Object)new Integer(2101313), (Object)"Slice Location");
        dict.put((Object)new Integer(0x280002), (Object)"Samples per pixel");
        dict.put((Object)new Integer(2621443), (Object)"Samples per pixel used");
        dict.put((Object)new Integer(2621444), (Object)"Photometric Interpretation");
        dict.put((Object)new Integer(2621446), (Object)"Planar Configuration");
        dict.put((Object)new Integer(0x280008), (Object)"Number of frames");
        dict.put((Object)new Integer(2621449), (Object)"Frame Increment Pointer");
        dict.put((Object)new Integer(2621450), (Object)"Frame Dimension Pointer");
        dict.put((Object)new Integer(2621456), (Object)"Rows");
        dict.put((Object)new Integer(2621457), (Object)"Columns");
        dict.put((Object)new Integer(2621458), (Object)"Planes");
        dict.put((Object)new Integer(2621460), (Object)"Ultrasound Color Data Present");
        dict.put((Object)new Integer(2621488), (Object)"Pixel Spacing");
        dict.put((Object)new Integer(2621489), (Object)"Zoom Factor");
        dict.put((Object)new Integer(2621490), (Object)"Zoom Center");
        dict.put((Object)new Integer(2621492), (Object)"Pixel Aspect Ratio");
        dict.put((Object)new Integer(2621521), (Object)"Corrected Image");
        dict.put((Object)new Integer(2621696), (Object)"Bits Allocated");
        dict.put((Object)new Integer(2621697), (Object)"Bits Stored");
        dict.put((Object)new Integer(2621698), (Object)"High Bit");
        dict.put((Object)new Integer(2621699), (Object)"Pixel Representation");
        dict.put((Object)new Integer(2621702), (Object)"Smallest Image Pixel Value");
        dict.put((Object)new Integer(2621703), (Object)"Largest Image Pixel Value");
        dict.put((Object)new Integer(2621704), (Object)"Smallest Pixel Value in Series");
        dict.put((Object)new Integer(2621705), (Object)"Largest Pixel Value in Series");
        dict.put((Object)new Integer(2621712), (Object)"Smallest Image Pixel Value in Plane");
        dict.put((Object)new Integer(2621713), (Object)"Largest Image Pixel Value in Plane");
        dict.put((Object)new Integer(2621728), (Object)"Pixel Padding Value");
        dict.put((Object)new Integer(2622208), (Object)"Quality Control Image");
        dict.put((Object)new Integer(2622209), (Object)"Burned in Annotation");
        dict.put((Object)new Integer(2625600), (Object)"Pixel Intensity Relationship");
        dict.put((Object)new Integer(2625601), (Object)"Pixel Intensity Relationship Sign");
        dict.put((Object)new Integer(2625616), (Object)"Window Center");
        dict.put((Object)new Integer(2625617), (Object)"Window Width");
        dict.put((Object)new Integer(2625618), (Object)"Rescale Intercept");
        dict.put((Object)new Integer(2625619), (Object)"Rescale Slope");
        dict.put((Object)new Integer(2625620), (Object)"Rescale Type");
        dict.put((Object)new Integer(2625621), (Object)"Window Center and Width Explanation");
        dict.put((Object)new Integer(2625680), (Object)"Recommended Viewing Mode");
        dict.put((Object)new Integer(2625793), (Object)"Red Palette Color LUT Descriptor");
        dict.put((Object)new Integer(2625794), (Object)"Green Palette Color LUT Descriptor");
        dict.put((Object)new Integer(2625795), (Object)"Blue Palette Color LUT Descriptor");
        dict.put((Object)new Integer(2625945), (Object)"Palette Color LUT UID");
        dict.put((Object)new Integer(2626049), (Object)"Red Palette Color LUT Data");
        dict.put((Object)new Integer(2626050), (Object)"Green Palette Color LUT Data");
        dict.put((Object)new Integer(2626051), (Object)"Blue Palette Color LUT Data");
        dict.put((Object)new Integer(0x281221), (Object)"Segmented Red Palette Color LUT Data");
        dict.put((Object)new Integer(0x281222), (Object)"Segmented Green Palette Color LUT Data");
        dict.put((Object)new Integer(2626083), (Object)"Segmented Blue Palette Color LUT Data");
        dict.put((Object)new Integer(2626304), (Object)"Implant Present");
        dict.put((Object)new Integer(2626384), (Object)"Partial View");
        dict.put((Object)new Integer(2626385), (Object)"Partial View Description");
        dict.put((Object)new Integer(2629904), (Object)"Lossy Image Compression");
        dict.put((Object)new Integer(0x282112), (Object)"Lossy Image Compression Ratio");
        dict.put((Object)new Integer(2629908), (Object)"Lossy Image Compression Method");
        dict.put((Object)new Integer(2633728), (Object)"Modality LUT Sequence");
        dict.put((Object)new Integer(2633730), (Object)"LUT Descriptor");
        dict.put((Object)new Integer(2633731), (Object)"LUT Explanation");
        dict.put((Object)new Integer(2633732), (Object)"Modality LUT Type");
        dict.put((Object)new Integer(2633734), (Object)"LUT Data");
        dict.put((Object)new Integer(2633744), (Object)"VOI LUT Sequence");
        dict.put((Object)new Integer(2634000), (Object)"Softcopy VOI LUT Sequence");
        dict.put((Object)new Integer(2641920), (Object)"Bi-Plane Acquisition Sequence");
        dict.put((Object)new Integer(2646032), (Object)"Representative Frame Number");
        dict.put((Object)new Integer(2646048), (Object)"Frame Numbers of Interest (FOI)");
        dict.put((Object)new Integer(2646050), (Object)"Frame(s) of Interest Description");
        dict.put((Object)new Integer(2646051), (Object)"Frame of Interest Type");
        dict.put((Object)new Integer(2646080), (Object)"R Wave Pointer");
        dict.put((Object)new Integer(2646272), (Object)"Mask Subtraction Sequence");
        dict.put((Object)new Integer(2646273), (Object)"Mask Operation");
        dict.put((Object)new Integer(2646274), (Object)"Applicable Frame Range");
        dict.put((Object)new Integer(2646288), (Object)"Mask Frame Numbers");
        dict.put((Object)new Integer(2646290), (Object)"Contrast Frame Averaging");
        dict.put((Object)new Integer(2646292), (Object)"Mask Sub-pixel Shift");
        dict.put((Object)new Integer(2646304), (Object)"TID Offset");
        dict.put((Object)new Integer(2646416), (Object)"Mask Operation Explanation");
        dict.put((Object)new Integer(2658305), (Object)"Data Point Rows");
        dict.put((Object)new Integer(2658306), (Object)"Data Point Columns");
        dict.put((Object)new Integer(2658307), (Object)"Signal Domain Columns");
        dict.put((Object)new Integer(2658568), (Object)"Data Representation");
        dict.put((Object)new Integer(2658576), (Object)"Pixel Measures Sequence");
        dict.put((Object)new Integer(2658610), (Object)"Frame VOI LUT Sequence");
        dict.put((Object)new Integer(2658629), (Object)"Pixel Value Transformation Sequence");
        dict.put((Object)new Integer(2658869), (Object)"Signal Domain Rows");
        dict.put((Object)new Integer(5505041), (Object)"Number of Energy Windows");
        dict.put((Object)new Integer(5505057), (Object)"Number of Detectors");
        dict.put((Object)new Integer(5505105), (Object)"Number of Rotations");
        dict.put((Object)new Integer(5505152), (Object)"Slice Vector");
        dict.put((Object)new Integer(5505153), (Object)"Number of Slices");
        dict.put((Object)new Integer(5505538), (Object)"Type of Detector Motion");
        dict.put((Object)new Integer(0x540400), (Object)"Image ID");
        dict.put((Object)new Integer(0x20100100), (Object)"Border Density");
        return dict.build();
    }
}

