/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.utils;

import eu.kliegr.ac1.GenerateCSVHeaderConfig;
import eu.kliegr.ac1.rule.parsers.GUHASimplifiedParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenerateCSVHeader {
    private static final Logger LOGGER = Logger.getLogger(GUHASimplifiedParser.class.getName());

    public static void generateCSVHeader(GenerateCSVHeaderConfig config) throws FileNotFoundException, IOException {
        PrintStream outputFile = new PrintStream(new FileOutputStream(config.getOutputPath()));
        LOGGER.log(Level.INFO, "Reading input from {0}", config.getInputPath());
        BufferedReader in = new BufferedReader(new FileReader(new File(config.getInputPath())));
        int lineNumber = 0;
        StringBuilder firstLine = new StringBuilder();
        String line = in.readLine();
        while (line != null) {
            String outLine;
            if (lineNumber == 0) {
                String[] cols = line.split(config.getSeparator());
                for (int i = 0; i < cols.length; ++i) {
                    if (i == 0 && config.IsGenerateID().booleanValue()) {
                        firstLine.append("ID,");
                    }
                    if (i == cols.length - 1) {
                        firstLine.append("XClass");
                        continue;
                    }
                    firstLine.append("c").append(i).append(",");
                }
                outLine = firstLine.toString();
            } else {
                outLine = config.IsGenerateID() != false ? lineNumber + config.getSeparator() + line : line;
            }
            ++lineNumber;
            outputFile.println(outLine);
            line = in.readLine();
        }
        LOGGER.log(Level.INFO, "Written output to {0}", config.getOutputPath());
        outputFile.close();
    }

    private GenerateCSVHeader() {
    }
}

