/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;
import multidendrograms.core.utils.MathUtils;
import multidendrograms.core.utils.SmartAxis;
import multidendrograms.types.BandHeight;
import multidendrograms.types.OriginType;
import multidendrograms.utils.NumberUtils;

public class UltrametricMatrix {
    private int precision;
    private String[] labels;
    private Hashtable<String, Integer> hashLabels;
    private SymmetricMatrix ultraMatrix;

    public UltrametricMatrix(Dendrogram dendrogram, String[] stringArray, OriginType originType, BandHeight bandHeight) {
        this.precision = dendrogram.precision;
        this.labels = stringArray;
        this.hashLabels = this.getSorting(stringArray);
        boolean bl = originType.equals((Object)OriginType.UNIFORM_ORIGIN);
        boolean bl2 = bandHeight.equals((Object)BandHeight.BAND_BOTTOM);
        SmartAxis smartAxis = new SmartAxis(dendrogram, bl);
        double d = dendrogram.isDistanceBased ? smartAxis.smartMin() : smartAxis.smartMax();
        this.ultraMatrix = new SymmetricMatrix(dendrogram.numberOfLeaves());
        this.calculateUltrametricMatrix(dendrogram, d, bl, bl2);
    }

    private Hashtable<String, Integer> getSorting(String[] stringArray) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], i);
        }
        return hashtable;
    }

    private void calculateUltrametricMatrix(Dendrogram dendrogram, double d, boolean bl, boolean bl2) {
        int n = dendrogram.numberOfSubclusters();
        if (n == 1) {
            double d2 = dendrogram.getRootBottomHeight();
            double d3 = Double.isNaN(d2) || bl ? MathUtils.round(d, this.precision) : MathUtils.round(d2, this.precision);
            int n2 = this.hashLabels.get(dendrogram.getLabel());
            this.ultraMatrix.setElement(n2, n2, d3);
        } else {
            int n3;
            double d4 = bl2 ? dendrogram.getRootBottomHeight() : dendrogram.getRootInternalHeight();
            d4 = MathUtils.round(d4, this.precision);
            int n4 = dendrogram.numberOfLeaves();
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                Dendrogram dendrogram2 = dendrogram.getLeaf(n3);
                int n5 = this.hashLabels.get(dendrogram2.getLabel());
                for (int i = n3 + 1; i < n4; ++i) {
                    Dendrogram dendrogram3 = dendrogram.getLeaf(i);
                    int n6 = this.hashLabels.get(dendrogram3.getLabel());
                    this.ultraMatrix.setElement(n5, n6, d4);
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                this.calculateUltrametricMatrix(dendrogram.getSubcluster(n3), d, bl, bl2);
            }
        }
    }

    public SymmetricMatrix getMatrix() {
        return this.ultraMatrix;
    }

    public void saveAsTxt(String string) throws IOException {
        int n;
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        String string2 = "";
        for (n = 0; n < this.labels.length; ++n) {
            string2 = string2 + this.labels[n] + "\t";
        }
        printWriter.println(string2);
        for (n = 0; n < this.ultraMatrix.numberOfRows(); ++n) {
            string2 = "";
            for (int i = 0; i < this.ultraMatrix.numberOfRows(); ++i) {
                double d = this.ultraMatrix.getElement(n, i);
                string2 = string2 + NumberUtils.format(d, this.precision);
                string2 = string2 + "\t";
            }
            printWriter.println(string2);
        }
        printWriter.close();
    }
}

