/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.Geost_Constraint;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistGeq;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistLeq;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistLinear;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.externalConstraints.NonOverlapping;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.geost.GeostOptions;
import choco.kernel.model.constraints.geost.externalConstraints.DistGeqModel;
import choco.kernel.model.constraints.geost.externalConstraints.DistLeqModel;
import choco.kernel.model.constraints.geost.externalConstraints.DistLinearModel;
import choco.kernel.model.constraints.geost.externalConstraints.IExternalConstraint;
import choco.kernel.model.constraints.geost.externalConstraints.NonOverlappingModel;
import choco.kernel.model.variables.geost.GeostObject;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import java.util.ArrayList;
import java.util.List;

public final class GeostManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Object[]) {
            Object[] params = (Object[])parameters;
            int dim = (Integer)params[0];
            List shiftedBoxes = (List)params[1];
            List ectr = (List)params[2];
            List vgo = (List)params[3];
            List ctrlVs = (List)params[4];
            GeostOptions opt = (GeostOptions)params[5];
            if (opt == null) {
                opt = new GeostOptions();
            }
            ArrayList<Obj> vo = new ArrayList<Obj>(vgo.size());
            for (int i = 0; i < vgo.size(); ++i) {
                GeostObject g = (GeostObject)vgo.get(i);
                vo.add(i, new Obj(g.getDim(), g.getObjectId(), solver.getVar(g.getShapeId()), solver.getVar(g.getCoordinates()), solver.getVar(g.getStartTime()), solver.getVar(g.getDurationTime()), solver.getVar(g.getEndTime()), g.getRadius()));
            }
            ArrayList<ExternalConstraint> ectrs = new ArrayList<ExternalConstraint>();
            for (IExternalConstraint iectr : ectr) {
                IExternalConstraint ctr;
                if (iectr instanceof DistLeqModel) {
                    DistLeqModel dlm = (DistLeqModel)iectr;
                    if (dlm.hasDistanceVar()) {
                        ectrs.add(new DistLeq(dlm.getEctrID(), dlm.getDim(), dlm.getObjectIds(), dlm.D, dlm.q, solver.getVar(dlm.getDistanceVar())));
                    } else {
                        ectrs.add(new DistLeq(dlm.getEctrID(), dlm.getDim(), dlm.getObjectIds(), dlm.D, dlm.q));
                    }
                }
                if (iectr instanceof DistGeqModel) {
                    DistGeqModel dgm = (DistGeqModel)iectr;
                    if (dgm.hasDistanceVar()) {
                        ectrs.add(new DistGeq(dgm.getEctrID(), dgm.getDim(), dgm.getObjectIds(), dgm.D, dgm.q, solver.getVar(dgm.getDistanceVar())));
                    } else {
                        ectrs.add(new DistGeq(dgm.getEctrID(), dgm.getDim(), dgm.getObjectIds(), dgm.D, dgm.q));
                    }
                }
                if (iectr instanceof NonOverlappingModel) {
                    ctr = (NonOverlappingModel)iectr;
                    ectrs.add(new NonOverlapping(ctr.getEctrID(), ctr.getDim(), ctr.getObjectIds()));
                }
                if (!(iectr instanceof DistLinearModel)) continue;
                ctr = (DistLinearModel)iectr;
                ectrs.add(new DistLinear(ctr.getEctrID(), ctr.getDim(), ctr.getObjectIds(), ((DistLinearModel)ctr).a, ((DistLinearModel)ctr).b));
            }
            if (ctrlVs == null) {
                return new Geost_Constraint(solver.getVar(variables), dim, vo, shiftedBoxes, ectrs, false, opt.included, solver);
            }
            return new Geost_Constraint(solver.getVar(variables), dim, vo, shiftedBoxes, ectrs, ctrlVs, GeostOptions.memoisation, opt.included, GeostOptions.increment, solver);
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }
}

