/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.inference.BruteForceInferencer;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.CPT;
import cc.mallet.grmm.types.DirectedModel;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.Factors;
import cc.mallet.grmm.types.LogTableFactor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.Variable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestDirectedModel
extends TestCase {
    private CPT pA;
    private CPT pB;
    private CPT pC;
    private DiscreteFactor fA;
    private DiscreteFactor fB;
    private DiscreteFactor fC;
    private Variable[] vars;
    private Variable A = new Variable(2);
    private Variable B = new Variable(2);
    private Variable C = new Variable(2);

    public TestDirectedModel(String name) {
        super(name);
        this.vars = new Variable[]{this.A, this.B, this.C};
        this.fA = LogTableFactor.makeFromValues(this.A, new double[]{1.0, 4.0});
        this.fB = LogTableFactor.makeFromValues(this.B, new double[]{3.0, 2.0});
        double[] vals = new double[]{3.0, 7.0, 5.0, 5.0, 9.0, 1.0, 6.0, 4.0};
        this.fC = new TableFactor(this.vars, vals);
        this.pA = Factors.normalizeAsCpt((AbstractTableFactor)this.fA.duplicate(), this.A);
        this.pB = Factors.normalizeAsCpt((AbstractTableFactor)this.fB.duplicate(), this.B);
        this.pC = Factors.normalizeAsCpt((AbstractTableFactor)this.fC.duplicate(), this.C);
    }

    public void testSimpleModel() {
        FactorGraph fg1 = new FactorGraph(this.vars);
        fg1.addFactor(this.pA);
        fg1.addFactor(this.pB);
        fg1.addFactor(this.fC);
        DirectedModel dm = new DirectedModel(this.vars);
        dm.addFactor(this.pA);
        dm.addFactor(this.pB);
        dm.addFactor(this.pC);
        BruteForceInferencer inf = new BruteForceInferencer();
        DiscreteFactor joint1 = (DiscreteFactor)inf.joint(fg1);
        DiscreteFactor joint2 = (DiscreteFactor)inf.joint(dm);
        this.comparePotentials(joint1, joint2);
    }

    private void comparePotentials(DiscreteFactor fActual, DiscreteFactor fExpected) {
        double[] actual = fActual.toValueArray();
        double[] expected = fExpected.toValueArray();
        TestDirectedModel.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            TestDirectedModel.assertEquals((double)expected[i], (double)actual[i], (double)0.001);
        }
    }

    public void testCycleChecking() {
        TableFactor f1;
        DirectedModel dm = new DirectedModel(this.vars);
        dm.addFactor(this.pA);
        dm.addFactor(this.pB);
        dm.addFactor(this.pC);
        try {
            f1 = new TableFactor(new Variable[]{this.B, this.C});
            dm.addFactor(new CPT(f1, this.B));
            TestDirectedModel.assertTrue((String)"Test failed: No exception thrown.", (boolean)false);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            f1 = new TableFactor(new Variable[]{this.A, this.C});
            dm.addFactor(new CPT(f1, this.A));
            TestDirectedModel.assertTrue((String)"Test failed: No exception thrown.", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCptOfVar() {
        DirectedModel dm = new DirectedModel(this.vars);
        dm.addFactor(this.pA);
        dm.addFactor(this.pB);
        dm.addFactor(this.pC);
        TestDirectedModel.assertTrue((this.pA == dm.getCptofVar(this.A) ? 1 : 0) != 0);
        TestDirectedModel.assertTrue((this.pB == dm.getCptofVar(this.B) ? 1 : 0) != 0);
        TestDirectedModel.assertTrue((this.pC == dm.getCptofVar(this.C) ? 1 : 0) != 0);
    }

    public void testFactorReplace() {
        DirectedModel dm = new DirectedModel(this.vars);
        dm.addFactor(this.pA);
        dm.addFactor(this.pB);
        dm.addFactor(this.pC);
        TestDirectedModel.assertEquals((int)3, (int)dm.factors().size());
        TableFactor f1 = new TableFactor(new Variable[]{this.B, this.C});
        CPT p1 = new CPT(f1, this.C);
        try {
            dm.addFactor(p1);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public static Test suite() {
        return new TestSuite(TestDirectedModel.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestDirectedModel(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestDirectedModel.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

