/*
 * Decompiled with CFR 0.152.
 */
package org.fgilbert.jdx;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Utility {
    public static List<Object> createList(Object[] objects) {
        ArrayList<Object> lst = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            lst.add(objects[i]);
            ++i;
        }
        return lst;
    }

    public static List<Map<String, Object>> createListOfRecords(String[] columnNames, Object[] columns) {
        int rows = 0;
        if (columns.length > 0) {
            rows = Array.getLength(columns[0]);
        }
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>(rows);
        int i = 0;
        while (i < rows) {
            lst.add(new LinkedHashMap(columns.length));
            ++i;
        }
        i = 0;
        while (i < columns.length) {
            int j;
            Object[] a;
            Class<?> ct = columns[i].getClass().getComponentType();
            String name = columnNames[i];
            if (ct.equals(Double.TYPE)) {
                a = (double[])columns[i];
                j = 0;
                while (j < rows) {
                    ((Map)lst.get(j)).put(name, a[j]);
                    ++j;
                }
            } else if (ct.equals(String.class)) {
                a = (String[])columns[i];
                j = 0;
                while (j < rows) {
                    ((Map)lst.get(j)).put(name, a[j]);
                    ++j;
                }
            } else if (ct.equals(Integer.TYPE)) {
                a = (int[])columns[i];
                j = 0;
                while (j < rows) {
                    ((Map)lst.get(j)).put(name, (int)a[j]);
                    ++j;
                }
            } else if (ct.equals(Boolean.TYPE)) {
                a = (boolean[])columns[i];
                j = 0;
                while (j < rows) {
                    ((Map)lst.get(j)).put(name, (boolean)a[j]);
                    ++j;
                }
            } else if (ct.equals(Byte.TYPE)) {
                a = (byte[])columns[i];
                j = 0;
                while (j < rows) {
                    ((Map)lst.get(j)).put(name, (byte)a[j]);
                    ++j;
                }
            } else {
                throw new RuntimeException(String.format("'%s' is not a supported column type.", ct.getName()));
            }
            ++i;
        }
        return lst;
    }

    public static Map<String, Object> createMap(String[] names, Object[] objects) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(names.length, 1.0f);
        int i = 0;
        while (i < names.length) {
            m.put(names[i], objects[i]);
            ++i;
        }
        return m;
    }

    public static Object createNdimensionalArrayColumnMajor(boolean[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Boolean.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            boolean[] subarray = (boolean[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex++];
                ++j2;
            }
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMajor(byte[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Byte.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            byte[] subarray = (byte[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex++];
                ++j2;
            }
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMajor(double[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Double.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            double[] subarray = (double[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex++];
                ++j2;
            }
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMajor(int[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Integer.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            int[] subarray = (int[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex++];
                ++j2;
            }
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMajor(String[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(String.class, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            String[] subarray = (String[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex++];
                ++j2;
            }
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMinor(boolean[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Boolean.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int rowCount = dimensions[dimensions.length - 2];
        int columnCount = dimensions[dimensions.length - 1];
        int matrixIndex = 0;
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            boolean[] subarray = (boolean[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < columnCount) {
                subarray[j2] = data[currentDataIndex + rowCount * j2];
                ++j2;
            }
            currentDataIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentDataIndex;
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMinor(byte[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Byte.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int rowCount = dimensions[dimensions.length - 2];
        int columnCount = dimensions[dimensions.length - 1];
        int matrixIndex = 0;
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            byte[] subarray = (byte[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < columnCount) {
                subarray[j2] = data[currentDataIndex + rowCount * j2];
                ++j2;
            }
            currentDataIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentDataIndex;
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMinor(double[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Double.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int rowCount = dimensions[dimensions.length - 2];
        int columnCount = dimensions[dimensions.length - 1];
        int matrixIndex = 0;
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            double[] subarray = (double[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < columnCount) {
                subarray[j2] = data[currentDataIndex + rowCount * j2];
                ++j2;
            }
            currentDataIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentDataIndex;
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMinor(int[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Integer.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int rowCount = dimensions[dimensions.length - 2];
        int columnCount = dimensions[dimensions.length - 1];
        int matrixIndex = 0;
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            int[] subarray = (int[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < columnCount) {
                subarray[j2] = data[currentDataIndex + rowCount * j2];
                ++j2;
            }
            currentDataIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentDataIndex;
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayColumnMinor(String[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(String.class, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int rowCount = dimensions[dimensions.length - 2];
        int columnCount = dimensions[dimensions.length - 1];
        int matrixIndex = 0;
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            String[] subarray = (String[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < columnCount) {
                subarray[j2] = data[currentDataIndex + rowCount * j2];
                ++j2;
            }
            currentDataIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentDataIndex;
            j2 = currentSubarrayIndex.length - 1;
            while (j2 > -1) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                --j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayRowMajor(boolean[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Boolean.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            boolean[] subarray = (boolean[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex + subarrayCount * j2];
                ++j2;
            }
            ++currentDataIndex;
            j2 = 0;
            while (j2 < currentSubarrayIndex.length) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                ++j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayRowMajor(byte[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Byte.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            byte[] subarray = (byte[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex + subarrayCount * j2];
                ++j2;
            }
            ++currentDataIndex;
            j2 = 0;
            while (j2 < currentSubarrayIndex.length) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                ++j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayRowMajor(double[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Double.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            double[] subarray = (double[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex + subarrayCount * j2];
                ++j2;
            }
            ++currentDataIndex;
            j2 = 0;
            while (j2 < currentSubarrayIndex.length) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                ++j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayRowMajor(int[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(Integer.TYPE, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            int[] subarray = (int[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex + subarrayCount * j2];
                ++j2;
            }
            ++currentDataIndex;
            j2 = 0;
            while (j2 < currentSubarrayIndex.length) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                ++j2;
            }
            ++i2;
        }
        return array;
    }

    public static Object createNdimensionalArrayRowMajor(String[] data, int[] dimensions) {
        if (dimensions.length == 1) {
            return Arrays.copyOfRange(data, 0, dimensions[0]);
        }
        Object[] array = (Object[])Array.newInstance(String.class, dimensions);
        int subarrayCount = dimensions[0];
        int i = 1;
        while (i < dimensions.length - 1) {
            subarrayCount *= dimensions[i];
            ++i;
        }
        int subarrayLength = dimensions[dimensions.length - 1];
        int currentDataIndex = 0;
        int[] currentSubarrayIndex = new int[dimensions.length - 1];
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = array;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            String[] subarray = (String[])Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]);
            int j2 = 0;
            while (j2 < subarrayLength) {
                subarray[j2] = data[currentDataIndex + subarrayCount * j2];
                ++j2;
            }
            ++currentDataIndex;
            j2 = 0;
            while (j2 < currentSubarrayIndex.length) {
                if (currentSubarrayIndex[j2] < dimensions[j2] - 1) {
                    int n = j2;
                    currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                    break;
                }
                currentSubarrayIndex[j2] = 0;
                ++j2;
            }
            ++i2;
        }
        return array;
    }

    public static List<Object> deepAsList(Object array) {
        int arrayLength = Array.getLength(array);
        ArrayList<Object> al = new ArrayList<Object>(arrayLength);
        if (array.getClass().getComponentType().isArray()) {
            int i = 0;
            while (i < arrayLength) {
                Object element = Array.get(array, i);
                al.add(element == null ? null : Utility.deepAsList(element));
                ++i;
            }
        } else {
            int i = 0;
            while (i < arrayLength) {
                al.add(Array.get(array, i));
                ++i;
            }
        }
        return al;
    }

    public static Class<?> getArrayBaseComponentType(Class<?> cls) {
        if (!cls.isArray()) {
            return null;
        }
        Class<?> ct = cls.getComponentType();
        while (ct.getComponentType() != null) {
            ct = ct.getComponentType();
        }
        return ct;
    }

    public static int getArrayDimensionCount(Class<?> cls) {
        if (!cls.isArray()) {
            return 0;
        }
        int dimensions = 1;
        Class<?> ct = cls.getComponentType();
        while (ct.getComponentType() != null) {
            ++dimensions;
            ct = ct.getComponentType();
        }
        return dimensions;
    }

    public static int[] getRectangularArrayDimensions(Object array) {
        if (array == null) {
            return null;
        }
        int dimensionCount = Utility.getArrayDimensionCount(array.getClass());
        if (dimensionCount == 0) {
            return null;
        }
        int[] dimensions = new int[dimensionCount];
        Object o = array;
        int i = 0;
        while (i < dimensionCount) {
            int length = Array.getLength(o);
            if (length == 0) break;
            dimensions[i] = length;
            if ((o = Array.get(o, 0)) == null) break;
            ++i;
        }
        if (!Utility.isArrayRectangular(array, dimensions, 0)) {
            return null;
        }
        return dimensions;
    }

    private static boolean isArrayRectangular(Object array, int[] dimensions, int dimensionIndex) {
        if (dimensionIndex >= dimensions.length - 1) {
            return true;
        }
        int subarrayLength = dimensions[dimensionIndex + 1];
        int i = 0;
        while (i < dimensions[dimensionIndex]) {
            Object subarray = Array.get(array, i);
            if (subarray == null || Array.getLength(subarray) != subarrayLength) {
                return false;
            }
            if (dimensionIndex + 1 < dimensions.length - 1 && !Utility.isArrayRectangular(subarray, dimensions, dimensionIndex + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void reverseArray(boolean[] array) {
        if (array == null) {
            return;
        }
        int rightIdx = 0;
        int goTo = array.length / 2;
        int i = 0;
        while (i < goTo) {
            rightIdx = array.length - i - 1;
            boolean swap = array[i];
            array[i] = array[rightIdx];
            array[rightIdx] = swap;
            ++i;
        }
    }

    public static void reverseArray(byte[] array) {
        if (array == null) {
            return;
        }
        int rightIdx = 0;
        int goTo = array.length / 2;
        int i = 0;
        while (i < goTo) {
            rightIdx = array.length - i - 1;
            byte swap = array[i];
            array[i] = array[rightIdx];
            array[rightIdx] = swap;
            ++i;
        }
    }

    public static void reverseArray(double[] array) {
        if (array == null) {
            return;
        }
        int rightIdx = 0;
        int goTo = array.length / 2;
        int i = 0;
        while (i < goTo) {
            rightIdx = array.length - i - 1;
            double swap = array[i];
            array[i] = array[rightIdx];
            array[rightIdx] = swap;
            ++i;
        }
    }

    public static void reverseArray(int[] array) {
        if (array == null) {
            return;
        }
        int rightIdx = 0;
        int goTo = array.length / 2;
        int i = 0;
        while (i < goTo) {
            rightIdx = array.length - i - 1;
            int swap = array[i];
            array[i] = array[rightIdx];
            array[rightIdx] = swap;
            ++i;
        }
    }

    public static void reverseArray(String[] array) {
        if (array == null) {
            return;
        }
        int rightIdx = 0;
        int goTo = array.length / 2;
        int i = 0;
        while (i < goTo) {
            rightIdx = array.length - i - 1;
            String swap = array[i];
            array[i] = array[rightIdx];
            array[rightIdx] = swap;
            ++i;
        }
    }
}

