/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgNum;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVReader {
    private static final Pattern csvPattern = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");

    public static boolean read(InputStream inputStream, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener) {
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = 1;
            String string = bufferedReader.readLine();
            string = CSVReader.stripUTF8Bom(string);
            ArrayList<String> arrayList = CSVReader.readCells(string);
            for (n = 0; n < arrayList.size(); ++n) {
                if (arrayList.get(n).equals("Type")) {
                    n2 = n;
                    continue;
                }
                if (arrayList.get(n).equals("Local Number")) {
                    n3 = n;
                    continue;
                }
                if (arrayList.get(n).equals("Message")) {
                    n4 = n;
                    continue;
                }
                if (!arrayList.get(n).equals("Field 1")) continue;
                n5 = n;
                break;
            }
            while ((string = bufferedReader.readLine()) != null) {
                MesgDefinition mesgDefinition = null;
                arrayList = CSVReader.readCells(string);
                ++n6;
                if (arrayList.size() <= n2 || arrayList.size() <= n3 || arrayList.size() <= n4) continue;
                Mesg mesg = Factory.createMesg(arrayList.get(n4));
                if (mesg.getNum() == MesgNum.INVALID) {
                    System.err.printf("CSVReader.read(): Error on line %d - Unknown message \"%s\".\n", n6, mesg.getName());
                    return false;
                }
                if (n3 >= 0) {
                    mesg.setLocalNum(Integer.valueOf(arrayList.get(n3)));
                }
                if (n2 >= 0 && arrayList.get(n2).equals("Definition")) {
                    mesgDefinition = new MesgDefinition(mesg);
                }
                n = n5;
                while (n + 2 <= arrayList.size()) {
                    String string2 = arrayList.get(n++);
                    ArrayList<String> arrayList2 = CSVReader.readValues(arrayList.get(n++));
                    FieldDefinition fieldDefinition = null;
                    ++n;
                    if (string2 == null) break;
                    Field field = Factory.createField(mesg.getName(), string2);
                    if (field.getNum() == 255) {
                        System.err.printf("CSVReader.read(): Error on line %d - Unknown field \"%s\" in message \"%s\".\n", n6, string2, mesg.getName());
                        return false;
                    }
                    if (arrayList2 == null) break;
                    if (mesgDefinition != null) {
                        fieldDefinition = new FieldDefinition(field);
                    }
                    for (String string3 : arrayList2) {
                        try {
                            if (Double.valueOf(string3).toString().contains("E") && field.getType() == 7) {
                                throw new NumberFormatException();
                            }
                            field.setValue(field.getNumValues(), (Object)Double.valueOf(string3), string2);
                            if (fieldDefinition == null) continue;
                            fieldDefinition.setSize(Integer.valueOf(string3) * Fit.baseTypeSizes[field.getType() & 0x1F]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            field.setValue(field.getNumValues(), (Object)string3, string2);
                        }
                    }
                    mesg.addField(field);
                    if (mesgDefinition == null) continue;
                    mesgDefinition.addField(fieldDefinition);
                }
                if (mesgDefinition != null) {
                    if (mesgDefinitionListener == null) continue;
                    mesgDefinitionListener.onMesgDefinition(mesgDefinition);
                    continue;
                }
                if (mesgListener == null) continue;
                mesgListener.onMesg(mesg);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return true;
    }

    private static ArrayList<String> readCells(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return null;
        }
        Matcher matcher = csvPattern.matcher(string);
        while (matcher.find() && (string2 = matcher.group()) != null) {
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.length() == 0) {
                string2 = null;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static ArrayList<String> readValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return null;
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '|') {
                arrayList.add(string2);
                string2 = "";
                continue;
            }
            string2 = string2 + string.charAt(i);
        }
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static String stripUTF8Bom(String string) {
        byte[] byArray = string.getBytes(Charset.forName("UTF-8"));
        if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            byte[] byArray2 = new byte[byArray.length - 3];
            System.arraycopy(byArray, 3, byArray2, 0, byArray2.length);
            try {
                string = new String(byArray2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string;
    }
}

