/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.unsupervised.attribute.Add;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.StreamThroughput;
import weka.gui.beans.SubstringLabelerRules;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.Visible;

@KFStep(category="Tools", toolTipText="Label instances according to substring matches in String attributes")
public class SubstringLabeler
extends JPanel
implements BeanCommon,
Visible,
Serializable,
InstanceListener,
TrainingSetListener,
TestSetListener,
DataSourceListener,
EventConstraints,
EnvironmentHandler,
DataSource {
    private static final long serialVersionUID = 6297059699297260134L;
    protected transient Environment m_env;
    protected String m_matchDetails = "";
    protected transient SubstringLabelerRules m_matches;
    protected transient Logger m_log;
    protected transient boolean m_busy;
    protected Object m_listenee;
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();
    protected ArrayList<DataSourceListener> m_dataListeners = new ArrayList();
    protected boolean m_nominalBinary;
    protected boolean m_consumeNonMatchingInstances;
    protected Add m_addFilter;
    protected String m_attName = "Match";
    protected InstanceEvent m_ie = new InstanceEvent(this);
    protected BeanVisual m_visual = new BeanVisual("SubstringLabeler", "weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
    protected transient StreamThroughput m_throughput;

    public SubstringLabeler() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
    }

    public String globalInfo() {
        return "Matches substrings in String attributes using either literal or regular expression matches. The value of a new attribute is set to reflect the status of the match. The new attribute can be either binary (in which case values indicate match or no match) or multi-valued nominal, in which case a label must be associated with each distinct matching rule. In the case of labeled matches, the user can opt to have non matching instances output with missing value set for the new attribute or not output at all (i.e. consumed by the step).";
    }

    public void setMatchDetails(String details) {
        this.m_matchDetails = details;
    }

    public String getMatchDetails() {
        return this.m_matchDetails;
    }

    public void setNominalBinary(boolean nom) {
        this.m_nominalBinary = nom;
    }

    public boolean getNominalBinary() {
        return this.m_nominalBinary;
    }

    public void setConsumeNonMatching(boolean consume) {
        this.m_consumeNonMatchingInstances = consume;
    }

    public boolean getConsumeNonMatching() {
        return this.m_consumeNonMatchingInstances;
    }

    public void setMatchAttributeName(String name) {
        this.m_attName = name;
    }

    public String getMatchAttributeName() {
        return this.m_attName;
    }

    @Override
    public void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.add(dsl);
    }

    @Override
    public void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.remove(dsl);
    }

    @Override
    public void addInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.add(dsl);
    }

    @Override
    public void removeInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.remove(dsl);
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        EventConstraints ec;
        if (this.m_listenee == null) {
            return false;
        }
        if (!eventName.equals("instance") && !eventName.equals("dataSet")) {
            return false;
        }
        if (this.m_listenee instanceof DataSource && this.m_listenee instanceof EventConstraints) {
            EventConstraints ec2 = (EventConstraints)this.m_listenee;
            return ec2.eventGeneratable(eventName);
        }
        if (this.m_listenee instanceof TrainingSetProducer && this.m_listenee instanceof EventConstraints) {
            ec = (EventConstraints)this.m_listenee;
            if (!eventName.equals("dataSet")) {
                return false;
            }
            if (!ec.eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (this.m_listenee instanceof TestSetProducer && this.m_listenee instanceof EventConstraints) {
            ec = (EventConstraints)this.m_listenee;
            if (!eventName.equals("dataSet")) {
                return false;
            }
            if (!ec.eventGeneratable("testSet")) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
        this.m_visual.setText("SubstringLabeler");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
        if (this.m_listenee != null && this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Stopped");
        }
        this.m_busy = false;
    }

    @Override
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        if (!(eventName.equals("instance") || eventName.equals("dataSet") || eventName.equals("trainingSet") || eventName.equals("testSet"))) {
            return false;
        }
        return this.m_listenee == null;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        if (source == this.m_listenee) {
            this.m_listenee = null;
        }
    }

    protected void makeOutputStructure(Instances inputStructure) throws Exception {
        this.m_matches = new SubstringLabelerRules(this.m_matchDetails, this.m_attName, this.getConsumeNonMatching(), this.getNominalBinary(), inputStructure, this.statusMessagePrefix(), this.m_log, this.m_env);
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        this.m_busy = true;
        if (e.getStatus() == 0) {
            this.m_throughput = new StreamThroughput(this.statusMessagePrefix());
            Instances structure = e.getStructure();
            try {
                this.makeOutputStructure(structure);
            }
            catch (Exception ex) {
                String msg = this.statusMessagePrefix() + "ERROR: unable to create output instances structure.";
                if (this.m_log != null) {
                    this.m_log.statusMessage(msg);
                    this.m_log.logMessage("[SubstringLabeler] " + ex.getMessage());
                }
                this.stop();
                ex.printStackTrace();
                this.m_busy = false;
                return;
            }
            if (!e.m_formatNotificationOnly && this.m_log != null) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "Processing stream...");
            }
            this.m_ie.setStructure(this.m_matches.getOutputStructure());
            this.m_ie.m_formatNotificationOnly = e.m_formatNotificationOnly;
            this.notifyInstanceListeners(this.m_ie);
        } else {
            Instance inst = e.getInstance();
            Instance out = null;
            if (inst != null) {
                this.m_throughput.updateStart();
                try {
                    out = this.m_matches.makeOutputInstance(inst, false);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                this.m_throughput.updateEnd(this.m_log);
            }
            if (inst == null || out != null || e.getStatus() == 2) {
                this.m_ie.setInstance(out);
                this.m_ie.setStatus(e.getStatus());
                this.notifyInstanceListeners(this.m_ie);
            }
            if (e.getStatus() == 2 || inst == null) {
                this.m_throughput.finished(this.m_log);
            }
        }
        this.m_busy = false;
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        this.m_busy = true;
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Processing batch...");
        }
        try {
            this.makeOutputStructure(new Instances(e.getDataSet(), 0));
        }
        catch (Exception ex) {
            String msg = this.statusMessagePrefix() + "ERROR: unable to create output instances structure.";
            if (this.m_log != null) {
                this.m_log.statusMessage(msg);
                this.m_log.logMessage("[SubstringLabeler] " + ex.getMessage());
            }
            this.stop();
            ex.printStackTrace();
            this.m_busy = false;
            return;
        }
        Instances toProcess = e.getDataSet();
        for (int i = 0; i < toProcess.numInstances(); ++i) {
            Instance current = toProcess.instance(i);
            Instance result = null;
            try {
                result = this.m_matches.makeOutputInstance(current, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (result == null) continue;
            this.m_matches.getOutputStructure().add(result);
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Finished.");
        }
        DataSetEvent d = new DataSetEvent(this, this.m_matches.getOutputStructure());
        this.notifyDataListeners(d);
        this.m_busy = false;
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances test = e.getTestSet();
        DataSetEvent d = new DataSetEvent(this, test);
        this.acceptDataSet(d);
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances train = e.getTrainingSet();
        DataSetEvent d = new DataSetEvent(this, train);
        this.acceptDataSet(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataListeners(DataSetEvent e) {
        List l;
        SubstringLabeler substringLabeler = this;
        synchronized (substringLabeler) {
            l = (List)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            for (DataSourceListener ds : l) {
                ds.acceptDataSet(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstanceListeners(InstanceEvent e) {
        List l;
        SubstringLabeler substringLabeler = this;
        synchronized (substringLabeler) {
            l = (List)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (InstanceListener il : l) {
                il.acceptInstance(e);
            }
        }
    }

    protected String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

