/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA;

import java.io.IOException;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Apriori;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Population;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.myDataset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.parseParameters;
import org.core.Files;
import org.core.Randomize;

public class FCRA {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String fileDB;
    String fileRB;
    String fileTime;
    String fileHora;
    String data;
    DataBase dataBase;
    RuleBase ruleBase;
    Apriori apriori;
    Population pop;
    long startTime;
    long totalTime;
    int nLabels;
    double minpsup;
    double minpconf;
    int populationSize;
    int nGenerations;
    int lengthSC;
    int Jmax;
    double crossProb;
    double mutationProb;
    double wV;
    double wCAR;
    double n1;
    double n2;
    private boolean somethingWrong = false;

    public FCRA() {
    }

    public FCRA(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasMissingAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.fileDB = parameters.getOutputFile(0);
        this.fileRB = parameters.getOutputFile(1);
        this.data = parameters.getTrainingInputFile();
        this.fileTime = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/hora.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.nGenerations = Integer.parseInt(parameters.getParameter(1));
        this.populationSize = Integer.parseInt(parameters.getParameter(2));
        if (this.populationSize % 2 > 0) {
            ++this.populationSize;
        }
        this.lengthSC = Integer.parseInt(parameters.getParameter(3));
        this.wCAR = Double.parseDouble(parameters.getParameter(4));
        this.wV = Double.parseDouble(parameters.getParameter(5));
        this.crossProb = Double.parseDouble(parameters.getParameter(6));
        this.mutationProb = Double.parseDouble(parameters.getParameter(7));
        this.n1 = Double.parseDouble(parameters.getParameter(8));
        this.n2 = Double.parseDouble(parameters.getParameter(9));
        this.Jmax = Integer.parseInt(parameters.getParameter(10));
        this.nLabels = Integer.parseInt(parameters.getParameter(11));
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, either the data-set has missing values.");
            System.err.println("Please remove the examples with missing data or apply a MV preprocessing.");
            System.err.println("Aborting the program");
        } else {
            this.dataBase = new DataBase(this.nLabels, this.train);
            this.train.createFGTTFS(this.dataBase);
            this.apriori = new Apriori(this.dataBase, this.train);
            this.pop = new Population(this.train, this.dataBase, this.populationSize, this.crossProb, this.mutationProb, this.lengthSC, this.wCAR, this.wV, this.n1, this.n2, this.Jmax, this.apriori);
            this.pop.Generation(this.nGenerations);
            System.out.println("Building classifier");
            this.ruleBase = this.pop.getBestRB();
            this.dataBase.saveFile(this.fileDB);
            this.ruleBase.saveFile(this.fileRB, this.pop.getBestMinFS(), this.pop.getBestMinFC());
            this.doOutput(this.val, this.outputTr);
            this.doOutput(this.test, this.outputTst);
            this.totalTime = System.currentTimeMillis() - this.startTime;
            this.writeTime();
            System.out.println("Algorithm Finished");
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.data + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.data + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsString(i) + " " + this.classificationOutput(dataset.getExample(i)) + "\n";
        }
        Files.writeFile(filename, output);
    }

    private String classificationOutput(double[] example) {
        String output = new String("?");
        int clas = this.ruleBase.FRM(example);
        if (clas >= 0) {
            output = this.train.getOutputValue(clas);
        }
        return output;
    }
}

