/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.binarray;

import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.base.AbstractIndividual;
import org.apache.commons.lang.builder.EqualsBuilder;

public class BinArrayIndividual
extends AbstractIndividual<byte[]> {
    private static final long serialVersionUID = 6227386750669278917L;

    public BinArrayIndividual() {
    }

    public BinArrayIndividual(byte[] genotype) {
        super(genotype);
    }

    public BinArrayIndividual(byte[] genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public IIndividual copy() {
        int gl = ((byte[])this.genotype).length;
        byte[] gother = new byte[((byte[])this.genotype).length];
        System.arraycopy(this.genotype, 0, gother, 0, gl);
        if (this.fitness != null) {
            return new BinArrayIndividual(gother, this.fitness.copy());
        }
        return new BinArrayIndividual(gother);
    }

    @Override
    public double distance(IIndividual other) {
        byte[] gother = (byte[])((BinArrayIndividual)other).genotype;
        int distance = 0;
        int gl = ((byte[])this.genotype).length;
        int i = 0;
        while (i < gl) {
            if (((byte[])this.genotype)[i] != gother[i]) {
                ++distance;
            }
            ++i;
        }
        return distance;
    }

    public boolean equals(Object other) {
        if (other instanceof BinArrayIndividual) {
            BinArrayIndividual baother = (BinArrayIndividual)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((byte[])this.genotype, (byte[])baother.genotype);
            eb.append(this.fitness, baother.fitness);
            return eb.isEquals();
        }
        return false;
    }
}

