/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;
import keel.Algorithms.Decision_Trees.M5.M5Vector;
import keel.Algorithms.Decision_Trees.M5.SerializedObject;

public class M5Attribute
implements Serializable {
    public static final int NUMERIC = 0;
    public static final int NOMINAL = 1;
    public static final int STRING = 2;
    private static final int STRING_COMPRESS_THRESHOLD = 200;
    private String m_Name;
    private int m_Type;
    private M5Vector m_Values;
    private Hashtable m_Hashtable;
    private int m_Index;

    public M5Attribute(String attributeName) {
        this.m_Name = attributeName;
        this.m_Index = -1;
        this.m_Values = null;
        this.m_Hashtable = null;
        this.m_Type = 0;
    }

    public M5Attribute(String attributeName, M5Vector attributeValues) {
        this.m_Name = attributeName;
        this.m_Index = -1;
        if (attributeValues == null) {
            this.m_Values = new M5Vector();
            this.m_Hashtable = new Hashtable();
            this.m_Type = 2;
        } else {
            this.m_Values = new M5Vector(attributeValues.size());
            this.m_Hashtable = new Hashtable(attributeValues.size());
            for (int i = 0; i < attributeValues.size(); ++i) {
                Object store = attributeValues.elementAt(i);
                if (((String)store).length() > 200) {
                    try {
                        store = new SerializedObject(attributeValues.elementAt(i), true);
                    }
                    catch (Exception ex) {
                        System.err.println("Couldn't compress nominal attribute value - storing uncompressed.");
                    }
                }
                this.m_Values.addElement(store);
                this.m_Hashtable.put(store, new Integer(i));
            }
            this.m_Type = 1;
        }
    }

    public Object copy() {
        M5Attribute copy = new M5Attribute(this.m_Name);
        copy.m_Index = this.m_Index;
        if (!this.isNominal() && !this.isString()) {
            return copy;
        }
        copy.m_Type = this.m_Type;
        copy.m_Values = this.m_Values;
        copy.m_Hashtable = this.m_Hashtable;
        return copy;
    }

    public final Enumeration enumerateValues() {
        if (this.isNominal() || this.isString()) {
            final Enumeration ee = this.m_Values.elements();
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return ee.hasMoreElements();
                }

                public Object nextElement() {
                    Object oo = ee.nextElement();
                    if (oo instanceof SerializedObject) {
                        return ((SerializedObject)oo).getObject();
                    }
                    return oo;
                }
            };
        }
        return null;
    }

    public final boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        M5Attribute att = (M5Attribute)other;
        if (!this.m_Name.equals(att.m_Name)) {
            return false;
        }
        if (this.isNumeric() && att.isNumeric()) {
            return true;
        }
        if (this.isNumeric() || att.isNumeric()) {
            return false;
        }
        if (this.m_Values.size() != att.m_Values.size()) {
            return false;
        }
        for (int i = 0; i < this.m_Values.size(); ++i) {
            if (this.m_Values.elementAt(i).equals(att.m_Values.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public final int index() {
        return this.m_Index;
    }

    public final int indexOfValue(String value) {
        Integer val;
        if (!this.isNominal() && !this.isString()) {
            return -1;
        }
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - searching uncompressed.");
            }
        }
        if ((val = (Integer)this.m_Hashtable.get(store)) == null) {
            return -1;
        }
        return val;
    }

    public final boolean isNominal() {
        return this.m_Type == 1;
    }

    public final boolean isNumeric() {
        return this.m_Type == 0;
    }

    public final boolean isString() {
        return this.m_Type == 2;
    }

    public final String name() {
        return this.m_Name;
    }

    public final int numValues() {
        if (!this.isNominal() && !this.isString()) {
            return 0;
        }
        return this.m_Values.size();
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append("@attribute " + M5StaticUtils.quote(this.m_Name) + " ");
        if (this.isNominal()) {
            text.append('{');
            Enumeration enuma = this.enumerateValues();
            while (enuma.hasMoreElements()) {
                text.append(M5StaticUtils.quote((String)enuma.nextElement()));
                if (!enuma.hasMoreElements()) continue;
                text.append(',');
            }
            text.append('}');
        } else if (this.isNumeric()) {
            text.append("numeric");
        } else {
            text.append("string");
        }
        return text.toString();
    }

    public final int type() {
        return this.m_Type;
    }

    public final String value(int valIndex) {
        if (!this.isNominal() && !this.isString()) {
            return "";
        }
        Object val = this.m_Values.elementAt(valIndex);
        if (val instanceof SerializedObject) {
            val = ((SerializedObject)val).getObject();
        }
        return (String)val;
    }

    M5Attribute(String attributeName, int index) {
        this(attributeName);
        this.m_Index = index;
    }

    M5Attribute(String attributeName, M5Vector attributeValues, int index) {
        this(attributeName, attributeValues);
        this.m_Index = index;
    }

    public int addStringValue(String value) {
        Integer index;
        if (!this.isString()) {
            return -1;
        }
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - storing uncompressed.");
            }
        }
        if ((index = (Integer)this.m_Hashtable.get(store)) != null) {
            return index;
        }
        int intIndex = this.m_Values.size();
        this.m_Values.addElement(store);
        this.m_Hashtable.put(store, new Integer(intIndex));
        return intIndex;
    }

    public int addStringValue(M5Attribute src, int index) {
        if (!this.isString()) {
            return -1;
        }
        Object store = src.m_Values.elementAt(index);
        Integer oldIndex = (Integer)this.m_Hashtable.get(store);
        if (oldIndex != null) {
            return oldIndex;
        }
        int intIndex = this.m_Values.size();
        this.m_Values.addElement(store);
        this.m_Hashtable.put(store, new Integer(intIndex));
        return intIndex;
    }

    final void addValue(String value) {
        this.m_Values = (M5Vector)this.m_Values.copy();
        this.m_Hashtable = (Hashtable)this.m_Hashtable.clone();
        this.forceAddValue(value);
    }

    final M5Attribute copy(String newName) {
        M5Attribute copy = new M5Attribute(newName);
        copy.m_Index = this.m_Index;
        if (!this.isNominal() && !this.isString()) {
            return copy;
        }
        copy.m_Type = this.m_Type;
        copy.m_Values = this.m_Values;
        copy.m_Hashtable = this.m_Hashtable;
        return copy;
    }

    final void delete(int index) {
        if (!this.isNominal() && !this.isString()) {
            throw new IllegalArgumentException("Can only remove value ofnominal or string attribute!");
        }
        this.m_Values = (M5Vector)this.m_Values.copy();
        this.m_Values.removeElementAt(index);
        Hashtable hash = new Hashtable(this.m_Hashtable.size());
        Enumeration enuma = this.m_Hashtable.keys();
        while (enuma.hasMoreElements()) {
            Object string = enuma.nextElement();
            Integer valIndexObject = (Integer)this.m_Hashtable.get(string);
            int valIndex = valIndexObject;
            if (valIndex > index) {
                hash.put(string, new Integer(valIndex - 1));
                continue;
            }
            if (valIndex >= index) continue;
            hash.put(string, valIndexObject);
        }
        this.m_Hashtable = hash;
    }

    final void forceAddValue(String value) {
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - storing uncompressed.");
            }
        }
        this.m_Values.addElement(store);
        this.m_Hashtable.put(store, new Integer(this.m_Values.size() - 1));
    }

    final void setIndex(int index) {
        this.m_Index = index;
    }

    final void setValue(int index, String string) {
        if (!this.isNominal() && !this.isString()) {
            throw new IllegalArgumentException("Can only set value of nominalor string attribute!");
        }
        this.m_Values = (M5Vector)this.m_Values.copy();
        this.m_Hashtable = (Hashtable)this.m_Hashtable.clone();
        Object store = string;
        if (string.length() > 200) {
            try {
                store = new SerializedObject(string, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - storing uncompressed.");
            }
        }
        this.m_Hashtable.remove(this.m_Values.elementAt(index));
        this.m_Values.setElementAt(store, index);
        this.m_Hashtable.put(store, new Integer(index));
    }

    public static void main(String[] ops) {
        try {
            M5Attribute length = new M5Attribute("length");
            M5Attribute weight = new M5Attribute("weight");
            M5Vector my_nominal_values = new M5Vector(3);
            my_nominal_values.addElement("first");
            my_nominal_values.addElement("second");
            my_nominal_values.addElement("third");
            M5Attribute position = new M5Attribute("position", my_nominal_values);
            System.out.println("Name of \"position\": " + position.name());
            Enumeration attValues = position.enumerateValues();
            while (attValues.hasMoreElements()) {
                String string = (String)attValues.nextElement();
                System.out.println("Value of \"position\": " + string);
            }
            M5Attribute copy = (M5Attribute)position.copy();
            System.out.println("Copy is the same as original: " + copy.equals(position));
            System.out.println("Index of attribute \"weight\" (should be -1): " + weight.index());
            System.out.println("Index of value \"first\" of \"position\" (should be 0): " + position.indexOfValue("first"));
            System.out.println("\"position\" is numeric: " + position.isNumeric());
            System.out.println("\"position\" is nominal: " + position.isNominal());
            System.out.println("\"position\" is string: " + position.isString());
            System.out.println("Name of \"position\": " + position.name());
            System.out.println("Number of values for \"position\": " + position.numValues());
            for (int i = 0; i < position.numValues(); ++i) {
                System.out.println("Value " + i + ": " + position.value(i));
            }
            System.out.println(position);
            switch (position.type()) {
                case 0: {
                    System.out.println("\"position\" is numeric");
                    break;
                }
                case 1: {
                    System.out.println("\"position\" is nominal");
                    break;
                }
                case 2: {
                    System.out.println("\"position\" is string");
                    break;
                }
                default: {
                    System.out.println("\"position\" has unknown type");
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

