/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.matrices.Toeplitz;

public class TrenchSolver
implements Cloneable {
    public DataBlock w;
    public DataBlock z;
    public Matrix A;
    public Matrix B;
    public Matrix lA;
    public Matrix S;
    private double[] l;

    public <T extends IArimaModel> TrenchSolver(RegArimaModel<T> regArimaModel) {
        RegModel dmodel = regArimaModel.getDModel();
        DataBlock dy = dmodel.getY();
        int nobs = dy.getLength();
        double[] r = regArimaModel.getArma().getAutoCovarianceFunction().values(nobs);
        Toeplitz toeplitz = new Toeplitz(r);
        this.S = toeplitz.inverse();
        this.z = new DataBlock(nobs);
        this.z.product(dy, this.S.columns());
        int nx = 0;
        Matrix X = dmodel.variables();
        for (int i = 0; i < dmodel.getVarsCount(); ++i) {
            if (X.column(i).isZero()) continue;
            ++nx;
        }
        if (nx == 0) {
            this.A = null;
            this.lA = null;
            this.B = null;
            this.w = null;
            this.l = null;
        } else {
            this.l = new double[nx];
            this.w = new DataBlock(nx);
            this.B = new Matrix(nx, nobs);
            this.A = new Matrix(nx, nx);
            int i = 0;
            for (int j = 0; j < dmodel.getVarsCount(); ++j) {
                DataBlock xcol = X.column(j);
                if (xcol.isZero()) continue;
                this.B.row(i).product(xcol, this.S.columns());
                this.w.set(i, xcol.dot(new DataBlock(this.z)));
                for (int k = 0; k <= i; ++k) {
                    this.A.set(i, k, xcol.dot(this.B.row(k)));
                }
                ++i;
            }
            SymmetricMatrix.fromLower(this.A);
            this.lA = this.A.clone();
            SymmetricMatrix.lcholesky(this.lA, 1.0E-15);
        }
    }

    public TrenchSolver clone() {
        try {
            TrenchSolver solver = (TrenchSolver)super.clone();
            solver.z = this.z.clone();
            if (this.B != null) {
                solver.B = this.B.clone();
                solver.l = new double[this.B.getRowsCount()];
            }
            solver.S = this.S.clone();
            return solver;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public void cumul() {
        this.z.reverse().difference();
        if (this.B != null) {
            DataBlockIterator brows = this.B.rows();
            DataBlock brow = brows.getData();
            do {
                brow.reverse().difference();
            } while (brows.next());
        }
        DataBlockIterator scols = this.S.columns();
        DataBlock scol = scols.getData();
        do {
            scol.reverse().difference();
        } while (scols.next());
        DataBlockIterator srows = this.S.rows();
        DataBlock srow = srows.getData();
        do {
            srow.reverse().difference();
        } while (srows.next());
    }

    public void cumul(double delta) {
        this.z.reverse().difference(delta);
        if (this.B != null) {
            DataBlockIterator brows = this.B.rows();
            DataBlock brow = brows.getData();
            do {
                brow.reverse().difference(delta);
            } while (brows.next());
        }
        DataBlockIterator scols = this.S.columns();
        DataBlock scol = scols.getData();
        do {
            scol.reverse().difference(delta);
        } while (scols.next());
        DataBlockIterator srows = this.S.rows();
        DataBlock srow = srows.getData();
        do {
            srow.reverse().difference(delta);
        } while (srows.next());
    }

    public void cumul(double delta, int lag) {
        this.z.reverse().difference(delta, lag);
        if (this.B != null) {
            DataBlockIterator brows = this.B.rows();
            DataBlock brow = brows.getData();
            do {
                brow.reverse().difference(delta, lag);
            } while (brows.next());
        }
        DataBlockIterator scols = this.S.columns();
        DataBlock scol = scols.getData();
        do {
            scol.reverse().difference(delta, lag);
        } while (scols.next());
        DataBlockIterator srows = this.S.rows();
        DataBlock srow = srows.getData();
        do {
            srow.reverse().difference(delta, lag);
        } while (srows.next());
    }

    public void cumul(int lag) {
        this.z.reverse().difference(lag);
        if (this.B != null) {
            DataBlockIterator brows = this.B.rows();
            DataBlock brow = brows.getData();
            do {
                brow.reverse().difference(lag);
            } while (brows.next());
        }
        DataBlockIterator scols = this.S.columns();
        DataBlock scol = scols.getData();
        do {
            scol.reverse().difference(lag);
        } while (scols.next());
        DataBlockIterator srows = this.S.rows();
        DataBlock srow = srows.getData();
        do {
            srow.reverse().difference(lag);
        } while (srows.next());
    }

    public void difference() {
        this.z.reverse().cumul();
        if (this.B != null) {
            DataBlockIterator brows = this.B.rows();
            DataBlock brow = brows.getData();
            do {
                brow.reverse().cumul();
            } while (brows.next());
        }
        SymmetricMatrix.rcumul(this.S);
    }

    public void difference(double delta) {
        this.z.reverse().cumul(delta);
        if (this.B != null) {
            DataBlockIterator brows = this.B.rows();
            DataBlock brow = brows.getData();
            do {
                brow.reverse().cumul(delta);
            } while (brows.next());
        }
        SymmetricMatrix.rcumul(this.S, delta);
    }

    public void difference(double delta, int lag) {
        this.z.reverse().cumul(delta, lag);
        if (this.B != null) {
            DataBlockIterator brows = this.B.rows();
            DataBlock brow = brows.getData();
            do {
                brow.reverse().cumul(delta, lag);
            } while (brows.next());
        }
        SymmetricMatrix.rcumul(this.S, delta, lag);
    }

    public void difference(int lag) {
        this.z.reverse().cumul(lag);
        if (this.B != null) {
            DataBlockIterator brows = this.B.rows();
            DataBlock brow = brows.getData();
            do {
                brow.reverse().cumul(lag);
            } while (brows.next());
        }
        SymmetricMatrix.rcumul(this.S, lag);
    }

    public double TStat(int pos) {
        if (this.B != null) {
            this.B.column(pos).copyTo(this.l, 0);
        }
        double xy = this.z.get(pos);
        double xx = this.S.get(pos, pos);
        if (this.B != null) {
            LowerTriangularMatrix.rsolve(this.lA, this.l);
            double q = 0.0;
            for (int i = 0; i < this.l.length; ++i) {
                q += this.l[i] * this.l[i];
            }
            double c = xx - q;
            if (c <= 0.0) {
                return Double.NaN;
            }
            double[] n = new double[this.w.getLength()];
            this.w.copyTo(n, 0);
            LowerTriangularMatrix.rsolve(this.lA, n);
            double nm = 0.0;
            for (int i = 0; i < this.l.length; ++i) {
                nm += this.l[i] * n[i];
            }
            return (xy - nm) / Math.sqrt(c);
        }
        if (xx <= 0.0) {
            return Double.NaN;
        }
        return xy / Math.sqrt(xx);
    }

    public double TStat(int ostart, int pos, double[] o, int[] idx) {
        DataBlock L = null;
        if (this.B != null) {
            L = new DataBlock(this.l);
            L.set(0.0);
        }
        double xx = 0.0;
        double xy = 0.0;
        int n = this.z.getLength();
        for (int i = 0; i < idx.length; ++i) {
            int iw = idx[i] + pos - ostart;
            if (iw < 0 || iw >= n) continue;
            double io = o[idx[i]];
            if (this.B != null) {
                L.addAY(io, this.B.column(iw));
            }
            xy += this.z.get(iw) * io;
            double s = this.S.get(iw, iw);
            xx += io * io * s;
            for (int j = 0; j < i; ++j) {
                int jw = idx[j] + pos - ostart;
                if (jw < 0) continue;
                double jo = o[idx[j]];
                xx += 2.0 * this.S.get(iw, jw) * io * jo;
            }
        }
        if (this.B != null) {
            LowerTriangularMatrix.rsolve(this.lA, this.l);
            double q = L.dot(L);
            double c = xx - q;
            if (c <= 0.0) {
                return Double.NaN;
            }
            double[] nw = new double[this.w.getLength()];
            this.w.copyTo(nw, 0);
            LowerTriangularMatrix.lsolve(this.lA, this.l);
            double nm = 0.0;
            for (int i = 0; i < this.l.length; ++i) {
                nm += this.l[i] * nw[i];
            }
            return (xy - nm) / Math.sqrt(c);
        }
        if (xx <= 0.0) {
            return Double.NaN;
        }
        return xy / Math.sqrt(xx);
    }
}

