/*
 * Decompiled with CFR 0.152.
 */
package com.visutools.nav.bislider;

import com.visutools.nav.bislider.BiSliderAbstraction;
import com.visutools.nav.bislider.BiSliderListener;
import com.visutools.nav.bislider.BiSliderPresentation;
import com.visutools.nav.bislider.BiSliderSupport;
import com.visutools.nav.bislider.Colorizer;
import com.visutools.nav.bislider.ContentPainterListener;
import com.visutools.nav.bislider.ContentPainterSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.sound.sampled.Clip;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.text.html.parser.ParserDelegator;

public class BiSlider
extends JComponent
implements Serializable {
    protected static final ParserDelegator MAXIMUM_VARIABLE_SIZE_FOR_NAME = null;
    static final long serialVersionUID = 8045586992642853136L;
    protected BiSliderAbstraction Abstr = null;
    protected BiSliderPresentation Pres = null;
    protected BiSliderSupport BiSliderSupport1 = new BiSliderSupport();
    protected ContentPainterSupport ContentPainterSupport1 = new ContentPainterSupport();
    protected Clip ClipClick = null;
    protected Clip ClipClick2 = null;
    protected Clip ClipClickY = null;
    protected Clip ClipFlip = null;
    public static final String RGB = "RGB";
    public static final String HSB = "HSB";
    public static final String CENTRAL = "CENTRAL";
    public static final int MAX_SEGMENT_COUNT = 100;

    public BiSlider() {
        this(HSB);
    }

    public BiSlider(String InterpolationMode_Arg) {
        this.setDoubleBuffered(false);
        this.Abstr = new BiSliderAbstraction();
        this.setBackground(this.Abstr.DefaultColor);
        this.Pres = new BiSliderPresentation(this, this.ContentPainterSupport1);
        this.setUI(this.Pres);
        this.Abstr.InterpolationMode = InterpolationMode_Arg;
    }

    public BiSlider(String InterpolationMode_Arg, boolean MinOnTop_Arg) {
        this(InterpolationMode_Arg);
        this.removeMouseListener(this.Pres);
        this.removeMouseMotionListener(this.Pres);
        this.removeMouseWheelListener(this.Pres);
        this.removeComponentListener(this.Pres);
        this.Pres = null;
        this.setUI(this.Pres);
    }

    public void setMinimumColoredValue(int NewValue_Arg) {
        if (this.Abstr != null && this.Pres != null && NewValue_Arg != this.Abstr.MinimumColoredValue && NewValue_Arg >= this.Abstr.MinimumValue && NewValue_Arg <= this.Abstr.MaximumValue) {
            this.Abstr.MinimumColoredValue = NewValue_Arg;
            this.Pres.setRulerValues(this.Abstr.MinimumColoredValue, this.Abstr.MaximumColoredValue);
            this.repaint();
            this.BiSliderSupport1.fireNewMinValue(this);
        }
    }

    public int getMinimumColoredValue() {
        return this.Abstr.MinimumColoredValue;
    }

    public void setMaximumColoredValue(int MaximumColoredValue_Arg) {
        if (this.Abstr != null && this.Pres != null && MaximumColoredValue_Arg != this.Abstr.MaximumColoredValue && MaximumColoredValue_Arg >= this.Abstr.MinimumValue && MaximumColoredValue_Arg <= this.Abstr.MaximumValue) {
            this.Abstr.MaximumColoredValue = MaximumColoredValue_Arg;
            this.Pres.setRulerValues(this.Abstr.MinimumColoredValue, this.Abstr.MaximumColoredValue);
            this.repaint();
            this.BiSliderSupport1.fireNewMaxValue(this);
        }
    }

    public int getMaximumColoredValue() {
        return this.Abstr.MaximumColoredValue;
    }

    public String getUnit() {
        return this.Abstr.Unit;
    }

    public void setUnit(String Unit_Arg) {
        this.Abstr.Unit = Unit_Arg;
    }

    public void setColoredValues(int MinValue_Arg, int MaxValue_Arg) {
        if (this.Abstr != null && this.Pres != null && MinValue_Arg <= MaxValue_Arg && MinValue_Arg >= this.Abstr.MinimumValue && MaxValue_Arg <= this.Abstr.MaximumValue && MinValue_Arg <= this.Abstr.MaximumValue && MaxValue_Arg >= this.Abstr.MinimumValue && (MinValue_Arg != this.Abstr.MinimumColoredValue || this.Abstr.MaximumColoredValue != MaxValue_Arg)) {
            if (this.isSound() && this.ClipFlip != null && (int)((double)(MaxValue_Arg - this.Abstr.MinimumValue) / this.Abstr.SegmentSize) != (int)((double)(this.Abstr.MaximumColoredValue - this.Abstr.MinimumValue) / this.Abstr.SegmentSize) && (int)((double)(MinValue_Arg - this.Abstr.MinimumValue) / this.Abstr.SegmentSize) != (int)((double)(this.Abstr.MinimumColoredValue - this.Abstr.MinimumValue) / this.Abstr.SegmentSize)) {
                this.ClipFlip.setFramePosition(0);
                this.ClipFlip.start();
            } else if (this.isSound() && this.ClipClick != null && ((int)((double)(MaxValue_Arg - this.Abstr.MinimumValue) / this.Abstr.SegmentSize) != (int)((double)(this.Abstr.MaximumColoredValue - this.Abstr.MinimumValue) / this.Abstr.SegmentSize) || (int)((double)(MinValue_Arg - this.Abstr.MinimumValue) / this.Abstr.SegmentSize) != (int)((double)(this.Abstr.MinimumColoredValue - this.Abstr.MinimumValue) / this.Abstr.SegmentSize))) {
                this.ClipClick.setFramePosition(0);
                this.ClipClick.start();
            }
            this.Abstr.MinimumColoredValue = MinValue_Arg;
            this.Abstr.MaximumColoredValue = MaxValue_Arg;
            this.Pres.setRulerValues(this.Abstr.MinimumColoredValue, this.Abstr.MaximumColoredValue);
            this.repaint();
            this.BiSliderSupport1.fireNewValues(this);
        } else {
            if (MinValue_Arg == this.Abstr.MinimumColoredValue && this.Abstr.MaximumColoredValue == MaxValue_Arg) {
                return;
            }
            System.err.println("Problem with setColoredValues");
            System.err.println("  MinValue_Arg = " + MinValue_Arg);
            System.err.println("  MaxValue_Arg = " + MaxValue_Arg);
            System.err.println("  Abstr.MinimumValue = " + this.Abstr.MinimumValue);
            System.err.println("  Abstr.MaximumValue = " + this.Abstr.MaximumValue);
            System.err.println("  Abstr.MinimumColoredValue = " + this.Abstr.MinimumColoredValue);
            System.err.println("  Abstr.MaximumColoredValue = " + this.Abstr.MaximumColoredValue);
            System.err.println("");
        }
    }

    public void setMinimumValue(int MinValue_Arg) {
        if (MinValue_Arg >= this.Abstr.MaximumValue) {
            this.Abstr.MaximumValue = MinValue_Arg + 1;
        }
        this.Abstr.MinimumValue = MinValue_Arg;
        if (MinValue_Arg > this.Abstr.MinimumColoredValue) {
            this.Abstr.MinimumColoredValue = MinValue_Arg;
        }
        if (MinValue_Arg > this.Abstr.MaximumColoredValue) {
            this.Abstr.MaximumColoredValue = MinValue_Arg;
        }
        if (this.isUniformSegment() && (this.Abstr.MaximumValue - this.Abstr.MinimumValue) % this.Abstr.SegmentCount != 0) {
            this.Abstr.SegmentCount = this.Abstr.searchSegmentCount(this.Abstr.SegmentCount);
        }
        this.Pres.setRulerValues(this.Abstr.MinimumColoredValue, this.Abstr.MaximumColoredValue);
        this.setSegmentSize(this.Abstr.SegmentSize);
        this.repaint();
        this.BiSliderSupport1.fireNewColors(this);
    }

    public double getMinimumValue() {
        return this.Abstr.MinimumValue;
    }

    public void setMaximumValue(int MaxValue_Arg) {
        if (MaxValue_Arg <= this.Abstr.MinimumValue) {
            this.Abstr.MinimumValue = MaxValue_Arg - 1;
        }
        this.Abstr.MaximumValue = MaxValue_Arg;
        if (MaxValue_Arg < this.Abstr.MinimumColoredValue) {
            this.Abstr.MinimumColoredValue = MaxValue_Arg;
        }
        if (MaxValue_Arg < this.Abstr.MaximumColoredValue) {
            this.Abstr.MaximumColoredValue = MaxValue_Arg;
        }
        if (this.isUniformSegment() && (this.Abstr.MaximumValue - this.Abstr.MinimumValue) % this.Abstr.SegmentCount != 0) {
            this.Abstr.SegmentCount = this.Abstr.searchSegmentCount(this.Abstr.SegmentCount);
        }
        this.Pres.setRulerValues(this.Abstr.MinimumColoredValue, this.Abstr.MaximumColoredValue);
        this.setSegmentSize(this.Abstr.SegmentSize);
        this.repaint();
        this.BiSliderSupport1.fireNewColors(this);
    }

    public double getMaximumValue() {
        return this.Abstr.MaximumValue;
    }

    public void setValues(int MinValue_Arg, int MaxValue_Arg) {
        if (MinValue_Arg <= MaxValue_Arg) {
            this.Abstr.MinimumValue = MaxValue_Arg - 1;
        }
        this.Abstr.MinimumValue = MinValue_Arg;
        this.Abstr.MaximumValue = MaxValue_Arg;
        if (MaxValue_Arg < this.Abstr.MinimumColoredValue) {
            this.setMinimumColoredValue(MaxValue_Arg);
        }
        if (MaxValue_Arg < this.Abstr.MaximumColoredValue) {
            this.setMaximumColoredValue(MaxValue_Arg);
        }
        if (MinValue_Arg > this.Abstr.MinimumColoredValue) {
            this.setMinimumColoredValue(MinValue_Arg);
        }
        if (MinValue_Arg > this.Abstr.MaximumColoredValue) {
            this.setMaximumColoredValue(MinValue_Arg);
        }
        if (this.isUniformSegment() && (this.Abstr.MaximumValue - this.Abstr.MinimumValue) % this.Abstr.SegmentCount != 0) {
            this.Abstr.SegmentCount = this.Abstr.searchSegmentCount(this.Abstr.SegmentCount);
        }
        this.Pres.setRulerValues(this.Abstr.MinimumColoredValue, this.Abstr.MaximumColoredValue);
        this.setSegmentSize(this.Abstr.SegmentSize);
        this.repaint();
        this.BiSliderSupport1.fireNewColors(this);
    }

    public void setSegmentSize(double SegmentSize_Arg) {
        if (SegmentSize_Arg == 0.0) {
            return;
        }
        if (this.Abstr.UniformSegment && (double)((long)SegmentSize_Arg) == SegmentSize_Arg) {
            int NewSegmentCount = this.Abstr.searchSegmentCount((int)((double)(this.Abstr.MaximumValue - this.Abstr.MinimumValue) / SegmentSize_Arg));
            if (this.isSound() && NewSegmentCount != this.Abstr.SegmentCount) {
                this.ClipClick2.setFramePosition(0);
                this.ClipClick2.start();
            }
            this.Abstr.SegmentCount = NewSegmentCount;
            this.Abstr.SegmentSize = (this.Abstr.MaximumValue - this.Abstr.MinimumValue) / this.Abstr.SegmentCount;
        } else if (this.Abstr.UniformSegment) {
            int NewSegmentCount = (int)Math.round((double)(this.Abstr.MaximumValue - this.Abstr.MinimumValue) / SegmentSize_Arg);
            double NewSegmentSize = (this.Abstr.MaximumValue - this.Abstr.MinimumValue) / NewSegmentCount;
            if (this.isSound() && NewSegmentCount != this.Abstr.SegmentCount && NewSegmentSize == (double)((int)NewSegmentSize)) {
                this.ClipClick2.setFramePosition(0);
                this.ClipClick2.start();
            }
            this.Abstr.SegmentCount = NewSegmentCount;
            this.Abstr.SegmentSize = (this.Abstr.MaximumValue - this.Abstr.MinimumValue) / this.Abstr.SegmentCount;
        } else {
            this.Abstr.SegmentSize = SegmentSize_Arg;
            this.Abstr.SegmentCount = (int)Math.ceil((double)(this.Abstr.MaximumValue - this.Abstr.MinimumValue) / SegmentSize_Arg);
        }
        if (this.Abstr.SegmentCount > 100) {
            this.Abstr.SegmentCount = 100;
            this.Abstr.SegmentSize = (this.Abstr.MaximumValue - this.Abstr.MinimumValue) / 100;
        }
        if (this.Abstr.SegmentCount <= 0) {
            this.Abstr.SegmentCount = 1;
            this.Abstr.SegmentSize = this.Abstr.MaximumValue - this.Abstr.MinimumValue;
        }
        this.repaint();
        this.BiSliderSupport1.fireNewSegments(this);
    }

    public double getSegmentSize() {
        return this.Abstr.SegmentSize;
    }

    public int getSegmentCount() {
        return this.Abstr.SegmentCount;
    }

    public void setDefaultColor(Color Color_Arg) {
        this.Abstr.DefaultColor = Color_Arg;
    }

    public Color getDefaultColor() {
        return this.Abstr.DefaultColor;
    }

    public void setSliderBackground(Color Color_Arg) {
        this.Abstr.SliderBackground = Color_Arg;
    }

    public Color getSliderBackground() {
        return this.Abstr.SliderBackground;
    }

    public void setArcSize(int ArcSize_Arg) {
        this.Abstr.ArcSize = ArcSize_Arg;
    }

    public int getArcSize() {
        return this.Abstr.ArcSize;
    }

    public void setMinimumColor(Color MinimumColor_Arg) {
        if (this.Abstr.MinimumColor != MinimumColor_Arg) {
            this.Abstr.MinimumColor = MinimumColor_Arg;
            this.BiSliderSupport1.fireNewColors(this);
        }
    }

    public Color getMinimumColor() {
        return this.Abstr.MinimumColor;
    }

    public void setMiddleColor(Color MiddleColor_Arg) {
        if (this.Abstr.MiddleColor != MiddleColor_Arg) {
            this.Abstr.MiddleColor = MiddleColor_Arg;
            this.BiSliderSupport1.fireNewColors(this);
        }
    }

    public Color getMiddleColor() {
        return this.Abstr.MiddleColor;
    }

    public void setMaximumColor(Color MaximumColor_Arg) {
        if (this.Abstr.MaximumColor != MaximumColor_Arg) {
            this.Abstr.MaximumColor = MaximumColor_Arg;
            this.BiSliderSupport1.fireNewColors(this);
        }
    }

    public Color getMaximumColor() {
        return this.Abstr.MaximumColor;
    }

    public void setUniformSegment(boolean UniformSegment_Arg) {
        this.Abstr.UniformSegment = UniformSegment_Arg;
        if (UniformSegment_Arg) {
            this.setSegmentSize(this.getSegmentSize());
        }
    }

    public boolean isUniformSegment() {
        return this.Abstr.UniformSegment;
    }

    public void setSound(boolean Sound_Arg) {
        this.Abstr.Sound = Sound_Arg;
    }

    public boolean isSound() {
        return this.Abstr.Sound;
    }

    public void setPrecise(boolean Precise_Arg) {
        this.Abstr.Precise = Precise_Arg;
    }

    public boolean isPrecise() {
        return this.Abstr.Precise;
    }

    public void setHorizontal(boolean Horizontal_Arg) {
        if (!Horizontal_Arg) {
            this.removeMouseListener(this.Pres);
            this.removeMouseMotionListener(this.Pres);
            this.removeComponentListener(this.Pres);
            this.removeMouseWheelListener(this.Pres);
            this.Pres = null;
            this.setUI(this.Pres);
        } else {
            this.removeMouseListener(this.Pres);
            this.removeMouseMotionListener(this.Pres);
            this.removeComponentListener(this.Pres);
            this.removeMouseWheelListener(this.Pres);
            this.Pres = null;
            this.Pres = new BiSliderPresentation(this, this.ContentPainterSupport1);
            this.setUI(this.Pres);
        }
    }

    @Override
    public void paint(Graphics Graphics_Arg) {
        this.Pres.setRulerValues(this.Abstr.MinimumColoredValue, this.Abstr.MaximumColoredValue);
        this.paintComponent(Graphics_Arg);
    }

    @Override
    public void paintComponent(Graphics Graphics_Arg) {
        if (this.ui != null) {
            this.ui.update(Graphics_Arg, this);
        }
    }

    public double[][] getColorTable() {
        return this.Abstr.getColorTable();
    }

    public Colorizer getColorizer() {
        return this.BiSliderSupport1.createBiSliderEvent(this, this.Abstr.getColorTable());
    }

    public synchronized void addBiSliderListener(BiSliderListener Listener_Arg) {
        this.BiSliderSupport1.addBiSliderListener(Listener_Arg);
    }

    public synchronized void removeBiSliderListener(BiSliderListener Listener_Arg) {
        this.BiSliderSupport1.removeBiSliderListener(Listener_Arg);
    }

    public synchronized void addContentPainterListener(ContentPainterListener Listener_Arg) {
        this.ContentPainterSupport1.addContentPainterListener(Listener_Arg);
    }

    public synchronized void removeContentPainterListener(ContentPainterListener Listener_Arg) {
        this.ContentPainterSupport1.removeContentPainterListener(Listener_Arg);
    }

    public String getInterpolationMode() {
        return this.Abstr.InterpolationMode;
    }

    public void setInterpolationMode(String InterpolationMode_Arg) {
        this.Abstr.InterpolationMode = InterpolationMode_Arg;
        this.BiSliderSupport1.fireNewColors(this);
    }

    public void setParameters(String InterpolationMode_Arg, boolean UniformSegment_Arg, int SegmentSize_Arg, Color MinimumColor_Arg, Color MaximumColor_Arg, int MinValue_Arg, int MaxValue_Arg, int MinimumColoredValue_Arg, int MaximumColoredValue_Arg) {
        this.Abstr.MinimumColoredValue = MinimumColoredValue_Arg;
        this.Abstr.MaximumColoredValue = MaximumColoredValue_Arg;
        this.Abstr.MinimumValue = MinValue_Arg;
        this.Abstr.MaximumValue = MaxValue_Arg;
        this.Abstr.MinimumColor = MinimumColor_Arg;
        this.Abstr.MaximumColor = MaximumColor_Arg;
        this.Abstr.UniformSegment = UniformSegment_Arg;
        this.Abstr.InterpolationMode = InterpolationMode_Arg;
        this.setSegmentSize(SegmentSize_Arg);
    }

    public JPopupMenu createPopupMenu() {
        final BiSlider Myself = this;
        ButtonGroup ButtonGroup1 = new ButtonGroup();
        JPopupMenu JPopupMenu1 = new JPopupMenu("BiSlider");
        final JMenuItem JMenuItemMid = new JMenuItem("= Mid", new Icon(){

            @Override
            public int getIconHeight() {
                return 14;
            }

            @Override
            public int getIconWidth() {
                return 14;
            }

            @Override
            public void paintIcon(Component Component_Arg, Graphics Graphics_Arg, int X_Arg, int Y_Arg) {
                Color Color1 = Graphics_Arg.getColor();
                Graphics_Arg.setColor(BiSlider.this.getMiddleColor());
                Graphics_Arg.fillRect(1, 1, Component_Arg.getHeight() - 2, Component_Arg.getHeight() - 2);
                Graphics_Arg.setColor(Color1);
            }
        });
        JMenuItemMid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                Color Color1 = JColorChooser.showDialog(Myself, "Choose a color for the middle value", BiSlider.this.getMiddleColor());
                if (Color1 != null) {
                    BiSlider.this.setMiddleColor(Color1);
                }
                BiSlider.this.repaint();
            }
        });
        if (!this.getInterpolationMode().equals(CENTRAL)) {
            JMenuItemMid.setEnabled(false);
        }
        JMenuItem JMenuItem1 = new JRadioButtonMenuItem(RGB, this.getInterpolationMode().equals(RGB));
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                JMenuItemMid.setEnabled(false);
                BiSlider.this.setInterpolationMode(BiSlider.RGB);
                BiSlider.this.repaint();
            }
        });
        ButtonGroup1.add(JMenuItem1);
        JPopupMenu1.add(JMenuItem1);
        JMenuItem1 = new JRadioButtonMenuItem(HSB, this.getInterpolationMode().equals(HSB));
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                JMenuItemMid.setEnabled(false);
                BiSlider.this.setInterpolationMode(BiSlider.HSB);
                BiSlider.this.repaint();
            }
        });
        ButtonGroup1.add(JMenuItem1);
        JPopupMenu1.add(JMenuItem1);
        JMenuItem1 = new JRadioButtonMenuItem(CENTRAL, this.getInterpolationMode().equals(CENTRAL));
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                JMenuItemMid.setEnabled(true);
                BiSlider.this.setInterpolationMode(BiSlider.CENTRAL);
                BiSlider.this.repaint();
            }
        });
        ButtonGroup1.add(JMenuItem1);
        JPopupMenu1.add(JMenuItem1);
        JPopupMenu1.add(new JSeparator());
        JMenuItem1 = new JMenuItem("Shrink");
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                BiSlider.this.setMinimumValue(BiSlider.this.getMinimumColoredValue());
                BiSlider.this.setMaximumValue(BiSlider.this.getMaximumColoredValue());
                BiSlider.this.repaint();
            }
        });
        JPopupMenu1.add(JMenuItem1);
        JMenuItem1 = new JCheckBoxMenuItem("Uniform", this.isUniformSegment());
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                JCheckBoxMenuItem JCheckBoxMenuItem1 = (JCheckBoxMenuItem)ActionEvent_Arg.getSource();
                BiSlider.this.setUniformSegment(JCheckBoxMenuItem1.isSelected());
                BiSlider.this.repaint();
            }
        });
        JPopupMenu1.add(JMenuItem1);
        JMenuItem1 = new JCheckBoxMenuItem("Sound", this.isSound());
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                JCheckBoxMenuItem JCheckBoxMenuItem1 = (JCheckBoxMenuItem)ActionEvent_Arg.getSource();
                BiSlider.this.setSound(JCheckBoxMenuItem1.isSelected());
                BiSlider.this.repaint();
            }
        });
        JPopupMenu1.add(JMenuItem1);
        JMenuItem1 = new JCheckBoxMenuItem("Precise", this.isPrecise());
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                JCheckBoxMenuItem JCheckBoxMenuItem1 = (JCheckBoxMenuItem)ActionEvent_Arg.getSource();
                BiSlider.this.setPrecise(JCheckBoxMenuItem1.isSelected());
                BiSlider.this.repaint();
            }
        });
        JPopupMenu1.add(JMenuItem1);
        JPopupMenu1.add(new JSeparator());
        JMenuItem1 = new JMenuItem("= Min", new Icon(){

            @Override
            public int getIconHeight() {
                return 14;
            }

            @Override
            public int getIconWidth() {
                return 14;
            }

            @Override
            public void paintIcon(Component Component_Arg, Graphics Graphics_Arg, int X_Arg, int Y_Arg) {
                Color Color1 = Graphics_Arg.getColor();
                Graphics_Arg.setColor(BiSlider.this.getMinimumColor());
                Graphics_Arg.fillRect(1, 1, Component_Arg.getHeight() - 2, Component_Arg.getHeight() - 2);
                Graphics_Arg.setColor(Color1);
            }
        });
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                Color Color1 = JColorChooser.showDialog(Myself, "Choose a color for minimum values", BiSlider.this.getMinimumColor());
                if (Color1 != null) {
                    BiSlider.this.setMinimumColor(Color1);
                }
                BiSlider.this.repaint();
            }
        });
        JPopupMenu1.add(JMenuItem1);
        JPopupMenu1.add(JMenuItemMid);
        JMenuItem1 = new JMenuItem("= Max", new Icon(){

            @Override
            public int getIconHeight() {
                return 14;
            }

            @Override
            public int getIconWidth() {
                return 14;
            }

            @Override
            public void paintIcon(Component Component_Arg, Graphics Graphics_Arg, int X_Arg, int Y_Arg) {
                Color Color1 = Graphics_Arg.getColor();
                Graphics_Arg.setColor(BiSlider.this.getMaximumColor());
                Graphics_Arg.fillRect(1, 1, Component_Arg.getHeight() - 2, Component_Arg.getHeight() - 2);
                Graphics_Arg.setColor(Color1);
            }
        });
        JMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ActionEvent_Arg) {
                Color Color1 = JColorChooser.showDialog(Myself, "Choose a color for maximum values", BiSlider.this.getMaximumColor());
                if (Color1 != null) {
                    BiSlider.this.setMaximumColor(Color1);
                }
                BiSlider.this.repaint();
            }
        });
        JPopupMenu1.add(JMenuItem1);
        return JPopupMenu1;
    }

    public void setUI(BiSliderPresentation newUI) {
        super.setUI(newUI);
    }

    @Override
    public BiSliderPresentation getUI() {
        return (BiSliderPresentation)this.ui;
    }

    @Override
    public String getUIClassID() {
        return "BiSliderPresentation";
    }
}

